/*-------------------------------------------------------------------------*/
/* Benchmark (Finite Domain)            INRIA Rocquencourt - ChLoE Project */
/*                                                                         */
/* Name           : queens.pl                                              */
/* Title          : N-queens problem                                       */
/* Original Source: P. Van Hentenryck's book                               */
/* Adapted by     : Daniel Diaz - INRIA France                             */
/* Date           : January 1993                                           */
/*                                                                         */
/* Put N queens on an NxN chessboard so that there is no couple of queens  */
/* threatening each other.                                                 */
/*                                                                         */
/* Solution:                                                               */
/* N=4  [2,4,1,3]                                                          */
/* N=8  [1,5,8,6,3,7,2,4]                                                  */
/* N=16 [1,3,5,2,13,9,14,12,15,6,16,7,4,11,8,10]                           */
/*-------------------------------------------------------------------------*/

:- main.

q:-	get_labeling(Lab), write('N ?'), read_integer(N),
	statistics(runtime,_),
	queens(N,L,Lab), statistics(runtime,[_,Y]),
	write(L), nl,
	write('time : '), write(Y), nl,
	halt_or_else(0,true).




queens(N,L,Lab):-
	fd_vector_max(N),
	length(L,N),
	domain(L,1,N),
	safe(L),
	lab(Lab,L).




safe([]).

safe([X|L]):-
	noattack(L,X,1),
	safe(L).




noattack([],_,_).

/*
% faster than the original PVH's version 

noattack([Y|L],X,I):-
	I1 is I+1,
	noattack(L,X,I1),
	diff(X,Y,I).
*/

noattack([Y|L],X,I):-
	diff(X,Y,I),
	I1 is I+1,
	noattack(L,X,I1).


/*
diff(X,Y,I):-
	X in -({val(Y)}:{val(Y)-I}:{val(Y)+I}),
	Y in -({val(X)}:{val(X)-I}:{val(X)+I}).
*/


diff(X,Y,I):-
	X in -{val(Y)} & -{val(Y)-I} & -{val(Y)+I},
	Y in -{val(X)} & -{val(X)-I} & -{val(X)+I}.





/*
diff(X,Y,I):-
	X in (0..val(Y)-1   : val(Y)+1  ..infinity) &
	     (0..val(Y)-I-1 : val(Y)-I+1..infinity) &
	     (0..val(Y)+I-1 : val(Y)+I+1..infinity),

	Y in (0..val(X)-1   : val(X)+1  ..infinity) &
	     (0..val(X)-I-1 : val(X)-I+1..infinity) &
	     (0..val(X)+I-1 : val(X)+I+1..infinity).
*/


/* 
diff(X,Y,I):-
	diff1(X,Y),
	diff2(X,Y,I),
	diff2(Y,X,I).

diff1(X,Y):-
	X in 0..val(Y)-1 : val(Y)+1..infinity,
	Y in 0..val(X)-1 : val(X)+1..infinity.

diff2(X,Y,I):-
	X in 0..val(Y)-I-1 : val(Y)-I+1..infinity,
	Y in 0..val(X)+I-1 : val(X)+I+1..infinity.
*/




/*
diff(X,Y,I):-
	X in (0..max(Y)-1   : min(Y)+1  ..infinity) &
	     (0..max(Y)-I-1 : min(Y)-I+1..infinity) &
	     (0..max(Y)+I-1 : min(Y)+I+1..infinity),

	Y in (0..max(X)-1   : min(X)+1  ..infinity) &
	     (0..max(X)-I-1 : min(X)-I+1..infinity) &
	     (0..max(X)+I-1 : min(X)+I+1..infinity).
*/


/*
diff(X,Y,I):-
	'x<>y'(X,Y),
	'x<>y+c'(X,Y,I),
	'x<>y+c'(Y,X,I).



'x<>y+c'(X,Y,C):- 
	X in -{val(Y)+C}, 
	Y in -{val(X)-C}.
*/




lab(normal,L):-  
	labeling(L).

lab(ff,L):-
	labelingff(L).




get_labeling(Lab):- 
	argc(C),
	get_labeling1(C,Lab).


get_labeling1(1,normal).

get_labeling1(2,Lab):-
	argv(1,Lab).




:- q.
