/*-------------------------------------------------------------------------*/
/* Benchmark (Finite Domain)            INRIA Rocquencourt - ChLoE Project */
/*                                                                         */
/* Name           : donald.pl                                              */
/* Title          : crypt-arithmetic                                       */
/* Original Source: Daniel Diaz - INRIA France                             */
/* Adapted by     :                                                        */
/* Date           : September 1992                                         */
/*                                                                         */
/* Solve the operation:                                                    */
/*                                                                         */
/*    D O N A L D                                                          */
/*  + G E R A L D                                                          */
/*  --------------                                                         */
/*  = R O B E R T                                                          */
/*                                                                         */
/* (resolution by line)                                                    */
/*                                                                         */
/* Solution:                                                               */
/*  [D,O,N,A,L,G,E,R,B,T]                                                  */
/*  [5,2,6,4,8,1,9,7,3,0]                                                  */
/*-------------------------------------------------------------------------*/

:- main.

q:-	get_labeling(Lab), statistics(runtime,_),
	donald(LD,Lab), statistics(runtime,[_,Y]),
	write(LD), nl,
	write('time : '), write(Y), nl,
	halt_or_else(0,true).




donald(LD,Lab):-
	LD=[D,O,N,A,L,G,E,R,B,T],
	alldifferent(LD),
	domain(LD,0,9),
	D in 1..9,
	G in 1..9,

	   100000*D+10000*O+1000*N+100*A+10*L+D +
	   100000*G+10000*E+1000*R+100*A+10*L+D
	#= 100000*R+10000*O+1000*B+100*E+10*R+T,

	lab(Lab,LD).




lab(normal,L):-  
	labeling(L).

lab(ff,L):-
	labelingff(L).




get_labeling(Lab):- 
	argc(C),
	get_labeling1(C,Lab).


get_labeling1(1,normal).

get_labeling1(2,Lab):-
	argv(1,Lab).




:- q.
