/*-------------------------------------------------------------------------*/
/* Benchmark (Finite Domain)            INRIA Rocquencourt - ChLoE Project */
/*                                                                         */
/* Name           : digit8.pl                                              */
/* Title          : particular 8 digit number                              */
/* Original Source: Daniel Diaz - INRIA France                             */
/* Adapted by     :                                                        */
/* Date           : October 1993                                           */
/*                                                                         */
/* Find the 8 digit number N such that:                                    */
/*                                                                         */
/*    - N is a square                                                      */
/*    - if we put a 1 in front of the decimal notation of N then it still  */
/*      is a square                                                        */
/*                                                                         */
/* Solution:                                                               */
/*  [N,X,M,Y]                                                              */
/*  [23765625,4875,123765625,11125]                                        */
/*  [56250000,7500,156250000,12500]                                        */
/*-------------------------------------------------------------------------*/

:- main.

q:-     get_labeling(Lab),
        statistics(runtime,_),
        (digit8(L,Lab), 
         write(L), nl,
         fail
           ;
         write('No more solutions'), nl),
	statistics(runtime,[_,Y]),
        write('time : '), write(Y), nl,
	halt_or_else(0,true).




digit8(L,Lab):-
	L=[N,X,M,Y],
	N in 10000000..99999999,
        'xx=y'(X,N),
	100000000+N #= M,
        'xx=y'(Y,M),
	lab(Lab,L).




lab(normal,L):-
        labeling(L).

lab(ff,L):-
        labelingff(L).




get_labeling(Lab):-
        argc(C),
        get_labeling1(C,Lab).


get_labeling1(1,normal).

get_labeling1(2,Lab):-
        argv(1,Lab).




:- q.

