# Executable's make file: bqueens.mk

EXECUTABLE= bqueens
MODULES   = bqueens.o array.o
OTHERS    =

COMPILER  = clp_fd
WGCC      = fd_gcc
PFLAGS    =  -v
CFLAGS    = -O2
LFLAGS    = -s

OBJS      = $(MODULES) $(OTHERS)
.SUFFIXES:
.SUFFIXES: .o .usr .c .pl $(SUFFIXES)

.pl.c:
	$(COMPILER) $(PFLAGS) -c $*.pl

.pl.usr:
	if [ -f $*.usr ]; then \
	touch $*.usr; \
	else \
	$(COMPILER) $(PFLAGS) -c $*.pl; \
	fi

.usr.o:
	$(WGCC) $(CFLAGS) -c $*.c

.c.o:
	$(WGCC) $(CFLAGS) -c $*.c

$(EXECUTABLE): $(OBJS)
	$(WGCC) -o $(EXECUTABLE)    $(CFLAGS) $(LFLAGS) $(OBJS) -l$(COMPILER)

$(EXECUTABLE)_pp: $(OBJS)
	$(WGCC) -o $(EXECUTABLE)_pp $(CFLAGS) $(LFLAGS) $(OBJS) -l$(COMPILER)_pp

bqueens.o: bqueens.c bqueens.usr

array.o: array.c array.usr

