/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Version 1.0  -  C Run-time                           Daniel Diaz - 1992 */
/* Extended to FD Constraints (July 1992)                                  */
/*                                                                         */
/* FD Constraints Implementation                                           */
/*                                                                         */
/* fd_engine.c                                                             */
/*-------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
int fprintf();
int sscanf();

#define FD_ENGINE

#include "wam_engine.h"
#include "fd_engine.h"




/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

static WamWord dummy_fd_var[FD_VARIABLE_FRAME_SIZE];




#ifdef WAM_PROFILE

static int   nb_fd_var=0;
static int   nb_fd_int_var=0;


static int   nb_fd_cstr=0;
static int   nb_fd_int_cstr=0;
static int   nb_unif_fd_int_imposs=0;
static int   nb_unif_fd_int_poss=0;

static int   prof_count[100];

static char *prof_name[100]=
       { "",                                /* prof_{name/count}[0] unused */
         "Total Tell",
         "True  Tell", "False Tell", 
         "INT Check Ok", "INT C Not Ok", "Empty Range",
         "",
         "Total Avoid","X Ground","Reexec",
         "$"};

#endif




/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/
static 
void     All_Propagations       (WamWord *fdv_adr,int propag);




#ifdef WAM_PROFILE

#define COUNT(x)   prof_count[x]++

#else

#define COUNT(x)

#endif



#define Display_Vector_Too_Small                                            \
     Lib1(printf,MSG_VECTOR_TOO_SMALL);




/*---------------------------------*/
/* Auxiliary engine macros         */
/*---------------------------------*/

#define Update_Range_From_Int(fdv_adr,n,propag)                             \
    {                                                                       \
     propag=MASK_EMPTY;                                                     \
                                                                            \
     Trail_Fd_Int_Variable_If_Necessary(fdv_adr)                            \
     Nb_Elem(fdv_adr)=1;                                                    \
                                                                            \
     Set_Min_Max_Mask(propag)                                               \
     Set_Dom_Mask(propag)                                                   \
     Set_Val_Mask(propag)                                                   \
                                                                            \
     if (Min(fdv_adr) != n)                                                 \
        {                                                                   \
         Min(fdv_adr)=n;                                                    \
         Set_Min_Mask(propag)                                               \
        }                                                                   \
                                                                            \
     if (Max(fdv_adr) != n)                                                 \
        {                                                                   \
         Max(fdv_adr)=n;                                                    \
         Set_Max_Mask(propag)                                               \
        }                                                                   \
                                                                            \
     Vec(fdv_adr)=NULL;                                                     \
     FD_Tag_Value(fdv_adr)=Tag_Value(INT,n);                                \
     FD_INT_Date(fdv_adr) =DATE;                                            \
    }




#define Update_Interval_From_Interval(fdv_adr,nb_elem,min,max,propag)       \
    {                                                                       \
     propag=MASK_EMPTY;                                                     \
                                                                            \
     if (Nb_Elem(fdv_adr) != nb_elem)                                       \
        {                                                                   \
         Trail_Range_If_Necessary(fdv_adr)                                  \
         Nb_Elem(fdv_adr)=nb_elem;                                          \
                                                                            \
         Set_Min_Max_Mask(propag)                                           \
         Set_Dom_Mask(propag)                                               \
                                                                            \
         if (Min(fdv_adr) != min)                                           \
            {                                                               \
             Min(fdv_adr)=min;                                              \
             Set_Min_Mask(propag)                                           \
            }                                                               \
                                                                            \
         if (Max(fdv_adr) != max)                                           \
            {                                                               \
             Max(fdv_adr)=max;                                              \
             Set_Max_Mask(propag)                                           \
            }                                                               \
        }                                                                   \
    }




#define Update_Range_From_Range(fdv_adr,nb_elem,range,propag)               \
    {                                                                       \
     propag=MASK_EMPTY;                                                     \
                                                                            \
     if (Min(fdv_adr) != (range)->min)                                      \
        {                                                                   \
         Set_Min_Mask(propag)                                               \
         Set_Min_Max_Mask(propag)                                           \
        }                                                                   \
                                                                            \
     if (Max(fdv_adr) != (range)->max)                                      \
        {                                                                   \
         Set_Max_Mask(propag)                                               \
         Set_Min_Max_Mask(propag)                                           \
        }                                                                   \
                                                                            \
     if (Nb_Elem(fdv_adr) != nb_elem)                                       \
         Set_Dom_Mask(propag)                                               \
                                                                            \
     if (propag || Is_Interval(Range(fdv_adr)) && Is_Sparse(range))         \
        {                                                                   \
         Trail_Range_If_Necessary(fdv_adr)                                  \
         Nb_Elem(fdv_adr)=nb_elem;                                          \
         Range_Copy(Range(fdv_adr),range);                                  \
        }                                                                   \
    }




/*-------------------------------------------------------------------------*/
/* INIT_FD_ENGINE                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Init_Fd_Engine(void)

{
 char *p;
 int   max_val;

 p=(char *) Lib1(getenv,ENV_VAR_VECTOR_MAX);
 if (p && *p)
     Lib3(sscanf,p,"%d",&max_val);
  else
     max_val=DEFAULT_VECTOR_MAX;

 Define_Vector_Size(max_val);

 STAMP=DATE=0;
}




/*-------------------------------------------------------------------------*/
/* TERM_FD_ENGINE                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Term_Fd_Engine(void)

{
#ifdef WAM_PROFILE
 int i,j;
#endif


#ifdef WAM_PROFILE
 Lib1(printf,"clp(FD) Profile informations\n\n");


 Lib1(printf,"FD variables:\n");
 Lib2(printf,"   true FD var :%10d\n",nb_fd_var);
 Lib2(printf,"   integer     :%10d\n\n",nb_fd_int_var);

 Lib1(printf,"Constraints:\n");
 Lib2(printf,"   Basic X in r:%10d\n",nb_fd_cstr);
 Lib2(printf,"   Unif integer:%10d with a possible value\n",
             nb_unif_fd_int_poss);
 Lib2(printf,"                %10d with an impossible value\n\n",
             nb_unif_fd_int_imposs);

 Lib1(printf,"Vectors:\n");

 Lib2(printf,"   defined size:%10d word(s)\n",vec_size);
 Lib2(printf,"   defined max :%10d\n\n",vec_infinity);

 Lib1(printf,"Counters:\n");

 for(i=j=1;*prof_name[i]!='$';i++)
     if (*prof_name[i])
         Lib3(printf,"   %-12s:%10d\n",prof_name[i],prof_count[j++]);
      else
         Lib1(printf,"\n");

 Lib1(printf,"\n");

#endif
}




/*-------------------------------------------------------------------------*/
/* PUSH_FD_VARIABLE                                                        */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Push_Fd_Variable(void)

{
 FD_Tag_Value(H)=Tag_Value(FDV,H);
 FD_INT_Date(H)=(unsigned) (1<<31)-1; /*must be > DATE while tag==FDV*/
 PS_Next_Fdv_Adr(H)=1;
 PS_Propag_Mask(H)=0;

 Range_Stamp(H)=Chains_Stamp(H)=STAMP;
 Nb_Elem(H)=INTERVAL_INFINITY+1;
 Init_Interval_Range(Range(H),0,INTERVAL_INFINITY);

 Chains_Mask(H)=MASK_EMPTY;
 Chain_Min(H)=Chain_Max(H)=Chain_Min_Max(H)=NULL;
 Chain_Dom(H)=Chain_Val(H)=NULL;

 H += FD_VARIABLE_FRAME_SIZE;

#ifdef WAM_PROFILE
 nb_fd_var++;
#endif
}




/*-------------------------------------------------------------------------*/
/* PUSH_FD_INT_VARIABLE                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Push_Fd_Int_Variable(int n)

{
 FD_Tag_Value(H)=Tag_Value(INT,n);
 FD_INT_Date(H)=DATE;
 PS_Next_Fdv_Adr(H)=1;
 PS_Propag_Mask(H)=0;

 Range_Stamp(H)=Chains_Stamp(H)=STAMP;
 Nb_Elem(H)=1;
 Init_Interval_Range(Range(H),n,n);

 H += FD_INT_VARIABLE_FRAME_SIZE;

#ifdef WAM_PROFILE
 nb_fd_int_var++;
#endif
}




/*-------------------------------------------------------------------------*/
/* X_Y_VALUE_IN_A_FRAME                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool X_Y_Value_In_A_Frame(WamWord word,WamWord tag,WamWord *adr)

{
 switch(tag)
    {
     case REF:
         Bind_UV(adr,Tag_Value(REF,H))
         *AF++ =(WamWord) H;
         Push_Fd_Variable();
         return TRUE;

     case INT:
         *AF++ =(WamWord) H;
         Push_Fd_Int_Variable(UnTag_INT(word));
         return TRUE;

     case FDV:
         *AF++ =(WamWord) UnTag_FDV(word);
         return TRUE;
    }

 return FALSE;
}




/*-------------------------------------------------------------------------*/
/* INIT_CALL_CONSTRAINT                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Init_Call_Constraint(void)

{
 TP=dummy_fd_var;
 DATE++;

#ifdef WAM_PROFILE
 nb_fd_cstr++;
#endif
}




/*-------------------------------------------------------------------------*/
/* TELL_INT_INTERVAL                                                       */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Tell_Int_Interval(int n,int min,int max)

{ 
 COUNT(1);

 if (n<min || n>max)                      /* detects also if the initial   */
    {                                     /* interval (min, max) was empty */
     COUNT(5);
     return FALSE;
    }

 COUNT(4);
 return TRUE;
}




/*-------------------------------------------------------------------------*/
/* TELL_INT_RANGE                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Tell_Int_Range(int n,Range *range)

{ 
 COUNT(1);

 if (!Is_Int_In_Range(range,n))
    {
     COUNT(5);

     if (n>vec_infinity && range->extra_cstr)
         Display_Vector_Too_Small

     return FALSE;
    }

 COUNT(4);
 H=save_H;
 return TRUE;
}





/*-------------------------------------------------------------------------*/
/* TELL_INTERVAL_INTERVAL                                                  */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Tell_Interval_Interval(WamWord *fdv_adr,int min,int max)

{ 
 int nb_elem;
 int propag;
 int min1,max1;

 COUNT(1);

 min1=Min(fdv_adr);
 max1=Max(fdv_adr);

 min=math_max(min,min1);
 max=math_min(max,max1);

 if (min>max)                             /* detects also if the initial   */
    {                                     /* interval (min, max) was empty */
     COUNT(6);
     return FALSE;
    }

 if (min==max)
     Update_Range_From_Int(fdv_adr,min,propag)
  else
    {
     nb_elem=max-min+1;
     Update_Interval_From_Interval(fdv_adr,nb_elem,min,max,propag)
    }

 if (propag)
    {
     COUNT(2);
     All_Propagations(fdv_adr,propag);
     return TRUE;
    }

 COUNT(3);

 return TRUE;
}




/*-------------------------------------------------------------------------*/
/* TELL_RANGE_RANGE                                                        */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Tell_Range_Range(WamWord *fdv_adr,Range *range)

{ 
 int nb_elem;
 int propag;

 COUNT(1);

 Range_Inter(range,Range(fdv_adr));

 if (Is_Empty(range))
    {
     COUNT(6);
     if (range->extra_cstr)
         Display_Vector_Too_Small

     return FALSE;
    }

 H=save_H;

 if (range->min==range->max)
    {
     if (range->extra_cstr)
         Display_Vector_Too_Small

     Update_Range_From_Int(fdv_adr,range->min,propag)
    }
  else
    {
     nb_elem=Range_Nb_Elem(range);
     Update_Range_From_Range(fdv_adr,nb_elem,range,propag)
    }

 if (propag)
    {
     COUNT(2);
     All_Propagations(fdv_adr,propag);
     return TRUE;
    }

 COUNT(3);

 return TRUE;
}




/*-------------------------------------------------------------------------*/
/* ALL_PROPAGATIONS                                                        */
/*                                                                         */
/*-------------------------------------------------------------------------*/
static void All_Propagations(WamWord *fdv_adr,int propag)

{
 int propag1;

 if (propag &= Chains_Mask(fdv_adr))
    {
     propag1=PS_Propag_Mask(fdv_adr);

     if (propag1==0)                               /* not yet in the queue */
        {
         PS_Propag_Mask(fdv_adr)=propag;
         PS_Next_Fdv_Adr(TP)=(WamWord) fdv_adr;
         TP=fdv_adr;
        }
      else                                         /* already in the queue */
        {
         propag|=propag1;
         PS_Propag_Mask(fdv_adr)=propag;
         COUNT(7);
         COUNT(9);
        }
    }
}




/*-------------------------------------------------------------------------*/
/* EXECUTE_PROPAGATION                                                     */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Execute_Propagation(void)

{
 WamWord *fdv_adr;
 WamWord  propag;
 WamWord *record_adr;
 WamWord *chain_adr;
 WamWord *cf;
 WamWord *bp;
 WamWord  date=DATE;

 if (TP==dummy_fd_var)
     return TRUE;

 bp=dummy_fd_var;         /* this dummy fd var will be ignored in the loop */

 do
    {
     bp=(WamWord *) PS_Next_Fdv_Adr(bp);

     fdv_adr=(WamWord *) bp;
     propag=PS_Propag_Mask(fdv_adr);
     PS_Propag_Mask(fdv_adr)=0;

     chain_adr= &Chain_Min(fdv_adr);

     for(;propag;propag >>= 1, chain_adr++)
         if (propag & 1)
            {
             record_adr=(WamWord *) (*chain_adr);
             do
                {
                 cf=(WamWord *) CF_Pointer(record_adr);

                 CF=cf;
#if 1
                                                               /* optim #2 */
                 if (FD_INT_Date(Tell_Fdv_Adr(cf))<date && Optim2(cf))
                    {
                     COUNT(7);
                     COUNT(8);
                     continue;
                    }
#endif

                 Execute_Constraint(goto failure;)
                }
             while(record_adr=(WamWord *) Next_Chain(record_adr));
            }
    }
 while(bp!=TP);

 return TRUE;


failure:                                      /* Reset PS_Propag_Maxk to 0 */
 while(bp!=TP)
    {
     bp=(WamWord *) PS_Next_Fdv_Adr(bp);

     fdv_adr=(WamWord *) bp;
     PS_Propag_Mask(fdv_adr)=0;
    }

 return FALSE;
}




/*-------------------------------------------------------------------------*/
/* UNIFY_FDV_AND_INT (for wam_engine)                                      */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Unify_FDV_And_INT(WamWord *fdv_adr,int n)

{
 int propag;

/* COUNT(1); */

 if (!Is_Int_In_Range(Range(fdv_adr),n))
    {
#ifdef WAM_PROFILE
     nb_unif_fd_int_imposs++;
#endif

/*     COUNT(6); */

     if (Extra_Cstr(fdv_adr) && n>vec_infinity)
         Display_Vector_Too_Small

     return FALSE;
    }

/* COUNT(2); */

 Init_Call_Constraint();                        /* Unify(X,n) == X in n..n */

#ifdef WAM_PROFILE
     nb_fd_cstr--;                    /* count this as possibl unification */
     nb_unif_fd_int_poss++;
#endif

 Update_Range_From_Int(fdv_adr,n,propag)

 All_Propagations(fdv_adr,propag);

 return Execute_Propagation();
}




/*-------------------------------------------------------------------------*/
/* UNIFY_FDV_AND_FDV (for wam_engine)                                      */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Unify_FDV_And_FDV(WamWord *fdv_adr1,WamWord *fdv_adr2)

#define Fd_Unify_2   Prefix(X66645F756E696679_2)

{
 Prototype(Fd_Unify_2)
 Bool     ret;
 WamWord *save_reg_bank=reg_bank;
 WamWord  local_reg_bank[REG_BANK_SIZE];

 Switch_Reg_Bank(local_reg_bank);

 A(0)=Tag_Value(REF,fdv_adr1);
 A(1)=Tag_Value(REF,fdv_adr2);

 ret=Call_Prolog((CodePtr) Fd_Unify_2);

 Switch_Reg_Bank(save_reg_bank);

 return ret;
}




/*-------------------------------------------------------------------------*/
/* FD_VARIABLE_SIZE                                                        */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int Fd_Variable_Size(WamWord *fdv_adr)

{
 int size=FD_VARIABLE_FRAME_SIZE;

 if (Is_Sparse(Range(fdv_adr)))
     size+=vec_size;

 return 1+size;         /* 1+ for <REF,->fdv_adr> since Global_UnMove(FDV) */
}




/*-------------------------------------------------------------------------*/
/* COPY_FD_VARIABLE                                                        */
/*                                                                         */
/* also returns the size of the created fd var (like FD_TERM_SIZE)         */
/*-------------------------------------------------------------------------*/
int Copy_Fd_Variable(WamWord *dst_adr,WamWord *fdv_adr)

{
 WamWord *savH;
 int size;

 savH=H;
 H=dst_adr;

 Push_Fd_Variable();
 size=H-dst_adr;
 H=savH;

 Range_Copy(Range(dst_adr),Range(fdv_adr));

 return size;
}




/*-------------------------------------------------------------------------*/
/* PROLOG_RANGE_TO_RANGE                                                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Prolog_Range_To_Range(WamWord *start_adr,Range *range)

{
 WamWord word,tag;
 WamWord *adr;
 WamWord *cur_adr;

 range->extra_cstr=FALSE;
 Vector_Allocate(range->vec);
 Vector_Empty(range->vec);

 Deref(*start_adr,word,tag,adr)

 while(word!=word_nil)
    {
     if (tag!=LST)
         return FALSE;

     
     adr=UnTag_LST(word);
     cur_adr=&Car(adr);
     start_adr=&Cdr(adr);
     Deref(*cur_adr,word,tag,adr)
     if (tag!=INT)
         return FALSE;

     word=UnTag_INT(word);

     if (word>vec_infinity)
         range->extra_cstr=TRUE;
      else
         if (word>=0)
             Set_Int_In_Vector(range->vec,word);

     Deref(*start_adr,word,tag,adr)
    }

 Range_From_Vector(range);

 return TRUE;
}




/*-------------------------------------------------------------------------*/
/* WRITE_FD_VARIABLE                                                       */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Write_Fd_Variable(FILE *out,WamWord *fdv_adr)

{
 Range_Write(out,Range(fdv_adr));
}
