/****************************************************************************
Prolog to Wam Compiler                     INRIA Rocquencourt - ChLoE Project
Version 2.2                                                Daniel Diaz - 1994

File : ../Builtin/fd_math.c
Main : no_main
****************************************************************************/

#define DEBUG_LEVEL    0

#include "wam_engine.h"
#include "fd_engine.h"

#include "fd_math.h"
#include "fd_math.usr"


#define ASCII_PRED "min(x,y)=z"
#define PRED       X6D696E28782C79293D7A
#define ARITY      3

Begin_Public_Pred
      allocate(3)
      get_y_variable(1,0)
      get_y_variable(0,1)
      get_y_variable(2,2)
      put_y_value(1,0)
      put_y_value(2,1)
      call(Pred_Name(X783E3D79,2),1,3,1,"x>=y",2)          /* begin sub 1 */
      put_y_value(0,0)
      put_y_value(2,1)
      call(Pred_Name(X783E3D79,2),1,3,2,"x>=y",2)          /* begin sub 2 */
      fd_set_x_AF(3,0)
      fd_y_value_in_A_frame(2)
      fd_y_value_in_A_frame(1)
      fd_y_value_in_A_frame(0)
      fd_install_constraint_with_x_AF(1,0)
      fd_call_constraint
      deallocate
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(1)

      fd_create_C_frame(1,0,0)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(1)

      fd_allocate
      fd_ind_min_max(3,0,1)
      fd_ind_min_max(2,1,2)
      fd_interval_range(0,3,0)
      fd_interval_range(1,2,1)
      fd_union(0,1)
      fd_tell_range(0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "max(x,y)=z"
#define PRED       X6D617828782C79293D7A
#define ARITY      3

Begin_Public_Pred
      allocate(3)
      get_y_variable(1,0)
      get_y_variable(0,1)
      get_y_variable(2,2)
      put_y_value(2,0)
      put_y_value(1,1)
      call(Pred_Name(X783E3D79,2),1,3,1,"x>=y",2)          /* begin sub 1 */
      put_y_value(2,0)
      put_y_value(0,1)
      call(Pred_Name(X783E3D79,2),1,3,2,"x>=y",2)          /* begin sub 2 */
      fd_set_x_AF(3,0)
      fd_y_value_in_A_frame(2)
      fd_y_value_in_A_frame(1)
      fd_y_value_in_A_frame(0)
      fd_install_constraint_with_x_AF(2,0)
      fd_call_constraint
      deallocate
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(2)

      fd_create_C_frame(2,0,0)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(2)

      fd_allocate
      fd_ind_min_max(3,0,1)
      fd_ind_min_max(2,1,2)
      fd_interval_range(0,3,0)
      fd_interval_range(1,2,1)
      fd_union(0,1)
      fd_tell_range(0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "|x-y|=z"
#define PRED       X7C782D797C3D7A
#define ARITY      3

Begin_Public_Pred
      fd_set_x_AF(3,3)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(2)
      fd_install_constraint_with_x_AF(3,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(4,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(5,3)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(3)

      fd_create_C_frame(3,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(3)

      fd_allocate
      fd_ind_min_max(2,1,1)
      fd_ind_min_max(3,4,2)
      fd_term_copy(5,2)
      fd_term_add_term(5,3)
      fd_term_copy(0,1)
      fd_term_add_term(0,4)
      fd_interval_range(0,5,0)
      fd_term_sub_term(2,4)
      fd_term_sub_term(1,3)
      fd_interval_range(1,2,1)
      fd_union(0,1)
      fd_tell_range(0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(4)

      fd_create_C_frame(4,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(4)

      fd_allocate
      fd_ind_min_max(2,1,0)
      fd_ind_min_max(3,4,2)
      fd_term_copy(5,2)
      fd_term_add_term(5,3)
      fd_term_copy(0,1)
      fd_term_add_term(0,4)
      fd_interval_range(0,5,0)
      fd_term_sub_term(2,4)
      fd_term_sub_term(1,3)
      fd_interval_range(1,2,1)
      fd_union(0,1)
      fd_tell_range(0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(5)

      fd_create_C_frame(5,2,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(5)

      fd_allocate
      fd_ind_min_max(3,4,0)
      fd_ind_min_max(2,1,1)
      fd_term_copy(5,3)
      fd_term_sub_term(5,1)
      fd_term_copy(0,4)
      fd_term_sub_term(0,2)
      fd_interval_range(0,5,0)
      fd_term_sub_term(2,4)
      fd_term_sub_term(1,3)
      fd_interval_range(1,2,1)
      fd_union(0,1)
      fd_tell_range(0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "xx=y"
#define PRED       X78783D79
#define ARITY      2

Begin_Public_Pred
      fd_set_x_AF(2,2)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(6,2)
      fd_call_constraint
      fd_install_constraint_with_x_AF(7,2)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(6)

      fd_create_C_frame(6,0,1)
      fd_install_ind_min_max(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(6)

      fd_ind_min_max(3,2,1)
      fd_term_fct(Sqrt_Ceil,1,arg_1(tr(3)))
      fd_term_fct(Sqrt_Floor,0,arg_1(tr(2)))
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(7)

      fd_create_C_frame(7,1,1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(7)

      fd_ind_min_max(1,0,0)
      fd_term_mul_term(1,1)
      fd_term_mul_term(0,0)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "xy=z"
#define PRED       X78793D7A
#define ARITY      3

Begin_Public_Pred
      fd_set_x_AF(3,3)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(2)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(8,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(9,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(10,3)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(8)

      fd_create_C_frame(8,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(8)

      fd_ind_min_max(5,3,1)
      fd_ind_min_max(2,4,2)
      fd_term_fct(div0_ceil,1,arg_2(tr(5),tr(4)))
      fd_term_fct(div0_floor,0,arg_2(tr(3),tr(2)))
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(9)

      fd_create_C_frame(9,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(9)

      fd_ind_min_max(5,3,1)
      fd_ind_min_max(2,4,0)
      fd_term_fct(div0_ceil,1,arg_2(tr(5),tr(4)))
      fd_term_fct(div0_floor,0,arg_2(tr(3),tr(2)))
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(10)

      fd_create_C_frame(10,1,0)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(10)

      fd_ind_min_max(1,0,0)
      fd_ind_min_max(3,2,2)
      fd_term_mul_term(1,3)
      fd_term_mul_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x=y"
#define PRED       X783D79
#define ARITY      2

Begin_Public_Pred
      fd_set_x_AF(2,2)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(11,2)
      fd_call_constraint
      fd_install_constraint_with_x_AF(12,2)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(11)

      fd_create_C_frame(11,0,1)
      fd_install_ind_min_max(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(11)

      fd_ind_min_max(1,0,1)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(12)

      fd_create_C_frame(12,1,1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(12)

      fd_ind_min_max(1,0,0)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x<>y"
#define PRED       X783C3E79
#define ARITY      2

Begin_Public_Pred
      fd_set_x_AF(2,2)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(13,2)
      fd_call_constraint
      fd_install_constraint_with_x_AF(14,2)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(13)

      fd_create_C_frame(13,0,1)
      fd_install_dly_val(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(13)

      fd_allocate
      fd_dly_val(0,1,1)
      fd_compl_of_singleton(0,0)
      fd_tell_range(0)

   Fd_Label(1)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(14)

      fd_create_C_frame(14,1,1)
      fd_install_dly_val(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(14)

      fd_allocate
      fd_dly_val(0,0,1)
      fd_compl_of_singleton(0,0)
      fd_tell_range(0)

   Fd_Label(1)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x>=y"
#define PRED       X783E3D79
#define ARITY      2

Begin_Public_Pred
      fd_set_x_AF(2,2)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(15,2)
      fd_call_constraint
      fd_install_constraint_with_x_AF(16,2)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(15)

      fd_create_C_frame(15,0,1)
      fd_install_ind_min(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(15)

      fd_ind_min(1,1)
      fd_integer(0,infinity)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(16)

      fd_create_C_frame(16,1,1)
      fd_install_ind_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(16)

      fd_ind_max(0,0)
      fd_integer(1,0)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x>y"
#define PRED       X783E79
#define ARITY      2

Begin_Public_Pred
      fd_set_x_AF(2,2)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(17,2)
      fd_call_constraint
      fd_install_constraint_with_x_AF(18,2)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(17)

      fd_create_C_frame(17,0,1)
      fd_install_ind_min(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(17)

      fd_ind_min(1,1)
      fd_integer(0,1)
      fd_term_add_term(1,0)
      fd_integer(0,infinity)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(18)

      fd_create_C_frame(18,1,1)
      fd_install_ind_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(18)

      fd_ind_max(0,0)
      fd_integer(1,0)
      fd_integer(2,1)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax=y"
#define PRED       X61783D79
#define ARITY      3

Begin_Public_Pred
      fd_set_x_AF(3,3)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(2)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(19,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(20,3)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(19)

      fd_create_C_frame(19,0,1)
      fd_install_ind_min_max(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(19)

      fd_ind_min_max(1,0,1)
      fd_term_parameter(2,2)
      fd_term_ceil_div_term(1,2)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(20)

      fd_create_C_frame(20,1,1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(20)

      fd_ind_min_max(1,0,0)
      fd_term_parameter(2,2)
      fd_term_mul_term(1,2)
      fd_term_mul_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x+y=z"
#define PRED       X782B793D7A
#define ARITY      3

Begin_Public_Pred
      fd_set_x_AF(3,3)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(2)
      fd_x_value_in_A_frame(1)
      fd_install_constraint_with_x_AF(21,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(22,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(23,3)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(21)

      fd_create_C_frame(21,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(21)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(2,3,2)
      fd_term_sub_term(1,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(22)

      fd_create_C_frame(22,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(22)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(2,3,0)
      fd_term_sub_term(1,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(23)

      fd_create_C_frame(23,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(23)

      fd_ind_min_max(1,0,0)
      fd_ind_min_max(3,2,2)
      fd_term_add_term(1,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x+c=y"
#define PRED       X782B633D79
#define ARITY      3

Begin_Public_Pred
      fd_set_x_AF(3,3)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(2)
      fd_x_term_parameter_in_A_frame(1)
      fd_install_constraint_with_x_AF(24,3)
      fd_call_constraint
      fd_install_constraint_with_x_AF(25,3)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(24)

      fd_create_C_frame(24,0,1)
      fd_install_ind_min_max(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(24)

      fd_ind_min_max(1,0,1)
      fd_term_parameter(2,2)
      fd_term_sub_term(1,2)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(25)

      fd_create_C_frame(25,1,1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(25)

      fd_ind_min_max(1,0,0)
      fd_term_parameter(2,2)
      fd_term_add_term(1,2)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+c=y"
#define PRED       X61782B633D79
#define ARITY      4

Begin_Public_Pred
      fd_set_x_AF(4,4)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(3)
      fd_x_term_parameter_in_A_frame(2)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(26,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(27,4)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(26)

      fd_create_C_frame(26,0,1)
      fd_install_ind_min_max(1)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(26)

      fd_ind_min_max(1,0,1)
      fd_term_parameter(3,2)
      fd_term_sub_term(1,3)
      fd_term_parameter(2,3)
      fd_term_ceil_div_term(1,2)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(27)

      fd_create_C_frame(27,1,1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(27)

      fd_ind_min_max(1,0,0)
      fd_term_parameter(3,3)
      fd_term_mul_term(1,3)
      fd_term_parameter(2,2)
      fd_term_add_term(1,2)
      fd_term_mul_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+y=z"
#define PRED       X61782B793D7A
#define ARITY      4

Begin_Public_Pred
      fd_set_x_AF(4,4)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(3)
      fd_x_value_in_A_frame(2)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(28,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(29,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(30,4)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(28)

      fd_create_C_frame(28,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(28)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(3,2,2)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,3)
      fd_term_ceil_div_term(1,2)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(29)

      fd_create_C_frame(29,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(29)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(2,4,0)
      fd_term_parameter(3,3)
      fd_term_mul_term(4,3)
      fd_term_sub_term(1,4)
      fd_term_mul_term(2,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(30)

      fd_create_C_frame(30,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(30)

      fd_ind_min_max(1,0,0)
      fd_ind_min_max(4,2,2)
      fd_term_parameter(3,3)
      fd_term_mul_term(1,3)
      fd_term_add_term(1,4)
      fd_term_mul_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+by=z"
#define PRED       X61782B62793D7A
#define ARITY      5

Begin_Public_Pred
      fd_set_x_AF(5,5)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(4)
      fd_x_term_parameter_in_A_frame(2)
      fd_x_value_in_A_frame(3)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(31,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(32,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(33,5)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(31)

      fd_create_C_frame(31,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(31)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,5,3)
      fd_term_parameter(3,2)
      fd_term_copy(2,3)
      fd_term_mul_term(2,5)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,4)
      fd_term_ceil_div_term(1,2)
      fd_term_mul_term(3,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(32)

      fd_create_C_frame(32,3,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(32)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,5,0)
      fd_term_parameter(3,4)
      fd_term_copy(2,3)
      fd_term_mul_term(2,5)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,2)
      fd_term_ceil_div_term(1,2)
      fd_term_mul_term(3,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(33)

      fd_create_C_frame(33,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(33)

      fd_ind_min_max(2,4,0)
      fd_ind_min_max(6,3,3)
      fd_term_parameter(0,4)
      fd_term_copy(1,0)
      fd_term_mul_term(1,2)
      fd_term_parameter(2,2)
      fd_term_copy(5,2)
      fd_term_mul_term(5,6)
      fd_term_add_term(1,5)
      fd_term_mul_term(0,4)
      fd_term_mul_term(2,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x+y+c=z"
#define PRED       X782B792B633D7A
#define ARITY      4

Begin_Public_Pred
      fd_set_x_AF(4,4)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(3)
      fd_x_value_in_A_frame(1)
      fd_x_term_parameter_in_A_frame(2)
      fd_install_constraint_with_x_AF(34,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(35,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(36,4)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(34)

      fd_create_C_frame(34,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(34)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(3,2,2)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,3)
      fd_term_sub_term(1,2)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(35)

      fd_create_C_frame(35,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(35)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(3,2,0)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,3)
      fd_term_sub_term(1,2)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(36)

      fd_create_C_frame(36,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(36)

      fd_ind_min_max(1,0,0)
      fd_ind_min_max(2,3,2)
      fd_term_add_term(1,2)
      fd_term_parameter(2,3)
      fd_term_add_term(1,2)
      fd_term_add_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+y+c=z"
#define PRED       X61782B792B633D7A
#define ARITY      5

Begin_Public_Pred
      fd_set_x_AF(5,5)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(4)
      fd_x_value_in_A_frame(2)
      fd_x_term_parameter_in_A_frame(3)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(37,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(38,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(39,5)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(37)

      fd_create_C_frame(37,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(37)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,2,2)
      fd_term_sub_term(1,2)
      fd_term_parameter(3,3)
      fd_term_sub_term(1,3)
      fd_term_parameter(2,4)
      fd_term_ceil_div_term(1,2)
      fd_term_sub_term(0,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(38)

      fd_create_C_frame(38,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(38)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,5,0)
      fd_term_parameter(3,4)
      fd_term_copy(2,3)
      fd_term_mul_term(2,5)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,3)
      fd_term_sub_term(1,2)
      fd_term_mul_term(3,4)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(39)

      fd_create_C_frame(39,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(39)

      fd_ind_min_max(5,4,0)
      fd_ind_min_max(2,3,2)
      fd_term_parameter(0,4)
      fd_term_copy(1,0)
      fd_term_mul_term(1,5)
      fd_term_add_term(1,2)
      fd_term_parameter(2,3)
      fd_term_add_term(1,2)
      fd_term_mul_term(0,4)
      fd_term_add_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+by+c=z"
#define PRED       X61782B62792B633D7A
#define ARITY      6

Begin_Public_Pred
      fd_set_x_AF(6,6)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(5)
      fd_x_term_parameter_in_A_frame(2)
      fd_x_value_in_A_frame(3)
      fd_x_term_parameter_in_A_frame(4)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(40,6)
      fd_call_constraint
      fd_install_constraint_with_x_AF(41,6)
      fd_call_constraint
      fd_install_constraint_with_x_AF(42,6)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(40)

      fd_create_C_frame(40,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(40)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(5,3,3)
      fd_term_parameter(4,2)
      fd_term_copy(2,4)
      fd_term_mul_term(2,3)
      fd_term_sub_term(1,2)
      fd_term_parameter(3,4)
      fd_term_sub_term(1,3)
      fd_term_parameter(2,5)
      fd_term_ceil_div_term(1,2)
      fd_term_mul_term(4,5)
      fd_term_sub_term(0,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(41)

      fd_create_C_frame(41,3,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(41)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(5,3,0)
      fd_term_parameter(4,5)
      fd_term_copy(2,4)
      fd_term_mul_term(2,3)
      fd_term_sub_term(1,2)
      fd_term_parameter(3,4)
      fd_term_sub_term(1,3)
      fd_term_parameter(2,2)
      fd_term_ceil_div_term(1,2)
      fd_term_mul_term(4,5)
      fd_term_sub_term(0,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(42)

      fd_create_C_frame(42,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(42)

      fd_ind_min_max(2,5,0)
      fd_ind_min_max(6,4,3)
      fd_term_parameter(0,5)
      fd_term_copy(1,0)
      fd_term_mul_term(1,2)
      fd_term_parameter(3,2)
      fd_term_copy(2,3)
      fd_term_mul_term(2,6)
      fd_term_add_term(1,2)
      fd_term_parameter(2,4)
      fd_term_add_term(1,2)
      fd_term_mul_term(0,5)
      fd_term_mul_term(3,4)
      fd_term_add_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "x+y+z=t"
#define PRED       X782B792B7A3D74
#define ARITY      4

Begin_Public_Pred
      fd_set_x_AF(4,4)
      fd_x_value_in_A_frame(0)
      fd_x_value_in_A_frame(3)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(2)
      fd_install_constraint_with_x_AF(43,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(44,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(45,4)
      fd_call_constraint
      fd_install_constraint_with_x_AF(46,4)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(43)

      fd_create_C_frame(43,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(43)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(3,5,2)
      fd_ind_min_max(2,4,3)
      fd_term_sub_term(1,5)
      fd_term_sub_term(1,4)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(44)

      fd_create_C_frame(44,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(44)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(3,5,0)
      fd_ind_min_max(2,4,3)
      fd_term_sub_term(1,5)
      fd_term_sub_term(1,4)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(45)

      fd_create_C_frame(45,3,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(45)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(3,5,0)
      fd_ind_min_max(2,4,2)
      fd_term_sub_term(1,5)
      fd_term_sub_term(1,4)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(46)

      fd_create_C_frame(46,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(46)

      fd_ind_min_max(1,0,0)
      fd_ind_min_max(5,3,2)
      fd_ind_min_max(4,2,3)
      fd_term_add_term(1,5)
      fd_term_add_term(1,4)
      fd_term_add_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+y+z=t"
#define PRED       X61782B792B7A3D74
#define ARITY      5

Begin_Public_Pred
      fd_set_x_AF(5,5)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(4)
      fd_x_value_in_A_frame(2)
      fd_x_value_in_A_frame(3)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(47,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(48,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(49,5)
      fd_call_constraint
      fd_install_constraint_with_x_AF(50,5)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(47)

      fd_create_C_frame(47,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(2)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(47)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,5,2)
      fd_ind_min_max(3,2,3)
      fd_term_sub_term(1,5)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,4)
      fd_term_ceil_div_term(1,2)
      fd_term_sub_term(0,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(48)

      fd_create_C_frame(48,2,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(48)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,7,0)
      fd_ind_min_max(2,5,3)
      fd_term_parameter(3,4)
      fd_term_copy(6,3)
      fd_term_mul_term(6,7)
      fd_term_sub_term(1,6)
      fd_term_sub_term(1,5)
      fd_term_mul_term(3,4)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(49)

      fd_create_C_frame(49,3,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(49)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(4,7,0)
      fd_ind_min_max(2,5,2)
      fd_term_parameter(3,4)
      fd_term_copy(6,3)
      fd_term_mul_term(6,7)
      fd_term_sub_term(1,6)
      fd_term_sub_term(1,5)
      fd_term_mul_term(3,4)
      fd_term_sub_term(0,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(50)

      fd_create_C_frame(50,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(2)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(50)

      fd_ind_min_max(7,4,0)
      fd_ind_min_max(6,3,2)
      fd_ind_min_max(5,2,3)
      fd_term_parameter(0,4)
      fd_term_copy(1,0)
      fd_term_mul_term(1,7)
      fd_term_add_term(1,6)
      fd_term_add_term(1,5)
      fd_term_mul_term(0,4)
      fd_term_add_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint



#define ASCII_PRED "ax+by+z=t"
#define PRED       X61782B62792B7A3D74
#define ARITY      6

Begin_Public_Pred
      fd_set_x_AF(6,6)
      fd_x_value_in_A_frame(1)
      fd_x_value_in_A_frame(5)
      fd_x_term_parameter_in_A_frame(2)
      fd_x_value_in_A_frame(3)
      fd_x_value_in_A_frame(4)
      fd_x_term_parameter_in_A_frame(0)
      fd_install_constraint_with_x_AF(51,6)
      fd_call_constraint
      fd_install_constraint_with_x_AF(52,6)
      fd_call_constraint
      fd_install_constraint_with_x_AF(53,6)
      fd_call_constraint
      fd_install_constraint_with_x_AF(54,6)
      fd_call_constraint
      proceed

End_Pred

#undef ASCII_PRED
#undef PRED
#undef ARITY


Begin_Fd_Install(51)

      fd_create_C_frame(51,0,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(3)
      fd_install_ind_min_max(4)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(51)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(5,7,3)
      fd_ind_min_max(3,2,4)
      fd_term_parameter(4,2)
      fd_term_copy(6,4)
      fd_term_mul_term(6,7)
      fd_term_sub_term(1,6)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,5)
      fd_term_ceil_div_term(1,2)
      fd_term_mul_term(4,5)
      fd_term_sub_term(0,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(52)

      fd_create_C_frame(52,3,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(4)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(52)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(5,7,0)
      fd_ind_min_max(3,2,4)
      fd_term_parameter(4,5)
      fd_term_copy(6,4)
      fd_term_mul_term(6,7)
      fd_term_sub_term(1,6)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,2)
      fd_term_ceil_div_term(1,2)
      fd_term_mul_term(4,5)
      fd_term_sub_term(0,4)
      fd_term_sub_term(0,3)
      fd_term_floor_div_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(53)

      fd_create_C_frame(53,4,1)
      fd_install_ind_min_max(1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(3)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(53)

      fd_ind_min_max(1,0,1)
      fd_ind_min_max(5,6,0)
      fd_ind_min_max(3,7,3)
      fd_term_parameter(4,5)
      fd_term_copy(2,4)
      fd_term_mul_term(2,6)
      fd_term_sub_term(1,2)
      fd_term_parameter(2,2)
      fd_term_copy(6,2)
      fd_term_mul_term(6,7)
      fd_term_sub_term(1,6)
      fd_term_mul_term(4,5)
      fd_term_sub_term(0,4)
      fd_term_mul_term(2,3)
      fd_term_sub_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Fd_Install(54)

      fd_create_C_frame(54,1,1)
      fd_install_ind_min_max(0)
      fd_install_ind_min_max(3)
      fd_install_ind_min_max(4)
      fd_proceed

End_Fd_Install


Begin_Fd_Constraint(54)

      fd_ind_min_max(3,5,0)
      fd_ind_min_max(8,4,3)
      fd_ind_min_max(6,2,4)
      fd_term_parameter(0,5)
      fd_term_copy(1,0)
      fd_term_mul_term(1,3)
      fd_term_parameter(3,2)
      fd_term_copy(7,3)
      fd_term_mul_term(7,8)
      fd_term_add_term(1,7)
      fd_term_add_term(1,6)
      fd_term_mul_term(0,5)
      fd_term_mul_term(3,4)
      fd_term_add_term(0,3)
      fd_term_add_term(0,2)
      fd_tell_interval(1,0)
      fd_proceed

End_Fd_Constraint


Begin_Init_Tables(fd_math)

 Define_Atom(X5B5D,"[]")
 Define_Atom(X6D696E28782C79293D7A,"min(x,y)=z")
 Define_Atom(X6D617828782C79293D7A,"max(x,y)=z")
 Define_Atom(X7C782D797C3D7A,"|x-y|=z")
 Define_Atom(X78783D79,"xx=y")
 Define_Atom(X78793D7A,"xy=z")
 Define_Atom(X783D79,"x=y")
 Define_Atom(X783C3E79,"x<>y")
 Define_Atom(X783E3D79,"x>=y")
 Define_Atom(X783E79,"x>y")
 Define_Atom(X61783D79,"ax=y")
 Define_Atom(X782B793D7A,"x+y=z")
 Define_Atom(X782B633D79,"x+c=y")
 Define_Atom(X61782B633D79,"ax+c=y")
 Define_Atom(X61782B793D7A,"ax+y=z")
 Define_Atom(X61782B62793D7A,"ax+by=z")
 Define_Atom(X782B792B633D7A,"x+y+c=z")
 Define_Atom(X61782B792B633D7A,"ax+y+c=z")
 Define_Atom(X61782B62792B633D7A,"ax+by+c=z")
 Define_Atom(X782B792B7A3D74,"x+y+z=t")
 Define_Atom(X61782B792B7A3D74,"ax+y+z=t")
 Define_Atom(X61782B62792B7A3D74,"ax+by+z=t")


 Define_Pred(X6D696E28782C79293D7A,3,1)

 Define_Pred(X6D617828782C79293D7A,3,1)

 Define_Pred(X7C782D797C3D7A,3,1)

 Define_Pred(X78783D79,2,1)

 Define_Pred(X78793D7A,3,1)

 Define_Pred(X783D79,2,1)

 Define_Pred(X783C3E79,2,1)

 Define_Pred(X783E3D79,2,1)

 Define_Pred(X783E79,2,1)

 Define_Pred(X61783D79,3,1)

 Define_Pred(X782B793D7A,3,1)

 Define_Pred(X782B633D79,3,1)

 Define_Pred(X61782B633D79,4,1)

 Define_Pred(X61782B793D7A,4,1)

 Define_Pred(X61782B62793D7A,5,1)

 Define_Pred(X782B792B633D7A,4,1)

 Define_Pred(X61782B792B633D7A,5,1)

 Define_Pred(X61782B62792B633D7A,6,1)

 Define_Pred(X782B792B7A3D74,4,1)

 Define_Pred(X61782B792B7A3D74,5,1)

 Define_Pred(X61782B62792B7A3D74,6,1)

 Init_Usr_File

End_Init_Tables


Begin_Exec_Directives(fd_math)



End_Exec_Directives
