/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Version 1.0  -  C Run-time                           Daniel Diaz - 1991 */
/* Extended to FD Constraints (July 1992)                                  */
/*                                                                         */
/* Built-In: FD predicates                                                 */
/*                                                                         */
/* fd_bips.pl                                                              */
/*-------------------------------------------------------------------------*/

:- public fd_vector_max/1.


fd_vector_max(_N):-
	pragma_c('Fd_Vector_Max_1').




          /* FD variable informations */

:- public fd_infinity/1,
          fd_var/1, fd_min/2, fd_max/2, fd_dom/2, fd_size/2, fd_extra_cstr/2,
          fd_has_vector/1, fd_use_vector/1.

fd_infinity(_X):-
	pragma_c('get_integer(infinity,0)').




fd_var(_X):-
	pragma_c('Fd_Var_1').




fd_min(_X,_S):-
	pragma_c('Fd_Min_2').




fd_max(_X,_S):-
	pragma_c('Fd_Max_2').




fd_dom(_X,_L):-
	pragma_c('Fd_Dom_2').




fd_size(_X,_S):-
	pragma_c('Fd_Size_2').




fd_extra_cstr(_X,_F):-
	pragma_c('Fd_Extra_Cstr_2').




fd_has_vector(_X):-
        pragma_c('Fd_Has_Vector_1').




fd_use_vector(X):-
        X in (0..2:4..infinity):(3..infinity).




            /* Unification */

:- public fd_unify/2.

fd_unify(X,Y):-
	X in dom(Y),
	Y in dom(X).




            /* Domain declaration and labeling */

:- public domain/3, indomain/1, labeling/1, labelingff/1, deleteff/3.


domain([],_,_).

domain([X|L],I,S):-
	X in I..S,
	domain(L,I,S).




indomain(_X):-
	pragma_c('Indomain_1').




labeling([]).

labeling([X|L]):-
	indomain(X),
	labeling(L).




labelingff(_L):-
	pragma_c('Labelingff_1').


labelingff1(L,X):-                                 % called by Labelingff_1
	indomain(X),
	labelingff(L).






deleteff(X,[Y|L],L1):-
	deleteff(X,L,Y,L1).


deleteff(X,L,Y,L1) :-
	fd_size(Y,SY),
	deleteff(X,L,Y,SY,L1).

deleteff(X,L,X,1,L):-
	!.

deleteff(X,[],X,_,[]) :-
	!.

deleteff(X,[Z|L],Y,J,L1) :-
	fd_size(Z,I),
	(J=<I -> L1=[Z|L2],
                 H1=Y,
		 K=J
	      ;  
                 L1=[Y|L2],
		 H1=Z,
		 K=I),
	deleteff(X,L,H1,K,L2).




	/* Symbolic constraints */

:- public alldifferent/1, element/3, atmost/3, relation/2, relationc/2.


alldifferent([]).

alldifferent([X|L]):-
	out_of(L,X),
	alldifferent(L).




out_of([],_).

out_of([Y|L],X):-
	'x<>y'(X,Y),
	out_of(L,X).




element(I,L,V):-
	length(L,N),
	element1(I,V,N,L).


element1(_I,_V,_N,_L):-
	pragma_c('Element1_4').




atmost(Nb,L,V):-
	length(L,N),
	atmost1(Nb,V,N,L).


atmost1(_Nb,_V,_N,_L):-
	pragma_c('Atmost1_4').





relation(Tuples,Vars):-
	lines_to_columns(Tuples,CTuples),
	relationc1(CTuples,Vars,_).



relationc(CTuples,Vars):-
	relationc1(CTuples,Vars,_).




relationc1([],[],_).

relationc1([C|CTuples],[X|Vars],R):-
	element(R,C,X),
	relationc1(CTuples,Vars,R).




lines_to_columns([[]|_],[]):-
        !.

lines_to_columns(Tuples,[Column|Columns]):-
        create_column(Tuples,Column,Tuples1),
        lines_to_columns(Tuples1,Columns).




create_column([],[],[]).

create_column([[X|L]|Tuples],[X|Column],[L|Tuples1]):-
        create_column(Tuples,Column,Tuples1).




          /* Optimization predicates */

:- public minof/2, maxof/2.

minof(Goal,Var):-
	fd_infinity(Max),
	g_assign('$cur_min',Max),
	repeat,
	g_read('$cur_min',B),
	(Var in 0..B-1, call(Goal)
                 -> fd_min(Var,C), 
	            g_assign('$cur_min',C),
		    fail
		 ;
		    !,
		    Var=B,
		    call(Goal)).



maxof(Goal,Var):-
	g_assign('$cur_max',0),
	repeat,
	g_read('$cur_max',B),
	(Var in B+1..infinity, call(Goal)
                 -> fd_max(Var,C), 
	            g_assign('$cur_max',C),
		    fail
		 ;
		    !,
		    Var=B,
		    call(Goal)).




:- 	op(700,xfx,in), op(690,xf,no_opt2),
	op(650,yfx,:),  op(600,yfx,&), op(550,xfx,..),
	op(700,xfx,[#=,#\=,#<,#<=,#>,#>=]), 
	fail ; true.                                        % gc
