/*-------------------------------------------------------------------------*/
/* Prolog To Wam Compiler                INRIA Rocquencourt - CLoE Project */
/* C Run-time                                           Daniel Diaz - 1994 */
/*                                                                         */
/* Inline builtin library                                                  */
/*                                                                         */
/* lib_inline.c                                                            */
/*-------------------------------------------------------------------------*/
#include "wam_engine.h"




/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

#define MAX_G_VARS 4096

#define ERR_ILLEGAL_ARGUMENT       "\nError: Illegal argument\n"




/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

static WamWord g_vars[MAX_G_VARS];




/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/


/*--- Builtins ------------------------------------------------------------*/



          /* Term Comparison */


/*-------------------------------------------------------------------------*/
/* BLT_2_TERM_EQ                                                           */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_term_eq(WamWord x,WamWord y)

{
 return (Compare_Term(&x,&y)==0);
}




/*-------------------------------------------------------------------------*/
/* BLT_2_TERM_NEQ                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_term_neq(WamWord x,WamWord y)

{
 return (Compare_Term(&x,&y)!=0);
}




/*-------------------------------------------------------------------------*/
/* BLT_2_TERM_LT                                                           */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_term_lt(WamWord x,WamWord y)

{
 return (Compare_Term(&x,&y)<0);
}




/*-------------------------------------------------------------------------*/
/* BLT_2_TERM_LTE                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_term_lte(WamWord x,WamWord y)

{
 return (Compare_Term(&x,&y)<=0);
}




/*-------------------------------------------------------------------------*/
/* BLT_2_TERM_GT                                                           */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_term_gt(WamWord x,WamWord y)

{
 return (Compare_Term(&x,&y)>0);
}




/*-------------------------------------------------------------------------*/
/* BLT_2_TERM_GTE                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_term_gte(WamWord x,WamWord y)

{
 return (Compare_Term(&x,&y)>=0);
}




          /* Math comparison */




/*-------------------------------------------------------------------------*/
/* BLT_2_EQ                                                                */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_eq(WamWord x,WamWord y)

{
 return x==y;
}




/*-------------------------------------------------------------------------*/
/* BLT_2_NEQ                                                               */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_neq(WamWord x,WamWord y)

{
 return x!=y;
}




/*-------------------------------------------------------------------------*/
/* BLT_2_LT                                                                */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_lt(WamWord x,WamWord y)

{
 return x<y;
}




/*-------------------------------------------------------------------------*/
/* BLT_2_LTE                                                               */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_lte(WamWord x,WamWord y)

{
 return x<=y;
}




/*-------------------------------------------------------------------------*/
/* BLT_2_GT                                                                */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_gt(WamWord x,WamWord y)

{
 return x>y;
}




/*-------------------------------------------------------------------------*/
/* BLT_2_GTE                                                               */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_gte(WamWord x,WamWord y)

{
 return x>=y;
}




          /* Type tests */




#define Tag_Is_Var(t)              ((t)==REF)
#define Tag_Is_Nonvar(t)           (!Tag_Is_Var(t))
#define Tag_Is_Atom(t)             ((t)==CST)
#define Tag_Is_Integer(t)          ((t)==INT)
#define Tag_Is_Number(t)           (Tag_Is_Integer(t))
#define Tag_Is_Atomic(t)           (Tag_Is_Atom(t) || Tag_Is_Number(t))
#define Tag_Is_Compound(t)         ((t)==STC || (t)==LST)




#define Type_Test(test,x)                                                   \
    {                                                                       \
     WamWord word,tag,*adr;                                                 \
                                                                            \
     Deref(&x,word,tag,adr)                                                 \
     return CPP_CAT(test,(tag));                                            \
    }




/*-------------------------------------------------------------------------*/
/* TYPE TEST FUNCTIONS                                                     */
/*                                                                         */
/*-------------------------------------------------------------------------*/

Bool Blt_1_var     (WamWord x) { Type_Test(Tag_Is_Var,x)      }
Bool Blt_1_nonvar  (WamWord x) { Type_Test(Tag_Is_Nonvar,x)   }
Bool Blt_1_atom    (WamWord x) { Type_Test(Tag_Is_Atom,x)     }
Bool Blt_1_integer (WamWord x) { Type_Test(Tag_Is_Integer,x)  }
Bool Blt_1_number  (WamWord x) { Type_Test(Tag_Is_Number,x)   }
Bool Blt_1_atomic  (WamWord x) { Type_Test(Tag_Is_Atomic,x)   }
Bool Blt_1_compound(WamWord x) { Type_Test(Tag_Is_Compound,x) }




/*-------------------------------------------------------------------------*/
/* LOAD_MATH_EXPRESSION                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Load_Math_Expression(WamWord exp,WamWord *result)

#define Eval_2   Prefix(X6576616C_2)

{
 Prototype(Eval_2)
 WamWord  word,tag,*adr;
 Bool     ret;
 WamWord  a1;
 WamWord *save_reg_bank=reg_bank;
 WamWord  local_reg_bank[REG_BANK_SIZE];

 Switch_Reg_Bank(local_reg_bank);

 A(0)=exp;
 put_x_variable(1,1)
 a1=A(1);
 ret=Call_Prolog((CodePtr) Eval_2);

 Deref(&a1,word,tag,adr)

 *result=word;

 Switch_Reg_Bank(save_reg_bank);

 return ret;
}





/*-------------------------------------------------------------------------*/
/* BLT_2_G_ASSIGN                                                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_g_assign(WamWord gvar,WamWord gval)

{
 WamWord *g_adr;
 WamWord word,tag,*adr;

 Deref(&gvar,word,tag,adr)
 if (tag!=INT && tag!=CST)
    {
     Lib1(printf,ERR_ILLEGAL_ARGUMENT);
     return FALSE;
    }

 g_adr=(tag==INT) ? g_vars+UnTag_INT(word) : &(UnTag_CST(word)->info);

 Deref(&gval,word,tag,adr)
 if (tag!=INT && tag!=CST)
    {
     Lib1(printf,ERR_ILLEGAL_ARGUMENT);
     return FALSE;
    }

 *g_adr=word;
 return TRUE;
}







/*-------------------------------------------------------------------------*/
/* BLT_2_G_READ                                                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Blt_2_g_read(WamWord gvar,WamWord gval)

{
 WamWord *g_adr;
 WamWord word,tag,*adr;

 Deref(&gvar,word,tag,adr)
 if (tag!=INT && tag!=CST)
    {
     Lib1(printf,ERR_ILLEGAL_ARGUMENT);
     fail
    }

 g_adr=(tag==INT) ? g_vars+UnTag_INT(word) : &(UnTag_CST(word)->info);

 return Unify(g_adr,&gval);
}
