/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Buit-In Predicates                                   Daniel Diaz - 1994 */
/*                                                                         */
/* call/1 and other control predicates                                     */
/*                                                                         */
/* call.pl                                                                 */
/*-------------------------------------------------------------------------*/


	/* Control */

:- public otherwise/0, true/0, false/0, repeat/0, halt/0, halt/1, abort/0.


otherwise.

true.

false:-	fail.

repeat.
repeat:-
	repeat.




halt:-	halt(0).




halt(_S):-
	pragma_c('Halt_1').




abort:-
	halt(1).




:- public call/1, call/2.


call(P):-
	current_caller_module(Module),
        '$get_bc_reg'(VarCut),
	call1(P,VarCut,Module).


call(P,Module):-
        '$get_bc_reg'(VarCut),
	call1(P,VarCut,Module).


call1(X,_,_):-
	var(X),
	!,
	write('Error: variable given as goal'), nl,
	fail.

call1((P,Q),VarCut,Module):-
	!, 
	call1(P,VarCut,Module),
	call1(Q,VarCut,Module).

call1((P;Q),VarCut,Module):-
	!,
	call_or(P,Q,VarCut,Module).

call1(!,VarCut,_):- 
%           !,          this cut is useless because Meta_Cut
        '$cut'(VarCut).

call1((P->Q),VarCut,Module):- 
	!,
	call(P,Module),
	!,
	call1(Q,VarCut,Module).

call1(\+P,_,Module):- 
	!, 
	(call(P,Module), !, fail; true).

call1(_P,_VarCut,_Module):-
	pragma_c('Call1_3').




call_or((P->Q),R,VarCut,Module):-
	!,
	(call(P,Module),
	 !,
	 call1(Q,VarCut,Module) 
	   ; 
	 call1(R,VarCut,Module)).
	
call_or(P,_,VarCut,Module):-
	call1(P,VarCut,Module).

call_or(_,Q,VarCut,Module):-
	call1(Q,VarCut,Module).




          /* top level */

:- public top_level/0.


top_level:-
	current_caller_module(Module),
	version,
	repeat,
	write_debug_indicator,
	write('| ?- '),
	read_term(X,[variable_names(VarNames)]),
	(X==end_of_file -> !,
                           nl
                        ;
                           (exec(X,VarNames,Module) -> nl, write(yes), nl
                                                    ;  nl, write(no),  nl),
			   debug_mode(DbgMode),             % read debug mode
			   debug_mode(DbgMode),             % reinit debugger
			   fail).




write_debug_indicator:-
	debug_mode(DebugMode),
	write_debug_indicator(DebugMode).


write_debug_indicator(debug):-
	write('{debug}'), nl.

write_debug_indicator(trace):-
	write('{trace}'), nl.

write_debug_indicator(nodebug).




exec(X,VarNames,Module):-
	get_current_B(B),
	call(X,Module),
	get_current_B(B1),
	write_solution(VarNames),
	(B1>B -> write(' ? '),
                 read_command(C),
		 C==10
              ;
                 true).




read_command(C):-
	get0(C1),
	skip_until_return(C1),
	(C1==10 -> C=C1
                ;  
		   (C1\==0'; -> write('Action (";" for more choices, '),
		                write('otherwise <return>): '),
                                read_command(C)
                             ;  C=C1)).




skip_until_return(C):-
	(C==10 -> true
               ;
                  get0(C1),
		  skip_until_return(C1)).




write_solution([]).

write_solution([X=V|L]):-
	formata('~n~a = ~q',[X,V]),
	write_solution(L).




:- public get_current_B/1, current_caller_module/1.

get_current_B(_B):-
	pragma_c('get_integer(Local_Offset(B),0)').




current_caller_module(_Module):-
	pragma_c('Current_Caller_Module_1').

