/*
 * symbol.c
 *
 * symbol manipulation primitives
 */

# include	"kalypso.h"
# include	"mem.h"

lispval
/*ARGSUSED*/
Def (s, count)
lispval	*s;
{
	struct symbol	*a;
	lispval		i;
	struct dotted	*l;

	
	l = itemtolist (*s);
	i = l->car;
	if (!symbolp (i) || !l->cdr)
		return error ("def: bad form %v", listtoitem (l));
	a = itemtosymbol (i);
	a->value = l->cdr->car;
	return symboltoitem (a);
}

lispval
GetName (a)
lispval	a;
{
	if (!symbolp (a))
		return error ("get-name: non symbol %v", a);
	return itemtosymbol (a)->name;
}

lispval
Set (s, count)
register lispval	*s;
{
	register lispval	i;
	register lispval	ret;

	ret = nil;
	while (count) {
		i = *s++;
		count--;
		if (!symbolp (i) || !count)
			return error ("set: improper use");
		ret = (itemtosymbol (i))->value = *s++;
		count--;
	}
	return ret;
}
	
lispval
/*ARGSUSED*/
Setq (s, count)
lispval	*s;
int count;
{
	lispval	i;
	lispval	ret;
	struct dotted	*l;

	l = itemtolist (*s);
	ret = nil;
	while (l) {
		i = l->car;
		if (!symbolp (i) || !l->cdr)
			return error ("setq: improper use");
		ret = (itemtosymbol (i))->value = iEval (l->cdr->car);
		if (jumping)
			break;
		l = l->cdr->cdr;
	}
	return ret;
}

struct symbol *
iNewSymbol (name, copy)
lispval	name;
{
	struct symbol	*new;
	int		framem;
	character	*newname;

	new = newSymbol ();
	new->value = undeftoitem (0);
	if (copy && stringp(name)) {
		framem = frameMark ();
		framePush (symboltoitem (new));
		new->name = nil;
		newname = iStrcpy (itemtostring (name));
		if (newname)
			name = stringtoitem (newname);
		else
			name = nil;
		frameReset (framem);
	}
	new->name = name;
	return new;
}

lispval
NewSymbol (name)
lispval	name;
{
	struct symbol	*new;

	new = iNewSymbol (name, 0);
	return symboltoitem (new);
}

setSymbolRef (a)
struct symbol	*a;
{
	if (setObjectRef ((char *) a))
		return;
	setRef (a->name);
	setRef (a->value);
}

struct builtin symbolStuff[] = {
	"def",		Def,		NLAMBDA,	0,
	"get-name",	GetName,	LAMBDA,		1,
	"set",		Set,		LEXPR,		0,
	"setq",		Setq,		NLAMBDA,	0,
	"new-symbol",	NewSymbol,	LAMBDA,		1,
	0,		0,		0,		0,
};
