/*
 * string.c
 *
 * strings for kalypso
 */

# include	"kalypso.h"
# include	"mem.h"

char quoteMap[256] = {
'\200'
 ,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

'\201','\202','\203',
      0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
};

character unquoteMap[256] = {
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

STREND, STRQUOTE, STRLNK, STRBLK,
         0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
};

character	*stralloc ();

lispval
Scar (s)
lispval	s;
{
	character	*c;

	if (!stringp (s))
		return error ("scar: non-string %v", s);
	c = itemtostring (s);
	return (numtoitem (iScar (c)));
}

lispval
Scdr (s)
lispval s;
{
	register character	*next;

	if (nilp (s))
		return nil;
	if (!stringp (s))
		return error ("scdr: non-string %v", s);
	next = itemtostring (s);
	next = iScdr (next);
	return *next == '\0' ? nil : stringtoitem (next);
}

lispval
Strlen (s)
lispval	s;
{
	if (nilp (s))
		return numtoitem (0);
	if (!stringp (s))
		return error ("strlen: non-string %v", s);
	return numtoitem (iStrlen (itemtostring (s)));
}

int
iStrlen (s)
character	*s;
{
	int	i;

	i = 0;
	while (*s) {
		++i;
		s = iScdr (s);
	}
	return i;
}

character *
iStrcpy (s)
character *s;
{
	int		len;
	character	*dest, *r;

	if (s == nil)
		return nil;
	len = 0;
	r = s;
	while (*r) {
		len++;
		r = iScdrLnk(r);
	}
	r = dest = stralloc (len + 1);
	while (*dest = *s) {
		s = iScdrLnk (s);
		dest = iScdrLnk (dest);
	}
	return r;
}

/*
 * convert a kalypso string into a C string,
 * it returns the source string if acceptable else
 * cons'es
 */

char *
iCstring (s, lenp)
character *s;
int *lenp;
{
	character	*r;
	char		*new, *t;
	int		makeCopy = 0;
	int		len;

	r = s;
	while (*r) {
		if (*r == STRLNK || *r == STRQUOTE) {
			makeCopy = 1;
			break;
		}
		++r;
	}
	if (makeCopy) {
		len = iStrlen (s);
		t = new = newObject (len + 1);
		while (*s != '\0') {
			*t++ = (char) iScar (s);
			s = iScdr (s);
		}
	} else {
		len = r - s;
		new = (char *) s;
	}
	if (lenp)
		*lenp = len;
	return new;
}

/*
 * convert a C string into a kalyspo string.
 * it returns the source string if acceptable and
 * a copy is not required, else cons'es
 */

character *
iKstring (s, copy, len)
char	*s;
int	copy;
int	len;
{
	int		clen;
	int		i, klen;
	character	*new, *k;
	char		*t;

	clen = len;
	if (clen == -1)
		clen = strlen (s);
	if (clen == 0)
		return 0;
	/*
	 * find out how many quoted character will
	 * be needed
	 */
	klen = 0;
	for (t = s, i = 0; i < clen; t++, i++) {
		if (special ((character) *t))
			++klen;
	}
	/*
	 * the string is acceptable if it contains
	 * no magic characters and is null
	 * terminated.
	 */
	if (!copy && klen == 0 && len == -1)
		return (character *) s;
	/*
	 * fix the string by allocating new space
	 */
	klen += clen;
	k = new = stralloc (klen + 1);
	for (t = s, i = 0; i < clen; t++, i++) {
		if (special (*t)) {
			*k++ = STRQUOTE;
			*k++ = quoteChar (*t);
		} else
			*k++ = *t;
	}
	*k = '\0';
	return new;
}

character *
iScons (s, c)
character	*s;
character	c;
{
	character	*p;
	int		need = 1;

	if (special (c))
		need = 2;
	if (s == nil) {
		p = stralloc (1 + need);
		p[need] = '\0';
	} else {
		p = s-need;
		if ((need == 2 && p[1] != STRBLK) || *p != STRBLK) {
			p = stralloc (1 + need + sizeof (character *));
			if (*p != STRBLK)
				panic (1, "ARGH! bad string block!\n");
			*((character **)(p + 1 + need)) = s;
			*(p+need) = STRLNK;
		}
	}
	if (special(c)) {
		*p = STRQUOTE;
		p[1] = quoteChar(c);
	} else
		*p = c;
	return p;
}

lispval
Scons (c, s)
lispval	c, s;
{
	character	*r;
	int		ch;

	if (!nump (c))
		return error ("scons: non-number %v", c);
	ch = itemtonum (c);
	if (ch < 0 || ch >= 256)
		return error ("scons: character out of range %v", c);
	if (!stringp (s) && !nilp (s)) {
		error ("scons: non-string %v", s);
		return nil;
	}
	r = iScons (itemtostring (s), (character) ch);
	return stringtoitem (r);
}

iStrcmp (s1, s2)
character	*s1, *s2;
{
	while (*s1 && *s2 && iScar(s1) == iScar(s2)) {
		s1 = iScdr (s1);
		s2 = iScdr (s2);
	}
	return *s1 - *s2;
}

lispval
Strcmp (s1, s2)
lispval	s1, s2;
{
	static char err[] = "strcmp: non-string %v";
	if (!stringp (s1))
		return error (err, s1);
	if (!stringp (s2))
		return error (err, s2);
	return numtoitem (iStrcmp (itemtostring (s1), itemtostring (s2)));
}

/*
 * string memory allocation.
 */

# define STRMIN		(4 * MINHUNK)

character *
stralloc (len)
{
	character	*new;
	int		l;
	int		newsize;

	l = len + 1;
	if (l < STRMIN)
		l = STRMIN;
	new = (character *) newObjectWithSize (l, &newsize);
	new[0] = '\0';
	bfill (new+1, newsize-1, STRBLK);
	return new + (newsize - len);
}

setStringRef (c)
character	*c;
{
	if (!c)
		return;

	if (setObjectRef ((char *) c))
		return;
	++c;
	while (*c) {
		if (*c == STRLNK) {
			setStringRef (*(character **) (c+1));
			break;
		}
		++c;
	}
}

setCstringRef (c)
char	*c;
{
	setObjectRef (c);
}


bfill (p, c, v)
register character	*p;
register int		c;
register character	v;
{
	while (c--)
		*p++ = v;
}

struct builtin stringStuff[] = {
	"scar",		Scar,		LAMBDA,		1,
	"scdr",		Scdr,		LAMBDA,		1,
	"strlen",	Strlen,		LAMBDA,		1,
	"scons",	Scons,		LAMBDA,		2,
	"strcmp",	Strcmp,		LAMBDA,		2,
	0,		0,		0,		0,
};
