/*
 * signal.c
 *
 * trap signals
 */

# include	<signal.h>
# ifndef NSIG
#  define NSIG	32
# endif
# include	"kalypso.h"

struct vector	*signalHandlers;

iSignal (signum, handler)
int	signum;
lispval handler;
{
	int			signalHandler ();
	extern struct vector	*iNewVector ();
	lispval			iStore ();
#ifndef SYSV
	struct sigvec		sigarg;
#endif

	if (!signalHandlers)
		signalHandlers = iNewVector (NSIG);
	(void) iStore (signalHandlers, signum, handler);
	if (handler == nil)
		(void) signal (signum, SIG_DFL);
	else {
#ifdef SYSV
		(void) signal (signum, signalHandler);
#else
		sigarg.sv_handler = signalHandler;
		sigarg.sv_mask = 0;
# ifdef SV_INTERRUPT
		sigarg.sv_flags = SV_INTERRUPT;
# else
		sigarg.sv_onstack = 0;
# endif
		(void) sigvec (signum, &sigarg, (struct sigvec *) 0);
#endif
	}
}

lispval
Signal (signum, handler)
lispval	signum, handler;
{
	int	s;

	if (nump (signum))
		s = itemtonum (signum);
	else if (floatpp (signum))
		s = *itemtofloatp (signum);
	else
		return error ("signal: non-numeric %v", signum);
	iSignal (s, handler);
	return handler;
}

signalHandler (sig)
{
	void	processSignal ();

#ifdef SYSV
	signal (sig, signalHandler);
#endif
	(void) saveAsync (processSignal, sig);
}

void
processSignal (sig)
{
	lispval	handler;
	struct dotted	*func, *arg;
	int	framem;
	lispval	iFetch ();

	if (signalHandlers) {
		handler = iFetch (signalHandlers, sig);
		if (handler) {
			framem = frameMark ();
			func = newDotted ();
			func->cdr = nil;
			func->car = nil;
			framePush (listtoitem (func));
			arg = newDotted ();
			arg->car = nil;
			arg->cdr = nil;

			func->cdr = arg;
			func->car = handler;
			arg->car = numtoitem (sig);
			(void) iEvallist (listtoitem (func));
			frameReset (framem);
		}
	}
}

struct builtin signalStuff[] = {
	"signal",	Signal,		LAMBDA,		2,
	0,		0,		0,		0,
};
