/*
 * services.c
 *
 * access /etc/services using C routines as any lisp
 * code will not be portable to YP
 */

# include	"kalypso.h"
#ifdef SERVICES_PACKAGE
# include	<sys/types.h>
# include	<netdb.h>
# include	<netinet/in.h>

static lispval
makeServent (ent)
struct servent	*ent;
{
	char		**aliases;
	character	*name, *alias, *proto;
	struct dotted	*first, *new, *last;
	int		framem;
	lispval		name_val, aliases_val, proto_val, port_val, ret;
	int		port_num;

	framem = frameMark ();
	name = iKstring (ent->s_name, 1, -1);
	name_val = nil;
	if (name)
		name_val = stringtoitem (name);
	framePush (name_val);

	first = new = last = nil;
	for (aliases = ent->s_aliases; *aliases; aliases++) {
		new = newDotted ();
		new->car = nil;
		new->cdr = nil;
		if (!first) {
			first = new;
			framePush (listtoitem (new));
		} else {
			last->cdr = new;
		}
		alias = iKstring (*aliases, 1, -1);
		if (alias)
			new->car = stringtoitem (alias);
	}
	aliases_val = nil;
	if (first)
		aliases_val = listtoitem (first);

	port_num = ntohs (ent->s_port);
	port_val = intRet (port_num);
	framePush (port_val);
	proto = iKstring (ent->s_proto, 1, -1);
	proto_val = nil;
	if (proto)
		proto_val = stringtoitem (proto);
	framePush (proto_val);
	first = makeList (4, name_val, aliases_val, port_val, proto_val);
	ret = listtoitem (first);
	frameReset (framem);
	return ret;
}

lispval
GetServiceByName (name, proto)
lispval	name, proto;
{
	char		*n, *p;
	struct servent	*ent;

	if (stringp (name))
		n = iCstring (itemtostring (name), (int *) 0);
	else if (nilp (name))
		n = "";
	else
		return error ("get-service-by-name: non-string name %v", name);
	if (stringp (proto))
		p = iCstring (itemtostring (proto), (int *) 0);
	else if (nilp (proto))
		p = 0;
	else
		return error ("get-service-by-name: non-string proto %v", proto);
	ent = getservbyname (n, p);
	if (!ent)
		return nil;
	return makeServent (ent);
}

lispval
GetServiceByPort (port, proto)
lispval	port, proto;
{
	int		n;
	char		*p;
	struct servent	*ent;

	if (nump (port))
		n = itemtonum (port);
	else if (floatpp (port))
		n = *itemtofloatp (port);
	else
		return error ("get-service-by-port: non-number port %v", port);
	if (stringp (proto))
		p = iCstring (itemtostring (proto), (int *) 0);
	else if (nilp (proto))
		p = 0;
	else
		return error ("get-service-by-port: non-string proto %v", proto);
	ent = getservbyport (n, p);
	if (!ent)
		return nil;
	return makeServent (ent);
}

struct builtin servicesStuff[] = {
	"get-service-by-name",	GetServiceByName,	LAMBDA,	2,
	"get-service-by-port",	GetServiceByPort,	LAMBDA,	2,
	0,			0,			0,	0,
};

#endif
