/*
 * read.c
 *
 * read an item
 */

# include	"kalypso.h"
# include	"lex.h"

static	int	token;

lispval		readItem();
struct dotted	*readList();
struct dictionary	*readDict();

lispval
iFreadDictionary (f, d)
FILE			*f;
struct dictionary	*d;
{
	lispval	ret;

	errorNumber->value = nil;
	token = lex (f);
	ret = readItem (f, d);
	return ret;
}

lispval
FreadDictionary (file, dict)
lispval	file;
lispval	dict;
{
	FILE			*f;
	struct dictionary	*d;

	if (!filep (file))
		return error ("fread-dict: non-file %v", file);
	f = itemtofile (file);
	if (!dictp (dict))
		return error ("fread-dict: non-dictionary %v", dict);
	d = itemtodict (dict);
	return iFreadDictionary (f, d);
}

lispval
iFread (f)
FILE	*f;
{
	struct dictionary	*d;

	if (!dictp (SystemDictionary->value))
		return error ("fread: non-dictionary %v", SystemDictionary->value);
	d = itemtodict (SystemDictionary->value);
	return iFreadDictionary (f, d);
}

lispval
Fread (file)
lispval	file;
{
	FILE	*f;

	if (!filep (file))
		return error ("fread: non-file %v", file);
	f = itemtofile (file);
	return iFread (f);
}

lispval
iSreadDictionary (s, d, len)
char			*s;
struct dictionary	*d;
int			len;
{
	FILE		buf;
	lispval		ret;

#if defined(SYSV) || defined (sun)
	buf._ptr = buf._base = (unsigned char *) s;
#else
	buf._ptr = buf._base = s;
#endif
	buf._cnt = len;
#ifdef SYSV
	buf._flag = _IOREAD;
#else
#ifndef APOLLO
	buf._bufsiz = buf._cnt;
#endif
	buf._flag = _IOREAD|_IOSTRG;
#endif
	ret = iFreadDictionary (&buf, d);
	return ret;
}

lispval
SreadDictionary (string, dictionary)
lispval	string;
lispval	dictionary;
{
	char	*s;
	struct dictionary	*d;
	int	len;
	int	mark;
	lispval	ret;

	if (nilp (string))
		return nil;
	if (!stringp (string))
		return error ("sread-dictionary: non string %v", string);
	if (!dictp (dictionary))
		return error ("sread-dictionary: non dictionary %v", dictionary);
	d = itemtodict (dictionary);
	s = iCstring (itemtostring (string), &len);
	mark = frameMark ();
	framePush (cstringtoitem (s));
	ret = iSreadDictionary (s, d, len);
	frameReset (mark);
	return ret;
}

lispval
Sread (string)
lispval	string;
{
	return SreadDictionary (string, SystemDictionary->value);
}

# define matchingParen(t)	((t) == OP ? CP : ((t) == OS ? CS : CC))

lispval
readItem (f, dictionary)
FILE			*f;
struct dictionary	*dictionary;
{
	struct symbol	*a;
	struct dotted	*l;
	character	*s;
	struct vector	*iListToVector ();
	double		d;
	double		atof ();
	lispval		o;
	int		framem;
	struct dictionary	*dict;
	extern struct symbol	*SymbolDictionary;

	switch (token) {
	case NAME:
		a = iSymbol (stringtoitem (lexToken), dictionary, 1);
		if (jumping)
			return nil;
		if (a == nilName)
			return nil;
		return symboltoitem (a);
	case NUM:
	case FLOAT:
		d = atof (lexToken);
		return doubleRet (d);
	case STRING:
		s = iStrcpy (lexToken);
		if (!s)
			return nil;
		return stringtoitem (s);
	case OS:
		l = readList (f, matchingParen(token), dictionary);
		if (jumping)
			return nil;
		framem = frameMark ();
		framePush (listtoitem (l));
		o = vectortoitem (iListToVector (l));
		frameReset (framem);
		return o;
	case OC:
		dict = readDict (f, matchingParen(token), dictionary);
		if (jumping)
			return nil;
		if (!dict)
			return nil;
		return dicttoitem (dict);
	case OP:
		l = readList (f, matchingParen(token), dictionary);
		if (jumping)
			return nil;
		if (!l)
			return nil;
		return listtoitem (l);
	case QUOTE:
		framem = frameMark ();
		l = newDotted ();
		l->car = symboltoitem (quote);
		l->cdr = nil;

		framePush (listtoitem (l));

		l->cdr = newDotted ();
		l->cdr->car = nil;
		l->cdr->cdr = nil;
		token = lex (f);
		l->cdr->car = readItem (f, dictionary);
		frameReset (framem);
		if (jumping)
			return nil;
		return listtoitem (l);
	case END:
		errorNumber->value = numtoitem (LISPEOF);
		return nil;
	default:
		o = error ("syntax error on %v", stringtoitem (iStrcpy (lexToken)));
		errorNumber->value = nil;
		return o;
	}
}

struct dotted *
readList (f, end, dictionary)
FILE	*f;
struct dictionary	*dictionary;
{
	struct dotted	*first, *last, *new;
	int		framem;
	lispval		errRet;

	framem = frameMark ();
	first = last = 0;
	for (;;) {
		token = lex (f);
		switch (token) {
		case NAME:
		case NUM:
		case FLOAT:
		case STRING:
		case OP:
		case OS:
		case OC:
		case QUOTE:
			new = newDotted ();
			new->cdr = nil;
			new->car = nil;
			if (!first) {
				first = new;
				framePush (listtoitem (first));
			} else
				last->cdr = new;
			new->car = readItem (f, dictionary);
			if (jumping) {
				frameReset (framem);
				return nil;
			}
			last = new;
			break;
		default:
			frameReset (framem);
			if (token == end) {
				return first;
			}
			errRet = error ("syntax error on %v", stringtoitem (iStrcpy (lexToken)));
			if (listp (errRet))
				return itemtolist (errRet);
			return nil;
		}
	}
}

struct dictionary *
readDict (f, end, dictionary)
FILE	*f;
int	end;
struct dictionary	*dictionary;
{
	struct dictionary	*new, *iNewDictionary();
	lispval		name, value;
	int		framem, m;
	int		match;
	lispval		iDictionaryInsert ();

	new = iNewDictionary();
	framem = frameMark ();
	framePush (dicttoitem (new));
	for (;;) {
		token = lex (f);
		switch (token) {
		case OP:
		case OS:
		case OC:
			match = matchingParen (token);
			m = frameMark ();
			token = lex (f);
			name = readItem (f, dictionary);
			framePush (name);
			token = lex (f);
			value = readItem (f, dictionary);
			framePush (value);
			token = lex (f);
			if (token != match) {
		baddict:	;
				frameReset (framem);
				value = error ("syntax error on %v", stringtoitem (iStrcpy (lexToken)));
				if (dictp (value))
					return itemtodict (value);
				return nil;
			}
			(void) iDictionaryInsert (new, name, value);
			frameReset (m);
			break;
		default:
			if (token == end) {
				frameReset (framem);
				return new;
			}
			goto baddict;
		}
	}
}

struct builtin readStuff[] = {
	"fread-dictionary",	FreadDictionary,	LAMBDA,		2,
	"fread",		Fread,			LAMBDA,		1,
	"sread-dictionary",	SreadDictionary,	LAMBDA,		2,
	"sread",		Sread,			LAMBDA,		1,
	0,			0,			0,		0,
};
