/*
 * profile.c
 *
 * profile the execution of a list
 */

# include	"kalypso.h"

#ifdef PROFILE

/*
 * per-symbol profile information
 */
struct profile {
	struct profile	*next;
	struct symbol	*function;
	struct profileCaller	*callers;
	int		count;		/* number of times placed on stack */
	int		onstack;	/* amount of time spent on stack */
};

/*
 * profile stack -- this roughly parallels
 * the eval stack; watch out -- this one is
 * of fixed size!
 */

struct profileStack {
	struct profile	*symbol;
	int		ontime;		/* when placed on stack */
};

/*
 * callers profile
 */

struct profileCaller {
	struct profileCaller	*next;
	struct symbol	*function;
	int		count;
};

# define PROFILEHASH	977
# define PROFILESTACK	10000

int	Profiling;

int	Profilecount;

struct profile		**profileBox;
struct profileStack 	*profileStack;
struct profileStack	*profileStackp;

lispval
/*ARGSUSED*/
Profile (ap, c)
lispval	*ap;
{
	lispval	a;
	lispval	ret;
	char	*malloc ();

	a = itemtolist(*ap)->car;
	profileBox = (struct profile **) malloc
			(PROFILEHASH * sizeof (struct profile *));
	profileStack = (struct profileStack *) malloc
			(PROFILESTACK * sizeof (struct profileStack));
	profileStackp = profileStack + PROFILESTACK;
	bzero ((char *) profileBox, PROFILEHASH * sizeof (struct profile *));
	Profiling = 1;
	ret = iEval (a);
	Profiling = 0;
	(void) dumpProfile ("lisp.profile");
	free ((char *) profileStack);
	return ret;
}

LcountStart (a)
struct symbol	*a;
{
	register struct profile	*p, *l;
	int			h;
	register struct profileCaller	*c;

	h = profileHash ((int) a);
	p = profileBox[h];
	l = 0;
	while (p) {
		if (p->function == a) {
			p->count++;
			goto gotme;
		}
		l = p;
		p = p->next;
	}
	p = (struct profile *) malloc (sizeof (struct profile));
	p->function = a;
	p->count = 1;
	p->onstack = 0;
	p->next = 0;
	if (l)
		l->next = p;
	else
		profileBox[h] = p;
gotme:	;
	if (profileStackp > profileStack) {
		if (profileStackp < profileStack + PROFILESTACK) {
			for (c = p->callers; c; c = c->next)
				if (c->function == profileStackp->symbol->function)
					goto gotparent;
			c = (struct profileCaller *)
	 			malloc (sizeof (struct profileCaller));
			c->function = profileStackp->symbol->function;
			c->next = p->callers;
			p->callers = c;
	gotparent:	;
			c->count++;
		}
		--profileStackp;
		profileStackp->symbol = p;
		profileStackp->ontime = Profilecount;
	}
	++Profilecount;
}

LcountEnd (a)
struct symbol	*a;
{
	struct profile	*p;

	p = profileStackp->symbol;
	if (a != p->function)
		return;
	p->onstack += Profilecount - profileStackp->ontime;
	++profileStackp;
}

dumpProfile (file)
char	*file;
{
	int	h;
	struct profile	*p;
	struct profile	*n;
	FILE		*out;
	struct profileCaller	*c, *cn;
	lispval		ret;

	out = fopen (file, "w");
	ret = nil;
	if (out == NULL)
		(void) error ("profile: can't open %v", stringtoitem (file));
	/*
	 * even if the file can't be opened,
	 * the profiling information must
	 * still be released, so
	 * go through the motions anyhow
	 */
	if (out != 0) {
		fprintf (out, "%10s %10s   %-40.40s\n",
			"count", "onstack", "name");
	}
	for (h = 0; h < PROFILEHASH; h++) {
		for (p = profileBox[h]; p; p=n) {
			if (out != 0) {
				fprintf (out, "%10d %10d %c %-40.40s\n",
					p->count,
					p->onstack,
					builtinp (p->function->value) ? 'B' : 'U',
					sprint (p->function->name, (int *) 0));
			}
			for (c = p->callers; c; c = cn) {
				if (out != 0) {
					fprintf (out, "%25.25s %10d  %-40.40s\n",
						"",
						c->count,
						sprint (c->function->name, (int *) 0));
				}
				cn = c->next;
				free ((char *) c);
			}
			n = p->next;
			free ((char *) p);
		}
	}
	if (out != 0)
		(void) fclose (out);
	free ((char *) profileBox);
	return ret;
}

profileHash (a)
int	a;
{
	int	h;

	h = a / (sizeof (struct symbol));
	return h % PROFILEHASH;
}

struct builtin profileStuff[] = {
	"profile",	Profile,	NLAMBDA,	0,
	0,		0,		0,		0,
};
#endif
