/*
 * print.c
 */

# include	"kalypso.h"
# include	"lex.h"

#if defined(SYSV) || defined (sun)
static unsigned char	sprintbuf[8192];
#else
static char		sprintbuf[8192];
#endif

lispval
Fprint (l, count)
lispval	*l;
{
	FILE	*f;
	lispval	ret;

	if (!filep(*l))
		return error ("fprint: non-file %v", *l);
	f = itemtofile (*l);
	l++;
	if (count--)
		ret = *l;
	while (count--) {
		fprint (*l++, f);
		if (jumping)
			return nil;
		if (count)
			(void) putc (' ', f);
	}
	return ret;
}

lispval
Sprint (l, count)
lispval *l;
{
	char	*foo, *ret;
	char	buf[8192];
	int	len;
	character	*k;

	foo = buf;
	while (count--) {
		ret = sprint (*l++, &len);
		if (jumping)
			return nil;
		while (foo < buf + (sizeof(buf)-1) && --len >= 0)
			*foo++ = *ret++;
		if (count && foo < buf + (sizeof(buf)-1))
			*foo++ = ' ';
	}
	k = iKstring (buf, 1, foo - buf);
	if (!k)
		return nil;
	return stringtoitem (k);
}

FILE *
open_string ()
{
	static FILE	_strbuf;

#ifdef SYSV
	_strbuf._flag = _IOWRT;
#else
	_strbuf._flag = _IOWRT|_IOSTRG;
#endif
	_strbuf._base = _strbuf._ptr = sprintbuf;
	_strbuf._cnt = sizeof (sprintbuf);
#ifndef SYSV
#ifndef APOLLO
	_strbuf._bufsiz = sizeof (sprintbuf);
#endif
#endif
	return &_strbuf;
}

char *
close_string (f, lenp)
FILE	*f;
int	*lenp;
{
	*f->_ptr = '\0';
	if (lenp)
		*lenp = f->_ptr - f->_base;
	return (char *) sprintbuf;
}

char *
sprint (i, lenp)
lispval	i;
int	*lenp;
{
	FILE	*s;

	s = open_string ();
	fprint (i, s);
	if (jumping)
		return nil;
	return close_string (s, lenp);
}

char *
itoa (d, base)
int	d;
int	base;
{
	static char	buf[20];
	char		*s;
	char		*ret;
	static char	digit[] = "0123456789abcdef";

	ret = buf;
	s = buf+sizeof(buf) - 2;
	*s = '\0';
	if (d < 0) {
		d = -d;
		*ret++ = '-';
	}
	do
		*--s = digit [d % base];
	while (d /= base);
	while (*ret++ = *s++)
		;
	return buf;
}

char *
dtoa (d)
double	d;
{
	static char	buf[30];

	sprintf (buf, "%-.10g", d);
	return buf;
}

fputstring (s, f)
register char	*s;
register FILE	*f;
{
	while (*s)
		putc (*s++, f);
}

fprint (i, f)
lispval	i;
FILE	*f;
{
	checkAsync ();
	if (jumping)
		return;
	if (nilp (i))
		fputstring ("()", f);
	else switch (TYPE(i)) {
	case LISTTYPE:
		fprintList (itemtolist(i), f);
		break;
	case SYMBOLTYPE:
		fprintSymbol (itemtosymbol(i), f);
		break;
	case STRINGTYPE:
		fprintString (itemtostring (i), f);
		break;
	case NUMTYPE:
		fputstring (itoa (itemtonum (i), 10), f);
		break;
	case FLOATPTYPE:
		fputstring (dtoa (*itemtofloatp (i)), f);
		break;
	case BUILTINTYPE:
		fprintBuiltin (itemtobuiltin (i), f);
		break;
	case FILETYPE:
		fprintFile (itemtofile (i), f);
		break;
	case DICTTYPE:
		fprintDict (itemtodict (i), f);
		break;
	case VECTORTYPE:
		fprintVector (itemtovector (i), f);
		break;
	case UNDEFTYPE:
	default:
		fprintUndefined (i, f);
		break;
	}
}

fprintList (l, f)
struct dotted *l;
FILE	*f;
{
	(void) putc ('(', f);
	while (l) {
		fprint (l->car, f);
		if (jumping)
			return;
		l = l->cdr;
		if (l)
			(void) putc (' ', f);
	}
	(void) putc (')', f);
}

fprintSymbol (a, f)
struct symbol	*a;
FILE		*f;
{
	lispval		name;
	character	*c;
	int		usePipe = 0;

	name = a->name;
	if (!stringp (name))
		fprint (name, f);
	else {
		c = itemtostring (name);
		if (!c || !printableName (c)) {
			usePipe++;
			(void) putc ('|', f);
		}
		if (c)
			fprintChars (c, VBAR|BACKSLASH, f);
		if (usePipe)
			(void) putc ('|', f);
	}
}

printableName (s)
register character	*s;
{
	int		isnum = 1;
	int		hasdigit = 0;
	register int	charClass;
	int		i;
	
	i = 0;
	while (*s) {
		charClass = classTable[iScar (s)];
		if (charClass & (NOTNAME|BACKSLASH))
			return 0;
		if (!(charClass & FLOATC))
			isnum = 0;
		else {
			if (i == 0 && (charClass & NOTFIRSTINNUM))
				isnum = 0;
			if (i != 0 && (charClass & FIRSTINNUM))
				isnum = 0;
			if (charClass & DIGIT)
				hasdigit = 1;
		}
		s = iScdr (s);
		++i;
	}
	if (!isnum || !hasdigit) {
		return 1;
	}
	return 0;
}

fprintString (s, f)
register character	*s;
register FILE		*f;
{
	(void) putc ('"', f);
	if (s)
		fprintChars (s, STRINGC|BACKSLASH, f);
	(void) putc ('"', f);
}

fprintChars (s, quoteClass, f)
register character	*s;
register FILE		*f;
{
	register int	class;
	int		c;

	while (*s) {
		c = iScar (s);
		class = classTable[c];
		if (class & quoteClass) {
			(void) putc ('\\', f);
			(void) putc (c, f);
		} else if (!(class & PRINTABLE)) {
			(void) putc ('\\', f);
			switch (c) {
			case '\n':
				(void) putc ('n', f); break;
			case '\b':
				(void) putc ('b', f); break;
			case '\t':
				(void) putc ('t', f); break;
			case '\f':
				(void) putc ('f', f); break;
			case '\r':
				(void) putc ('r', f); break;
			default:
				fputstring (itoa (c, 8), f);
				break;
			}
		} else {
			(void) putc (c, f);
		}
		s = iScdr (s);
	}
}

fpatomString (s, f)
register character	*s;
register FILE		*f;
{
	if (s)
		while (*s) {
			(void) putc (iScar (s), f);
			s = iScdr (s);
		}
}

char *
typeName (type)
{
	switch (type) {
	case LAMBDA:
		return "lambda";
	case NLAMBDA:
		return "nlambda";
	case LEXPR:
		return "lexpr";
	case MACRO:
		return "macro";
	default:
		return "unknown";
	}
}

fprintBuiltin (b, f)
struct builtin	*b;
FILE		*f;
{
	fputstring ("BCD ", f);
	fputstring (b->name, f);
	fputstring (" (", f);
	fputstring (typeName (b->type), f);
	putc (' ', f);
	fputstring (itoa (b->argc, 10), f);
	fputstring (" 0x", f);
	fputstring (itoa ((int) b->function, 16), f);
	putc (')', f);
}

fprintDict (d, f)
struct dictionary	*d;
FILE			*f;
{
	struct hashchain	**hc, *h;
	int			prev;

	prev = 0;
	(void) putc ('{', f);
	for (hc = d->hashtable; hc < d->hashtable + d->hashsize; hc++)
		for (h = *hc; h; h = h->next) {
			if (prev)
				(void) putc (' ', f);
			prev = 1;
			(void) putc ('(', f);
			fprint (h->name, f);
			if (jumping)
				return;
			(void) putc (' ', f);
			fprint (h->value, f);
			if (jumping)
				return;
			(void) putc (')', f);
		}
	(void) putc ('}', f);
}

fprintVector (v, f)
struct vector	*v;
FILE		*f;
{
	int	i;

	(void) putc ('[', f);
	for (i = 0; i < v->size; i++) {
		fprint (v->contents[i], f);
		if (jumping)
			return;
		if (i != v->size-1)
			(void) putc (' ', f);
	}
	(void) putc (']', f);
}

fprintFile (object, f)
FILE	*object, *f;
{
	fputstring ("FILE 0x", f);
	fputstring (itoa ((int) object, 16), f);
}

fprintUndefined (i, f)
lispval	i;
FILE	*f;
{
	int	type, value;

#ifndef SYSV
	type = i >> (ffs (TYPEMASK) - 1);
#else
	type = i >> 27;
#endif
	value = i & ~TYPEMASK;
	fputstring ("Undefined (", f);
	fputstring (itoa (type, 10), f);
	putc (' ', f);
	fputstring (itoa (value, 10), f);
	putc (')', f);
}
	
lispval
Fpatom (l, count)
lispval	*l;
int	count;
{
	FILE	*f;
	lispval	ret;

	if (!filep(*l))
		return error ("fpatom: non-file %v", *l);
	f = itemtofile (*l);
	l++;
	count--;
	ret = nil;
	while (count--) {
		ret = *l++;
		fpatom (ret, f);
		if (jumping)
			return nil;
	}
	return ret;
}

lispval
Spatom (l, count)
lispval *l;
{
	char	*foo, *ret;
	char	buf[8192];
	int	len;
	character	*k;

	foo = buf;
	while (count--) {
		ret = spatom (*l++, &len);
		if (jumping)
			return nil;
		while (foo < buf + (sizeof(buf)-1) && --len >= 0)
			*foo++ = *ret++;
	}
	k = iKstring (buf, 1, foo - buf);
	if (!k)
		return nil;
	return stringtoitem (k);
}

char *
spatom (i, lenp)
lispval	i;
int	*lenp;
{
	FILE	*s;

	s = open_string ();
	fpatom (i, s);
	if (jumping)
		return nil;
	return close_string (s, lenp);
}

fpatom (i, f)
lispval	i;
FILE	*f;
{
	checkAsync ();
	if (jumping)
		return;
	if (nilp (i))
		fputstring ("()", f);
	else switch (TYPE(i)) {
	case LISTTYPE:
		fpatomList (itemtolist(i), f);
		break;
	case SYMBOLTYPE:
		fpatomSymbol (itemtosymbol(i), f);
		break;
	case STRINGTYPE:
		fpatomString (itemtostring (i), f);
		break;
	case NUMTYPE:
		fputstring (itoa (itemtonum (i), 10), f);
		break;
	case FLOATPTYPE:
		fputstring (dtoa (*itemtofloatp (i)), f);
		break;
	case BUILTINTYPE:
		fprintBuiltin (itemtobuiltin (i), f);
		break;
	case FILETYPE:
		fprintFile (itemtofile (i),f);
		break;
	case DICTTYPE:
		fpatomDict (itemtodict (i), f);
		break;
	case VECTORTYPE:
		fpatomVector (itemtovector (i), f);
		break;
	case UNDEFTYPE:
	default:
		fprintUndefined (i, f);
		break;
	}
}

fpatomList (l, f)
struct dotted	*l;
FILE		*f;
{
	while (l) {
		fpatom (l->car, f);
		if (jumping)
			return;
		l = l->cdr;
		if (l)
			(void) putc (' ', f);
	}
}

fpatomSymbol (a, f)
struct symbol	*a;
FILE		*f;
{
	fpatom (a->name, f);
}

fpatomDict (d, f)
struct dictionary	*d;
FILE			*f;
{
	struct hashchain	**hc, *h;

	for (hc = d->hashtable; hc < d->hashtable + d->hashsize; hc++)
		for (h = *hc; h; h = h->next) {
			fpatom (h->name, f);
			if (jumping)
				return;
			fpatom (h->value, f);
			if (jumping)
				return;
		}
}

fpatomVector (v, f)
struct vector	*v;
FILE		*f;
{
	int	i;

	for (i = 0; i < v->size; i++) {
		fpatom (v->contents[i], f);
		if (jumping)
			return;
		if (i != v->size-1)
			(void) putc (' ', f);
	}
}

struct builtin printStuff[] = {
	"fprint",	Fprint,		LEXPR,		1,
	"sprint",	Sprint,		LEXPR,		0,
	"fpatom",	Fpatom,		LEXPR,		1,
	"spatom",	Spatom,		LEXPR,		0,
	0,		0,		0,		0,
};
