/*
 * math.c
 *
 * optional math primitives
 */

# include	"kalypso.h"
#ifdef MATH_PACKAGE

# include	<math.h>

double
infnan (iarg)
{
	lispval	ret;

	switch (iarg) {
	case ERANGE:
	case -ERANGE:
		ret = error ("floating point overflow");
		break;
	default:
		ret = error ("floating point underflow");
		break;
	}
	if (nump (ret))
		return (double) itemtonum (ret);
	if (floatpp (ret))
		return *itemtofloatp (ret);
	return 0.0;
}

lispval
lisp_acos (arg0)
lispval arg0;
{
	double	ret;
	double	acos();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("acos: non-numeric %v", arg0);

	ret = acos(a0);
	return doubleRet (ret);
}

lispval
lisp_asin (arg0)
lispval arg0;
{
	double	ret;
	double	asin();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("asin: non-numeric %v", arg0);

	ret = asin(a0);
	return doubleRet (ret);
}

lispval
lisp_atan (arg0)
lispval arg0;
{
	double	ret;
	double	atan();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("atan: non-numeric %v", arg0);

	ret = atan(a0);
	return doubleRet (ret);
}

lispval
lisp_atan2 (arg0, arg1)
lispval arg0, arg1;
{
	double	ret;
	double	atan2();
	double	a0;
	double	a1;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("atan2: non-numeric %v", arg0);

	if (nump (arg1))
		a1 = (double) itemtonum (arg1);
	else if (floatpp (arg1))
		a1 = *itemtofloatp (arg1);
	else
		return error ("atan2: non-numeric %v", arg1);

	ret = atan2(a0, a1);
	return doubleRet (ret);
}

lispval
lisp_ceil (arg0)
lispval arg0;
{
	double	ret;
	double	ceil();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("ceil: non-numeric %v", arg0);

	ret = ceil(a0);
	return doubleRet (ret);
}

lispval
lisp_cos (arg0)
lispval arg0;
{
	double	ret;
	double	cos();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("cos: non-numeric %v", arg0);

	ret = cos(a0);
	return doubleRet (ret);
}

lispval
lisp_cosh (arg0)
lispval arg0;
{
	double	ret;
	double	cosh();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("cosh: non-numeric %v", arg0);

	ret = cosh(a0);
	return doubleRet (ret);
}

lispval
lisp_exp (arg0)
lispval arg0;
{
	double	ret;
	double	exp();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("exp: non-numeric %v", arg0);

	ret = exp(a0);
	return doubleRet (ret);
}

lispval
lisp_fabs (arg0)
lispval arg0;
{
	double	ret;
	double	fabs();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("fabs: non-numeric %v", arg0);

	ret = fabs(a0);
	return doubleRet (ret);
}

lispval
lisp_floor (arg0)
lispval arg0;
{
	double	ret;
	double	floor();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("floor: non-numeric %v", arg0);

	ret = floor(a0);
	return doubleRet (ret);
}

lispval
lisp_hypot (arg0, arg1)
lispval arg0, arg1;
{
	double	ret;
	double	hypot();
	double	a0;
	double	a1;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("hypot: non-numeric %v", arg0);

	if (nump (arg1))
		a1 = (double) itemtonum (arg1);
	else if (floatpp (arg1))
		a1 = *itemtofloatp (arg1);
	else
		return error ("hypot: non-numeric %v", arg1);

	ret = hypot(a0, a1);
	return doubleRet (ret);
}

lispval
lisp_j0 (arg0)
lispval arg0;
{
	double	ret;
	double	j0();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("j0: non-numeric %v", arg0);

	ret = j0(a0);
	return doubleRet (ret);
}

lispval
lisp_j1 (arg0)
lispval arg0;
{
	double	ret;
	double	j1();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("j1: non-numeric %v", arg0);

	ret = j1(a0);
	return doubleRet (ret);
}

lispval
lisp_jn (arg0, arg1)
lispval arg0, arg1;
{
	double	ret;
	double	jn();
	int	a0;
	double	a1;

	if (nump (arg0))
		a0 = itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = (int) *itemtofloatp (arg0);
	else
		return error ("jn: non-numeric %v", arg0);

	if (nump (arg1))
		a1 = (double) itemtonum (arg1);
	else if (floatpp (arg1))
		a1 = *itemtofloatp (arg1);
	else
		return error ("jn: non-numeric %v", arg1);

	ret = jn(a0, a1);
	return doubleRet (ret);
}

lispval
lisp_log (arg0)
lispval arg0;
{
	double	ret;
	double	log();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("log: non-numeric %v", arg0);

	ret = log(a0);
	return doubleRet (ret);
}

lispval
lisp_log10 (arg0)
lispval arg0;
{
	double	ret;
	double	log10();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("log10: non-numeric %v", arg0);

	ret = log10(a0);
	return doubleRet (ret);
}

lispval
lisp_pow (arg0, arg1)
lispval arg0, arg1;
{
	double	ret;
	double	pow();
	double	a0;
	double	a1;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("pow: non-numeric %v", arg0);

	if (nump (arg1))
		a1 = (double) itemtonum (arg1);
	else if (floatpp (arg1))
		a1 = *itemtofloatp (arg1);
	else
		return error ("pow: non-numeric %v", arg1);

	ret = pow(a0, a1);
	return doubleRet (ret);
}

lispval
lisp_sin (arg0)
lispval arg0;
{
	double	ret;
	double	sin();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("sin: non-numeric %v", arg0);

	ret = sin(a0);
	return doubleRet (ret);
}

lispval
lisp_sinh (arg0)
lispval arg0;
{
	double	ret;
	double	sinh();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("sinh: non-numeric %v", arg0);

	ret = sinh(a0);
	return doubleRet (ret);
}

lispval
lisp_sqrt (arg0)
lispval arg0;
{
	double	ret;
	double	sqrt();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("sqrt: non-numeric %v", arg0);

	ret = sqrt(a0);
	return doubleRet (ret);
}

lispval
lisp_tan (arg0)
lispval arg0;
{
	double	ret;
	double	tan();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("tan: non-numeric %v", arg0);

	ret = tan(a0);
	return doubleRet (ret);
}

lispval
lisp_tanh (arg0)
lispval arg0;
{
	double	ret;
	double	tanh();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("tanh: non-numeric %v", arg0);

	ret = tanh(a0);
	return doubleRet (ret);
}

lispval
lisp_y0 (arg0)
lispval arg0;
{
	double	ret;
	double	y0();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("y0: non-numeric %v", arg0);

	ret = y0(a0);
	return doubleRet (ret);
}

lispval
lisp_y1 (arg0)
lispval arg0;
{
	double	ret;
	double	y1();
	double	a0;

	if (nump (arg0))
		a0 = (double) itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = *itemtofloatp (arg0);
	else
		return error ("y1: non-numeric %v", arg0);

	ret = y1(a0);
	return doubleRet (ret);
}

lispval
lisp_yn (arg0, arg1)
lispval arg0, arg1;
{
	double	ret;
	double	yn();
	int	a0;
	double	a1;

	if (nump (arg0))
		a0 = itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = (int) *itemtofloatp (arg0);
	else
		return error ("yn: non-numeric %v", arg0);

	if (nump (arg1))
		a1 = (double) itemtonum (arg1);
	else if (floatpp (arg1))
		a1 = *itemtofloatp (arg1);
	else
		return error ("yn: non-numeric %v", arg1);

	ret = yn(a0, a1);
	return doubleRet (ret);
}

struct builtin mathStuff[] = {
	{ "acos", lisp_acos, LAMBDA, 1},
	{ "asin", lisp_asin, LAMBDA, 1},
	{ "atan", lisp_atan, LAMBDA, 1},
	{ "atan2", lisp_atan2, LAMBDA, 2},
	{ "ceil", lisp_ceil, LAMBDA, 1},
	{ "cos", lisp_cos, LAMBDA, 1},
	{ "cosh", lisp_cosh, LAMBDA, 1},
	{ "exp", lisp_exp, LAMBDA, 1},
	{ "fabs", lisp_fabs, LAMBDA, 1},
	{ "floor", lisp_floor, LAMBDA, 1},
	{ "hypot", lisp_hypot, LAMBDA, 2},
	{ "j0", lisp_j0, LAMBDA, 1},
	{ "j1", lisp_j1, LAMBDA, 1},
	{ "jn", lisp_jn, LAMBDA, 2},
	{ "log", lisp_log, LAMBDA, 1},
	{ "log10", lisp_log10, LAMBDA, 1},
	{ "pow", lisp_pow, LAMBDA, 2},
	{ "sin", lisp_sin, LAMBDA, 1},
	{ "sinh", lisp_sinh, LAMBDA, 1},
	{ "sqrt", lisp_sqrt, LAMBDA, 1},
	{ "tan", lisp_tan, LAMBDA, 1},
	{ "tanh", lisp_tanh, LAMBDA, 1},
	{ "y0", lisp_y0, LAMBDA, 1},
	{ "y1", lisp_y1, LAMBDA, 1},
	{ "yn", lisp_yn, LAMBDA, 2},
	{ 0, 0, 0, 0 },
};
#endif
