/*
 * main.c
 *
 * kalypso main routine
 */

# include	"kalypso.h"

#ifndef NDEBUG
int	Edebug, GCdebug;
#endif

struct dotted	program;

extern int Isdumpped;

extern lispval	Cons (), Plus(), iFread (), Set ();

initArgs (ac, av)
lispval	ac, av;
{
	lispval	setArgs[2];

	setArgs[0] = av;
	setArgs[1] = nil;
	Set (setArgs, 2);
	setArgs[0] = ac;
	setArgs[1] = numtoitem (0);
	Set (setArgs, 2);
}

/*
 * add an argument, cons it on to argv and increment argc;
 */

static
addArg (string, ac, av)
char	*string;
lispval	ac, av;
{
	int		mark;
	lispval		args[2];
	lispval		new;
	character	*arg;

	mark = frameMark ();
	new = nil;
	arg = iKstring (string, 1, -1);
	if (arg)
		new = stringtoitem (arg);
	framePush (new);
	args[0] = av;
	args[1] = Cons (new, iEval (av));
	if (!jumping) {
		Set (args, 2);
		if (!jumping) {
			args[0] = iEval (ac);
			if (!jumping) {
				args[1] = numtoitem (1);
				new = Plus (args, 2);
				if (!jumping) {
					framePush (new);
					args[0] = ac;
					args[1] = new;
					Set (args, 2);
				}
			}
		}
	}
	frameReset (mark);
}

main (argc, argv)
char	**argv;
{
	lispval			ac, av;
	lispval			ret;
	int			mark, i;
	char			*arg0;
	
#ifdef UNLIMIT
	unlimit ();
#endif
	arg0 = argv[0];
#ifdef FAKEDUMP
	{
		extern char	*defaultImage;
		char		*image = defaultImage;

		if (argc > 1) {
			/*
			 * as a security precaution,
			 * setuid kalypso programs must
			 * use the default kalypso image
			 */
			if (!strcmp (argv[1], "-restore-lisp")) {
				setuid (getuid ());
				setgid (getgid ());
				image = argv[2];
				argc -= 2;
				argv += 2;
			} else if (!strcmp (argv[1], "-raw-lisp")) {
				setuid (getuid ());
				setgid (getgid ());
				image = 0;
				argc -= 1;
				argv += 1;
			}
		}
		if (image)
			restoreDump (image);
	}
#endif /* FAKEDUMP */
	if (!Isdumpped)
		init ();
	else
		cleanup ();
	/*
	 * parse the argument vector.
	 */
	mark = frameMark ();
	av = symbolCopy (stringtoitem ("argv"), SystemDictionary->value);
	framePush (av);
	ac = symbolCopy (stringtoitem ("argc"), SystemDictionary->value);
	framePush (ac);
	initArgs (ac, av);
	for (i = argc-1; i > 0; i--) {
#ifndef NDEBUG
		/*
		 * a debugging image has two magic arguments
		 */
		if (*(argv[i] == '-')) {
			while (*++argv[i]) {
				switch (*argv[i]) {
				case 'e':
					++Edebug;
					break;
				case 'g':
					++GCdebug;
					break;
				}
			}
		} else
#endif
		addArg (argv[i], ac, av);
		if (jumping)
			break;
	}
	addArg (arg0, ac, av);
	frameReset (mark);
	program.car = symbolCopy (stringtoitem ("main"),
 					SystemDictionary->value);
	program.cdr = nil;
	ret = iEval (listtoitem (&program));
	done (ret == nil ? 1 : 0);
}

lispval
Exit (l, count)
lispval	*l;
{
	int	ret;

	ret = 0;
	if (count > 0) {
		if (nump (*l))
			ret = itemtonum (*l);
	}
	done (ret);
#ifdef SABER
	return nil;
#endif
}

done (ret)
{
	exit (ret);
}

# include	<signal.h>

lispval
Main ()
{
	lispval	i;
	int	signalHandler ();
	extern lispval	errorRet;

	(void) signal (SIGINT, signalHandler);
	for (;;) {
		fputs ("-> ", stdout);
		i = iFread (stdin);
		if (jumping) {
			if (jumping == ErrorJumping)
				fpatom (jumpValue, stderr);
			jumping = 0;
			continue;
		}
		if (nump(errorNumber->value) &&
 		    itemtonum(errorNumber->value) == LISPEOF)
		{
			(void) putchar ('\n');
			break;
		}
		i = iEval (i);
		if (jumping) {
			if (jumping == ErrorJumping)
				fpatom (jumpValue, stderr);
			jumping = 0;
			continue;
		}
		(void) fprint (i, stdout);
		(void) putchar ('\n');
	}
	return symboltoitem (true);
}

#ifdef UNLIMIT
# include	<sys/types.h>
# include	<sys/time.h>
# include	<sys/resource.h>

unlimit ()
{
	struct rlimit	ret;

	if (getrlimit (RLIMIT_DATA, &ret) == -1)
		return;
	ret.rlim_cur = ret.rlim_max;
	if (setrlimit (RLIMIT_DATA, &ret) == -1)
		return;

	if (getrlimit (RLIMIT_STACK, &ret) == -1)
		return;
	ret.rlim_cur = ret.rlim_max;
	if (setrlimit (RLIMIT_STACK, &ret) == -1)
		return;
}
#endif

struct builtin mainStuff[] = {
	"exit",		Exit,		LEXPR,		0,
	"main",		Main,		LAMBDA,		0,
	0,		0,		0,		0,
};
