/*
 * link.c
 *
 * link external .o files into a running kalypso image
 *
 * Assumptions:
 *   this routine should not call anything which
 *   might call sbrk between the first sbrk(0) and
 *   the sbrk(size) calls, chaos will result
 */

# include "kalypso.h"

#ifdef LINK
# include <a.out.h>

#ifdef SABER
extern int	etext;
#define Etext	(&etext)
#else
extern char	etext[];
#define Etext	etext
#endif

lispval
iLink (ldargs, nameList)
char	*ldargs;
char	*nameList;
{
	struct exec	header;
	char		*textbase;
	char		*database;
	char		*bssbase;
	char		*names;
	char		*malloc ();
	unsigned	size;
	int		num_syms;
	int		i;
	struct nlist	sym;
	int		strsize;
	int		fd;
	static char	nameBase[] = "/tmp/kalypso.XXXXXX";
	static char	fatal[] = "link: unexpexted fatal error";
	char		tmpname[sizeof (nameBase)];
	char		*sbrk (), *malloc ();
	FILE		*f;
	char		cmd[1024];
	char		obuf[BUFSIZ];
	struct builtin	*newSymbols[2048];
	int		newNumber;
	char		*strcpy(), *mktemp();
	long		lseek();
	char		*brk();
	int		text;
	lispval		builtinAdd ();
	
	fd = open (nameList, 0);
	if (fd == -1) {
		(void) fputs ("link: ", stderr);
		(void) fflush (stderr);
		(void) perror (nameList);
		return nil;
	}
	if (read (fd, (char *) &header, (int) sizeof (header)) != sizeof (header) ||
		N_BADMAG(header))
	{
		(void) close (fd);
		return error ("link: bad name-list file %v", stringtoitem (nameList));
	}
	(void) close (fd);
	text = textSize ();
	if (text != -1 && header.a_text != text)
		return error ("link: kalypso-image %v doesn't match me",
 			stringtoitem (nameList));
	/* no mallocs from here to... */
	 
	textbase = sbrk (0);
	(void) strcpy (tmpname, nameBase);
	(void) mktemp (tmpname);
	(void) sprintf (cmd, "ld -N -o %s -A %s -T %x %s -lc",
 		tmpname, nameList, textbase, ldargs);
	if (system (cmd) != 0)
		return error ("link: \"%v\" command failed", stringtoitem (cmd));
	fd = open (tmpname, 0);
	(void) unlink (tmpname);
	if (read (fd, (char *) &header, (int) sizeof (header)) != sizeof (header) ||
		N_BADMAG(header))
	{
		(void) close (fd);
		return error (fatal);
	}
	size = header.a_text + header.a_data + header.a_bss;
	(void) sbrk ((int) size);
	/* ... no mallocs to here */
	database = textbase + header.a_text;
	bssbase = database + header.a_data;
	/*
	 * setup text, data and bss
	 */
	(void) lseek (fd, (long) N_TXTOFF(header), 0);
	if (read (fd, textbase, (int) header.a_text) != header.a_text) {
		(void) close (fd);
		return error (fatal);
	}
	if (read (fd, database, (int) header.a_data) != header.a_data) {
		(void) close (fd);
		return error (fatal);
	}
	if (header.a_bss)
		bzero (bssbase, (int) header.a_bss);
	/*
	 * read in the strings so we can look
	 * for magic cookie names
	 */
	f = fdopen (fd, "r");
	setbuf (f, obuf);
	(void) fseek (f, (long) N_STROFF(header), 0);
	if (fread ((char *) &strsize, sizeof (strsize), 1, f) != 1) {
		(void) fclose (f);
		(void) close (fd);
		return error (fatal);
	}
	strsize -= 4;
	names = malloc ((unsigned) strsize);
	if (fread (names, sizeof (char), strsize, f) != strsize) {
		(void) brk (names);
		(void) fclose (f);
		(void) close (fd);
		return error (fatal);
	}
	/*
	 * look through the symbol table
	 * for names starting with "_LISP" and
	 * assume they are struct builtins; 
	 * add them as builtins to the system
	 */
	(void) fseek (f, (long) N_SYMOFF(header), 0);
	num_syms = header.a_syms / sizeof (struct nlist);
	newNumber = 0;
	for (i = 0; i < num_syms; i++) {
		static char foo[] = "_LISP";
		if (fread ((char *) &sym, sizeof (sym), 1, f) != 1) {
			free (names);
			(void) fclose (f);
			(void) close (fd);
			return error (fatal);
		}
		if ((sym.n_type & N_TYPE) == N_DATA &&
			(int) database <= sym.n_value &&
			sym.n_value < (int) database + header.a_data &&
			!strncmp (&names[sym.n_un.n_strx-4], foo, 5))
 		{
			newSymbols[newNumber++] = (struct builtin *) sym.n_value;
		}
	}
	(void) fclose (f);
	free (names);
	(void) close (fd);
	for (i = 0; i < newNumber; i++)
		(void) builtinAdd (newSymbols[i], SystemDictionary->value);
	return symboltoitem (true);
}


int
textSize ()
{
	/*
	 * compute expected text size in a.out file -- used
	 * to verify filename in link
	 */
#ifdef sequent
	struct exec	e, *foo;
	char		*btext;

	/*
	 * on a sequent box, the a.out header
	 * is actually in the programs address space (this is quite
	 * strange, I know) so this next bit of code extracts the
	 * actual a.out header and rearranges the fields a bit
	 */
	foo = (struct exec *) 2048;
	e = *foo;
	btext = N_ADDRADJ(e) + sizeof (e);
	return Etext - btext;
#endif
#ifdef sun
	struct exec	e;
	char		*btext;

	e = *((struct exec *) 0x2000);
	btext = (char *) N_TXTADDR(e);
	return (((int) Etext - (int) btext) + page_size()) & ~(page_size()-1);
#endif
#ifdef vax
	return (((int) Etext) + page_size()) & ~(page_size()-1);
#endif
}

lispval
Link (l, count)
lispval	*l;
int	count;
{
	char	*nameList;
	char	*ldargs;
	lispval	n;

	if ((ldargs = printName (l[0])) == nil)
		return error ("link: bad command %v", l[0]);
	n = kalypsoImage->value;
	if (count > 1)
		n = l[1];
	if ((nameList = printName(n)) == nil)
		return error ("link: bad name list %v", n);
	return iLink (ldargs, nameList);
}

struct builtin linkStuff[] = {
	"link",		Link,		LEXPR,		1,
	0,		0,		0,		0,
};

#endif
