/*
 * lex.h
 *
 * communication between the lexer and read
 */

extern character	*lexToken;

/*
 * lex tokens
 */

# define END	0
# define NAME	1
# define OP	2
# define CP	3
# define OS	4
# define CS	5
# define OC	6
# define CC	7
# define QUOTE	8
# define STRING	9
# define NUM	10
# define FLOAT	11


/*
 * character classes
 */

# define PRINTABLE	0x00000001	/* \t \n ' ' - '~' */
# define QUOTED		0x00000002	/* \ anything */
# define BRA		0x00000004	/* ( [ { */
# define KET		0x00000008	/* ) ] } */
# define WHITE		0x00000010	/* ' ' \t \n */
# define DIGIT		0x00000020	/* [0-9] */
# define SIGN		0x00000040	/* +- */
# define DOT		0x00000080	/* . */
# define ENDOFFILE	0x00000100	/* end of file */
# define COMMENT	0x00000200	/* ; # */
# define IGNORE		0x00000400	/* \0 - ' ' */
# define QUOTEC		0x00000800	/* ' */
# define BACKSLASH	0x00001000	/* \ */
# define VBAR		0x00002000	/* | */
# define TWIDDLE	0x00004000	/* ~ */
# define STRINGC	0x00008000	/* " */
# define EXP		0x00010000	/* eE */

# define NOTNAME	(STRINGC|TWIDDLE|VBAR|QUOTEC|COMMENT|ENDOFFILE|WHITE|KET|BRA)
# define NUMBER		(DIGIT|SIGN)
# define FIRSTINNUM	(SIGN)
# define NOTFIRSTINNUM	(EXP)
# define FLOATONLY	(EXP|DOT)
# define FLOATC		(NUMBER|FLOATONLY)

extern long classTable[256];
