/*
 *	init.c
 */

# include	"kalypso.h"
# include	"local.h"

#ifdef FAKEDUMP
char	*defaultImage = KALYPSOFAKE;
#endif

init ()
{
	initIO ();
	initbuilt ();
}

extern struct builtin
	catchStuff[], controlStuff[],
#ifdef CURSES_PACKAGE
 	cursesStuff[],
#endif
 	dictionaryStuff[], dumpStuff[],
	errorStuff[], evalStuff[], fileStuff[], formatStuff[],
#ifdef LINK
 	linkStuff[],
#endif
 	listStuff[], mainStuff[],
#ifdef MATH_PACKAGE
	mathStuff[],
#endif
 	memStuff[],
#ifdef NETWORK_PACKAGE
	networkStuff[],
#endif
 	numberStuff[], objectStuff[], printStuff[],
#ifdef PROFILE
	profileStuff[],
#endif
 	progStuff[], readStuff[],
#ifdef SERVICES_PACKAGE
	servicesStuff[],
#endif
 	signalStuff[], stringStuff[],
	symbolStuff[],
#ifdef SYSTEM_PACKAGE
 	systemStuff[],
#endif
 	vectorStuff[];

struct builtin *packages[] = {
	catchStuff, controlStuff,
#ifdef CURSES_PACKAGE
 	cursesStuff,
#endif
 	dictionaryStuff, dumpStuff,
	errorStuff, evalStuff, fileStuff, formatStuff,
#ifdef LINK
 	linkStuff,
#endif
 	listStuff, mainStuff,
#ifdef MATH_PACKAGE
	mathStuff,
#endif
 	memStuff,
#ifdef NETWORK_PACKAGE
	networkStuff,
#endif
 	numberStuff, objectStuff, printStuff,
#ifdef PROFILE
	profileStuff,
#endif
 	progStuff, readStuff,
#ifdef SERVICES_PACKAGE
	servicesStuff,
#endif
 	signalStuff, stringStuff,
	symbolStuff,
#ifdef SYSTEM_PACKAGE
 	systemStuff,
#endif
 	vectorStuff,
	0,
};
	
# define BINDNIL	0
# define BINDUNDEF	1
# define BINDSELF	2
# define BINDTRUE	3

struct symbol	*true, *quote, *nilName;
struct symbol	*lambda, *nlambda, *lexpr, *macro;
struct symbol	*kalypsoImage, *kalypsoLib, *kalypsoManual, *kalypsoVersion;
struct symbol	*expandMacro, *errorNumber;
struct symbol	*Stdin, *Stdout, *Stderr;
struct symbol	*SystemDictionary, *SymbolDictionary;
			
struct symbol **referencedSymbols [] = {
	&true, &quote, &nilName,
	&lambda, &nlambda, &lexpr, &macro,
	&kalypsoImage, &expandMacro, &errorNumber,
	&Stdin, &Stdout, &Stderr, &SystemDictionary, &SymbolDictionary,
	0,
};

static struct dictionary	*systemDictionary;

struct bsymbol {
	char		*ba_name;
	struct symbol	**savein;
	int		bindopt;
} bsymbol [] = {
	"t",		&true,		BINDSELF,
	"nil",		&nilName,	BINDNIL,
	"lambda",	&lambda,	BINDUNDEF,
	"nlambda",	&nlambda,	BINDUNDEF,
	"lexpr",	&lexpr,		BINDUNDEF,
	"macro",	&macro,		BINDUNDEF,
	"quote",	&quote,		BINDUNDEF,
	"kalypso-image",	&kalypsoImage,	BINDUNDEF,
	"kalypso-lib",	&kalypsoLib,	BINDUNDEF,
	"kalypso-manual",	&kalypsoManual,	BINDUNDEF,
	"kalypso-version",	&kalypsoVersion,	BINDUNDEF,
	"expand-macro",	&expandMacro,	BINDTRUE,
	"error-number",	&errorNumber,	BINDNIL,
	"stdin",	&Stdin,		BINDUNDEF,
	"stdout",	&Stdout,	BINDUNDEF,
	"stderr",	&Stderr,	BINDUNDEF,
	"system-dictionary", &SystemDictionary,	BINDUNDEF,
	"symbol-dictionary", &SymbolDictionary, BINDUNDEF,
	0,		0,		0,
};

lispval	builtinAdd ();

initbuilt ()
{
	struct builtin	*b;
	struct bsymbol	*ba;
	struct builtin	**package;
	struct symbol	*a;
	int		framem;
	struct dictionary	*symDict;

	framem = frameMark ();
	framePush (filetoitem (stdin));
	framePush (filetoitem (stdout));
	framePush (filetoitem (stderr));
	systemDictionary = iNewDictionary ();
	framePush (dicttoitem (systemDictionary));

	for (package = packages; *package; package++)
		for (b = *package; b->name; b++)
			(void) builtinAdd (b, dicttoitem (systemDictionary));
	for (ba = bsymbol; ba->ba_name; ba++) {
		a = iSymbol (stringtoitem (iKstring (ba->ba_name, 1, -1)),
			     systemDictionary, 0);
		if (!a) {
			(void) error ("init: fatal dictionary error");
			abort ();
		}
		*ba->savein = a;
		switch (ba->bindopt) {
		case BINDNIL:
			a->value = nil;
			break;
		case BINDUNDEF:
			break;
		case BINDSELF:
			a->value = symboltoitem (a);
			break;
		case BINDTRUE:
			a->value = symboltoitem (true);
		}
	}
	kalypsoImage->value = stringtoitem (iKstring (KALYPSOIMAGE, 1, -1));
	kalypsoLib->value = stringtoitem (iKstring (KALYPSOLIB, 1, -1));
	kalypsoManual->value = stringtoitem (iKstring (KALYPSOMANUAL, 1, -1));
	kalypsoVersion->value = stringtoitem (iKstring (KALYPSOVERSION, 1, -1));
	Stdin->value = filetoitem (stdin);
	Stdout->value = filetoitem (stdout);
	Stderr->value = filetoitem (stderr);
	SystemDictionary->value = dicttoitem (systemDictionary);
	symDict = iNewDictionary ();
	SymbolDictionary->value = dicttoitem (symDict);
	frameReset (framem);
}

struct symbol *
builtinLookup (string, dict)
char			*string;
struct dictionary	*dict;
{
	return iSymbol (stringtoitem (iKstring (string, 1, -1)), dict, 0);
}

lispval
builtinAdd (b, dictionary)
struct builtin 		*b;
lispval			dictionary;
{
	struct symbol	*a;
	struct dictionary	*dict;
	
	if (!dictp (dictionary))
		return error ("builtin-add: non-dictionary %v", dictionary);
	dict = itemtodict (dictionary);
	a = builtinLookup (b->name, dict);
	if (jumping)
		return nil;
	a->value = builtintoitem (b);
	return symboltoitem (a);
}

#ifdef SYSV

bcopy (src, dest, amt)
register char	*src, *dest;
register int	amt;
{
	while (amt--)
		*dest++ = *src++;
}

bzero (src, amt)
register char	*src;
register int	amt;
{
	while (amt--)
		*src++ = '\0';
}

#endif
