/*
 * format.c
 *
 * formatted output.  Currently, width and precision are
 * unimplemented.  The only escapes recognised are
 *
 *	'a'	- patom value
 *	'v'	- print value
 *	'c'	- putchar integer value
 */

# include	"kalypso.h"

iFormat (f, format, argv, argc)
register FILE		*f;
register character	*format;
register lispval	*argv;
int			argc;
{
	register character	c;
	register int		count=0, width = 1, precision = 8, sign;
	lispval			value;

	c = iScar (format);
	format = iScdr (format);
	for (;;) {
		switch (c) {
		case '%':
			c = iScar (format);
			format = iScdr (format);
			width = 1; precision = 8; sign = 1;
percent:	;
			switch (c) {
			case 'a':
			case 'v':
			case 'c':
				if (argc == 0)
					goto out_of_args;
				value = *argv++;
				--argc;
				switch (c) {
				case 'a':
					fpatom (value, f);
					break;
				case 'v':
					fprint (value, f);
					break;
				case 'c':
					if (nump (value))
						c = itemtonum (value);
					else if (floatpp (value))
						c = *itemtofloatp (value);
					else
						return error ("fformat: non-numeric %v", value);
					(void) putc (c, f);
					break;
				}
				++count;
				break;
			case 0:
				return count;
			case '-':
				sign = -1;
				c = iScar (format);
				format = iScdr (format);
			default:
				if (('0' <= c && c <= '9') || c == '.' || c == '*') {
					if (c == '*') {
					/*
						if (argc == 0)
							goto out_of_args;
						value = *argv++;
						--argc;
						width = sign * itemtonum(value);
					*/
						c = iScar (format);
						format = iScdr (format);
					} else if (c != '.') {
						width = c - '0';
						c = iScar (format);
						format = iScdr (format);
						while ('0' <= c && c <= '9') {
							width = width * 10 + c - '0';
							c = iScar (format);
							format = iScdr (format);
						}
						width *= sign;
					}
					if (c == '.') {
						c = iScar (format);
						format = iScdr (format);
						if (c == '*') {
					/*
							if (argc == 0)
								goto out_of_args;
							value = *argv++;
							--argc;
							precision = itemtonum(value);
					*/
							c = iScar (format);
							format = iScdr (format);
						} else {
							precision = c - '0';
							c = iScar (format);
							format = iScdr (format);
							while ('0' <= c && c <= '9') {
								precision = precision * 10 + c - '0';
								c = iScar (format);
								format = iScdr (format);
							}
						}
					}
					goto percent;
				} else
					putc (c, f);
			}
			break;
		case 0:
			return count;
		default:
			putc (c, f);
		}
		c = iScar (format);
		format = iScdr (format);
	}
out_of_args:
	return error ("fformat: format specifier reqests too many args");
}

char *
iSformat (format, argv, argc, lenp)
character	*format;
lispval		*argv;
int		argc;
int		*lenp;
{
	FILE		*s;
	extern FILE	*open_string ();
	extern char	*close_string ();

	s = open_string ();
	iFormat (s, format, argv, argc);
	return close_string (s, lenp);
}

/*
 * format routine used by error routine
 */

format (f, format, args, count)
FILE	*f;
char	*format;
lispval	*args;
int	count;
{
	iFormat (f, (character *) format, args, count);
}

lispval
Fformat (l, count)
lispval	*l;
{
	FILE		*f;
	character	*format;

	if (!filep(*l))
		return error ("fformat: non-file %v", *l);
	f = itemtofile (*l);
	l++;
	--count;
	if (!stringp (*l))
		return error ("fformat: non-string %v", *l);
	format = itemtostring (*l);
	l++;
	--count;
	iFormat (f, format, l, count);
	if (jumping)
		return nil;
	return symboltoitem (true);
}

lispval
Sformat (l, count)
lispval	*l;
{
	character	*format;
	char		*result;
	character	*ret;
	int		len;

	if (!stringp (*l))
		return error ("fformat: non-string %v", *l);
	format = itemtostring (*l);
	l++;
	--count;
	result = iSformat (format, l, count, &len);
	if (jumping)
		return nil;
	ret = iKstring (result, 1, len);
	if (!ret)
		return nil;
	return stringtoitem (ret);
}

struct builtin formatStuff[] = {
	"fformat",	Fformat,	LEXPR,		2,
	"sformat",	Sformat,	LEXPR,		1,
	0, 0, 0, 0
};
