/*
 * eval.c
 */

# include	"kalypso.h"
# include	<assert.h>

# define checkFrameM(n)	((framep + n) > frametop  ? growStack (nil) : 0)

# define STATICFRAMESIZE	1000

# define MINNEWFRAMESIZE	10000
lispval	staticframe[STATICFRAMESIZE];

lispval	inProgress;
int	framesize = STATICFRAMESIZE;
lispval	*frame	= staticframe;
lispval	*framep = staticframe;
lispval	*frametop = staticframe + STATICFRAMESIZE;

int	jumping = 0;	/* set when eval should just return */
lispval	jumpValue;	/* value for jump catcher */

#ifdef PROFILE
extern int	Profiling;	/* profile bound lambdas */
#endif

#ifndef NDEBUG
extern int	Edebug, GCdebug;
static int	level = 0;
#endif

int	usingApply;	/* BLEAH!!!! */

# undef MACRO_STATS

lispval macroCache ();

# define NO_MACRO	undeftoitem (1)

lispval
iEvallist (l)
lispval	l;
{
	register lispval	ret;
	register struct symbol	*symbol;
	register struct builtin	*builtin;
 	register struct dotted	*actual;	/* actuals */
	register lispval	function;	/* (car list) */
	register int		i;

	int			type;
	int			args;		/* actual argument base offset */

	struct dotted		*list;		/* itemtolist (l) */
	int			argc;		/* number of args pushed */

	struct dotted		*formal;	/* (car (cdr list)) */

	int			savefp;		/* old fp offset */
	int			savelambda;	/* saved lambda values offset */
	int			fromApply = usingApply;

	struct dotted	*first, *new, *last;
#ifdef PROFILE
	struct symbol		*profile = 0;
#endif
	
	usingApply = 0;
#ifndef NDEBUG
	if (Edebug) {
		argc = level / 10;
		while (argc-- > 0)
			putchar ('X');
		argc = level % 10;
		while (argc-- > 0)
			putchar ('|');
		debug (" EVAL ");
		fprint (l, stdout);
		debug ("\n");
		level++;
	}
#endif
	/*
	 * macros come back here to eval the result
	 */

restart_eval:
	savefp = ((char *) framep) - ((char *) frame);

	checkFrameM (2);
	/*
	 * mark the eval frame
	 */
	*framep++ = FRAMEMARK;
	/*
	 * hold onto this list
	 */
	list = itemtolist (l);
	*framep++ = l;

	/*
	 * see if there is anything to do queued up
	 */
	checkAsync ();

	function = list->car;
	/*
	 * evaluate the first element of the list
	 * unless it is a list starting with 
	 * lambda, nlambda, macro or lexpr
	 */
	if (listp (function)) {
		ret = itemtolist (function)->car;
		if (symbolp (ret)) {
			symbol = itemtosymbol (ret);
			if (symbol == lambda ||
			    symbol == nlambda ||
			    symbol == macro ||
			    symbol == lexpr)
			 	goto quotedFunction;
		}
	}
#ifdef PROFILE
	if (Profiling && symbolp (function))
		profile = itemtosymbol (function);
#endif

#define EvalTypeVariable i
#define EvalTempVariable ret
	function = iEval (function);
	if (jumping) {
		type = UNKNOWN;
		goto abort_eval;
	}
#undef EvalTypeVariable
#undef EvalTempVariable

quotedFunction:
	if (builtinp (function)) {
		builtin = itemtobuiltin (function);
		type = i = builtin->type;
	} else {
		/*
		 * hold onto the lambda body
		 */
		framePush (function);

		i = UNKNOWN;
		if (listp (function)) {
			ret = itemtolist (function)->car;
			if (symbolp (ret)) {
				symbol = itemtosymbol (ret);
				if (symbol == lambda)
					i = LAMBDA;
				if (symbol == nlambda)
					i = NLAMBDA;
				if (symbol == lexpr)
					i = LEXPR;
				if (symbol == macro)
					i = MACRO;
			}
		}
		if (i == UNKNOWN)
			goto undefinedFunction;
		type = i;
	}

	/*
	 * check to see if this macro expansion has already been
	 * computed
	 */

	if (type == MACRO) {
		ret = macroCache (itemtolist (function), list);
		if (ret != NO_MACRO) {
			if (listp (ret)) {
				framep = (lispval *) (((char *) frame) + savefp);
				l = ret;
				goto restart_eval;
			} else {
				type = UNKNOWN;
				ret = iEval (ret);
				goto done_eval;
			}
		}
	}

	/*
	 * compute the arguments
	 */
	args = framep - frame;
	switch (i) {
	case LAMBDA:
	case LEXPR:
		actual = list->cdr;
		argc = 0;
		if (fromApply) {
			for (; actual != nil; actual = actual->cdr) {
				argc++;
				framePush (actual->car);
			}
		} else {
			for (; actual != nil; actual = actual->cdr) {
				argc++;
#define EvalTypeVariable i
#define EvalTempVariable ret
				ret = iEval (actual->car);
				framePush (ret);
#undef EvalTypeVariable
#undef EvalTempVariable
				if (jumping) {
					ret = nil;
					goto abort_eval;
				}
			}
		}
		break;
	case NLAMBDA:
		framePush (listtoitem (list->cdr));
		argc = 1;
		break;
	case MACRO:
		framePush (l);
		argc = 1;
		break;
	}
#ifdef PROFILE
	if (profile)
		LcountStart (profile);
#endif
	/*
	 * eval the function
	 */
	if (builtinp (function)) {
		switch (type) {
		case LAMBDA:
			if (argc != builtin->argc) {
				ret = error ("arg count mismatch %v",
						stringtoitem (builtin->name));
			} else {
				i = args;
				switch (argc) {
				case 0:
					ret = builtin->function ();
					break;
				case 1:
					ret = builtin->function (frame[i]);
					break;
				case 2:
					ret = builtin->function (frame[i],
	 							frame[i+1]);
					break;
				case 3:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2]);
					break;
				case 4:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3]);
					break;
				case 5:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3],
	 							frame[i+4]);
					break;
				case 6:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3],
	 							frame[i+4],
	 							frame[i+5]);
					break;
				case 7:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3],
	 							frame[i+4],
	 							frame[i+5],
	 							frame[i+6]);
					break;
				case 8:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3],
	 							frame[i+4],
	 							frame[i+5],
	 							frame[i+6],
	 							frame[i+7]);
					break;
				case 9:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3],
	 							frame[i+4],
	 							frame[i+5],
	 							frame[i+6],
	 							frame[i+7],
	 							frame[i+8]);
					break;
				case 10:
					ret = builtin->function (frame[i],
	 							frame[i+1],
	 							frame[i+2],
	 							frame[i+3],
	 							frame[i+4],
	 							frame[i+5],
	 							frame[i+6],
	 							frame[i+7],
	 							frame[i+8],
	 							frame[i+9]);
					break;
				}
			}
			break;
		case LEXPR:
			if (argc < builtin->argc) {
				ret = error ("too few arguments to %v", list->car);
				break;
			}
		case NLAMBDA:
		case MACRO:
			ret = builtin->function (frame+args, argc);
		}
	} else {
		actual = itemtolist (function);
		ret = actual->cdr->car;
		if (!listp (ret) && !nilp (ret)) {
			ret = error ("badly formed lambda %v", list->car);
			goto abort_eval;
		}
		formal = itemtolist (ret);
		savelambda = framep - frame;
		i = args;
		/*
		 * lambda bind formals
		 */
		switch (type) {
		case LEXPR:
			if (!formal) {
				ret = error ("eval: mal-formed lexpr %v", list->car);
				goto abort_eval;
			}
			while (formal->cdr) {
				ret = formal->car;
				if (!symbolp (ret))
					goto nonAtomBind;
 				if (!argc)
					goto toofewParameters;
				symbol = itemtosymbol (ret);
				framePush (symbol->value);
				symbol->value = frame[i++];
				--argc;
				formal = formal->cdr;
			}
			ret = formal->car;
			if (!symbolp (ret))
				goto nonAtomBind;
			symbol = itemtosymbol (ret);
			framePush (symbol->value);
			first = nil;
			last = nil;
			while (argc) {
				new = newDotted ();
				if (last)
					last->cdr = new;
				else {
					symbol->value =
						listtoitem(first = new);
				}
				new->car = frame[i++];
				new->cdr = nil;
				last = new;
				argc--;
			}
			if (nilp (first))
				symbol->value = nil;
			break;
		case NLAMBDA:
		case MACRO:
			ret = formal->car;
			if (!symbolp (ret))
				goto nonAtomBind;
			if (formal->cdr) {
				ret = error ("eval: mal-formed nlambda/macro %v",
					list->car);
				goto abort_eval;
			}
			symbol = itemtosymbol (ret);
			framePush (symbol->value);
			symbol->value = frame[i];
			break;
		case LAMBDA:
			while (formal) {
				ret = formal->car;
				if (!symbolp (ret))
					goto nonAtomBind;
 				if (!argc)
					goto toofewParameters;
				symbol = itemtosymbol (ret);
				framePush (symbol->value);
				symbol->value = frame[i++];
				--argc;
				formal = formal->cdr;
			}
			if (argc)
				goto toomanyParameters;
			break;
		}
		/*
		 * evaluate sexprs
		 */
		list = actual->cdr->cdr;
		while (list && !jumping) {
#define EvalTempVariable ret
#define EvalTypeVariable i
			ret = iEval (list->car);
#undef EvalTempVariable
#undef EvalTypeVariable
			list = list->cdr;
		}
		/*
		 * restore lambda bound symbols to previous values
		 */
		formal = itemtolist (actual->cdr->car);
		i = savelambda;
		argc = (framep - frame) - i;
		while (argc--) {
			symbol = itemtosymbol (formal->car);
			symbol->value = frame[i++];
			formal = formal->cdr;
		}
		if (jumping) {
			ret = nil;
			goto abort_eval;
		}
	}
	/*
	 * common code to abort this eval
	 */
abort_eval:
done_eval:

#ifdef PROFILE
	if (profile)
		LcountEnd (profile);
#endif

	framep = (lispval *) (((char *) frame) + savefp);

#ifndef NDEBUG
	if (Edebug) {
		level--;
		argc = level / 10;
		while (argc-- > 0)
			debug ("X");
		argc = level % 10;
		while (argc-- > 0)
			debug ("|");
		debug (" EVAL RETURNS ");
		fprint (ret, stdout);
		debug ("\n");
	}
#endif

	/*
	 * reevaluated the macro result
	 */

	if (type == MACRO && !jumping && expandMacro->value != nil) {
#ifdef MACRO_CACHE
		macroValue (itemtolist (function), itemtolist (l), ret);
#endif
		if (listp (ret)) {
			l = ret;
			goto restart_eval;
		} else {
			ret = iEval (ret);
		}
	}
	return ret;

	/*
	 * various error returns, placed down here to shrink loop
	 * sizes above for cache help.  A gross but very effective
	 * hack for 68020's and friends...
	 */

undefinedFunction:
	ret = error ("eval: undefined function %v", function);
	type = UNKNOWN;
	goto abort_eval;
nonAtomBind:
	ret = error ("eval: attempt to lambda bind non-symbol %v", ret);
	type = UNKNOWN;
	goto abort_eval;
toofewParameters:
	ret = error ("eval: too few parameters to %v", list->car);
	type = UNKNOWN;
	goto abort_eval;
toomanyParameters:
	ret = error ("eval: %v too many parameters to %v",
 		numtoitem (argc), list->car);
	type = UNKNOWN;
	goto abort_eval;
}

lispval
Eval (l)
lispval	l;
{
	register int		type;
	register lispval	temp;
	
#define EvalTempVariable temp
#define EvalTypeVariable type
	return iEval (l);
#undef EvalTempVariable
#undef EvalTypeVariable
}

lispval
Apply (func, actuals)
lispval	func, actuals;
{
	struct dotted	*temp;
	struct dotted	*a;
	lispval		result;

	if (!listp (actuals) && !nilp (actuals))
		return error ("apply: non-list actuals %v", actuals);
	a = itemtolist (actuals);
	temp = newDotted ();
	temp->car = func;
	temp->cdr = a;
	/*
	 * here's the magic.  iEvallist checks this global
	 * variable to see if the arguments shouldn't be eval'ed again.
	 * As recursive calls aren't necessarily apply's, iEvallist must
	 * zero this variable before executing the function body.
	 */
	++usingApply;
	result = iEvallist (listtoitem (temp));
	return result;
}

/*
 * reset the machine from a recovered dump image
 */

cleanup ()
{
	framep = frame;
#ifndef NDEBUG
	level = 0;
#endif
}

static lispval	growStackSave;

/*
 * expand the frame buffer
 */

growStack (saveMe)
lispval	saveMe;
{
	char	*malloc (), *realloc ();
	int	offset;
	int	newsize;
	lispval	*newframe;

	growStackSave = saveMe;
	offset = framep - frame;
	newsize = framesize * 6;
	if (newsize < MINNEWFRAMESIZE)
		newsize = MINNEWFRAMESIZE;
	while (!(newframe = (lispval *)
		malloc ((unsigned) newsize * sizeof (lispval))))
	{
		newsize /= 2;
		if (newsize <= framesize)
			panic (0, "out of memory, quiting\n");
	}
#ifndef NDEBUG
	if (GCdebug) {
		debug ("growstack to %d from %d\n", newsize, framesize);
	}
#endif
	bcopy ((char *) frame, (char *) newframe, framesize * sizeof (lispval));
	if (frame != staticframe)
		free ((char *) frame);
	frame = newframe;
	framesize = newsize;
	frametop = frame + framesize;
	framep = frame + offset;
	growStackSave = 0;
}

lispval
ActivationRecords (count)
lispval	count;
{
	lispval	*p;
	int	c;
	struct dotted	*first, *new, *last;
	int	framem;

	if (!nump (count))
		return error ("trace: non-numeric: %v", count);
	c = itemtonum (count);
	framem = frameMark ();
	last = first = nil;
	for (p = framep; p >= frame; p--)
		if (*p == FRAMEMARK)
			if (c > 0) {
				new = newDotted ();
				new->cdr = nil;
				new->car = p[1];
				if (!first) {
					first = new;
					framePush (listtoitem (first));
				} else
					last->cdr = new;
				last = new;
				--c;
			} else
				break;
	frameReset (framem);
	if (first)
		return listtoitem (first);
	return nil;
}

/*
 * mark all items referenced from the frames
 * for garbage collection
 */

markFrame ()
{
	register lispval	*b, *e;

	e = framep;
	for (b = frame; b < e; b++)
		setRef (*b);
	if (growStackSave)
		setRef (growStackSave);
#ifdef MACRO_CACHE
	macroFlushCache ();
#endif
}

# define CACHE_SIZE	1024

struct macroCache {
	struct macroCache	*next;
	struct dotted		*macro, *arguments;
	lispval			result;
};

static struct macroCache *cache[CACHE_SIZE];

# define hash(d)	((((unsigned) d) >> 3) % CACHE_SIZE)

#ifdef MACRO_STATS
static int	macroHits;
static int	macroMisses;
static int	macroEntries;
#endif MACRO_STATS

lispval
macroCache (macro, arguments)
register struct dotted	*macro, *arguments;
{
	register struct macroCache	**bucket, *m;

	bucket = &cache[hash(arguments)];
	for (m = *bucket; m ; m = m->next)
		if (m->arguments == arguments && m->macro == macro) {
#ifdef MACRO_STATS
			++macroHits;
#endif MACRO_STATS
			return m->result;
		}
#ifdef MACRO_STATS
	++macroMisses;
#endif MACRO_STATS
	return NO_MACRO;
}

macroValue (macro, arguments, result)
register struct dotted	*macro, *arguments;
lispval			result;
{
	register struct macroCache	**bucket, *m;

#ifdef MACRO_STATS
	++macroEntries;
#endif MACRO_STATS
	bucket = &cache[hash(arguments)];
	for (m = *bucket; m ; m = m->next)
		if (m->arguments == arguments && m->macro == macro) {
			m->result = result;
			return;
		}
	m = (struct macroCache *) newHunkFast (2);
	m->arguments = arguments;
	m->macro = macro;
	m->result = result;
	m->next = *bucket;
	*bucket = m;
}

macroFlushCache ()
{
	register int	i;

	for (i = 0; i < CACHE_SIZE; i++)
		cache[i] = 0;
#ifdef MACRO_STATS
	macroHits = 0;
	macroMisses = 0;
	macroEntries = 0;
#endif MACRO_STATS
}

#ifdef MACRO_STATS
lispval
MacroStats ()
{
	lispval	fargs[3];
	
	fargs[0] = intRet (macroEntries);
	fargs[1] = intRet (macroHits);
	fargs[2] = intRet (macroMisses);
	format (stdout, "cache entries: %v\ncache hits:    %v\ncache misses: %v\n",
		fargs, 3);
	return symboltoitem (true);
}
#endif MACRO_STATS

struct builtin evalStuff[] = {
	"eval",			Eval,		LAMBDA,		1,
	"apply",		Apply,		LAMBDA,		2,
	"activation-records",	ActivationRecords, LAMBDA,	1,
#ifdef MACRO_STATS
	"macro-cache-stats",	MacroStats,	LAMBDA,		0,
#endif
	0,			0,		0,		0,
};
