/*
 * error.c
 */

# include	"kalypso.h"
# include	<varargs.h>

lispval
/*ARGSUSED*/
ErrorCatch (s, count)
lispval		*s;
int		count;
{
	struct dotted	*l;
	lispval	ret;

	ret = nil;
	l = itemtolist (*s);
	while (l) {
		ret = iEval (l->car);
		if (jumping) {
			if (jumping == ErrorJumping) {
				ret = jumpValue;
				jumping = 0;
			} else
				ret = nil;
			break;
		}
		l = l->cdr;
	}
	return ret;
}

lispval
ErrorThrow (l)
lispval	l;
{
	jumpValue = l;
	jumping = ErrorJumping;
	return l;
}

lispval
Error (l, count)
lispval	*l;
int	count;
{
	character	*fmt;

	if (!stringp (*l)) {
		format (stderr, (character *) "error: bad format %v", *l);
	} else {
		fmt = itemtostring (*l);
		l++;
		count--;
		format (stderr, (char *) fmt, l, count);
	}
	(void) putc ('\n', stderr);
	return ErrorThrow (*l);
}

static int	inError;

#ifdef SYSV
#define index strchr
#endif

lispval
/*VARARGS1*/
error (f, va_alist)
char	*f;
va_dcl
{
	struct dotted	*first, *last, *new;
	char	*args;
	int	framem;
	lispval	a[4];
	int	i;
	int	count;
	char	*s, *index ();
	lispval	ret;
	extern int	usingApply;
	character	*k;

	/*
	 * count the number of % escapes in the format string
	 * to discover the expected number of arguments.
	 */
	s = f;
	count = 0;
	while (s = index (s, '%')) {
		count++;
		s++;
	}
	framem = frameMark ();
	if (inError) {
		va_start (args);
		for (i = 0; i < count; i++)
			a[i] = va_arg (args, lispval);
		va_end (args);
		format (stderr, f, a, count);
		fputs ("\nkalypso: recursive error\n", stderr);
		jumping = ErrorJumping;
		jumpValue = nil;
		return nil;
	}
	++inError;
	first = newDotted ();
	first->car = nil;
	first->cdr = nil;
	last = first;
	framePush (listtoitem (first));
	first->car = symbolCopy (stringtoitem ("error"),
 				SystemDictionary->value);
	new = newDotted ();
	new->car = nil;
	new->cdr = nil;
	last->cdr = new;
	last = new;
	k = iKstring (f, 1, -1);
	if (k)
		new->car = stringtoitem (k);
	else
		new->car = nil;
	va_start (args);
	for (i = 0; i < count; i++) {
		new = newDotted ();
		new->car = va_arg (args, lispval);
		new->cdr = nil;
		last->cdr = new;
		last = new;
	}
	--inError;
	if (jumping) {
		frameReset (framem);
		return nil;
	}
	++usingApply;
	ret = iEvallist (listtoitem (first));
	frameReset (framem);
	return ret;
}

#ifndef NDEBUG
debug (msg, arg1, arg2)
char	*msg;
{
	printf (msg, arg1, arg2);
	fflush (stdout);
}
#endif

panic (core_dump, msg)
char	*msg;
{
	fputs (msg,  stderr);
	fflush (stderr);
	if (core_dump)
		abort ();
	else
		exit (1);
}

struct builtin errorStuff [] = {
	"error-catch",		ErrorCatch,	NLAMBDA,	0,
	"error-throw",		ErrorThrow,	LAMBDA,		1,
	"error",		Error,		LEXPR,		1,
	0,			0,		0,		0,
};
