/*
 * dump.c
 *
 * make a new a.out file which is an image of the current lisp
 */

# include	"kalypso.h"

extern char		*sbrk();

int		Isdumpped;

#ifdef FAKEDUMP

lispval
dumpme (bdata, dataArg, image, nameList)
char	*bdata;
int	dataArg;
char	*image;
char	*nameList;
{
	int	fd;
	extern char	data_start [1];
	int	data;

	fd = creat (image, 0666);
	if (fd == -1) {
		perror (image);
		return nil;
	}
	data = sbrk (0) - data_start;
	if (write (fd, &data, sizeof (data)) != sizeof (data)) {
		perror (image);
		close (fd);
		return nil;
	}
	if (write (fd, data_start, data) != data) {
		perror (image);
		close (fd);
		return nil;
	}
	close (fd);
	return symboltoitem (true);
}

restoreDump (image)
char	*image;
{
	int		fd;
	extern char	data_start [1];
	int		cursize, change;
	int		data;
	char		**env;
	extern char	**environ;

	/* save environ value */
	env = environ;
	fd = open (image, 0);
	if (fd == -1)
		return -1;
	read (fd, &data, sizeof (data));
	cursize = sbrk (0) - data_start;
	change = data - cursize;
	sbrk (change);
	read (fd, data_start, data);
	/* restore environ value */
	environ = env;
}

#else /* FAKEDUMP */

# include	<a.out.h>
# include	<sys/param.h>

#ifdef lint
char		etext[];
#endif

#ifdef SABER
extern int	etext;
#define Etext	(&etext)
#else
extern char	etext[];
#define Etext	etext
#endif

#ifdef sequent
# define ROUND_TO	2048
#else
# ifdef PAGSIZ
#  define ROUND_TO	PAGSIZ
# else
#  ifdef CLBYTES
#   define ROUND_TO	CLBYTES
#  else
#   ifdef NBPG
#    define ROUND_TO	NBPG
#   else
#    ifdef MAXCLBYTES
#     define ROUND_TO	MAXCLBYTES
#     define PAGE_SIZE	1024
#    else
#     define ROUND_TO	1024
#    endif
#   endif
#  endif
# endif
#endif
#ifndef PAGE_SIZE
# define PAGE_SIZE	ROUND_TO
#endif

#ifdef mips
struct exec {
	FILHDR			filehdr;
	AOUTHDR			aouthdr;
	SCNHDR			sections[32];
};

#define esize(e)	(sizeof (FILHDR) + sizeof (AOUTHDR)\
				+ e.filehdr.f_nscns * sizeof (SCNHDR))

#define S_TEXT	0
#define S_RDATA	1
#define S_DATA	2
#define S_SDATA	3
#define	S_LIT8	4
#define S_LIT4	5
#define S_SBSS	6
#define S_BSS	7

struct sectionNames {
	char	*name;
	int	map;
} sectionMap[] = {
	_TEXT,	S_TEXT,
	_RDATA,	S_RDATA,
	_DATA,	S_DATA,
	_SDATA,	S_SDATA,
	_LIT8,	S_LIT8,
	_LIT4,	S_LIT4,
	_SBSS,	S_SBSS,
	_BSS,	S_BSS,
	0,	-1,
};

static int
mapSectionName (n)
char	*n;
{
	struct sectionNames	*sn;
	for (sn = sectionMap; sn->name; sn++)
		if (!strcmp (sn->name, n))
			break;
	return sn->map;
}

#else
#define esize(e)	(sizeof e)
#endif

int
page_size ()
{
	return PAGE_SIZE;
}

lispval
dumpme (bdata, data, image, nameList)
char	*bdata;
int	data;
char	*image, *nameList;
{
	int			fd;
	struct exec		e, n;
	extern long		lseek();
	int			nfd;
	int			c;
	char			buf[2048];
	char			*btext;
	int			text;
#ifdef mips
	char			*endtext;
	int			dataoffset;
#endif

	/*
	 * create a new a.out header
	 */
#ifdef sequent
	{ struct exec		*foo;
	foo = (struct exec *) 2048;
	e = *foo;
	}
	btext = N_ADDRADJ(e) + sizeof (e);
	text = Etext - btext;

	/*
	 * swizzle the a.out header fields a bit
	 */

	e.a_data = data;
	e.a_bss = 0;
	e.a_syms = 0;
#endif
#ifdef sun
	e = *((struct exec *) 0x2000);
	btext = (char *) N_TXTADDR(e) + sizeof (e);
	data += ((char *) N_DATADDR(e)) - bdata;
	bdata = (char *) N_DATADDR(e);
	text = e.a_text - sizeof (e);
	e.a_data = data;
	e.a_bss = 0;
#endif
#ifdef vax
	btext = (char *) 0;
	bzero ((char *) &e, (int) sizeof (e));
	text = (((int) Etext - (int) btext) + PAGE_SIZE) & ~(PAGE_SIZE-1);
	e.a_magic = ZMAGIC;
	e.a_text = text;
	e.a_data = data;
	e.a_bss = 0;
	e.a_trsize = 0;
	e.a_drsize = 0;
#endif
#ifdef mips
	btext = (char *) 0x400000;
	endtext = Etext;
	e = *(struct exec *) btext;
	{
		int	i, datasize, bsschange, datachange, filechange;
		SCNHDR	*s;

		bsschange = 0;
		for (i = 0; i < e.filehdr.f_nscns; i++) {
			s = &e.sections[i];
			switch (mapSectionName (s->s_name)) {
			case S_RDATA:
				dataoffset = s->s_scnptr;
				break;
			case S_DATA:
				datasize = data - (s->s_vaddr - (int) bdata);
				datachange = datasize - s->s_size;
				s->s_size = datasize;
				break;
			case S_SDATA:
			case S_LIT8:
			case S_LIT4:
			case S_BSS:
			case S_SBSS:
				bsschange -= s->s_size;
				s->s_size = 0;
				break;
			default:
				break;
			}
		}
		filechange = datachange + bsschange;
		/*
		 * the symbol format in mips files is
		 * too hard to put back together.
		 */
		e.filehdr.f_symptr = 0;
		e.aouthdr.bsize = 0;
		e.aouthdr.dsize = data;
		e.aouthdr.bss_start += datachange;
	}
	text = (int) endtext - (int) btext;
	btext = btext + esize (e);
	text -= esize (e);
#endif
	fd = creat (image, 0777);
	if (fd == -1) {
		perror (image);
		return nil;
	}

#ifdef N_SYMOFF
	/*
	 * try and open the file containing
	 * a namelist for the executing program,
	 * that way the dump'ed image will have
	 * a symbol table for 'link'
	 */
	nfd = open (nameList, 0);
	if (nfd != -1) {
		(void) read (nfd, (char *) &n, sizeof (n));
		e.a_syms = n.a_syms;
	}
#endif

	/*
	 * write the new a.out header
	 */
	if (write (fd, (char *) &e, esize (e)) != esize (e)) {
		perror (image);
		close (fd);
		return nil;
	}
	
#ifdef vax
	/*
	 * the vax pads the object file out,
	 * skip to the end of that padding
	 */
	(void) lseek (fd, (long) N_TXTOFF(e), 0);
#endif
	/*
	 * write the text and data.  Of course this
	 * is operating system dependent
	 */
	if (write (fd, btext, text) != text) {
		perror ("text");
		close (fd);
		return nil;
	}

#ifdef sequent
	(void) lseek (fd, N_DATAOFF(e), 0);
#endif
#ifdef mips
	(void) lseek (fd, dataoffset, 0);
#endif
	if (write (fd, bdata, data) != data) {
		perror ("data");
		close (fd);
		return nil;
	}

#ifdef N_SYMOFF
	/*
	 * copy the symbol table from the old image
	 */
	if (nfd != -1) {
		(void) lseek (nfd, (long) N_SYMOFF(n), 0);
		(void) lseek (fd, (long) N_SYMOFF(e), 0);
		while ((c = read (nfd, buf, sizeof (buf))) > 0)
			(void) write (fd, buf, c);
		(void) close (nfd);
	}
#endif
	(void) close (fd);
	return symboltoitem (true);
}

#endif /* FAKEDUMP */

#if defined (FAKEDUMP) || defined (sun)
extern	char	data_start[1];
#endif

lispval
Dump (l, count)
lispval	*l;
int	count;
{
	extern char		*sbrk();
	static char		defaultImage[] = "kalypsoimage";
	int			datachange;

	char			*bdata;
	int			data;

	char			*nameList, *image;
	lispval			nameListv;
	lispval			ret;

	image = defaultImage;
	if (count > 0) {
		image = printName (l[0]);
		if (!image)
			return error ("dump: non-string image %v", l[0]);
	}
	nameListv = kalypsoImage->value;
	if (count > 1)
		nameListv = l[1];
	if ((nameList = printName (nameListv)) == nil)
		return error ("dump: bad name list %v", nameListv);
	/*
	 * this is a global flag telling main() not to
	 * do the one-time initialization.  It ends up set
	 * in the image; it is not important that it remains
	 * set in the running program.
	 */
	Isdumpped = 1;
	/*
	 * close all open files
	 */
	cleanIO ();
#ifdef FAKEDUMP
	bdata = (char *) data_start;
#else /* FAKEDUMP */
	/*
	 * compute the size of the data space; this
	 * must be rounded up to a page-multiple so
	 * that the resultant file can be demand-paged in
	 */
#ifdef sun
	bdata = (char *) (((int) data_start) & ~(ROUND_TO - 1));
#endif
#if defined (vax) || defined (sequent)
	bdata = (char *) (((int) Etext + (ROUND_TO-1)) & ~(ROUND_TO-1));
#endif
#ifdef mips
	{ struct exec e;
		e = *(struct exec *) 0x400000;
		bdata = (char *) e.sections[1].s_vaddr;
	}
#endif
	datachange = ((int) sbrk(0)) % ROUND_TO;
	if (datachange)
		(void) sbrk (ROUND_TO - datachange);
#endif /* FAKEDUMP */
	data = sbrk(0) - bdata;

	ret = dumpme (bdata, data, image, nameList);
	restoreIO ();
	return ret;
}
	
lispval
FakeDump ()
{
#ifdef FAKEDUMP
	return symboltoitem (true);
#else
	return nil;
#endif
}

struct builtin dumpStuff[] = {
	"dump",			Dump,		LEXPR,		0,
	"fake-dump",		FakeDump,	LAMBDA,		0,
	0,			0,		0,		0,
};
