/*
 * curses.c
 *
 * optional curses package for kalypso
 */

# include	"kalypso.h"
# ifdef CURSES_PACKAGE
# include	<curses.h>

lispval
getLINES ()
{
	return numtoitem (LINES);
}

lispval
getCOLS ()
{
	return numtoitem (COLS);
}

lispval
lisp_initscr ()
{
	int	ret;

	ret = (int) initscr();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_nl ()
{
	int	ret;

	ret = nl();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_nonl ()
{
	int	ret;

	ret = nonl();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_crmode ()
{
	int	ret;

	ret = crmode();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_nocrmode ()
{
	int	ret;

	ret = nocrmode();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_echo ()
{
	int	ret;

	ret = echo();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_noecho ()
{
	int	ret;

	ret = noecho();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_addch (arg0)
lispval arg0;
{
	int	ret;
	int	a0;

	if (nump (arg0))
		a0 = itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = (int) *itemtofloatp (arg0);
	else
		return error ("addch: non-numeric %v", arg0);
	ret = addch(a0);
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_addstr (arg0)
lispval arg0;
{
	int	ret;
	char	*a0;

	if (!stringp (arg0))
		return error ("addstr: non-string %v", arg0);
	a0 = iCstring (itemtostring (arg0), (int *) 0);
	ret = addstr(a0);
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_clear ()
{
	int	ret;

	ret = clear();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_clrtobot ()
{
	int	ret;

	ret = clrtobot();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_clrtoeol ()
{
	int	ret;

	ret = clrtoeol();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_delch ()
{
	int	ret;

	ret = delch();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_deleteln ()
{
	int	ret;

	ret = deleteln();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_endwin ()
{
	endwin ();
	return symboltoitem (true);
}

lispval
lisp_erase ()
{
	int	ret;

	ret = erase();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_insch (arg0)
lispval arg0;
{
	int	ret;
	int	a0;

	if (nump (arg0))
		a0 = itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = (int) *itemtofloatp (arg0);
	else
		return error ("insch: non-numeric %v", arg0);
	ret = insch(a0);
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_insertln ()
{
	int	ret;

	ret = insertln();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_move (arg0, arg1)
lispval arg0, arg1;
{
	int	ret;
	int	a0;
	int	a1;

	if (nump (arg0))
		a0 = itemtonum (arg0);
	else if (floatpp (arg0))
		a0 = (int) *itemtofloatp (arg0);
	else
		return error ("move: non-numeric %v", arg0);
	if (nump (arg1))
		a1 = itemtonum (arg1);
	else if (floatpp (arg1))
		a1 = (int) *itemtofloatp (arg1);
	else
		return error ("move: non-numeric %v", arg1);
	ret = move(a0, a1);
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_refresh ()
{
	int	ret;

	ret = refresh();
	return ret ? symboltoitem (true) : nil;
}

lispval
lisp_inch ()
{
	int	ret;

	ret = inch();
	return numtoitem (ret);
}


lispval
lisp_getch ()
{
	int	ret;

	ret = getch();
	return numtoitem (ret);
}

struct builtin cursesStuff[] = {
	{ "getLINES", getLINES, LAMBDA, 0 },
	{ "getCOLS", getCOLS, LAMBDA, 0 },
	{ "initscr", lisp_initscr, LAMBDA, 0},
	{ "nl", lisp_nl, LAMBDA, 0},
	{ "nonl", lisp_nonl, LAMBDA, 0},
	{ "crmode", lisp_crmode, LAMBDA, 0},
	{ "nocrmode", lisp_nocrmode, LAMBDA, 0},
	{ "echo", lisp_echo, LAMBDA, 0},
	{ "noecho", lisp_noecho, LAMBDA, 0},
	{ "addch", lisp_addch, LAMBDA, 1},
	{ "addstr", lisp_addstr, LAMBDA, 1},
	{ "clear", lisp_clear, LAMBDA, 0},
	{ "clrtobot", lisp_clrtobot, LAMBDA, 0},
	{ "clrtoeol", lisp_clrtoeol, LAMBDA, 0},
	{ "delch", lisp_delch, LAMBDA, 0},
	{ "deleteln", lisp_deleteln, LAMBDA, 0},
	{ "endwin", lisp_endwin, LAMBDA, 0},
	{ "erase", lisp_erase, LAMBDA, 0},
	{ "insch", lisp_insch, LAMBDA, 1},
	{ "insertln", lisp_insertln, LAMBDA, 0},
	{ "move", lisp_move, LAMBDA, 2},
	{ "refresh", lisp_refresh, LAMBDA, 0},
	{ "inch", lisp_inch, LAMBDA, 0},
	{ "getch", lisp_getch, LAMBDA, 0},
	{ 0, 0, 0, 0 },
};
#endif
