/*
 * control.c
 *
 * basic control primitives
 */

# include "kalypso.h"

lispval
/*ARGSUSED*/
And (i, count)
lispval	*i;
int	count;
{
	register lispval	v;
	register struct dotted	*l;

	v = symboltoitem (true);
	l = itemtolist (*i);
	while (l != nil) {
		v = iEval (l->car);
		if (jumping)
			return nil;
		if (nilp (v))
			break;
		l = l->cdr;
	}
	return v;
}

lispval
/*ARGSUSED*/
Cond (s, count)
register lispval	*s;
int			count;
{
	register lispval	e;
	register struct dotted	*m;
	register lispval	ret;
	register struct dotted	*l;
	register int		i;

	l = itemtolist (*s);
	ret = nil;
	while (l) {
		e = l->car;
		if (!listp (e))
			return error ("cond: badly formed clause %v", e);
		m = itemtolist (e);
#define EvalTypeVariable i
#define EvalTempVariable ret
		ret = iEval (m->car);
#undef EvalTypeVariable
#undef EvalTempVariable
		if (jumping)
			return nil;
		if (!nilp (ret)) {
			m = m->cdr;
			while (m) {
#define EvalTypeVariable i
#define EvalTempVariable ret
				ret = iEval (m->car);
#undef EvalTypeVariable
#undef EvalTempVariable
				if (jumping)
					return nil;
				m = m->cdr;
			}
			break;
		}
		l = l->cdr;
	}
	return ret;
}

lispval
/*ARGSUSED*/
Or (i, count)
lispval	*i;
int	count;
{
	register lispval	v;
	register struct dotted	*l;

	v = symboltoitem (true);
	l = itemtolist (*i);
	while (l != nil) {
		v = iEval (l->car);
		if (jumping)
			return nil;
		if (!nilp (v))
			break;
		l = l->cdr;
	}
	return v;
}

struct builtin controlStuff[] = {
	{ "and",	And,	NLAMBDA,	0, },
	{ "cond",	Cond,	NLAMBDA,	0, },
	{ "or",		Or,	NLAMBDA,	0, },
	{ 0,		0,	0,		0, },
};
