/*
 * catch.c
 *
 * catch/throw
 */

# include "kalypso.h"

lispval	throwTag;

lispval
/*ARGSUSED*/
Catch (s, count)
lispval		*s;
int		count;
{
	struct dotted	*l;
	lispval	waitfor;
	lispval	ret;

	l = itemtolist (*s);
	if (nilp (l) || nilp (l->cdr))
		waitfor = nil;
	else {
		waitfor = iEval (l->car);
		if (jumping)
			return nil;
		l = l->cdr;
	}
	ret = nil;
	while (l) {
		ret = iEval (l->car);
		if (jumping) {
			if (jumping == ThrowJumping && waitfor == throwTag) {
				ret = jumpValue;
				jumping = 0;
				throwTag = nil;
				break;
			} else {
				ret = nil;
				break;
			}
		}
		l = l->cdr;
	}
	return ret;
}

lispval
Throw (l, count)
lispval	*l;
int	count;
{
	if (count > 0)
		throwTag = *l;
	else
		throwTag = nil;
	if (count > 1)
		jumpValue = l[1];
	else
		jumpValue = throwTag;
	jumping = ThrowJumping;
	return nil;
}

struct builtin catchStuff[] = {
	{ "catch",	Catch,	NLAMBDA,	0, },
	{ "throw",	Throw,	LEXPR,		0, },
	{ 0,		0,	0,		0, },
};
