/*
 * block.c
 *
 * while/begin/unwind-protect.  Sequential execution primitives.
 */

# include	"kalypso.h"

static int		depth, wdepth;

/*
 * terminate the nearest enclosing begin or while
 */

lispval
Return (l, count)
register lispval	*l;
{
	if (depth == 0)
		return error ("return: used outside begin/while");
	jumping = ReturnJumping;
	jumpValue = nil;
	if (count > 0)
		jumpValue = *l;
	return jumpValue;
}

lispval
Continue ()
{
	if (wdepth == 0)
		return error ("continue: used outside while");
	jumping = ContinueJumping;
	jumpValue = nil;
	return jumpValue;
}

/*
 * simple sequential execution.  A return forces termination of
 * the construct.
 */

lispval
/*ARGSUSED*/
Begin (a, count)
lispval *a;
{
	lispval	ret;
	struct dotted	*s;
	
	ret = nil;
	++depth;
	for (s = itemtolist (*a); s; s = s->cdr) {
		ret = iEval (s->car);
		if (jumping)
			if (jumping == ReturnJumping) {
				jumping = 0;
				ret = jumpValue;
				break;
			} else {
				ret = nil;
				break;
			}
	}
	--depth;
	return ret;
}

lispval
/*ARGSUSED*/
While (a, count)
lispval	*a;
{
	lispval	e;
	struct dotted	*s;
	lispval	ret;
	struct dotted	*l;

	l = itemtolist (*a);
	ret = nil;
	++depth;
	++wdepth;
	if (!nilp (l)) {
		e = l->car;
		l = l->cdr;
		while (!nilp (ret = iEval (e))) {
			if (jumping)
				if (jumping == ReturnJumping) {
					jumping = 0;
					ret = jumpValue;
					break;
				} else if (jumping == ContinueJumping) {
					jumping = 0;
					continue;
				} else {
					ret = nil;
					break;
				}
			for (s = l; s; s = s->cdr) {
				ret = iEval (s->car);
				if (jumping) {
					if (jumping == ReturnJumping) {
						jumping = 0;
						ret = jumpValue;
						goto wbreak;
					} else if (jumping == ContinueJumping) {
						jumping = 0;
						break;
					} else {
						ret = nil;
						goto wbreak;
					}
				}
			}
		}
	wbreak:
		;
	}
	--depth;
	--wdepth;
	return ret;
}

/*
 * this form *always* takes two s-exprs and *always* executes
 * the second s-expr, event if the first terminates with a non-local
 * goto.
 */

lispval
/*ARGSUSED*/
UnwindProtect (a, count)
lispval	*a;
int	count;
{
	lispval		sexpr, protect;
	struct dotted	*l;
	lispval		ret;
	lispval		oldjumpValue;
	lispval		oldthrowTag;
	int		oldjumping;
	int		mark;

	if (nilp (l = itemtolist (*a)) || nilp (l->cdr))
		return error ("unwind-protect: bad form %v", *a);
	sexpr = l->car;
	protect = l->cdr->car;
	ret = iEval (sexpr);
	mark = frameMark ();
	oldjumpValue = jumpValue;
	oldthrowTag = throwTag;
	framePush (oldjumpValue);
	framePush (oldthrowTag);
	oldjumping = jumping;
	++depth;
	jumping = 0;
	(void) iEval (protect);
	--depth;
	frameReset (mark);
	if (jumping == ReturnJumping) {
		jumping = 0;
		ret = jumpValue;
	} else {
		jumping = oldjumping;
		jumpValue = oldjumpValue;
		throwTag = oldthrowTag;
	}
	return ret;
}

struct builtin progStuff[] = {
	"return",		Return,		LEXPR,		0,
	"continue",		Continue,	LAMBDA,		0,
	"begin",		Begin,		NLAMBDA,	0,
	"while",		While,		NLAMBDA,	0,
	"unwind-protect",	UnwindProtect,	NLAMBDA,	0,
	0,			0,		0,		0,
};
