/*
 * async.c
 *
 * manage a queue of events to process "sometime" soon
 */

# include	"kalypso.h"
# include	<signal.h>
#ifndef NSIG
# define NSIG 32
#endif

# define ASYNC_QUEUE	200

int		asyncPending;
int		canDoAsyncNow;

struct asyncEvent {
	void	(*function)();
	int	arg;
} asyncQueue[ASYNC_QUEUE];

int	queueInsert;
int	queueDelete;

async ()
{
	int	arg, i;
	int	oldcan;
	void	(*fp)();
	
	oldcan = canDoAsyncNow;
	canDoAsyncNow = 0;
	while (queueDelete != queueInsert) {
		/*
		 * assumption - async will not be called
		 * from here...
		 */
		i = queueDelete;
		fp = asyncQueue[i].function;
		arg = asyncQueue[i].arg;
		++i;
		if (i == ASYNC_QUEUE)
			i = 0;
		queueDelete = i;
		--asyncPending;
		/*
 		 * ... to here 
		 */
		fp (arg);
	}
	canDoAsyncNow = oldcan;
}

/*
 * do not call this routine in tight loops - it is a cpu pig
 */

int
saveAsync (function, arg)
void	(*function)();
int	arg;
{
	int	i;
	int	oldmask;
	int	ret;

#ifndef SYSV
	oldmask = sigsetmask ((1 << NSIG) - 1);
#endif
	i = queueInsert;
	i++;
	if (i == ASYNC_QUEUE)
		i = 0;
	if (i == queueDelete)
		ret = 0;
	else {
		asyncQueue[queueInsert].function = function;
		asyncQueue[queueInsert].arg = arg;
		queueInsert = i;
		asyncPending++;
		ret = 1;
	}
	if (canDoAsyncNow) {
#ifndef SYSV
		(void) sigsetmask (0);
#endif
		checkAsync ();
	}
#ifndef SYSV
	(void) sigsetmask (oldmask);
#endif
	return ret;
}
