;; Eulisp Module
;; Author: pab
;; File: newgeneric.em
;; Date: Mon Jul 20 17:29:30 1992
;;
;; Project:
;; Description: 
;;   Fakes generic functions

(defmodule newgeneric
  (standard0
   list-fns
         
   )
  ()
  
  (defstruct generic ()
    ((method-table initform () accessor generic-method-table)
     (discriminator initform () accessor generic-discriminator)
     (argtype initarg argtype accessor generic-argtype))
    constructor make-generic)

  (defstruct std-generic generic
    ()
    )

  (defmethod generic-apply ((gf generic) args)
    ((generic-discriminator gf) args))

  (defmethod initialize-instance ((gf generic) lst)
    (let ((new (call-next-method)))
      ((setter generic-discriminator) gf 
       (compute-generic-discriminator gf lst))
      gf))

  (defgeneric compute-generic-discriminator (gf initlst))

  ;; conceptually...We could do with some (read lots) of caching.
  (defmethod compute-generic-discriminator ((gf generic) lst)
    (lambda (args) 
      (call-methods-by-list (find-applicable-methods gf args))))

  (defgeneric find-applicable-methods (gf args))
  
  (defmethod find-applicable-methods (gf args)
    (find-applic-methods-aux (generic-method-table gf)
			     (mapcar (lambda (x) (class-precedence-list (class-of x)))
				     args)))

  (defun find-applic-methods-aux (table cpl-lst)
    (if (null cpl-lst)
	nil
      (if (null (car cpl-lst))
	  nil
	(let ((xx (assq (car (car cpl-lst)) table)))
	  (if (null xx)
	      (find-applic-methods-aux table
				       (cons (cdr (car cpl-lst))
					     (cdr cpl-lst)))
	    (if (null (cdr cpl-lst))
		;; found summat
		(if (methodp (car (cdr xx)))
		    (cons (car (cdr xx))
			  (find-applic-methods-aux table
						   (cons (cdr (car cpl-lst))
							 (cdr cpl-lst))))
		  (progn (error "Not a method in method-table" Internal-Error 'error-value xx)
			 nil))
	      (append (find-applic-methods-aux (cdr xx) (cdr cpl-lst))
		      (find-applic-methods-aux table
					       (cons (cdr (car cpl-lst))
						     (cdr cpl-lst))))))))))
  
  (defmethod add-method ((gf generic) (x method))
    (let ((sig (method-signature meth))
	  (table (generic-method-table gf)))
      (if (null table)
	  (generic-method-table-setter gf (mk-initial-table sig (list meth)))
	(add-meth-aux table sig (list meth)))
      gf))

  (defun mk-initial-table (initkey initentry)
    (fold (lambda (class tab)
	    (cons (cons class tab) nil))
	  (reverse initkey)
	  initentry))

  ;; starting this lot up...
  
  (defun add-meth-aux (table sig meth)
    (let ((xx (assq (car sig) table)))
      (if (null table)
	  ;; should never happen (should be a callback)
	  (error "can't happen" Internal-Error)
	(if (null xx)
	    (progn (nconc table
			  (fold (lambda (class tab)
				  (cons (cons class tab) nil))
				(reverse sig)
				meth))
		   table)
	  (if (null (cdr sig))
	      ;; must have a relacement method
	      ((setter cdr) xx meth)
	    (add-meth-aux (cdr xx) (cdr sig) meth))))))

  ;; end module
  )
