;; Eulisp Module
;; Author: pab
;; File: bitvectors.em
;; Date: Tue Jun 29 22:57:10 1993
;;
;; Project:
;; Description: 
;;

(defmodule bitvectors
  (telos1
   macros0
   defs
   init
   
   )
  ()
  
  (defclass <bit-vector> (<sequence>)
    ((self accessor bits))
    direct-initargs (size fill)
    )

  (defmethod initialize ((x <bit-vector>) args)
    (let ((new (call-next-method))
	  (size (scan-args 'size args required-argument)))
      ((setter bits) new (primitive-make-bit-vector size))
      (when (= fill 1)
	(fill new 0 (- size 1)))
      new))
  
  (defmethod element ((bv <bit-vector>) s)
    (primitive-bit-vector-ref (bits bv) s))

  (defmethod (setter element) ((bv <bit-vector>) s v)
    ((setter primitive-bit-vector-ref) (bits bv) s v))
  
  (defmethod size ((bv <bit-vector>))
    (bit-vector-length (bits bv)))

  (defmethod current-key ((c <bit-vector>) (s <fixint>)) s)
  
  (defmethod clone ((x <bit-vector>))
    (make <bit-vector> 'size x))

  ;; end module
  )
