;; Eulisp Module
;; Author: pete broadbery
;; File: syntax-env.em
;; Date: 31/aug/1991
;;
;; Project:
;; Description: 
;;   "optimised" syntatic env reference
;;

(defmodule syntx-env 
  (standard0
   list-fns
   abs-syntx
   comp-utl
   mod-cache

   )
  ()
  
  (expose mod-cache)
  (expose abs-syntx)

  (defun env-ref (env x)
    (let/cc out
	    (mapc (lambda (e) (if (eq (car e) x) (out (cdar e)) ()))
		  env)))
		  
  (defstruct module-imports ()
    ((imports initarg imports 
	      reader module-imports-imports)
     (macros initarg macros
	     accessor module-import-macros)
     (text initarg text 
	   reader module-import-desc))
    constructor (make-module-imports text imports macros))
  
  (defun module-imports-list (mi)
    (mapcar cdr (module-imports-imports mi)))

  (export module-imports-list module-import-desc)

  ;; Define a new syntax object with convienient properties

  (defstruct imported-definition abs-definition
    ((import-properties initarg import-info
			accessor import-proplist)
     (home initarg home
	   reader import-home-mod))
    ;; ide for name in abs-syntx.
    constructor (make-imported-definition ide import-info home)
    predicate imported-defn-p
    )

  (export imported-definition import-proplist imported-defn-p)

  ;; copied in comp-defn
  (defconstant *local-module-name* '%%-me-local--%%)

  (defgeneric external-name (x)
    methods ((((import imported-definition))
	      (cons (import-home import)
		    (import-real-name import)))
	     (((x local-definition))
	      (cons *local-module-name* (defn-ide x)))))

  (export external-name)

  (defun import-prop-ref (x name)
    (let ((xx (assq name (import-proplist x))))
      (if (null xx) nil
	(cdr xx))))

  (defun import-home (x)
    (car (import-prop-ref x 'address)))

  (defun import-real-name (x) 
    (import-prop-ref x 'name))
  
  (defun import-object-type (x) 
    (let ((xx (import-prop-ref x 'class)))
      (if (null xx)
	  'internal
	xx)))

  (defun import-defn-setter (x)
    (let ((setter (import-prop-ref x 'setter)))
      (if setter
	  (make-imported-definition 
	   'some-setter setter (import-home-mod x))
	nil)))

  (defun import-function-nargs (x)
    (let ((xx (import-prop-ref x 'argtype)))
      (cond ((consp xx) (car xx))
	    ;; xxx should be something strange...
	    ((null xx) (cons nil 0))
	    (t (cons (< xx 0)
		     (if (< xx 0) (- xx) xx))))))
  
  
  (defun import-module-prop-ref (x name)
    (assq (imported-module-props (import-home x)) name))

  (export import-prop-ref import-home import-real-name 
	  import-object-type import-function-nargs
	  import-defn-setter)

  ;; 
  (defun is-macro (obj)
    (eq (import-prop-ref obj 'class) 'macro))

  (defun expander (obj)
    (get-expander (import-home obj)
		  (import-real-name obj)))
  
  (defun compile-macro-expand (expander forms)
    ((setter compile-time-p) t)
    (prog1 (apply expander forms)
      ((setter compile-time-p) nil)))

  (export compile-macro-expand)

  (defun find-macro (env name)
    (assq name (module-import-macros env)))

  (defun simple-find-name (env name)
    (assq name (module-imports-imports env)))

  (deflocal lastenv (cons nil nil))

  (defun find-name (env name)
    (cond ((eq (car lastenv) env)
	   (or (table-ref (cdr lastenv) name)
	       (let ((xx (simple-find-name env name)))
		 ((setter table-ref) (cdr lastenv) name xx)
		 xx)))
	  (t (setq lastenv (cons env (make-table eq)))
	     (find-name env name))))

  (export find-name find-macro expander)
  
  ;; returns a module-imports structure

  (defconstant mod-imports-cache (mk-finder))

  (defun read-imports (ispec)
    (or (mod-imports-cache ispec)
	(let* ((imports (generic-read-imports ispec))
	       (macros (collect (lambda (x) (is-macro (cdr x)))
				imports))
	       (mi (make-module-imports (import-text ispec) imports macros)))
	  ((setter mod-imports-cache) ispec mi)
	  (format t "Read imports: ~a ~%~a~%" ispec mi)
	  mi)))
	       
  ;; returns a list of import objects
  (defgeneric generic-read-imports (import-specifier))
  
  (defmethod generic-read-imports ((import import-directive))
    (format t "Env: generic-read-imports: ~a~%" (import-directive-name import))
    (mapcar construct-import-defn (read-exportations (import-directive-name import))))

  ;; import is (name props module)

  (defun construct-import-defn (import)
    (cons (car import)
	  (make-imported-definition (car import)
				    (cadr import)
				    (caddr import))))
  ;; this *should* check for name-clashes....

  (defmethod generic-read-imports ((union union-directive))
    (fold append 
	  (mapcar generic-read-imports (union-content union))
	  ()))

  (defmethod generic-read-imports ((only only-directive))
    (collect (lambda (x) 
	       (format t "Only: ~a ~a~%" x  (only-name-list only))
	       (let ((xx (memq (car x) (only-name-list only))))
		 (if xx x nil)))
	     (generic-read-imports (only-imports only))))
  
  (defmethod generic-read-imports ((rename rename-directive))
    (mapcar (lambda (import)
	      (let ((new (assq (car import)
			       (rename-name-list rename))))
		(if new (format t "Rename: ~a->~a~%" (car import) new) nil)
		(if new (cons (cadr new) (cdr import))
		  import)))
	    (generic-read-imports (rename-imports rename))))

  (defmethod generic-read-imports ((except except-directive))
    (collect (lambda (x) (not (memq (car x) (except-name-list except))))
	     (generic-read-imports (except-imports except))))
  

  (export read-imports)

  ;; Name lists

  (defun module-exported-names (lst)
    (mapcar external-name lst))

  (defun module-imported-names (obj)
    (mapcar (lambda (x) (external-name (cdr x)))
	    (module-imports-imports obj)))
  
  (defgeneric import-text (ispec)
    methods ((((x import-directive))
	      (list 'import (import-directive-name x)))
	     (((x union-directive))
	      (cons 'union 
		    (mapcar import-text
			    (union-content x))))
	     (((x only-directive))
	      (list 'only (only-name-list x)
		    (import-text (only-imports x))))
	     (((x rename-directive))
	      (list 'rename (rename-name-list x)
		    (import-text (rename-imports x))))
	     (((x except-directive))
	      (list 'except (except-name-list x) 
		    (import-text (except-imports x))))
	     (((x object))
	      (error "Import-text: strange-directive" clock-tick 
		       'error-value x))))
  (export module-exported-names module-imported-names )
  ;; end module
)
