;;; -*- Mode: LISP; Syntax: Common-Lisp -*-

;;; This example is adapted from a similar one in Luger & Stubblefield
;;; 1989, "AI and the design of expert systems", Chapter 14.

(USE-PACKAGE 'BOOPS)

;;; prototypical objects

(DEFOBJECT THERMOSTAT OBJECT
  (SETTING 65))

(DEFOBJECT ROOM OBJECT
  (TEMPERATURE 65))

(DEFOBJECT HEATER OBJECT
  (STATE 'OFF))

;;; our example
;;; the room has a thermostat; the thermostat knows its location
;;; and the heater it controls; the heater knows the room it heats.

(DEFOBJECT ROOM-327 ROOM
  (THERMOSTAT 'THERMOSTAT-327))

(DEFOBJECT THERMOSTAT-327 THERMOSTAT
  (HEATER 'HEATER-327)
  (LOCATION 'ROOM-327))

(DEFOBJECT HEATER-327 HEATER
  (LOCATION 'ROOM-327))

;;; aspects

(DEFASPECT ROOM CHANGE-TEMP
  :FUNCTION (SELF AMOUNT-OF-CHANGE)
  (LET ((NEW-TEMP (+ AMOUNT-OF-CHANGE
		     (MESSAGE SELF 'TEMPERATURE))))
    (MESSAGE SELF 'SET-VALUE 'TEMPERATURE NEW-TEMP)
    (TERPRI)
    (PRINC "Temperature in ") (PRINC SELF)
    (PRINC " changes to ") (PRINC NEW-TEMP)
    (PRINC " degrees.")
    (MESSAGE (MESSAGE SELF 'THERMOSTAT)
	     'CHECK-TEMP)))

(DEFASPECT THERMOSTAT CHECK-TEMP
  :FUNCTION (SELF)
  (COND ((< (MESSAGE (MESSAGE SELF 'LOCATION)
		     'TEMPERATURE)
	    (MESSAGE SELF 'SETTING))
	 (MESSAGE (MESSAGE SELF 'HEATER)
		  'TURN-ON))
	(T (MESSAGE (MESSAGE SELF 'HEATER)
		  'TURN-OFF))))

(DEFASPECT THERMOSTAT CHANGE-SETTING
  :FUNCTION (SELF TEMP)
  (MESSAGE SELF 'SET-VALUE 'SETTING TEMP)
  (TERPRI)
  (PRINC "New setting of ") (PRINC SELF)
  (PRINC " is ") (PRINC TEMP)
  (PRINC " degrees.")
  (MESSAGE SELF 'CHECK-TEMP))

(DEFASPECT HEATER TURN-ON
  :FUNCTION (SELF)
  (COND ((EQUAL (MESSAGE SELF 'STATE) 'OFF)
	 (TERPRI)
	 (PRINC "Heater turns on in ")
	 (PRINC (MESSAGE SELF 'LOCATION))
	 (MESSAGE SELF 'SET-VALUE 'STATE 'ON)))
  (MESSAGE (MESSAGE SELF 'LOCATION)
	   'CHANGE-TEMP 1))

(DEFASPECT HEATER TURN-OFF
  :FUNCTION (SELF)
  (COND ((EQUAL (MESSAGE SELF 'STATE) 'ON)
	 (TERPRI)
	 (PRINC "Heater turns off in ")
	 (PRINC (MESSAGE SELF 'LOCATION))
	 (MESSAGE SELF 'SET-VALUE 'STATE 'OFF))))

;;; test: (message 'room-327 'change-temp -5)
;;; test: (message 'thermostat-327 'change-setting 70)
