;;;-*-Mode:LISP; Package:PCL; Base:10; Syntax:Common-lisp -*-

(in-package :pcl)

;;; 1 arguments 
(defgeneric accessor-method-slot-definition (method))
(defgeneric accessor-method-slot-name (standard-accessor-method))
(defgeneric |BUILT-IN-CLASS class predicate| (object))
(defgeneric class-cached-in-generic-functions (pcl-class))
(defgeneric class-can-precede-list (pcl-class))
(defgeneric class-constructors (class))
(defgeneric class-default-initargs (class))
(defgeneric class-defstruct-conc-name (structure-class))
(defgeneric class-defstruct-constructor (structure-class))
(defgeneric class-direct-default-initargs (class))
(defgeneric class-direct-slots (class))
(defgeneric class-direct-subclasses (class))
(defgeneric class-direct-superclasses (class))
(defgeneric class-eq-specializer (pcl-class))
(defgeneric class-eq-specializer-p (object))
(defgeneric class-finalized-p (class))
(defgeneric class-from-defclass-p (structure-class))
(defgeneric class-incompatible-superclass-list (pcl-class))
(defgeneric class-internal-slotds (pcl-class))
(defgeneric class-name (class))
(defgeneric class-precedence-list (class))
(defgeneric class-predicate-name (pcl-class))
(defgeneric class-prototype (class))
(defgeneric class-side-effect-internal-slotds (slot-class))
(defgeneric class-slot-cells (class))
(defgeneric class-slots (class))
(defgeneric class-wrapper (pcl-class))
(defgeneric classp (object))
(defgeneric compute-class-precedence-list (root))
(defgeneric compute-default-initargs (class))
(defgeneric compute-discriminating-function (gf))
(defgeneric compute-discriminating-function-arglist-info (generic-function))
(defgeneric compute-slots (class))
(defgeneric constructor-class (constructor))
(defgeneric constructor-code-generators (constructor))
(defgeneric constructor-code-type (constructor))
(defgeneric constructor-name (constructor))
(defgeneric constructor-supplied-initarg-names (constructor))
(defgeneric definition-source (definition-source-mixin))
(defgeneric |DEFINITION-SOURCE-MIXIN class predicate| (object))
(defgeneric dependent (updater))
(defgeneric |DEPENDENT-UPDATE-MIXIN class predicate| (object))
(defgeneric |DIRECT-SLOT-DEFINITION class predicate| (object))
(defgeneric |DOCUMENTATION-MIXIN class predicate| (object))
(defgeneric |EFFECTIVE-SLOT-DEFINITION class predicate| (object))
(defgeneric eql-specializer-object (eql-specializer))
(defgeneric eql-specializer-p (object))
(defgeneric exact-class-specializer-p (object))
(defgeneric finalize-inheritance (class))
(defgeneric forward-referenced-class-p (object))
(defgeneric funcallable-standard-class-p (object))
(defgeneric function-keywords (method))
(defgeneric generic-function-argument-precedence-order (standard-generic-function))
(defgeneric generic-function-declarations (standard-generic-function))
(defgeneric generic-function-lambda-list (standard-generic-function))
(defgeneric generic-function-method-class (standard-generic-function))
(defgeneric generic-function-method-combination (standard-generic-function))
(defgeneric generic-function-methods (standard-generic-function))
(defgeneric generic-function-name (standard-generic-function))
(defgeneric generic-function-p (object))
(defgeneric generic-function-pretty-arglist (generic-function))
(defgeneric gf-arg-info (standard-generic-function))
(defgeneric gf-dfun-state (standard-generic-function))
(defgeneric gf-pretty-arglist (standard-generic-function))
(defgeneric gf-valid-p (standard-generic-function))
(defgeneric initialize-allocate-static-slot-storage-copy (class))
(defgeneric initialize-internal-slot-functions (slotd))
(defgeneric install-lazy-constructor-installer (constructor))
(defgeneric long-method-combination-function (long-method-combination))
(defgeneric make-class-prototype (class))
(defgeneric make-instances-obsolete (class))
(defgeneric |METAOBJECT class predicate| (object))
(defgeneric method-cached-functions (method))
(defgeneric method-cached-functions-alist (standard-method))
(defgeneric method-closure-generator (standard-method))
(defgeneric method-combination-options (standard-method-combination))
(defgeneric method-combination-p (object))
(defgeneric method-combination-type (standard-method-combination))
(defgeneric method-constant-value (method))
(defgeneric method-function (standard-method))
(defgeneric method-function-for-caching-p (method))
(defgeneric method-function-name (standard-method))
(defgeneric method-generic-function (standard-method))
(defgeneric method-identifier (standard-method))
(defgeneric method-lambda-list (standard-method))
(defgeneric method-needs-next-methods-p (standard-method))
(defgeneric method-optimized-function (standard-method))
(defgeneric method-optimized-method-lambda (standard-method))
(defgeneric method-optimized-slot-indices (standard-method))
(defgeneric method-p (object))
(defgeneric method-pretty-arglist (method))
(defgeneric method-qualifiers (method))
(defgeneric method-specializers (standard-method))
(defgeneric object-plist (plist-mixin))
(defgeneric |PCL-CLASS class predicate| (object))
(defgeneric |PLIST-MIXIN class predicate| (object))
(defgeneric raw-instance-allocator (class))
(defgeneric short-combination-identity-with-one-argument (short-method-combination))
(defgeneric short-combination-operator (short-method-combination))
(defgeneric short-method-combination-p (object))
(defgeneric |SLOT-CLASS class predicate| (object))
(defgeneric |SLOT-DEFINITION class predicate| (object))
(defgeneric slot-definition-allocation (standard-slot-definition))
(defgeneric slot-definition-boundp-function (effective-slot-definition))
(defgeneric slot-definition-class (slot-definition))
(defgeneric slot-definition-defstruct-accessor-symbol (structure-slot-definition))
(defgeneric slot-definition-initargs (slot-definition))
(defgeneric slot-definition-initform (slot-definition))
(defgeneric slot-definition-initfunction (slot-definition))
(defgeneric slot-definition-initfunction-side-effect-free-p (slot-definition))
(defgeneric slot-definition-internal-reader-function (structure-slot-definition))
(defgeneric slot-definition-internal-slotd (effective-slot-definition))
(defgeneric slot-definition-internal-writer-function (structure-slot-definition))
(defgeneric slot-definition-location (effective-slot-definition))
(defgeneric slot-definition-name (slot-definition))
(defgeneric slot-definition-reader-function (effective-slot-definition))
(defgeneric slot-definition-readers (slot-definition))
(defgeneric slot-definition-type (slot-definition))
(defgeneric slot-definition-writer-function (effective-slot-definition))
(defgeneric slot-definition-writers (slot-definition))
(defgeneric |SLOT-OBJECT class predicate| (object))
(defgeneric slots-fetcher (class))
(defgeneric specializer-class (specializer))
(defgeneric specializer-direct-generic-functions (specializer))
(defgeneric specializer-direct-methods (specializer))
(defgeneric specializer-method-table (specializer))
(defgeneric specializer-object (class-eq-specializer))
(defgeneric specializer-type (specializer))
(defgeneric |SPECIALIZER-WITH-OBJECT class predicate| (object))
(defgeneric specializerp (object))
(defgeneric standard-accessor-method-p (object))
(defgeneric standard-boundp-method-p (object))
(defgeneric standard-class-p (object))
(defgeneric |STANDARD-DIRECT-SLOT-DEFINITION class predicate| (object))
(defgeneric |STANDARD-EFFECTIVE-SLOT-DEFINITION class predicate| (object))
(defgeneric standard-generic-function-p (object))
(defgeneric standard-method-p (object))
(defgeneric |STANDARD-OBJECT class predicate| (object))
(defgeneric standard-reader-method-p (object))
(defgeneric |STANDARD-SLOT-DEFINITION class predicate| (object))
(defgeneric standard-writer-method-p (object))
(defgeneric |STD-CLASS class predicate| (object))
(defgeneric structure-class-p (object))
(defgeneric |STRUCTURE-DIRECT-SLOT-DEFINITION class predicate| (object))
(defgeneric |STRUCTURE-EFFECTIVE-SLOT-DEFINITION class predicate| (object))
(defgeneric |STRUCTURE-OBJECT class predicate| (object))
(defgeneric |STRUCTURE-SLOT-DEFINITION class predicate| (object))
(defgeneric update-constructors (class))
(defgeneric wrapper-fetcher (class))

;;; 2 arguments 
(defgeneric add-constructor (class constructor))
(defgeneric add-dependent (metaobject dependent))
(defgeneric add-direct-method (specializer method))
(defgeneric add-direct-subclass (class subclass))
(defgeneric add-method (generic-function method))
(defgeneric cached-slot-locations-and-fetchers-from-wrappers (method wrappers))
(defgeneric change-class (instance new-class-name))
(defgeneric (setf class-incompatible-superclass-list) (new-value pcl-class))
(defgeneric (setf class-name) (new-value class))
(defgeneric class-slot-value (class slot-name))
(defgeneric compatible-meta-class-change-p (class proto-new-class))
(defgeneric compute-applicable-methods (generic-function arguments))
(defgeneric compute-applicable-methods-using-classes (generic-function classes))
(defgeneric compute-class-slots (class eslotds))
(defgeneric compute-constructor-code (class constructor))
(defgeneric compute-effective-slot-definition-initargs (class direct-slotds))
(defgeneric compute-instance-layout (class instance-eslotds))
(defgeneric compute-storage-info (class eslotds))
(defgeneric (setf constructor-code-type) (new-value constructor))
(defgeneric describe-object (class stream))
(defgeneric direct-slot-definition-class (class initargs))
(defgeneric effective-slot-definition-class (class initargs))
(defgeneric (setf generic-function-method-class) (new-value standard-generic-function))
(defgeneric (setf generic-function-method-combination) (new-value standard-generic-function))
(defgeneric (setf generic-function-methods) (new-value standard-generic-function))
(defgeneric (setf generic-function-name) (new-value standard-generic-function))
(defgeneric (setf gf-dfun-state) (new-value standard-generic-function))
(defgeneric (setf gf-pretty-arglist) (new-value standard-generic-function))
(defgeneric (setf gf-valid-p) (new-value standard-generic-function))
(defgeneric inform-type-system-about-class (class name))
(defgeneric legal-declarations-p (object x))
(defgeneric legal-documentation-p (object x))
(defgeneric legal-lambda-list-p (object x))
(defgeneric legal-method-function-p (object x))
(defgeneric legal-qualifier-p (object x))
(defgeneric legal-qualifiers-p (object x))
(defgeneric legal-slot-name-p (object x))
(defgeneric legal-specializer-p (object x))
(defgeneric legal-specializers-p (object x))
(defgeneric make-cached-method-function-from-stored-lambda (method slot-locations-and-fetchers))
(defgeneric make-cached-method-lambda-from-stored-lambda (method slot-locations-and-fetchers))
(defgeneric map-dependents (metaobject function))
(defgeneric maybe-update-constructors (generic-function method))
(defgeneric (setf method-cached-functions-alist) (new-value standard-method))
(defgeneric method-function-for-caching (method wrappers))
(defgeneric (setf method-function-name) (new-value standard-method))
(defgeneric (setf method-generic-function) (new-value standard-method))
(defgeneric (setf method-optimized-function) (new-value standard-method))
(defgeneric (setf object-plist) (new-value plist-mixin))
(defgeneric print-object (constructor stream))
(defgeneric remove-boundp-method (class generic-function))
(defgeneric remove-constructor (class constructor))
(defgeneric remove-dependent (metaobject dependent))
(defgeneric remove-direct-method (specializer method))
(defgeneric remove-direct-subclass (class subclass))
(defgeneric remove-method (generic-function method))
(defgeneric remove-reader-method (class generic-function))
(defgeneric remove-writer-method (class generic-function))
(defgeneric same-specializer-p (specl1 specl2))
(defgeneric slot-accessor-function (slotd type))
(defgeneric slot-accessor-std-p (slotd type))
(defgeneric (setf slot-definition-allocation) (new-value standard-slot-definition))
(defgeneric (setf slot-definition-boundp-function) (new-value effective-slot-definition))
(defgeneric (setf slot-definition-class) (new-value slot-definition))
(defgeneric (setf slot-definition-defstruct-accessor-symbol) (new-value structure-slot-definition))
(defgeneric (setf slot-definition-initargs) (new-value slot-definition))
(defgeneric (setf slot-definition-initform) (new-value slot-definition))
(defgeneric (setf slot-definition-initfunction) (new-value slot-definition))
(defgeneric (setf slot-definition-initfunction-side-effect-free-p) (new-value slot-definition))
(defgeneric (setf slot-definition-internal-reader-function) (new-value structure-slot-definition))
(defgeneric (setf slot-definition-internal-slotd) (new-value effective-slot-definition))
(defgeneric (setf slot-definition-internal-writer-function) (new-value structure-slot-definition))
(defgeneric (setf slot-definition-location) (new-value effective-slot-definition))
(defgeneric (setf slot-definition-name) (new-value slot-definition))
(defgeneric (setf slot-definition-reader-function) (new-value effective-slot-definition))
(defgeneric (setf slot-definition-readers) (new-value slot-definition))
(defgeneric (setf slot-definition-type) (new-value slot-definition))
(defgeneric (setf slot-definition-writer-function) (new-value effective-slot-definition))
(defgeneric (setf slot-definition-writers) (new-value slot-definition))
(defgeneric slots-to-inspect (class object))
(defgeneric update-gf-dfun (class gf))
(defgeneric validate-superclass (fsc class))

;;; 3 arguments 
(defgeneric (setf class-slot-value) (nv class slot-name))
(defgeneric compute-effective-method (generic-function combin applicable-methods))
(defgeneric compute-effective-slot-definition (class name dslotds))
(defgeneric compute-layout (class cpl instance-eslotds))
(defgeneric default-initargs (class supplied-initargs all-default))
(defgeneric find-method-combination (generic-function type options))
(defgeneric (setf slot-accessor-std-p) (value slotd type))
(defgeneric slot-boundp-using-class (class object slotd))
(defgeneric slot-exists-p-using-class (class object slotd))
(defgeneric slot-makunbound-using-class (class object slotd))
(defgeneric slot-unbound (class class-instance slot-name))
(defgeneric slot-value-using-class (class object slotd))
(defgeneric store-closure-generator-p (generic-function method initargs))
(defgeneric store-method-function-p (generic-function method initargs))
(defgeneric store-method-optimized-function-p (generic-function method initargs))
(defgeneric store-optimized-method-lambda-p (generic-function method initargs))

;;; 4 arguments 
(defgeneric load-constructor-internal (class name initargs generators))
(defgeneric make-closure-generator-form (generic-function method optimized-method-lambda initargs))
(defgeneric make-documented-boundp-method-function (class generic-function boundp-method-prototype slot-name))
(defgeneric make-documented-reader-method-function (class generic-function reader-method-prototype slot-name))
(defgeneric make-documented-writer-method-function (class generic-function writer-method-prototype slot-name))
(defgeneric make-method-lambda (generic-function method lambda-expression environment))
(defgeneric make-optimized-boundp-method-function (class generic-function boundp-method-prototype slot-name))
(defgeneric make-optimized-method-lambda (generic-function method lambda-expression environment))
(defgeneric make-optimized-reader-method-function (class generic-function reader-method-prototype slot-name))
(defgeneric make-optimized-writer-method-function (class generic-function writer-method-prototype slot-name))
(defgeneric (setf slot-value-using-class) (new-value class object slotd))

;;; 5 arguments 
(defgeneric compile-structure-class-internals (class direct-slots conc-name predicate-name constructor))
(defgeneric make-constructor-code-generators (class name lambda-list supplied-initarg-names supplied-initargs))

;;; 6 arguments 
(defgeneric do-defstruct-from-defclass (class direct-superclasses direct-slots conc-name predicate constructor))

;;; 8 arguments 
(defgeneric optimize-instance-access (generic-function method parameter-class parameter slots read/write slot-name new-value))

;;; optional arguments  
(defgeneric add-boundp-method (class generic-function slot-name &optional direct-slot))
(defgeneric add-cached-function (method function slot-locations &optional slot-fetchers))
(defgeneric add-reader-method (class generic-function slot-name &optional direct-slot))
(defgeneric add-writer-method (class generic-function slot-name &optional direct-slot))
(defgeneric documentation (object &optional doc-type))
(defgeneric (setf documentation) (new-value object &optional doc-type))
(defgeneric get-cached-function (method slot-locations &optional slot-fetchers))
(defgeneric get-constructor (class name &optional error-p))
(defgeneric get-method (generic-function qualifiers specializers &optional errorp))
(defgeneric remove-named-method (generic-function-name argument-specifiers &optional extra))
(defgeneric slot-missing (class instance slot-name operation &optional new-value))
(defgeneric update-slot-accessor-function (slotd type function &optional update-accessors-p))

;;; keyword arguments  
(defgeneric allocate-instance (class &rest initargs))
(defgeneric boundp-method-class (class direct-slot &rest initargs))
(defgeneric copy-instance-slots (object1 object2 &key exclude-slot-names))
(defgeneric describe-object-slots (object stream &key slots-to-inspect &allow-other-keys))
(defgeneric ensure-class-using-class (name class &rest args &key))
(defgeneric ensure-generic-function-using-class (generic-function function-specifier &key generic-function-class environment &allow-other-keys))
(defgeneric initialize-instance (gf &key lambda-list argument-precedence-order))
(defgeneric make-direct-slotd (class &rest initargs &key name conc-name defstruct-accessor-symbol &allow-other-keys))
(defgeneric make-instance (class-name &rest initargs))
(defgeneric no-applicable-method (generic-function &rest args))
(defgeneric no-next-method (generic-function method &rest args))
(defgeneric reader-method-class (class direct-slot &rest initargs))
(defgeneric reinitialize-instance (gf &rest args &key lambda-list argument-precedence-order))
(defgeneric shared-initialize (generic-function slot-names &key lambda-list argument-precedence-order))
(defgeneric trace-method (method &rest options))
(defgeneric update-dependent (meta-object dependent &rest initargs))
(defgeneric update-instance-for-different-class (previous current &rest initargs))
(defgeneric update-instance-for-redefined-class (instance added-slots discarded-slots property-list &rest initargs))
(defgeneric writer-method-class (class direct-slot &rest initargs))

