;;; -*- Mode:Lisp; Syntax: Common-lisp; Package:XLIB; Base:10; Lowercase: Yes -*-

(in-package :xlib)

(defun hello-world (host &rest args &key (string "Hello World") (font "fixed"))
  ;; CLX demo, says STRING using FONT in its own window on HOST
  (let ((display nil)
	(abort t))
    (unwind-protect
	 (progn 
	   (setq display (open-display host))
	   (multiple-value-prog1
	       (let* ((screen (display-default-screen display))
		      (black (screen-black-pixel screen))
		      (white (screen-white-pixel screen))
		      (font (open-font display font))
		      (border 1)	; Minimum margin around the text
		      (width (+ (text-width font string) (* 2 border)))
		      (height (+ (max-char-ascent font) (max-char-descent font) (* 2 border)))
		      (x (truncate (- (screen-width screen) width) 2))
		      (y (truncate (- (screen-height screen) height) 2))
		      (window (create-window :parent (screen-root screen)
					     :x x :y y :width width :height height
					     :background black
					     :border white
					     :border-width 1
					     :colormap (screen-default-colormap screen)
					     :bit-gravity :center
					     :event-mask '(:exposure :button-press)))
		      (gcontext (create-gcontext :drawable window
						 :background black
						 :foreground white
						 :font font)))
		 ;; Set window manager hints
		 (set-wm-properties window
				    :name 'hello-world
				    :icon-name string
				    :resource-name string
				    :resource-class 'hello-world
				    :command (list* 'hello-world host args)
				    :x x :y y :width width :height height
				    :min-width width :min-height height
				    :input :off :initial-state :normal)
		 (map-window window)	; Map the window
		 ;; Handle events
 ((LAMBDA (G4 G5)
    ((LAMBDA (.DISPLAY. .TIMEOUT.
			.FORCE-OUTPUT-P.
			.DISCARD-P.)
       (WITH-EVENT-QUEUE (.DISPLAY.)
	 (MULTIPLE-VALUE-BIND
	       (.PROGV-VARS. .PROGV-VALS.
			     .CURRENT-EVENT-SYMBOL.
			     .CURRENT-EVENT-DISCARDED-P-SYMBOL.)
	     (EVENT-LOOP-SETUP .DISPLAY.)
	   (PROGV .PROGV-VARS.
	       .PROGV-VALS.
	     (LOOP
	      (MULTIPLE-VALUE-BIND
		    (.EVENT. .EOF-OR-TIMEOUT.)
		  (EVENT-LOOP-STEP-BEFORE 
		   .DISPLAY.
		   .TIMEOUT.
		   .FORCE-OUTPUT-P.
		   .CURRENT-EVENT-SYMBOL.)
		(WHEN (NULL .EVENT.)
		  (RETURN
		    (VALUES NIL
			    .EOF-OR-TIMEOUT.)))
		(LET ((.ABORTED. T))
		  (UNWIND-PROTECT
		       (PROGN
			 (LET ((G3 .EVENT.))
			   (print .event.) (force-output *terminal-io*)
			   ((LAMBDA (%REPLY-BUFFER)
			     (LET* ((BUFFER-BOFFSET (THE ARRAY-INDEX 0))
			      (BUFFER-BBUF (REPLY-IBUF8 %REPLY-BUFFER)))
				BUFFER-BOFFSET
				BUFFER-BBUF
    (LET ((T81 (SVREF *EVENT-KEY-VECTOR*
		      (EVENT-CODE G3))))
      (print t81) (force-output *terminal-io*)
      (CASE T81
	(:EXPOSURE
	 (BINDING-EVENT-VALUES
	  (G4 T81
	      :EXPOSURE
	      WINDOW
	      COUNT)
	  (LET ((T82
		 (PROGN
		   (WHEN (ZEROP COUNT)
		     (WITH-STATE
			 (WINDOW)
		       (LET ((X
			      (TRUNCATE
			       (-
				(DRAWABLE-WIDTH
				 WINDOW)
				WIDTH)
			       2))
			     (Y
			      (TRUNCATE
			       (-
				(+
				 (DRAWABLE-HEIGHT
				  WINDOW)
				 (MAX-CHAR-ASCENT
				  FONT))
				(MAX-CHAR-DESCENT
				 FONT))
			       2)))
			 (CLEAR-AREA
			  WINDOW)
			 (DRAW-GLYPHS
			  WINDOW
			  GCONTEXT
			  X
			  Y
			  STRING)))
		     NIL))))
	    (WHEN T82
	      (UNLESS G5
		(DISCARD-CURRENT-EVENT
		 G4))
	      (RETURN T82)))))
	(:BUTTON-PRESS
	 (BINDING-EVENT-VALUES (G4 T81 :BUTTON-PRESS)
			       (LET ((T83 (PROGN T)))
				 (WHEN T83
				   (UNLESS G5
				     (DISCARD-CURRENT-EVENT
				      G4))
				   (RETURN T83)))))))))
			    G3)



			   )
			 (SETQ .ABORTED. NIL))
		    (EVENT-LOOP-STEP-AFTER
		     .DISPLAY.
		     .EVENT.
		     .DISCARD-P.
		     .CURRENT-EVENT-SYMBOL.
		     .CURRENT-EVENT-DISCARDED-P-SYMBOL.
		     .ABORTED.)))))))))
     G4
     NIL
     T
     T))
  DISPLAY
  NIL));; Pressing any mouse-button exits
	     (setq abort nil)))
      ;; Ensure display is closed when done
      (when display
	(close-display display :abort abort)))))

