/* Based on a dynamic loader written in C++ by:
  Glenn Gribble			glenn@synaptics.com	uunet!synaptx!glenn
  Synaptics, Inc.		(408) 434-0110
  2860 Zanker Road, Suite 105	(408) 434-9819 FAX
  San Jose, CA 95134

 Copyright (C) 1990 by Glenn Gribble; all rights are reserved.
 This program may be used for any purposes including inclusion in
 for profit programs.  If the source is copied, the copyright notice
 must be included.  Please send bug fixes/reports to glenn@synaptics.com
 This program is distributed without any warranty.

  */

/* HEY! Clean this stuff up....still messy after a quick conversion from C++ */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/mman.h>
#include <signal.h>

#include <stdio.h>
/* #include <stdlib.h>*/
/* #include <osfcn.h> */
/* #include <memory.h> */
#include <fcntl.h>
#include <a.out.h>
#include <strings.h>
#include <link.h>

#define TRUE 1
#define FALSE 0

typedef struct reloc_info_sparc reloc_info_type;

int d_all = 0;
int d_relocation = 0;
int d_execs = 0;
int d_ctors = 0;
int d_symbols = 0;

#define DEBUGSYMBOLS  (d_symbols || d_all)
#define DEBUGRELOCATION   (d_relocation || d_all)
#define DEBUGEXECS     (d_execs || d_all)
#define DEBUGRUCTORS  (d_ctors || d_all)

/* See <link.h> for details */
extern struct link_dynamic _DYNAMIC;

/* Set the n_type field of an nlist to N_SET when the value is known good */
#define N_SET N_TYPE

typedef unsigned char *memptr;
typedef struct exec exec;
typedef struct nlist nlist;
typedef unsigned long  ULONG;
typedef struct nlist *nlistptr;
typedef enum reloc_type reloc_type;

typedef struct sym_table {
  nlist *realSymbols;
  int    numRealSymbols;
  nlist **quickSymbols;
  int    numQuickSymbols;
  char  *FileName;
  unsigned   good;
  long data_offset;
  long text_offset;
  struct sym_table *prev;
  exec E;
} sym_table;

typedef struct segment {
  memptr data;
  int    prot;
  int    len;
} segment;

#ifdef ansi_fixed_args
extern unsigned long intern_if_needed(char* c_name);
extern char *strdup(char *s1);
extern int mprotect(caddr_t addr, int len, int prot);
extern nlist *value_by_name(sym_table *table,  char *name);
extern unsigned doReloc(sym_table *table,
			reloc_info_type *rl,
			int	relocSize,
			register	memptr	seg);
void showReloc(sym_table *table, reloc_info_type *rl, int size, memptr seg);
#else
extern unsigned long intern_if_needed();
extern char *strdup();
extern int mprotect();
extern nlist *value_by_name();
extern unsigned doReloc();
void showReloc();
#endif

sym_table *top;
char *baseFile = NULL;

segment *new_segment_3(d, l, p)
     memptr d; int l; int p;
{
  segment *s;
  
  s = (segment *) malloc(sizeof(segment));
  s->data = d;
  s->len = l;
  s->prot=p;
  return(s);
}

segment *new_segment_2(l, p)
     int l; int p;
{
  segment *seg = new_segment_3(0,l,p);
  if (l == 0) {
    seg->data = NULL;
  } else {
    seg->data = (memptr)
      mmap(0, seg->len, seg->prot, MAP_PRIVATE, dev_zero(), 0);
    if ((int) (seg->data) == -1) {
      perror("segmentseg->_ctor:mmap");
      fprintf(stderr,"seg->len=%d, seg->prot=%d\n", seg->len, seg->prot);
      seg->data = NULL;
    }
  }
  return(seg);
}
     
int ZERO = -1;

/* HEY! Use staic var? */
int dev_zero()
{
  if (ZERO == -1) {
    ZERO = open("/dev/zero", O_RDONLY);
  }
  return ZERO;
}

void setProt(seg, newProt)
     segment *seg; int newProt;
{
  if (mprotect((caddr_t) seg->data,seg->len, newProt) != 0) {
    perror("mprotect");
  } else {
    seg->prot = newProt;
  }
}

void segment_unmap(seg)
     segment *seg;
{
  if (seg->data != NULL)
    if (munmap((caddr_t)(seg->data), seg->len) != 0)
      perror("setment_munmap");
}

void printLong(N)
     nlist *N;
{
  char *sn = N->n_un.n_name;
  int X = N->n_type & 0x1;
  char kn[20];
  
  if (sn == NULL) sn = "NO-NAME";
  switch (N->n_type & ~0x1) {
  case N_TEXT:
    strcpy(kn, X ? "TEXT" : "text");
    break;
  case N_DATA:
    strcpy(kn, X ? "DATA" : "data");
    break;
  case N_BSS:
    strcpy(kn, X ? "BSS"  : "bss");
    break;
  default:
    sprintf(kn,"0x%0X",N->n_type);
    break;
  }
  printf("%-16s (%4s) %08X\n", sn, kn, N->n_value);
  fflush(stdout);
}

segment *mapSome(fd, offset, length)
     int fd; int offset; int length;
{
  int prot = PROT_READ|PROT_EXEC|PROT_WRITE;
  int flag = MAP_PRIVATE;
  int pageSize = getpagesize();
  int realOffset = offset & ~(pageSize-1);
  int inPageOffset = offset - realOffset;
  int realLength = length + (offset-realOffset);
  memptr tmp = (memptr)mmap(0, realLength, prot, flag, fd, realOffset);
  if ( (int)(tmp) == -1 ) {
    perror("mmap");
    return NULL;
  }
  return new_segment_3(tmp + inPageOffset, length, prot);
}

segment *copySomeI(fd, offset, length, extra)
     int fd; int offset; int length; int extra;
{
  segment *s = new_segment_2(length+extra, PROT_READ|PROT_EXEC|PROT_WRITE);
  int len;
  if (s->data == NULL) return s;
  
  lseek(fd, offset, L_SET);
  len = read(fd, s->data, (int)length);
  if (len != (int)length) {
    perror("read");
    return NULL;
  }
  
  return s;
}

segment *copySome(fd, offset, length, extra)
     int fd;
     unsigned long offset;
     unsigned long length;
     unsigned long extra;
{
  return(copySomeI(fd, (int)offset, (int)length, (int)extra));
}

/* Change all n_strx entries to point to the actual string (n_name) */
void fixup(table, strBase)
     sym_table *table; char *strBase;
{
  int quick = 0;
  int i;
  long offset;
  nlist *Nptr;
  nlist *nl = table->realSymbols;
  int nnl = table->numRealSymbols;
  nlist **qs;
  
  for (i=0; i < nnl; i++) {
    Nptr = nl + i;
    offset = Nptr->n_un.n_strx;
    if (offset != 0)
      Nptr->n_un.n_name = strBase + offset;
    else
      Nptr->n_un.n_name = "no-name";
    if ( (Nptr->n_type & N_EXT) == N_EXT ) quick++;
  }
  
  /* Now we know how many external symbols there are, so we can allocate */
  /* the 'quick' array */
  
  table->numQuickSymbols = quick;
  table->quickSymbols = (nlistptr *)
    malloc(sizeof(nlistptr) * table->numQuickSymbols);
  
  quick = 0;
  qs = table->quickSymbols;
  for (i=0; i < nnl; i++) {
    Nptr = nl+i;
    if ((Nptr->n_type & N_EXT) == N_EXT) {
      qs[quick++] = Nptr;
    }
  }
}

nlist *lookup(table,  name)
     sym_table *table;  char *name;
{
  int i;
  nlist **qs = table->quickSymbols;
  nlist* N;
  
  for (i = 0; i< table->numQuickSymbols; i++) {
    N = qs[i];
    if (strcmp(N->n_un.n_name, name) == 0) return N;
  }
  return NULL;
}

nlist *value_by_nlist(table, N)
     sym_table *table; nlist *N;
{
  nlist *N2;
  unsigned long lvalue;

  switch (N->n_type) {
    
  case N_ABS + N_EXT:
  case N_SET:
    break;
  case N_UNDF + N_EXT:
    /* Undefined symbol, try to define it from lower levels */
    if ((table->prev == NULL) ||
	((N2 = value_by_name(table->prev,(N->n_un.n_name))) == NULL)) {
      if ((lvalue = intern_if_needed((N->n_un.n_name) + 1)) == NULL) {
	printf("error: %s: symbol undefined\n", N->n_un.n_name);
	return NULL;
      } else {
	N->n_type = N_SET;	/* HEY! How's this??? */
	N->n_value = lvalue;
	break;
      }
    }
    N->n_type = N2->n_type;
    N->n_value= N2->n_value;
    break;
    
  case N_TEXT + N_EXT:
    N->n_value += table->text_offset;
    N->n_type   = N_SET;
    break;
  case N_DATA + N_EXT:
  case N_BSS + N_EXT:
    if (table->data_offset == -1) {
      /* HEY! Symbols in a shared lib seem to end up in text, but
	 .o files that we try to load think they're in data. Everything
	 seems to work as is, although I'm not quite sure why.
	 For now I'll just nix the warning...

	printf("warning: %s mapped to data in illegal data segment",
	N->n_un.n_name);
	*/
      N->n_value += table->text_offset;
    } else
      N->n_value += table->data_offset;
    
    N->n_type   = N_SET;
    break;
  default:
    printf("warning: %s mapped to funny type symbol",N->n_un.n_name);
    printLong(N);
    break;
  }
  return(N);
}

nlist *value_by_name(table, name)
     sym_table *table;  char *name;
{
  nlist *v = lookup(table,name);
  if (v != NULL)
    return value_by_nlist(table,v);
  if (table->prev == NULL)
    return NULL;
  return value_by_name(table->prev,name);
}

nlist *value_by_index(table, indx)
     sym_table *table; int indx;
{
  nlist *v = table->realSymbols+indx;
  return value_by_nlist(table,v);
}

void printAll(table)
     sym_table *table;
{
  int i;
  
  for (i = 0; i< table->numRealSymbols; i++)
    printLong(&(table->realSymbols[i]));
}

unsigned mapit(table)
     sym_table *table;
{
  segment *fbs;
  memptr fileBase;
  memptr symWhere;
  memptr strWhere;
  int fileLength;
  int fd = open(table->FileName, O_RDONLY);
  int symbolOffset;
  int symbolsAndStrings;
  
  if (fd < 0) {
    perror(table->FileName);
    return FALSE;
  }
  if (read(fd, &(table->E), sizeof(struct exec)) != sizeof(struct exec)) {
    perror(table->FileName);
    close(fd);
    return FALSE;
  }
  
  if (N_BADMAG(table->E)) {
    printf("error: Bad magic number for %s",table->FileName);
    close(fd);
    return FALSE;
  }
  
  fileLength = (int) lseek(fd, 0, L_XTND);
  lseek(fd, 0, 0);
  if (DEBUGEXECS)
    printf("info: %s is %d bytes long\n", table->FileName, fileLength);
  
  symbolOffset = (int) N_SYMOFF(table->E);
  symbolsAndStrings = fileLength - symbolOffset;
  
  fbs = mapSome(fd, symbolOffset, symbolsAndStrings);
  fileBase = fbs->data;
  
  if (DEBUGEXECS)
    printf("info: mapped symbols at %x\n",(int)(fileBase));
  if ( fileBase == NULL ) {
    printf("error: mmap");
    close(fd);
    return FALSE;
  }
  
  /*memptr textWhere = fileBase + N_TXTOFF(E); */
  /*memptr dataWhere = fileBase + N_DATOFF(E); */
  /*memptr trelWhere = fileBase + N_TRELOFF(E); */
  /*memptr drelWhere = fileBase + N_DRELOFF(E); */
  
  symWhere  = fileBase;
  strWhere  = fileBase + N_STROFF(table->E) - N_SYMOFF(table->E);
  
  table->realSymbols = (nlist*) symWhere;
  table->numRealSymbols = (int)(table->E.a_syms) / sizeof(nlist);
  fixup(table,(char *) strWhere);
  close(fd);			/* Fix fd leak... */
  return TRUE;
}

/* Map in a file and think about it */
unsigned copyin(table)
     sym_table *table;
{
  long v;
  int i;
  int fd = open(table->FileName, O_RDONLY);
  int fileLength;
  nlist *nl;
  nlist *N;
  segment *text;
  segment *trel;
  segment *drel; 
  segment *syms; 
  segment *strs; 
  memptr  data;
  memptr  bss;
  reloc_info_type *TR;
  reloc_info_type *DR;
  char *ructorBase;
  int ructorBaseLen;
  
  if (fd<0) {
    perror(table->FileName);
    return FALSE;
  }
  
  fileLength = (int)lseek(fd, 0, L_XTND);
  lseek(fd, 0, 0);
  if (DEBUGEXECS)
    printf("info: %s is %d bytes long\n", table->FileName, fileLength);
  
  if (read(fd, &(table->E), sizeof(exec)) != sizeof(exec)) {
    perror(table->FileName);
    close(fd);
    return FALSE;
  }
  if (N_BADMAG(table->E)) {
    printf("error: Bad magic number for %s",table->FileName);
    close(fd);
    return FALSE;
  }
  
  if (table->E.a_magic != OMAGIC) {
    printf("error: Bad magic number for %s, %o.  Need %o",
	   table->FileName, table->E.a_magic, ZMAGIC);
    close(fd);
    return FALSE;
  }
  
  text = copySome(fd,
		  N_TXTOFF(table->E),
		  table->E.a_text+table->E.a_data,
		  table->E.a_bss);
  data = text->data + table->E.a_text;
  bss  = data + table->E.a_data;
  
  trel = copySome(fd, N_TRELOFF(table->E), table->E.a_trsize, 0);
  drel = copySome(fd, N_DRELOFF(table->E), table->E.a_drsize, 0);
  syms = copySome(fd, N_SYMOFF(table->E),  table->E.a_syms, 0);
  strs = copySome(fd,
		  N_STROFF(table->E),
		  fileLength-N_STROFF(table->E),
		  0);
  setProt(strs,PROT_READ);
  
  close(fd);
  
  table->realSymbols = (nlist*) syms->data;
  table->numRealSymbols = (int)(table->E.a_syms) / sizeof(nlist);
  fixup(table,(char*) strs->data);
  
  table->text_offset = (long) text->data;
  table->data_offset = table->text_offset;
  
  TR = (reloc_info_type*) trel->data;
  DR = (reloc_info_type*) drel->data;
  
  if (DEBUGRELOCATION) {
    printf("info: Text relocation\n");
    showReloc(table,TR, (int) table->E.a_trsize, text->data);
  }
  if (!doReloc(table,TR, (int) table->E.a_trsize, text->data)) {
    printf("error: could not relocate text segment");
    segment_unmap(trel);
    segment_unmap(drel);
    return FALSE;
  }
  if (DEBUGRELOCATION) {
    printf("info: After text relocation\n");
    showReloc(table,TR, (int) table->E.a_trsize, text->data);
  }
  
  if (DEBUGRELOCATION) {
    printf("info: Data relocation\n");
    showReloc(table,DR, (int) table->E.a_drsize, data);
  }
  if (!doReloc(table,DR, (int) table-> E.a_drsize, data)) {
    printf("error: could not relocate data segment");
    segment_unmap(trel);
    segment_unmap(drel);
    return FALSE;
  }
  if (DEBUGRELOCATION) {
    printf("info: After data relocation\n");
    showReloc(table,DR, (int) table->E.a_drsize, data);
  }
  segment_unmap(trel);
  segment_unmap(drel);
  
  ructorBase = "___sti__";
  ructorBaseLen= strlen(ructorBase);
  
  /* Look for ructors and call them */
  for (i=0; i< table->numRealSymbols; i++) {
    N = &(table->realSymbols[i]);
    if (strncmp(ructorBase, N->n_un.n_name, ructorBaseLen) == 0) {
      nl = value_by_index(table,i);
      v = nl->n_value;
      if (DEBUGRUCTORS)
	printf("info: Calling '%s' at %x\n", N->n_un.n_name, v);
      fflush(stdout);
      fflush(stderr);
      printf("Constructor call goes here\n");
      /* callit(v); */
    }
  }
  return TRUE;
}

sym_table *new_sym_table(fn, loadWholeFile)
     char *fn; unsigned loadWholeFile;
{
  sym_table *table = (sym_table *) malloc(sizeof(sym_table));
  
  table->FileName = malloc(strlen(fn)+1); 
  strcpy(table->FileName, fn);
  
  table->data_offset = 0;
  table->text_offset = 0;
  
  table->good = TRUE;
  table->prev = top;
  
  if (loadWholeFile) {
    if (!copyin(table)) {
      table->good = FALSE;
    }
  } else {
    if (!mapit(table)) {
      printf("error: %s: could not mapit\n", table->FileName);
      table->good = FALSE;
    }
  }
  
  if (table->good) {
    top = table;
  }
  
  return(table);
}

sym_table *loadsym_table(fn, loadWholeFile)
     char *fn; unsigned loadWholeFile;
{
  sym_table *st = new_sym_table(fn, loadWholeFile);
  if (st->good)
    return st;
  
  /* HEY! free it here? delete st; */
  return NULL;
}

char *symbolNumToText(symbolNum)
     int symbolNum;
{
  switch (symbolNum) {
  case N_TEXT:
    return "text-rel";
  case N_DATA:
    return "data-rel";
  case N_UNDF:
    return "undef-rel";
  case N_ABS:
    return "abs-rel";
  case N_BSS:
    return "bss-rel";
  case N_COMM:
    return "comm-rel";
  case N_FN:
    return "fn-rel";
  case N_EXT:
    return "ext-rel";
  default:
    return "unknown-symbol-num";
  }
}

char *sparcRelocType(ir)
     int ir;
{
  reloc_type r = (reloc_type) ir;
  switch (r) {
  case RELOC_8:
    return "RELOC_8";
  case RELOC_16:
    return "RELOC_16";
  case RELOC_32:
    return "RELOC_32";
  case RELOC_DISP8:
    return "RELOC_DISP8";
  case RELOC_DISP16:
    return "RELOC_DISP16";
  case RELOC_DISP32:
    return "RELOC_DISP32";
  case RELOC_WDISP30:
    return "RELOC_WDISP30";
  case RELOC_WDISP22:
    return "RELOC_WDISP22";
  case RELOC_HI22:
    return "RELOC_HI22";
  case RELOC_22:
    return "RELOC_22";
  case RELOC_13:
    return "RELOC_13";
  case RELOC_LO10:
    return "RELOC_LO10";
  case RELOC_SFA_BASE:
    return "RELOC_SFA_BASE";
  case RELOC_SFA_OFF13:
    return "RELOC_SFA_OFF13";
  case RELOC_BASE10:
    return "RELOC_BASE10";
  case RELOC_BASE13:
    return "RELOC_BASE13";
  case RELOC_BASE22:
    return "RELOC_BASE22";
  case RELOC_PC10:
    return "RELOC_PC10";
  case RELOC_PC22:
    return "RELOC_PC22";
  case RELOC_JMP_TBL:
    return "RELOC_JMP_TBL";
  case RELOC_SEGOFF16:
    return "RELOC_SEGOFF16";
  case RELOC_GLOB_DAT:
    return "RELOC_GLOB_DAT";
  case RELOC_JMP_SLOT:
    return "RELOC_JMP_SLOT";
  case RELOC_RELATIVE:
    return "RELOC_RELATIVE";
  default:
    return "RELOC_unknown";
  }
}

unsigned doReloc(table, rl, relocSize, seg)
     sym_table *table;
     reloc_info_type *rl;
     int	relocSize;
     memptr	seg;
{
  char *sym;
  unsigned bad;
  memptr where;
  ULONG  value;
  unsigned failed = FALSE;
  int i;
  int nreloc = relocSize / sizeof(reloc_info_type);
  nlist *nl;
  
  for (i = 0; i < nreloc; i++) {
    reloc_info_type *R = (rl + i);
    long addMe = 0;
    
    if (R->r_extern) {
      nl = value_by_index(table,R->r_index);
      if (nl != NULL)
	addMe = nl->n_value;
      else {
	printf("error: doReloc: undef symbol # %d\n", R->r_index);
	failed = TRUE;
      }
    } else {
      switch (R->r_index) {
      case N_TEXT:
      case N_DATA:
      case N_BSS:
	addMe = table->text_offset;	/* Same as data_offset */
	break;
      default:
	failed = TRUE;
	printf("error: doReloc: Don't understand %s\n",
	       symbolNumToText(R->r_index));
      }
    }
    
    where = seg + R->r_address;
    value = addMe + R->r_addend;
    
    bad = FALSE;	/* Do I know how to process this? */
    switch (R->r_type) {
    case RELOC_8:
      bad = TRUE;
      break;
    case RELOC_16:
      bad = TRUE;
      break;
    case RELOC_32:		/* Just set the value */
      *(ULONG*) where = value;
      break;
    case RELOC_DISP8:
      bad = TRUE;
      break;
    case RELOC_DISP16:
      bad = TRUE;
      break;
    case RELOC_DISP32:
      bad = TRUE;
      break;
    case RELOC_WDISP30:		/* "Word Displacement", PC-REL, (shr by 2) */
      *(unsigned long *) where |= (addMe-(unsigned long)(where)) >> 2;
      break;
    case RELOC_WDISP22:		/* "Word Displacement", PC-REL, (shr by 2) */
      bad = TRUE;
      break;
    case RELOC_HI22:		/* High 22 bits of thingie, (shr by 10) */
      *(ULONG*) where |= value >> 10;
      break;
    case RELOC_22:
      bad = TRUE;
      break;
    case RELOC_13:
      bad = TRUE;
      break;
    case RELOC_LO10:		/* Low 10 bits of thingie, (just mask bits) */
      *(ULONG*) where |= value & 0x03FF;
      break;
    case RELOC_SFA_BASE:
      bad = TRUE;
      break;
    case RELOC_SFA_OFF13:
      bad = TRUE;
      break;
    case RELOC_BASE10:
      bad = TRUE;
      break;
    case RELOC_BASE13:
      bad = TRUE;
      break;
    case RELOC_BASE22:
      bad = TRUE;
      break;
    case RELOC_PC10:
      bad = TRUE;
      break;
    case RELOC_PC22:
      bad = TRUE;
      break;
    case RELOC_JMP_TBL:
      bad = TRUE;
      break;
    case RELOC_SEGOFF16:
      bad = TRUE;
      break;
    case RELOC_GLOB_DAT:
      bad = TRUE;
      break;
    case RELOC_JMP_SLOT:
      bad = TRUE;
      break;
    case RELOC_RELATIVE:
      bad = TRUE;
      break;
    default:
      bad = TRUE;
      break;
    }
    if (bad) {
      long value = *(long*) (seg + R->r_address);
      failed = TRUE;
      
      printf("error: Could not process %s\n", sparcRelocType(R->r_type));
      sym = "";
      if (R->r_extern)
	sym = table->realSymbols[R->r_index].n_un.n_name;
      else
	sym = symbolNumToText(R->r_index);
      printf("info: %4d : %08x +%08x (%6d) %16s %s%s",
	     R->r_address, value, R->r_addend, R->r_addend,
	     sym, sparcRelocType(R->r_type), bad ? " (bad)" : "");
    }
  }
  return !failed;
}

#if 0
enum reloc_type
{
  RELOC_8,	RELOC_16,	RELOC_32,	/* simplest relocs    */
  RELOC_DISP8,	RELOC_DISP16,	RELOC_DISP32,	/* Disp's (pc-rel)    */
  RELOC_WDISP30,RELOC_WDISP22,			/* SR word disp's     */
  RELOC_HI22,	RELOC_22,			/* SR 22-bit relocs   */
  RELOC_13,	RELOC_LO10,			/* SR 13&10-bit relocs*/
  RELOC_SFA_BASE,RELOC_SFA_OFF13,		/* SR S.F.A. relocs   */
  RELOC_BASE10,	RELOC_BASE13,	RELOC_BASE22,	/* base_relative pic */
  RELOC_PC10,	RELOC_PC22,			/* special pc-rel pic*/
  RELOC_JMP_TBL,				/* jmp_tbl_rel in pic */
  RELOC_SEGOFF16,				/* ShLib offset-in-seg*/
  RELOC_GLOB_DAT, RELOC_JMP_SLOT, RELOC_RELATIVE, /* rtld relocs        */
};

struct reloc_info_sparc	/* used when header.a_machtype == M_SPARC */
{
  unsigned long int r_address;	/* relocation addr (offset in segment)*/
  unsigned int	r_index   :24;	/* segment index or symbol index      */
  unsigned int	r_extern  : 1;	/* if F, r_index==SEG#; if T, SYM idx */
  int			  : 2;	/* <unused>			      */
  enum reloc_type r_type  : 5;	/* type of relocation to perform      */
  long int	r_addend;	/* addend for relocation value	      */
};
#endif /* 0 */

void showReloc(table, rl, size, seg)
     sym_table *table; reloc_info_type *rl; int size; memptr seg;
{
  int i;
  int nreloc = size / sizeof(reloc_info_type);
  long value;
  
  for (i = 0; i < nreloc; i++) {
    reloc_info_type *R = rl + i;
    char *sym = (R->r_extern)
      ? table->realSymbols[R->r_index].n_un.n_name
	: symbolNumToText(R->r_index);
    
    unsigned bad = FALSE;	/* Do I know how to process this? */
    switch (R->r_type) {
    case RELOC_8:
      bad = TRUE;
      break;
    case RELOC_16:
      bad = TRUE;
      break;
    case RELOC_32:
      break;
    case RELOC_DISP8:
      bad = TRUE;
      break;
    case RELOC_DISP16:
      bad = TRUE;
      break;
    case RELOC_DISP32:
      bad = TRUE;
      break;
    case RELOC_WDISP30:	/* "Word Displacement", PC-REL, (shr by 2) */
      break;
    case RELOC_WDISP22: /* "Word Displacement", PC-REL, (shr by 2) */
      bad = TRUE;
      break;
    case RELOC_HI22:	/* High 22 bits of thingie, (shr by 10) */
      break;
    case RELOC_22:
      bad = TRUE;
      break;
    case RELOC_13:
      bad = TRUE;
      break;
    case RELOC_LO10:	/* Low 10 bits of thingie, (just mask bits) */
      break;
    case RELOC_SFA_BASE:
      bad = TRUE;
      break;
    case RELOC_SFA_OFF13:
      bad = TRUE;
      break;
    case RELOC_BASE10:
      bad = TRUE;
      break;
    case RELOC_BASE13:
      bad = TRUE;
      break;
    case RELOC_BASE22:
      bad = TRUE;
      break;
    case RELOC_PC10:
      bad = TRUE;
      break;
    case RELOC_PC22:
      bad = TRUE;
      break;
    case RELOC_JMP_TBL:
      bad = TRUE;
      break;
    case RELOC_SEGOFF16:
      bad = TRUE;
      break;
    case RELOC_GLOB_DAT:
      bad = TRUE;
      break;
    case RELOC_JMP_SLOT:
      bad = TRUE;
      break;
    case RELOC_RELATIVE:
      bad = TRUE;
      break;
    default:
      bad = TRUE;
      break;
    }
    /*
      opcode            rightShift   bytesize    bitsize     
      RELOC_8,             0           0           8     
      RELOC_16,            0           1          16     
      RELOC_32,            0           2          32     
      RELOC_DISP8,         0           0           8     
      RELOC_DISP16,        0           1          16     
      RELOC_DISP32,        0           2          32     
      RELOC_WDISP30,       2           2          30     
      RELOC_WDISP22,       2           2          22     
      RELOC_HI22,         10           2          22     
      RELOC_22,            0           2          22     
      RELOC_13,            0           2          13     
      RELOC_LO10,          0           2          10     
      RELOC_SFA_BASE,      0           2          32     
      RELOC_SFA_OFF13      0           2          32     
      RELOC_BASE10,        0           2          16     
      RELOC_BASE13,  				     
      RELOC_BASE22,  				     
      RELOC_PC10,    				     
      RELOC_PC22,    				     
      RELOC_JMP_TBL, 				     
      RELOC_SEGOFF16,				     
      RELOC_GLOB_DAT,				     
      RELOC_JMP_SLOT,				     
      RELOC_RELATIVE,				     
      */
    value = *(long*) (seg + R->r_address);
    
    printf("info: %4d : %08x +%08x (%6d) %16s %s%s",
	   R->r_address, value, R->r_addend, R->r_addend,
	   sym, sparcRelocType(R->r_type), bad ? " (bad)" : "");
  }
}

/* This procedure calls the procedure at v.  The main reason to have */
/* this be a separate procedure is for debugging (stop in callit) */
/*
  void callit(long v)
  {
  typedef void (*procedure)();
  procedure ctor = (procedure)v;
  (*ctor)();
  }
  */

unsigned loadSymbolChildren(l)
     struct link_map *l;
{
  sym_table *st;
  exec E;
  if (l == NULL) return TRUE;
  
  if (!loadSymbolChildren(l->lm_next))
    return FALSE;
  
  st = loadsym_table(l->lm_name, FALSE);
  if (st == NULL) {
    printf("error: loadSymbolChildren: could not create sym_table\n");
    return FALSE;
  }
  
  E = *(exec*) l->lm_addr;
  if (bcmp(&E, &(st->E), sizeof(exec)) != 0) {
    printf("error: loadSymbolChildren: execs do not match for %s\n",
	   l->lm_name);
    return FALSE;
  }
  
  if (DEBUGEXECS)
    printf("info: Found exec for %s at %x\n", st->FileName, &E);
  st->text_offset = (long)(l->lm_addr) - N_TXTOFF(E);
  st->data_offset = -1;
  return(TRUE);
}

unsigned open_tables(myFile)
     char *myFile;
{
  /* Check version of DYNAMIC structure */
  if (_DYNAMIC.ld_version > 3)
    printf("warning: DYNAMIC.ld_version = %d", _DYNAMIC.ld_version);
  
  if (!loadSymbolChildren(_DYNAMIC.ld_un.ld_2->ld_loaded)) return FALSE;
  
  if (loadsym_table(myFile, FALSE) == NULL)
    return FALSE;
  else
    return TRUE;
}

long c_symbol_value(name)
     char *name;
{
  int badValue = 0;
  char symbol[1024];
  nlist *nl;

  symbol[0] = '_';
  strcpy(symbol+1,name);
  nl = value_by_name(top,symbol);
  if (nl == NULL) {
    return badValue;
  } else {
    long v = nl->n_value;
    if (DEBUGSYMBOLS)
      printf("info: Value of %s is %x\n", symbol, v);
    return v;
  }
}

/* Why is this here!!!!??? */
char *strchr(s, c)
     char *s; char c;
{
  for ( ; *s != c && *s != '\0'; s++);
  if (*s == c)
    return s;
  else
    return NULL;
}

/* Return a pointer to an allocated string for the full pathname */
/* given just the argv[0] type name */
char *pathFind(fileName, path)
     char *fileName;  char *path;
{
  char *p;
  char name[1024];
  
  if (strchr(fileName, '/') != NULL) {
    /* fileName has a /, so it must be here */
    if (access(fileName, R_OK) < 0) {
      perror(fileName);
      return NULL;
    }
    return strdup(fileName);
  }
  
  p = path;
  
  do {
    /* Find the first path element */
    char *e = strchr(p, ':');
    if (e == NULL) e = p+strlen(p);
    strncpy(name, p, e-p);
    name[e-p] = '\0';
    p = e;
    if (*p == ':') p++;
    
    strcat(name, "/");
    strcat(name, fileName);
    /* fprintf(stderr,"Looking for %s\n", name); */
    if (access(name, R_OK) == 0)
      return strdup(name);
  } while ( *p != '\0' );
  
  return NULL;
}

void init_loader(a0)
     char *a0;
{
  /* Look everywhere in the path to find the file */
  char *PATH = getenv("PATH");
  if (PATH == NULL) {
    printf("error: setArg0: path is NULL?");
    return;
  }
  baseFile = pathFind(a0, PATH);
  if (baseFile == NULL) {
    printf("error: Could not find %s in %s", a0, PATH);
  }
  /* Don't let subsequent CD affect baseFile */
  baseFile = truename(baseFile,0);
  signal(SIGUSR1,SIG_IGN);
}

void signal_debug_info(filename, text_start)
     char* filename; unsigned long text_start;
{
  int pid = getpid();
  FILE *output;
  char path[1024];
  
  sprintf(path,"/tmp/add-file-command-%d\0",pid);
  output = fopen(path,"w");
  fprintf(output," %s 0x%x\n",filename,text_start);
  fflush(output);
  fclose(output);
  kill(pid,SIGUSR1);
  unlink(path);
}

unsigned load_compiled_file(fileName)
     char *fileName;
{
  sym_table *table;
  
  if (top == NULL) {
    if (baseFile == NULL) {
      printf("error: load_file(%s): could not load, baseFile == NULL", fileName);
      return FALSE;
    }
    if (!open_tables(baseFile))
      return FALSE;
  }
  
  if (top == NULL) {
    printf("error: load_file: top == NULL, can't load");
    return FALSE;
  }
  
  table = loadsym_table(fileName, TRUE);
  if (table != NULL) {
    signal_debug_info(table->FileName,table->text_offset);
    return TRUE;
  } else {
    return FALSE;
  }
}

pc_to_procedure_name(pc)
     unsigned long pc;
{
  printf("HEY! pc_to_procedure name doesn't work on SPARC!\n");
  return(0);
}

