;;; (C) Copyright 1990-1994 by Wade L. Hennessey. All rights reserved.

(in-package "W")

(defvar *delay-structure-defs?* nil)
(defvar *delayed-structure-defs?* nil)
(defvar *unbound* "UNBOUND")
(defvar *input-stream-line-numbers?* nil)
(defvar *lisp-package* (find-package "W"))
(defvar *host-lisp-package* (find-package "LISP"))
(defvar *keyword-package* (find-package "KEYWORD"))
(defvar *cl-version* 0)

(defconstant special-symbol-flag 0)
(defconstant constant-symbol-flag 1)
(defconstant macro-symbol-flag 2)

(defmacro defun-inline (name &rest stuff)
  `(defun ,name ,@stuff))

(load "../cl/decls/defstruct.lisp")
(load "../cl/functions/defstruct.lisp")
(load "../cl/decls/destructuring-bind.lisp")
(load "../cl/decls/constants.lisp")
(load "../cl/decls/cl-types.lisp")
(load "../cl/functions/cross-functions.lisp")

(defun proclaimed-special? (name)
  (let ((info (get-variable-info name)))
    (and info (variable-info-kind info))))

(defun constant-var? (name)
  (let ((info (get-variable-info name)))
    (and info (eq (variable-info-kind info) :constant))))

(defun proclaim-special-variable (name)
  (setf (variable-info-kind (get-or-create-variable-info name)) :special))

(defun proclaim-constant-variable (name constant-expr)
  (let ((info (get-or-create-variable-info name)))
    (setf (variable-info-kind info) :constant)
    (setf (variable-info-constant-expr info) constant-expr)))

(defun constant-expr (variable)
  (variable-info-constant-expr (get-variable-info variable)))

(defun complete-delayed-defstructs () nil)

(defparameter *package-abbrev-alist*
  (list
   (cons (find-package "LISP") #("s_lsp_" "p_lsp_" "m_lsp_"))
   (cons (find-package "W") #("s_lsp_" "p_lsp_" "m_lsp_"))
   (cons (find-package "USER") #("s_user_" "p_user_" "m_user_"))
   (cons (find-package "LUCID-COMMON-LISP")  #("s_lsp_" "p_lsp_" "m_lsp_"))
   (cons (find-package "LUCID-RUNTIME-SUPPORT")  #("s_lsp_" "p_lsp_" "m_lsp_"))
   (cons (find-package "KEYWORD") #("s_key_" "p_key_" "m_key_"))))

(defparameter *wcl-package* (find-package "W"))

(defparameter *lcl-package* (find-package "LUCID-COMMON-LISP"))

(defun package-abbrev (package index)
  (let ((entry (assoc package *package-abbrev-alist*)))
    (if (null entry)
	(progn (warn "No package abbrev for ~S, using lisp" package)
	       (package-abbrev (find-package "LISP") index))
	(svref (cdr entry) index))))

(defun defstruct-package (symbol)
  (declare (ignore symbol))
  *compiler-package*)

#+lucid
(def-foreign-function (getpid (:return-type :signed-32bit)
				   (:name "_getpid")
				   (:language :c)))


(defun getenv (x)
  (environment-variable x))

(defun tmpdir ()
  (or (getenv "TMPDIR") "/tmp"))

(defun make-line-symbol (x line)
  (declare (ignore line))
  x)	  

(defun line-symbol-p (s)
  (declare (ignore s))
  nil)

(defun line-symbol-line (s)
  (declare (ignore s))
  nil)

(defun line-symbol-symbol (s)
  s)

(defun source-line (s)
  (declare (ignore s))
  nil)

(defun remove-line-symbols (x)
  x)

