/* Changes to track when merging:
   Changes in stack.c to support backtrace changes
   Changes in infrun to support .o loading
   add lisp.c and lisp.o to Makefile.in
   Modify top-level README
   maybe symtab.c if we fix that stuff.
   dbxread.c: remove no debug symbols found msg.
*/

#include <string.h>
#include <stdio.h> 
#include "defs.h"
#include "param.h"
#include "frame.h"
#include "symtab.h"
#include "value.h"
#include "expression.h"
#include "gdbcore.h"
#include "gdbcmd.h"
#include "target.h"

extern char *xmalloc ();

#define CHAR_TO_NUMBER(c) ((c <= '9') ? c - '0' : c + 10 - 'A')

int lisp_name_p(name)
     char* name;
{
  return((name != NULL) &&
	 (strchr("pmsvftb",*name) != NULL) &&
	 (*(name + 1) == '_'));
}

char hex_to_ascii(hex)
     char* hex;
{
  return((CHAR_TO_NUMBER(hex[0]) * 16) + CHAR_TO_NUMBER(hex[1]));
}  

void print_lisp_name(name)
     char* name;
{
  char c;

  c = *name;
  name = name + 2;
  if (strchr("spm",c) != NULL) {
    name = strchr(name,'_');
    if (name == NULL) {
      printf("Lisp naming error: no package found\n");
    }
    name = name + 1;
  }
  c = *name;
  while (c != '\0') {
    if (c == '_') {
      c = hex_to_ascii(name + 1);
      putchar(c);
      name = name + 3; 
    } else {
      putchar(c);
      name = name + 1;
    }
    c = *name;
  }
}

char *lisp_demangle(name)
     char *name;
{
  char c,*new,*tmp;

  if (lisp_name_p(name)) {
    new = (char *) xmalloc(strlen(name));
    tmp = new;
    c = *name;
    name = name + 2;
    if (strchr("spm",c) != NULL) {
      name = strchr(name,'_');
      if (name == NULL) {
	printf("Lisp naming error: no package found\n");
	return(NULL);
      }
      name = name + 1;
    }
    c = *name;
    while (c != '\0') {
      if (c == '_') {
	c = hex_to_ascii(name + 1);
	*tmp = c;
	tmp = tmp + 1;
	name = name + 3; 
      } else {
	*tmp = c;
	tmp = tmp + 1;
	name = name + 1;
      }
      c = *name;
    }
    *tmp = 0;
    return(new);
  } else {
    return(NULL);
  }
}

lisp_strcmp(mangled,normal)
      char* mangled; char* normal;
{
  return(strcmp(mangled,normal));
  if ((((*mangled ==  'v')  ||(*mangled == 'p')) && (*(mangled + 1) == '_')) &&
      (*mangled != *normal)) {
    printf("lisp_strcmp: %s to %s\n",mangled,normal);
    if (*mangled == 'v') {
      mangled = mangled + 2;	/*  skip: v_ */
    } else {
      mangled = mangled + 6;	/*  skip: p_pkg_ */
    }
    while ((*normal != NULL) && (*mangled != NULL))  {
      if (toupper(*normal) == *mangled) {
	normal = normal + 1;
	mangled = mangled + 1;
      } else {
	if ((*mangled == '_') && (*normal == hex_to_ascii(mangled + 1))) {
	  normal = normal + 1;
	  mangled = mangled + 3;
	} else {
	  return(strcmp(mangled,normal));
	}
      }
    }
    if (*mangled == '_') {
      mangled = mangled + 1;
      /*  skip trialing number or return false if other stuff */
      while (*mangled != NULL) {
	if (isdigit(*mangled)) {
	  mangled = mangled + 1;
	} else {
	  break;
	}
      }
    }
  }
  return(strcmp(mangled,normal));
}

char* hidden_lisp_frames[] = { "apply_function", "apply_function_1", NULL };

int find_special_frame_entry(function_name)
     char* function_name;
{
  if ((function_name != NULL) &&
      (strcmp(function_name,"eval_closure_code")) == 0) {
    return(1);
  } else {
    return(0);
  }
} 

print_special_lisp_frame(index)
     int index;
{
  fflush(stdout);
  /* This relies on the selected_frame being correct */
  parse_and_eval("p_lsp_GDBBACKTRACE(1,name)",1);
  fprintf_filtered(stdout," (interpreted)"); 
}

int hide_frames = 1;

static void
hide_command(exp)
     char* exp;
{
  hide_frames = ((hide_frames == 0) ? 1 : 0);
}


hidden_lisp_frame_p(function_name)
     char* function_name;
{
  int i;

  if (hide_frames && (function_name != NULL)) {
    /* Hide all eval frames except function calls. */
    if (((strstr(function_name,"p_lsp_EVAL_")) != 0) &&
	(find_special_frame_entry(function_name) == 0)) {
      return(1);
    } else {
      for (i = 0; (hidden_lisp_frames[i] != NULL); i = i + 1) {
	if (strcmp(hidden_lisp_frames[i],function_name)  == 0) {
	  return(1);
	}
      }
    }
  }
  return(0);
}

static void
lprint_command(exp)
     char* exp;
{
  char buffer[1024];

  sprintf(buffer,"p_lsp_GDBPRINT(1,%s)",exp);
  parse_and_eval(buffer,1);
}

static void
leval_command(exp)
     char* exp;
{
  char *addr_exp;
  FRAME frame;
  struct frame_info *fi;
  struct symbol *func;
  char *funname = 0;
  extern FRAME parse_frame_specification ();
  extern int so_list_head;	/* lie... */

  if (so_list_head == 0) {
    printf("Issue the sharedlib library command before using eval.\n");
  } else {
    char buffer[1024];

    frame = parse_frame_specification (addr_exp);
    fi = get_frame_info (frame);
    func = get_frame_function (frame);
    if (exp == 0) {
      exp = "0";
    }
    if (func == 0 || (find_special_frame_entry(SYMBOL_NAME(func)) == 0)) {
      sprintf(buffer,"p_lsp_NULLEVALDEBUG(1,%s) \0",exp);
    } else {
      sprintf(buffer,"p_lsp_EVALDEBUG(7, %s, name, evaled_args, venv, fenv, tenv, benv) \0",exp);
    }
    parse_and_eval(buffer,1);
  }
}


static void
lisp_abort_command (arg, from_tty)
     char *arg;
     int from_tty;
{
  extern int so_list_head;	/* lie... */
  if (so_list_head == 0) {
    printf("Issue the sharedlib library command before using abort.\n");
  } else {
    printf("Aborting to top-level\n");
    jump_command("abort_to_top_level",from_tty);
  }
}


static void
lisp_restart_command (arg, from_tty)
     char *arg;
     int from_tty;
{
  extern int so_list_head;	/* lie... */

  int n = -1;
  if (arg) {
    n = parse_and_eval_address(arg);
  }
  if (so_list_head == 0) {
    printf("Issue the sharedlib library command before using restart.\n");
  } else {
    printf("Restarting\n");
    jump_command("select_restart_option",from_tty);
  }
}

static void
restart_info (exp, from_tty)
     char *exp;
     int from_tty;
{
  parse_and_eval("p_lsp_SHOW_2DRESTARTS(0)");
}


_initialize_lisp ()
{
  add_com ("hide", class_vars, hide_command,"Hide some stack frames");

  add_com ("lp", class_vars, lprint_command,"Call Lisp Printer");

  add_com ("eval", class_vars, leval_command,
           "Call Lisp Interpreter with current frame's environment");

  add_com ("abort", class_run, lisp_abort_command,
	   "Abort to top-level");

  add_com ("restart", class_run, lisp_restart_command,
	   "Select a restart option");

  add_info("restarts", restart_info, "Show available restart options");
}

