/*
    eval.h -- Macros and parameters..
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/



/*  C control stack  */

#ifdef MTCL
#define	CSGETA		500

#define cs_limit       clwp->lwp_cs_limit
#define cs_org         clwp->lwp_cs_org
#define cssize         clwp->lwp_cssize

#else
#define	CSGETA		4000

extern int *cs_org;
extern int *cs_limit;
extern int cssize;
#endif MTCL

#ifdef DOWN_STACK
#define	cs_check(something) \
	if ((int *)(&something) < cs_limit) \
		cs_overflow()
#else
#define	cs_check(something) \
	if ((int *)(&something) > cs_limit) \
		cs_overflow()
#endif DOWN_STACK


#define check_symbol(x) \
	if (type_of(x) != t_symbol) \
		not_a_symbol(x)

#define	check_var(x) \
	if (type_of(x) != t_symbol || \
	    (enum stype)(x)->s.s_stype == stp_constant) \
		not_a_variable(x)


#define CONS(a,d)	make_cons((a),(d))
#define CAR(x)	(x)->c.c_car
#define CDR(x)	(x)->c.c_cdr
#define CAAR(x)	(x)->c.c_car->c.c_car
#define CADR(x)	(x)->c.c_cdr->c.c_car
#define CDAR(x)	(x)->c.c_car->c.c_cdr
#define CDDR(x)	(x)->c.c_cdr->c.c_cdr
#define CAAAR(x)	(x)->c.c_car->c.c_car->c.c_car
#define CAADR(x)	(x)->c.c_cdr->c.c_car->c.c_car
#define CADAR(x)	(x)->c.c_car->c.c_cdr->c.c_car
#define CADDR(x)	(x)->c.c_cdr->c.c_cdr->c.c_car
#define CDAAR(x)	(x)->c.c_car->c.c_car->c.c_cdr
#define CDADR(x)	(x)->c.c_cdr->c.c_car->c.c_cdr
#define CDDAR(x)	(x)->c.c_car->c.c_cdr->c.c_cdr
#define CDDDR(x)	(x)->c.c_cdr->c.c_cdr->c.c_cdr
#define CAAAAR(x)	(x)->c.c_car->c.c_car->c.c_car->c.c_car
#define CAAADR(x)	(x)->c.c_cdr->c.c_car->c.c_car->c.c_car
#define CAADAR(x)	(x)->c.c_car->c.c_cdr->c.c_car->c.c_car
#define CAADDR(x)	(x)->c.c_cdr->c.c_cdr->c.c_car->c.c_car
#define CADAAR(x)	(x)->c.c_car->c.c_car->c.c_cdr->c.c_car
#define CADADR(x)	(x)->c.c_cdr->c.c_car->c.c_cdr->c.c_car
#define CADDAR(x)	(x)->c.c_car->c.c_cdr->c.c_cdr->c.c_car
#define CADDDR(x)	(x)->c.c_cdr->c.c_cdr->c.c_cdr->c.c_car

#define Null(x)	((x)==Cnil)

#ifdef CLOS
#define CLASS_OF(x)		x->in.in_class
#define CLASS_NAME(x)		x->in.in_slots[0]
#define CLASS_SUPERIORS(x)	x->in.in_slots[1]
#define CLASS_INFERIORS(x)	x->in.in_slots[2]
#define CLASS_SLOTS(x)		x->in.in_slots[3]
#define CLASS_CPL(x)		x->in.in_slots[4]
#endif CLOS

#define MV_SAVE(nr) \
   { object mv_values[nr]; /* __GNUC__ */ \
       memcpy(mv_values, &VALUES(0), (nr) * sizeof(object))
#define MV_RESTORE(nr) \
       memcpy(&VALUES(0), mv_values, (nr) * sizeof(object));}
#define MV_SHIFT(nr, d) \
   { int i; for (i = (nr)-1; i >= 0; i--) VALUES(i+d) = VALUES(i);}

