/*
    unixint.c -- Unix interrupt interface.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"
#include <signal.h>

object SVinterrupt_enable;

void
sigalrm()
{
	if (interrupt_flag) {
		interrupt_flag = FALSE;
		terminal_interrupt(TRUE);
	}
}

void
sigint()
{
  if (!interrupt_enable || interrupt_flag) {
    if (!interrupt_enable) {
      fprintf(stdout, "\n;;;Interrupt delayed.\n");
      fflush(stdout);
      interrupt_flag = TRUE;
    }
    signal(SIGINT, sigint);
    return;
  }
  if (symbol_value(SVinterrupt_enable) == Cnil) {
    SVinterrupt_enable->s.s_dbind = Ct;
    signal(SIGINT, sigint);
    return;
  }
#ifdef MSDOS
  if (interrupt_flag)
    sigalrm();
#endif MSDOS
  interrupt_flag = TRUE;
  signal(SIGALRM, sigalrm);
  alarm(1);
  signal(SIGINT, sigint);
}

void
sigfpe()
{
	signal(SIGFPE, sigfpe);
	FEerror("Floating-point exception.", 0);
}

#ifdef unix
void
signal_catcher(int sig, int code, int scp)
{
	char str[64];

	if (!interrupt_enable) {
		sprintf(str, "signal %d caught (during GC)", sig);
		error(str);
	}
	else if (sig == SIGSEGV)
	  FEerror("Segmentation violation.~%\
Wrong type argument to a compiled function.", 0);
	else {
	  printf("System error. Trying to recover ...\n");
	  fflush(stdout);
	  FEerror("Signal ~D caught.~%\
The internal memory may be broken.~%\
You should check the signal and exit from Lisp.", 1,
		  MAKE_FIXNUM(sig));
	}
}

siLcatch_bad_signals(int narg)
{
	check_arg(0);

	signal(SIGILL, signal_catcher);
	signal(SIGIOT, signal_catcher);
	signal(SIGBUS, signal_catcher);
	signal(SIGSEGV, signal_catcher);
#ifndef __linux__
	signal(SIGEMT, signal_catcher);
	signal(SIGSYS, signal_catcher);
#endif
	VALUES(0) = Ct;
	RETURN(1);
}

siLuncatch_bad_signals(int narg)
{
	check_arg(0);

	signal(SIGILL, SIG_DFL);
	signal(SIGIOT, SIG_DFL);
	signal(SIGBUS, SIG_DFL);
	signal(SIGSEGV, SIG_DFL);
#ifndef __linux__
	signal(SIGEMT, SIG_DFL);
	signal(SIGSYS, SIG_DFL);
#endif
	VALUES(0) = Ct;
	RETURN(1);
}
#endif unix

enable_interrupt()
{
	signal(SIGFPE, sigfpe);
	signal(SIGINT, sigint);
}

init_interrupt()
{
	SVinterrupt_enable
	= make_si_special("*INTERRUPT-ENABLE*", Ct);
#ifdef unix
	make_si_function("CATCH-BAD-SIGNALS", siLcatch_bad_signals);
	make_si_function("UNCATCH-BAD-SIGNALS", siLuncatch_bad_signals);
#endif unix
}
