;;; Write-Line and Write-String take keyword args, but people call them who
;;; don't want to cons.  So we turn them into calls to non-keyword parsing
;;; functions.

(deftransform write-string write-string-transform
  (string &optional (stream '*standard-output*)
	  &key (start) (end))
  (if start
      (if end
	  `(lisp::write-string* ,string ,stream ,start ,end)
	  `(lisp::write-string* ,string ,stream ,start))
      (if end
	  `(lisp::write-string* ,string ,stream 0 ,end)
	  `(lisp::write-string* ,string ,stream))))

(deftransform write-line write-line-transform
  (string &optional (stream '*standard-output*)
	  &key (start) (end))
  (if start
      (if end
	  `(lisp::write-line* ,string ,stream ,start ,end)
	  `(lisp::write-line* ,string ,stream ,start))
      (if end
	  `(lisp::write-line* ,string ,stream 0 ,end)
	  `(lisp::write-line* ,string ,stream))))
