;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%&%#%s%I%&$NItIJ$N%a%=%C%I4XO"(B
;;; window-parts-method.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;             All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors: 
;;;           Version2.0   91/02/28 T.Kosaka

;;; $B%&%#%s%I%&$NItIJ$N%a%=%C%I4XO"(B

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%&%#%s%I%&$NItIJ4XO"%a%=%C%I(B   ;;;
;;;          Version 2.0           ;;;              
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; title-bar-region $B$N(Bsetf$B%a%=%C%I(B
;;; $B%?%H%k%P!<$N%5%$%:JQ99(B
;;; (setf title-bar-region) region window
;;; ARG.
;;;         region    = $B?7$7$$%j!<%8%g%s(B
;;;         window    = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf title-bar-region) ((region region) (window window-stream))
  (set-title-bar-region (window-title-bar window) region)
  (redisplay-title-bar (window-title-bar window)))

;;; $B%?%$%H%k%P!<J8;zNs%"%/%;%9(B
;;; title-bar-string window
;;;ARG.
;;;             window = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric title-bar-string (window)
  (:method ((window window-stream))
	   (slot-value (window-title-bar window) 'title-bar-string))
  (:method ((window NULL))
	   nil))

;;; $B%?%$%H%k%P!<J8;zNs$NJQ99(B
;;; (setf title-bar-string) string window
;;; ARG.
;;;          string   = $B?7$7$$J8;zNs(B
;;;          window   = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf title-bar-string) (string window)
  (:method (string (window window-stream))
	   (setf (slot-value (window-title-bar window) 'title-bar-string)
	     string)
	   (redisplay-title-bar (window-title-bar window)))
  (:method (string (window NULL))
#-:PCL
   (declare (ignore string))
	   (values)))
	   

;;; $B%?%$%H%k%P!<%U%)%s%H$N%"%/%;%9%a%=%C%I(B
;;; title-bar-font window
;;; ARG.
;;;                window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric title-bar-font (window)
  (:method ((window window-stream))
    (slot-value (window-title-bar window) 'title-font))
  (:method ((window NULL))
	   NIL))

;;; $B%?%$%H%k%P!<%U%)%s%H$NJQ99%a%=%C%I(B
;;; (setf title-bar-font) new-font window
;;; ARG.
;;;                new-font = $B?7$7$$%U%)%s%H(B
;;;                window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf title-bar-font) (font window)
  (:method ((font text-font) (window window-stream))
    (let ((title-bar (window-title-bar window)))
      (setf (slot-value title-bar 'title-font) font
	    (region-height title-bar) (font-kanji-height font))
      (set-window-component-size window)
      (redisplay-window window)))
  (:method (font (window NULL))
#-:PCL
  (declare (ignore font))
	   NIL))

;;;$B%?%$%H%k%P!<I=<($N;2>H$NAm>N4X?t(B
;;; title-bar-visible window 
;;; ARG.
;;;          window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric title-bar-visible (window)
  (:method ((window window-stream))
	   (draw-piece-visible (window-title-bar window)))
  (:method ((window NULL))
	   NIL))

;;;$B%?%$%H%k%P!<I=<(>uBV$NJQ99$NAm>N4X?t(B
;;; (setf title-bar-visible) value window
;;; ARG.
;;;             value  =  T or NIL T: $BI=<((B NIL: $BHsI=<((B
;;;             window = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf title-bar-visible) (val window)
  (:method (val (window window-stream))
    (let ((title (window-title-bar window)))
	   (setf (draw-piece-visible title) val)))
  (:method (val (window NULL))
#-:PCL
  (declare (ignore val))
       nil))
	   
;;; $B%?%$%H%k%P!<$N?'$N;2>H$NAm>N4X?t(B
;;; title-bar-color window
;;; ARG.
;;;            window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric title-bar-color (window)
  (:method   ((window window-stream))
	     (slot-value (window-title-bar window) 'title-bar-color))
  (:method ((window NULL))
	   (values)))

;;; $B%?%$%H%k%P!<$N?'$NJQ99$NAm>N4X?t(B
;;; (setf title-bar-color) new-color window
;;; ARG.
;;;                new-color = $B?7$7$$%+%i!<$N%$%s%9%?%s%9(B
;;;                window    = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf title-bar-color) (new-color window)
  (:method  ((new-color color) (window window-stream))
	    (setf (slot-value (window-title-bar window) 'title-bar-color)
	      new-color)
	    (redisplay-title-bar (window-title-bar window)))
  (:method (new-color (window NULL))
#-:PCL
  (declare (ignore new-color))
	   (values)))


;;; world-region $B$N(Bset$B%a%=%C%I(B
;;; $B%o!<%k%I%5%$%:$NJQ99(B
;;; (setf world-region) region window
;;; ARG.
;;;             region      = $B?7$7$$%j!<%8%g%s(B
;;;             window      = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf world-region) ((region region) (window window-stream))
  (set-world-region-internal region window))

(defun set-world-region-internal (region window)
  (multiple-value-bind (v h)
      (resize-world region window)
    (setf 
	(world-height (window-vertical-scroll-bar window))
	(region-height window)
	(world-width (window-horizontal-scroll-bar window))
	(region-width window))
;(format t "v ~a h ~a~%" v t)
    (when v
	  (redisplay-vertical-scroll (window-vertical-scroll-bar window)))
    (when h
	  (redisplay-horizontal-scroll (window-horizontal-scroll-bar window)))
    ))


;;; frame$B$NBg$-$5JQ99%a%=%C%I(B
;;; (serf frame-region) region window
;;; ARG.
;;;            region   = $B?7$7$$%j!<%8%g%s(B
;;;            window   = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf frame-region) ((region region) (window window-stream))
  (set-frame-region (window-frame window) region)
  (setf (frame-height (window-vertical-scroll-bar window))
        (region-height (window-frame window))
        (frame-width (window-horizontal-scroll-bar window))
        (region-width (window-frame window))))


;;;$B=D%9%/%m!<%k%P!<$NI=<($N;2>H$NAm>N4X?t(B
;;; vertiacl-scroll-visible window 
;;; ARG.
;;;          window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric vertiacl-scroll-visible (window)
  (:method ((window window-stream))
	   (draw-piece-visible (window-vertical-scroll-bar window)))
  (:method ((window NULL))
	   NIL))

;;;$B=D%9%/%m!<%k%P!<$NI=<(>uBV$NJQ99$NAm>N4X?t(B
;;; (setf vertiacl-scroll-visible) value window
;;; ARG.
;;;             value  =  T or NIL T: $BI=<((B NIL: $BHsI=<((B
;;;             window = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf vertiacl-scroll-visible) (val window)
  (:method (val (window window-stream))
    (let ((scroll (window-vertical-scroll-bar window)))
	   (setf (draw-piece-visible scroll) val)))
  (:method (val (window NULL))
#-:PCL
   (declare (ignore val))
       nil))

;;; $B=DJ}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99$NAm>N4X?t(B
;;; (set vertical-scroll-region) new-region window
;;; ARG.
;;;                new-region = $B?7$7$$%j!<%8%g%s(B
;;;                window     = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf vertical-scroll-region) ((new-region region) (window window-stream))
  (set-scroll-region new-region 
		     (vertical-scroll-region window))
  (redisplay-vertical-scroll (vertical-scroll-region window))
  )

;;;$B2#%9%/%m!<%k%P!<$NI=<($N;2>H$NAm>N4X?t(B
;;; horizontal-scroll-visible window 
;;; ARG.
;;;          window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric horizontal-scroll-visible (window)
  (:method ((window window-stream))
	   (draw-piece-visible (window-horizontal-scroll-bar window)))
  (:method ((window NULL))
	   NIL))

;;;$B2#%9%/%m!<%k%P!<$NI=<(>uBV$NJQ99$NAm>N4X?t(B
;;; (setf horizontal-scroll-visible) value window
;;; ARG.
;;;             value  =  T or NIL T: $BI=<((B NIL: $BHsI=<((B
;;;             window = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf horizontal-scroll-visible) (val window)
  (:method (val (window window-stream))
    (let ((scroll (window-horizontal-scroll-bar window)))
	   (setf (draw-piece-visible scroll) val)))
  (:method (val (window NULL))
#-:PCL
   (declare (ignore val))
       nil))

;;; $B2#J}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99$NAm>N4X?t(B
;;; (set horizontal-scroll-region) new-region window
;;; ARG.
;;;                new-region = $B?7$7$$%j!<%8%g%s(B
;;;                window     = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf horizontal-scroll-region) ((new-region region) (window window-stream))
  (set-scroll-region new-region 
		     (horizontal-scroll-region window))
  (redisplay-horizontal-scroll (horizontal-scroll-region window))
  )

;;; X$B%*%U%;%C%H$N;2>H(B
;;; world-x-offset window
;;; ARG.    window = $B%&%#%s%I%&(B
(defgeneric world-x-offset (window)
  (:method ((window window-stream))
	(slot-value window 'world-x-offset))
  (:method ((window NULL))
	   0))

;;; X$B%*%U%;%C%HJQ99(B $B@dBPJQ99%a%=%C%I(B
;;; (setf world-x-offset) new-value window
;;; ARG.
;;;          new-value   = $B%*%U%;%C%H$N?7$7$$CM(B
;;;          window      = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf world-x-offset) (new-v window)
  (:method (new-v (window window-stream))
	   (set-world-x-offset new-v window)
	   (set-horizontal-world-x-offset 
	    (window-horizontal-scroll-bar window) new-v)
	   (redisplay-horizontal-scroll (window-horizontal-scroll-bar window)))
  (:method (new-v (window NULL))
#-:PCL
   (declare (ignore new-v))
     (values)))

;;; X$B%*%U%;%C%HJQ99(B $BAjBPJQ99(B
;;; add-x-offset window value
;;; ARG.
;;;              window   =   $B%&%#%s%I%&%9%H%j!<%`(B
;;;              value    =   $B2C;;CM(B
(defgeneric add-x-offset (window vlaue)
  (:method ((window window-stream) value)
     (let ((x (add-x-offset-world window value)))
       (set-horizontal-world-x-offset 
	   (window-horizontal-scroll-bar window) x)
       (redisplay-horizontal-scroll (window-horizontal-scroll-bar window))))

  (:method ((window NULL) value)
#-:PCL
   (declare (ignore value))
	   (values)))

;;; Y$B%*%U%;%C%H$N;2>H(B
;;; world-y-offset window
;;; ARG.    window = $B%&%#%s%I%&(B
(defgeneric world-y-offset (window)
  (:method ((window window-stream))
	(slot-value window 'world-y-offset))
  (:method ((window NULL))
	   0))

;;; Y$B%*%U%;%C%HJQ99(B $B@dBPJQ99%a%=%C%I(B
;;; (setf world-x-offset) new-value window
;;; ARG.
;;;          new-value   = $B%*%U%;%C%H$N?7$7$$CM(B
;;;          window      = $B%&%#%s%I%&%9%H%j!<%`(B
(defgeneric (setf world-y-offset) (new-v window)
  (:method (new-v (window window-stream))
	   (set-world-y-offset new-v window)
	   (set-vertical-world-y-offset 
	    (window-vertical-scroll-bar window) new-v)
	   (redisplay-vertical-scroll (window-vertical-scroll-bar window)))
  (:method (new-v (window NULL))
#-:PCL
   (declare (ignore new-v))
     (values)))

;;; Y$B%*%U%;%C%HJQ99(B $BAjBPJQ99(B
;;; add-y-offset window value
;;; ARG.
;;;              window   =   $B%&%#%s%I%&%9%H%j!<%`(B
;;;              value    =   $B2C;;CM(B
(defgeneric add-y-offset (window vlaue)
  (:method ((window window-stream) value)
     (let ((y (add-y-offset-world window value)))
       (set-vertical-world-y-offset 
	(window-vertical-scroll-bar window) y)
       (redisplay-vertical-scroll (window-vertical-scroll-bar window))))

  (:method ((window NULL) value)
#-:PCL
  (declare (ignore value))
	   (values)))

;;; XY$B%*%U%;%C%H$NJQ99(B $B@dBPJQ99(B
;;; change-world-xy-offset window x y
;;; ARG.
;;;         window   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;;         x y      =  $B0LCV(B
(defgeneric change-world-xy-offset (window x y)
  (:method ((window window-stream) (x integer) (y integer))
      (let ((x-offset (slot-value window 'world-x-offset))
	    (y-offset (slot-value window 'world-y-offset)))
	(multiple-value-bind (xx yy)
	  (change-world-xy-offset-internal window x y)

	  (set-vertical-world-y-offset 
	   (window-vertical-scroll-bar window) yy)
	  (set-horizontal-world-x-offset
	   (window-horizontal-scroll-bar window) xx)
	  (if (/= x-offset x)
	      (redisplay-horizontal-scroll 
	                  (window-horizontal-scroll-bar window)))
	  (if (/= y-offset y)
	      (redisplay-vertical-scroll (window-vertical-scroll-bar window)))
	  )))

  (:method ((window window-stream) (x integer) (y NULL))
    (setf (slot-value window 'world-x-offset) x))
  (:method ((window window-stream) (x NULL) (y integer))
    (setf (slot-value window 'world-y-offset) y))
  (:method ((window window-stream) x y)
#-:PCL
   (declare (ignore x y))
   (values))
  (:method ((window NULL) x y)
#-:PCL
   (declare (ignore x y))
    (values)))
	  
				
;;; $B:BI87OI=<(%(%j%"$N0LCVJQ99(B
;;; (setf coordinate-area-bottom) region window
;;; ARG.
;;;                region     = $B?7$7$$%j!<%8%g%s(B
;;;                window     = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf coordinate-area-bottom) (new-bottom (window window-stream))
  (set-coordinate-area-region (setf (region-bottom 
				     (window-coordinate-area window)) 
				    new-bottom)
			      (window-coordinate-area window))
  (redisplay-coordinate-area (window-coordinate-area window))
  )

;;; $B%&%#%s%I%&$N:FI=<((B
;;; redisplay-window window
;;; ARG.
;;;         window  = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod redisplay-window ((window window-stream))
  (redisplay-title-bar (window-title-bar window))
  (redisplay-horizontal-scroll (window-horizontal-scroll-bar window))
  (redisplay-vertical-scroll (window-vertical-scroll-bar window))
  (redisplay-coordinate-area (window-coordinate-area window))
  (redisplay-border window))


;;;$B%\!<%@!<I=<(>uBV$NJQ99(B after$B%a%=%C%I(B
;;; (setf border-visible) new window
;;; ARG.
;;;           new    =  T or NIL -> T:$BI=<((B NIL:$BHsI=<((B
;;;           window =  $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf border-visible) :after (new (window window-stream))
  (if new
      (setf (real-border-belt window) 0))
  (setf (real-border-belt window) (border-belt window))
  (set-window-component-size window)
  (redisplay-window window))


;;; $B%\!<%@!<$NI}JQ99%a%=%C%I(B after$B%a%=%C%I(B
;;; (setf border-belt) new-v window
;;; ARG.
;;;          new-v  =  $B%\!<%@$NI}(B
;;;          window = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf border-belt) :after (new-v (window window-stream))
  (setf (border-belt window) new-v)
  (if (border-visible window)
    (setf (real-border-belt window) new-v))
  (set-window-component-size window)
  (redisplay-window window))

;;; $B%\!<%@$N?'$NJQ99%a%=%C%I(B after $B%a%=%C%I(B
;;; (setf border-color) color window
;;; ARG.
;;;         color     =    $B?7$7$$%+%i!<(B
;;;         window    =    $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf border-color) :after ((color color) (window window-stream))
  (redisplay-border window))


;;; $B%\!<%@$N:FI=<((B
;;; redisplay-border window
;;; ARG.
;;;           window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod redisplay-border ((window window-stream))
  (declare (special *white-color*))
    (let* ((region (window-region window))
	 (belt (real-border-belt window))
	 (width (region-width region))
	 (height (region-height region)))
      (draw-piece-color window *white-color*)
      (draw-piece-rectangle window (floor (/ belt 2))
			  (floor (/ belt 2))
			  width height :color (border-color window)
			  :line-width belt)))

;;; $B%&%#%s%I%&$N%?%$%H%k%P!<$rJQ99$9$k%a%=%C%I(Bafter
;;; (setf window-title-bar) new-title-bar window
;;; ARG.
;;;            new-title-bar  =  $B%?%$%H%k!<%P!<%$%s%9%?%s%9(B
;;;            window         =  $B%&%#%s%I%&(B
(defmethod (setf window-title-bar) :after ((title title-bar)
					   (window window-stream))
  (set-window-component-size window)
  (redisplay-window window))

;;; $B%&%#%s%I%&$N2#%9%/%m!<%k%P!<$rJQ99$9$k%a%=%C%I(Bafter
;;; (setf window-horizontal-scroll-bar) new-val window
;;; ARG.
;;;           new-val   = $B2#%9%/%m!<%k%P!<%$%s%9%?%s%9(B
;;;           window    = $B%&%#%s%I%&(B
(defmethod (setf window-horizontal-scroll-bar) :after 
                    ((new-val horizontal-scroll-bar) (window window-stream))
  (set-window-component-size window)
  (redisplay-window window))

;;; $B%&%#%s%I%&$N=D%9%/%m!<%k%P!<$rJQ99$9$k%a%=%C%I(Bafter
;;; (setf window-vertiacal-scroll-bar) new-val window
;;; ARG.
;;;           new-val   = $B=D%9%/%m!<%k%P!<%$%s%9%?%s%9(B
;;;           window    = $B%&%#%s%I%&(B
(defmethod (setf window-vertical-scroll-bar) :after 
                    ((new-val vertical-scroll-bar) (window window-stream))
  (set-window-component-size window)
  (redisplay-window window))

			
;;; $B%&%#%s%I%&$N3F9=@.MWAG$N%5%$%:$N7W;;$H@_Dj(B
;;; set-window-component-size window
;;; ARG.
;;;         window   =  $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod set-window-component-size ((window window-stream))
  (declare (special *SCROLL-BAR-BELT*))

  (let* ((width (region-width (window-region window)))
	 (height (region-height (window-region window)))
	 (belt (real-border-belt window))
	 (f-l belt)
	 (f-b belt)
	 (f-r (- width belt))
	 (f-t (- height belt))
	 (frame-region (window-frame window)))

    (if (window-title-bar window)
	(when (draw-piece-visible (window-title-bar window))
	  ;;; $B%?%$%H%k%P!<$,$"$k(B
	  (let ((region (window-title-bar window)))
	    (setf (region-left region) belt
		  (region-bottom region) 0
		  (region-top region) (font-kanji-height 
				       (slot-value region 'title-font))
		  (region-right region) (- width (* belt 2))
		  f-b (region-height region))
	    (set-title-bar-region region region))))

    (if (window-coordinate-area window)
	(when (draw-piece-visible (window-coordinate-area window))
	  ;;; $B:BI87OI=<(%(%j%"$,$"$k(B
	  (let ((region  (window-coordinate-area window)))
	    (setf (region-left region) (real-border-belt window)
		  (region-bottom region) (- height belt *SCROLL-BAR-BELT*)
		  (region-top region) (+ (region-bottom region) *SCROLL-BAR-BELT*)
		  (region-right region) (+ (region-left region) *SCROLL-BAR-BELT*)
		  f-l (region-width region)
		  f-t (- height belt (region-height region)))
	    (set-coordinate-area-region region region))))

    (if (window-horizontal-scroll-bar window)
	(when (draw-piece-visible (window-horizontal-scroll-bar window))
	  ;;; $B2#%9%/%m!<%k%P!<$,$"$k(B
	  (let ((region (window-horizontal-scroll-bar window)))
	    (setf (region-left region) f-l
		  (region-right region) (- width belt)
		  (region-bottom region) (- height *SCROLL-BAR-BELT* belt)
		  (region-top region) (- height belt)
		  f-t (- height *SCROLL-BAR-BELT*))
	    (set-scroll-region region region))))

    (if (window-vertical-scroll-bar window)
	;;; $B=D%9%/%m!<%k%P!<$,$"$k(B
	(when (draw-piece-visible (window-vertical-scroll-bar window))
	      (let ((region (window-vertical-scroll-bar window)))
		(setf (region-left region) belt
		      (region-right region) (+ belt *SCROLL-BAR-BELT*)
		      (region-bottom region) f-b
		      (region-top region) f-t
		      f-l (region-width region))
		(set-scroll-region region region))))

    ;;; $B%U%l!<%`$NJQ99(B
    (setf (region-left frame-region) f-l
	  (region-bottom frame-region) f-b
	  (region-top frame-region) f-t
	  (region-right frame-region) f-r)

    ;;; $BBg$-$5$N@_Dj(B
    (setf (frame-region window) frame-region)
    ))
    
;;; $B%&%#%s%I%&$NBg$-$5JQ99(B
;;; (setf window-region) new-region window
;;; ARG.
;;;               new-region     =   $B?7$7$$%j!<%8%g%s(B
;;;               window         =   $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod (setf window-region) ((new-region region) (window window-stream))
  (let* ((region (window-region window))
	 (parent (parent-window window))
	 (tno (territory window))
	 (start-x (if parent (world-x-start parent) 0))
	 (start-y (if parent (world-y-start parent) 0)))

    ;;; $B0l<!E*$KHsIA2h(B
    (yy-protocol-2 tno 0)
	
    ;;; $BF1$8%j!<%8%g%s$G$J$$(B
    (unless (eq region new-region)
	    (set-region region new-region))

     ;;; $B3F9=@.MWAG$NBg$-$5$N:F7W;;(B
    (set-window-component-size window)

     ;;; $B<B:]$N0\F0$HJQ99(B
    (yy-protocol-4 tno (+ (region-left region) start-x)
		   (+ (with-translate-coordinate-stream (region-bottom region)
						     parent)
		      start-y)
		   (region-width region) (region-height region))

	;;; $BI=<(>uBV$N=$@5(B
    (if (and (eq (window-status window) :window)
	     (window-visible window))
	(yy-protocol-2 tno 1))
    )
  (redisplay-window window)
)

;;; $B%&%#%s%I%&%9%H%j!<%`$r:n$k(B
;;; $B$3$N4X?t$O!"A4$F$N%&%#%s%I%&$N9=@.MWAG$r$b$C$?>l9g$G$"$k!#(B
;;; $B;XDj$7$?%&%#%s%I%&$NBg$-$5$G!"3F9=@.MWAG$N7W;;$,$J$5$l$k(B
;;; $BMxMQ<T$,Dj5A$7$?%&%#%s%I%&%9%H%j!<%`$r@8@.$9$k>l9g$O!"(B
;;; initialize-instance$B$N(Bafter$B%a%=%C%I$r;XDj$9$k!#(B
;;; make-window-stream &rest rest &key (left 0) (bottom 0) width
;;;                    height (right 0) (top 0) (parent *root-window*)
;;;                    (title-font *default-font*) (title-string "")
;;;                    (border-belt 1) (visible T)
;;;                    (page-mode nil) (border-visible t) (title-bar-visible t)
;;;                    (vertical-scroll-visible T) (horizontal-scroll-visible t)
;;;                    (font *DEFAULT-FONT*) (coordinate :left-top) 
;;;                    (output-direction :horizontal) (coordinate-area-visible T)
;;; ARG.
;;;  rest                      = $BMxMQ<T$,%&%#%s%I%&$rDj5A$7$?;~$N=i4|2=0z?t$N%j%9%H(B
;;;  left                      = $B?F%&%#%s%I%&$+$i$N:8C<(B
;;;  bottom                    = $B?F%&%#%s%I%&$+$i$N(B0$B$K6a$$2<C<(B
;;;  width                     = $BI}(B
;;;  height                    = $B9b$5(B
;;;  right                     = $B?F%&%#%s%I%&$+$i$N1&C<(B
;;;  top                       = $B?F%&%#%s%I%&$+$i$N(B0$B$+$i1s$$>eC<(B
;;;  parent                    = $B?F%&%#%s%I%&(B
;;;  title-font               = $B%?%$%H%k$rI=<($9$k;~$N%U%)%s%H(B
;;;  title-string             = $B%?%$%H%k$NJ8;zNs(B
;;;  border-belt               = $B%\!<%@$NI}(B
;;;  visible                   = $B%&%#%s%I%&$rI=<($9$k$+H]$+(B(T->$BI=<((B)
;;;  page-mode                 = $B%&%#%s%I%&$N%b!<%I$N;XDj(B(T->$B%Z!<%8%b!<%I(B)
;;;  border-visible            = $B%&%#%s%I%&$N%\!<%@$rI=<($9$k$+H]$+(B(T->$BI=<((B)
;;;  title-bar-visible         = $B%?%$%H%k%P!<$rI=<($9$k$+H]$+(B(T->$BI=<((B)
;;;  vertical-scroll-visible   = $B=DJ}8~%9%/%m!<%k%P!<$rI=<($9$k$+H]$+(B(T->$BI=<((B)
;;;  horizontal-scroll-visible = $B2#J}8~%9%/%m!<%k%P!<$rI=<($9$k$+H]$+(B(T->$BI=<((B)
;;;  font                      = $B%&%#%s%I%&%9%H%j!<%`$N%F%-%9%HI=<($N%U%)%s%H(B
;;;  coordinate                = $B:BI87O$NA*Br(B(:left-top->$B:8>e6y(B :left-bottom->$B1&2<6y(B)
;;;  output-direction          = $B%F%-%9%H$NI=<(J}8~(B(:horizontal->$B2#(B :vertical->$B=D(B)
;;;  coordinate-area-visible   = $B:BI87OI=<(%(%j%"$rI=<($9$k$+H]$+(B(T->$BI=<((B)
(defun make-window-stream 
  (&key (left 0) (top 0) width height (bottom 0) (right 0)
	 (parent *ROOT-WINDOW*) (title-font *DEFAULT-FONT*) (title-string "")
	 (border-belt 1) (visible T) (page-mode nil) (border-visible t)
	 (title-bar-visible t) (vertical-scroll-visible T) 
	 (horizontal-scroll-visible t) (font *DEFAULT-FONT*) 
	 (coordinate :left-top)
	 (output-direction :horizontal) (coordinate-area-visible T))
	 
    (let ((region (make-region :left left :bottom bottom :top top :right right
			     :width width :height height)))
    
    ;;; $B%Z!<%8%b!<%I$+$I$&$+(B
    (if page-mode
	(apply #'make-instance 'page-window-stream
	       (list :window-region region
	       :window-frame 'window-frame
	       :title-bar 'title-bar
	       :horisontal-scroll-bar 'horisontal-scroll-bar
	       :translate-coordinate coordinate
	       :vertical-scroll-bar 'vertical-scroll-bar
	       :coordinate-area 'coordinate-area
	       :title-bar-font title-font
	       :parent parent
	       :title-bar-string title-string
	       :border-belt border-belt :visible visible
	       :window-icon 'icon
	       :border-visible border-visible
	       :horizontal-scroll-bar 'horizontal-scroll-bar
	       :title-bar-visible title-bar-visible
	       :vertical-scroll-bar 'vertical-scroll-bar
	       :vertical-scroll-visible vertical-scroll-visible
	       :horizontal-scroll-visible horizontal-scroll-visible
	       :font font
	       :line-feed (font-kanji-height font)
	       :coordinate-area 'coordinate-area
	       :coordinate coordinate :output-direction output-direction
	       :coordinate-area-visible coordinate-area-visible))

      (apply #'make-instance 'viewport-window-stream
     	       (list :window-region region
	       :window-frame 'window-frame
	       :title-bar 'title-bar
	       :horisontal-scroll-bar 'horisontal-scroll-bar
	       :vertical-scroll-bar 'vertical-scroll-bar
	       :coordinate-area 'coordinate-area
	       :translate-coordinate coordinate
	       :title-bar-font title-font
	       :parent parent
	       :title-bar-string title-string
	       :border-belt border-belt :visible visible
	       :window-icon 'icon
	       :border-visible border-visible
	       :title-bar-visible title-bar-visible
	       :vertical-scroll-visible vertical-scroll-visible
	       :horizontal-scroll-visible horizontal-scroll-visible
	       :font font
	       :line-feed (font-kanji-height font)
	       :coordinate-area 'coordinate-area
	       :coordinate coordinate :output-direction output-direction
	       :coordinate-area-visible coordinate-area-visible))

    )))


;;; $B%&%#%s%I%&%9%H%j!<%`$N%$%s%9%?%s%9$r:n$k(B
;;; $B$3$N4X?t$O!"MxMQ<T$,Dj5A$7$?%&%#%s%I%&!"%?%$%H%k%P!<!"%"%$%3%s(B
;;; $B%9%/%m!<%k%P!<!"%U%l!<%`!":BI87OI=<(%(%j%"$G(B
;;; $B%&%#%s%I%&%9%H%j!<%`$r@8@.$9$k!#(B
;;; $B3F9=@.MWAG$NL>A0$,;XDj$5$l$F$$$J$1$l$P!"%U%l!<%`$H%"%$%3%s(B
;;; $B=|$$$F@8@.$7$J$$!#(B
;;; $B3FItIJ$N%/%i%9$O!"3F!9$N%/%i%9$r7Q>5$7$FDj5A$7$J$1$l$P$J$i$J$$(B
;;; make-window-instance window-class-name &rest args &key
;;;        (left-margin nil) (right-margin nil) (top-margin nil)
;;;        (bottom-margin nil) (text-font *default-font*)
;;;        (line-feed (font-kanji-height *default-font*))
;;;        (output-direction :horizontal) (visible t)
;;;        (window-region (make-region :left 0 :bottom 0 :width 0 :height 0))
;;;        (parent-window *root-window*)
;;;        (border-belt 1) (border-visible t) (border-color *black-color*)
;;;        (title-bar 'title-bar) (title-font *default-font*) 
;;;        (title-bar-string "") (title-bar-visible T) 
;;;        (title-bar-color *black-color*)
;;;        (horizontal-scroll-bar 'horizontal-scroll-bar) 
;;;        (scroll-bar-color *black-color*)
;;;        (horizontal-scroll-visible T) 
;;;        (vertical-scroll-bar 'vertical-scroll-bar) 
;;;        (scroll-bar-color *black-color*)
;;;        (vertical-scroll-visible T) 
;;;        (coordinate-area 'coordinate-area)
;;;        (coordinate-area-color *black-color*)
;;;        (coordinate-area-visible T)
;;;        (window-icon nil)
;;;        (frame nil)
;;; ARG.
;;;   window-class-name        =  $BMxMQ<TDj5A$N%&%#%s%I%&$N%/%i%9L>(B
;;;   args                     =  $BMxMQ<T$,Dj5A$7$?;~$K8F$P$l$k%-!<%o!<%I0z?t(B
;;;   left-margin              =  $B:8%^!<%8%s!J%F%-%9%HMQ!K(B
;;;   right-margin             =  $B1&%^!<%8%s!J%F%-%9%HMQ!K(B
;;;   top-margin               =  $B>eC<%^!<%8%s!J%F%-%9%HMQ!K(B
;;;   bottom-margin            =  $B2<C<%^!<%8%s!J%F%-%9%HMQ!K(B
;;;   text-font                =  $B%U%)%s%H!J%9%H%j!<%`$K=q$+$l$k!K(B
;;;   line-feed                =  $B2~9TI}(B
;;;   visible                  =  $B%&%#%s%I%&$rI=<($9$k$+H]$+(B(T-> $BI=<((B)
;;;   output-direction         =  $BJ8;zNs$N=PNOJ}8~(B
;;;                               :horizontal or :vertical
;;;   translate-coordinate     =  $B:BI87O(B :left-top or :left-bottom
;;;   window-region            =  $B%&%#%s%I%&$NBg$-$5$H0LCV(B      
;;;   parent-window            =  $B?F%&%#%s%I%&(B
;;;   border-belt              =  $B%\!<%@I}(B
;;;   border-visible           =  $B%\!<%@$rI=<($9$k$+H]$+(B(T-> $BI=<((B)
;;;   border-color             =  $B%\!<%@$N?'(B (NIL $B"M(B $B:n$i$J$$(B)
;;;   title-bar                =  $BMxMQ<T$,Dj5A$7$?%/%i%9L>(B
;;;                               $B%G%U%)%k%H$O%7%9%F%`Ds6!(B
;;;   title-font              =  $B%?%$%H%k%P!<$N%U%)%s%H(B
;;;   title-bar-string         =  $B%?%$%H%k%P!<$NJ8;zNs(B
;;;   title-bar-visible        =  $B%?%$%H%k%P!<$r8+$;$k$+H]$+(B(T->$BI=<((B)
;;;   title-bar-color          =  $B%?%$%H%k%P!<$N?'(B
;;;   horizontal-scroll-bar    =  $BMxMQ<T$,Dj5A$7$?%/%i%9L>(B
;;;                               $B%G%U%)%k%H$O%7%9%F%`Ds6!(B
;;;   scroll-bar-color         =  $B2#J}8~%9%/%m!<%k%P!<$N?'(B
;;;   horizontal-scroll-visible=  $B%9%/%m!<%k%P!<$r8+$;$k$+H]$+(B(T->$BI=<((B)
;;;   vertical-scroll-bar      =  $BMxMQ<T$,Dj5A$7$?%/%i%9L>(B
;;;                               $B%G%U%)%k%H$O%7%9%F%`Ds6!(B
;;;   scroll-bar-color         =  $B=DJ}8~$N%9%/%m!<%k%P!<$N?'(B
;;;   vertical-scroll-visible  =  $B%9%/%m!<%k%P!<$r8+$;$k$+H]$+(B(T->$BI=<((B)
;;;   coordinate-area           =  $BMxMQ<T$,Dj5A$7$?%/%i%9L>(B
;;;                               $B%G%U%)%k%H$O%7%9%F%`Ds6!(B
;;;   coordinate-area-color     =  $B:BI87OI=<(%(%j%"$N?'(B
;;;   coordinate-area-visible   =  $B:BI87OI=<(%(%j%"$r8+$;$k$+H]$+(B(T->$BI=<((B)
;;;   window-icon              =  $B%&%#%s%I%&$N%"%$%3%s(B
;;;   frame                    =  $B%&%#%s%I%&$N%U%l!<%`(B
(defun make-window-instance (window-class-name &rest args &key
	(left-margin nil) (right-margin nil) (top-margin nil)
        (bottom-margin nil) (text-font *default-font*)
        (line-feed (font-kanji-height *default-font*))
        (output-direction :horizontal)
	(translate-coordinate :left-top)
        (window-region (make-region :left 0 :bottom 0 :width 10 :height 10))
        (parent-window *root-window*)
        (border-belt 1) (border-visible t) (border-color *black-color*)
        (title-bar 'title-bar) (title-font *default-font*) 
        (title-bar-string "") (title-bar-visible T) 
        (title-bar-color *black-color*)
        (horizontal-scroll-bar 'horizontal-scroll-bar) 
        (scroll-bar-color *black-color*)
        (horizontal-scroll-visible T) 
	(visible T)
        (vertical-scroll-bar 'vertical-scroll-bar) 
        (vertical-scroll-visible T) 
        (coordinate-area 'coordinate-area)
        (coordinate-area-color *black-color*)
        (coordinate-area-visible T)
	(frame 'window-frame)
        (window-icon nil) &allow-other-keys)
  (declare (special *DEFAULT-FONT* *black-color* *root-window*))
  (apply #'make-instance window-class-name 
    (make-arg-list (list 
		 :left-margin left-margin 
		 :right-margin right-margin
		 :top-margin  top-margin 
		 :bottom-margin bottom-margin
		 :text-font text-font
		 :line-feed line-feed
		 :output-direction output-direction
		 :translate-coordinate translate-coordinate
		 :window-region window-region
		 :visible visible
		 :parent-window parent-window
		 :border-belt border-belt
		 :border-visible  border-visible 
		 :border-color  border-color 
		 :title-bar title-bar 
		 :title-font title-font
		 :title-bar-string title-bar-string
		 :title-bar-visible title-bar-visible
		 :title-bar-color  title-bar-color 
		 :horizontal-scroll-bar horizontal-scroll-bar
		 :scroll-bar-color  scroll-bar-color 
		 :horizontal-scroll-visible  horizontal-scroll-visible 
		 :vertical-scroll-bar  vertical-scroll-bar 
		 :scroll-bar-color scroll-bar-color 
		 :vertical-scroll-visible vertical-scroll-visible
		 :coordinate-area coordinate-area
		 :coordinate-area-color coordinate-area-color 
		 :coordinate-area-visible coordinate-area-visible 
		 :frame frame
		 :window-icon window-icon) args))
  )


;;; make-arg-list 
(defun make-arg-list (default-list arg-list)
  (let ((flg t)
	(ret  (do ((def default-list (cddr def)))
		  ((null def) default-list)
		(do ((arg arg-list (cddr arg)))
		    ((null arg))
		  (if (eq (car def) (car arg))
		      (return (setf (second def) (second arg)
				    arg (cddr arg))))
		  ))))
    (do ((arg arg-list (cddr arg)))
	((null arg) default-list)
      (setf flg t)
      (do ((def ret (cddr def)))
	  ((null def))
	(if (eq (car def) (car arg))
	    (return (setf flg nil
			  ret (cddr ret)))))

      (if flg 
	  (progn 
	    (push (car arg) (cdr (last default-list)))
	    (push (second arg) (cdr (last default-list)))))
      )))

