;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%W%j%_%F%#%V$N4XO"(B
;;; primitive.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;
;; YY$B%&%#%s%I%&%7%9%F%`$N4pK\%/%i%9$rDj5A$9$k!#(B
;;               1990.1.17  $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-1-17
;;; Chnage LOG 
;;; Add near corner method 6/27 '90 $BM?$($i$l$?%]%8%7%g%s$K:G$b6a$$(B
;;;                                 $B%j!<%8%g%s$N3Q$N%]%8%7%g%s$rJV$9(B
;;; $B%j!<%8%g%s$NDj5A$rJQ99$9$k(B
;;; $B%9%m%C%H$H$7$F!"(Bleft,right,bottom,top$B$r;}$D(B

(in-package :yy)

;;; Position $B%/%i%9(B
(defclass position
  ()
  ((x :initarg :position-x :type integer :initform 0 :accessor position-x)
   (Y :initarg :position-y :type integer :initform 0 :accessor position-y))
)

;;; Position $B%$%s%9%?%s%9$N%W%j%s%H%a%=%C%I(B
(defmethod print-object ((position position) stream)
  (format stream "\#<Position (~a,~a)>" 
	  (position-x position) (position-y position))
)

;;; Position $B@8@.4X?t(B
(defun make-position (&key (x 0) (y 0))
  (if (and (integerp x) (integerp y))
      (make-instance 'position :position-x x :position-y y)
    (error "The argument :x ~a :y: ~a are not a number" x y)))


;;; Position-p $B%*%V%8%'%/%H$,(Bposition$B$G$"$k$+(B?
(defun position-p (pos)
  (typep pos 'position))

;;; Region $B%/%i%9(B
;;; bottom$B$O!"(B0$B$K6a$$$H$3$m$G$"$k!#(B

#|

 0,0
  +------------------------- x
  | (left,bottom)
  |     +--------------+
  |     |              |
  |     +--------------+
  |              (right,top)              
  y

  y
  |             (right,top)
  |     +-------------+
  |     |             |
  |     +-------------+
  |(left,bottom)
  +------------------------ x
 0,0



(defclass region 
  ()
  ((left-bottom  :type position :initarg :lb :reader left-bottom)
   (right-top  :type position :initarg :rt :reader right-top))
)

|#


;;; item$B$K0lCW$9$k<!$NMWAG$+$i$N%j%9%H$rJV$9(B
(defun find-list (item list)
        (do ((x list (cdr x)))
            ((null x) nil)
	  (if (eq (car x) item)
	      (return (second x)))))

;;; $B%j!<%8%g%s$N%/%i%9(B
(defclass region ()
  ((left :initarg :left :initform 0 :accessor region-left)
   (right :initarg :right :initform 0 :accessor region-right)
   (bottom :initarg :bottom :initform 0 :accessor region-bottom)
   (top :initarg :top :initform 0 :accessor region-top)))

;;; $B%j!<%8%g%s$N@8@.%a%=%C%I(B
(defmethod initialize-instance :after ((ob region) &rest rest 
				       &key &allow-other-keys)
  (with-slots 
   (left bottom right top) ob
   (let ((width (if (find-list :width rest)
		    (find-list :width rest)
		  (region-width ob)))
	 (height (if (find-list :height rest)
		     (find-list :height rest)
		   (region-height ob))))

	(if (/= width (+ right left))
	    (setf right (+ left width)))
	
	(if (/= height (- top bottom))
	    (setf top (+ bottom height))))
   ))
  
;;; Region $B%$%s%9%?%s%9$N%W%j%s%H%a%=%C%I(B
(defmethod print-object ((region region) stream)
  (format stream "\#<Region Left:~a Bottom:~a Right:~a Top:~a>" 
       (region-left region)
       (region-bottom region)
       (region-right region)
       (region-top region)))


;;; Region $B4XO"%a%=%C%I(B

;;; Region $B@8@.4X?t(B
(defun make-region (&key (left 0) (right 0) (bottom 0) (top 0) width height)
  (declare (inline +))
  (if width
      (setf right (+ left width)))
  (if height
      (setf top (+ bottom height)))
;  (cerror "aho" "baka")
  (if (and (integerp left) (integerp bottom) (integerp right) (integerp top))
      (make-instance 'region 
		     :left left :right right :bottom bottom :top top)
    (error "The argument is not a number. Should set a number"))
  )

;;; $B%j!<%8%g%s#1$K%j!<%8%g%s#2$NBg$-$5$r@_Dj$9$k(B
(defun set-region (region1 region2)
  (with-slots ((l1 left) (r1 right) (t1 top) (b1 bottom)) region1
     (with-slots ((l2 left) (r2 right) (t2 top) (b2 bottom)) region2
	 (setf l1 l2 r1 r2 t1 t2 b1 b2)))
  region1)

;;; Region$B$N%3%T!<%a%=%C%I(B
(defmethod region-copy ((region region))
  (make-region :left (region-left region)
	       :top (region-top region)
	       :bottom  (region-bottom region)
	       :right (region-right region)))

      
;;; region-width $B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-width) ((width integer) (region region))
  (declare (inline +))
  (with-slots (left right) region
      (setf right (+ left width))))
	    

;;; region-width$B$N%"%/%;%5(B
(defmethod region-width ((region region))
  (declare (inline -))
  (with-slots (left right) region
	      (- right left)))


;;; region-height$B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-height) ((height integer) (region region))
  (declare (inline +))
  (with-slots (bottom top) region
      (setf top (+ bottom height))))

;;; Height$B$N%"%/%;%5(B
(defmethod region-height ((region region))
  (declare (inline -))
  (with-slots (bottom top) region
	      (- top bottom)))

;;; region-p $B%*%V%8%'%/%H$,(Bregion$B$G$"$k$+(B?
(defun region-p (region)
  (typep region 'region))

;;; region-center $B%a%=%C%I(B region $B$N??Cf$r5a$a$k!#(B
(defmethod region-center ((region region) &key (return :multiple))
  (declare (inline + / round))
  (let ((center-x (+ (round (/ (region-width region) 2)) (region-left region)))
	(center-y (+ (round (/ (region-height region) 2)) 
		     (region-bottom region))))
	(case return
	    (:multiple (values center-x center-y))
	    (:position (make-position :x center-x :y center-y))
	    (t (list center-x center-y)))
	))

;;; region-contains-position-p $B%j!<%8%g%s$K%]%8%7%g%s$,F~$C$F$$$P$l(BT,
;;; $B$=$&$G$J$1$l$P!"(BNIL
(defmethod region-contains-position-p ((region region) (position position))
  (declare (inline >= <= ))
  (with-region-destuctured ((left top right bottom) region)
    (if (and (>= top (position-y position))
	     (>= right (position-x position))
	     (<= bottom (position-y position))
	     (<= left (position-x position)))
	t
        NIL)))

;;; region-contains-position-xy-p $B%j!<%8%g%s$K(BX$B$H(BY$B$,F~$C$F$$$P$l(BT,
;;; $B$=$&$G$J$1$l$P!"(BNIL
(defmethod region-contains-position-xy-p ((region region) (X integer) (Y integer))
  (declare (inline >= <=))
  (with-region-destuctured ((left top right bottom) region)
    (if (and (>= top Y)
	     (>= right X)
	     (<= bottom Y)
	     (<= left X))
	t
        NIL)))

;;;region-contains-region-p $B%j!<%8%g%s(B1$B$K%j!<%8%g%s(B2$B$,F~$C$F$$$l$P(BT
;;;$B$=$&$G$J$1$l$P(BNIL
(defmethod region-contains-region-p ((region1 region) (region2 region))
  (declare (inline >= <=))
  (with-region-destuctured ((left1 top1 right1 bottom1) region1)
    (with-region-destuctured ((left2 top2 right2 bottom2) region2)
      (if (and (<= left1 left2)
	       (>= top1 top2)
	       (>= right1 right2)
	       (<= bottom1 bottom2))
	  T
	NIL))))

;;; region-intersection $B%j!<%8%g%s$N8r$o$j$r5a$a$k!#(B
(defmethod region-intersection ((region1 region) (region2 region)
			       &key (return :mutiple) )
  (declare (inline max min))
  (let ((left 0) (top 0) (right 0) (bottom 0) (re (make-region)))
    (with-region-destuctured ((left1 top1 right1 bottom1) region1)
      (with-region-destuctured ((left2 top2 right2 bottom2) region2)
	  (setf left (max left1 left2)
 	        top  (min top1 top2)
	        right (min right1 right2)
	        bottom (max bottom1 bottom2))

	  ;;; $B?7%j!<%8%g%s$N@_Dj(B
	  (setf (region-left re) left
	        (region-right re) right
	        (region-top re) top
	        (region-bottom re) bottom)

	  ;;; $B?7%j!<%8%g%s$N%A%'%C%/(B
	  (if (not (and (region-contains-region-p region1 re)
		   (region-contains-region-p region2 re)))
	      nil
	    (case return
		  (:mutiple (values left top right bottom))
		  (:region  re)
		  (t (list left top right bottom)))
	    )))))


;;; $B%j!<%8%g%s$N%]%8%7%g%s$r5a$a$k(B $B%j!<%8%g%s$N%]%8%7%g%s$O(Bleft bottom$B$G$"$k!#(B
(defmethod region-position ((region region) &key (return :multiple))
  (case return 
	(:multiple (values (region-left region) (region-bottom region)))
	(:position (make-position :x (region-left region)
				  :y (region-bottom region)))
	(t (list (region-left region) (region-bottom region)))))

;;; $B%j!<%8%g%s$N%]%8%7%g%s$N(Bsetf 
(defmethod (setf region-position) ((new-position position)
				   (region region))
  (let ((width (region-width region))
	(height (region-height region)))

    (setf (region-left region) (position-x new-position)
	  (region-bottom region) (position-y new-position)
	  (region-width region) width
	  (region-height region) height)

    region))
    

;;;$B%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(BX Y$B$K@_Dj$9$k!#(B
(defmethod set-region-position-xy ((region region) (x number) (y number))
  (let ((width (region-width region))
	(height (region-height region)))

    (setf (region-left region) x
	  (region-bottom region) y
	  (region-width region) width
	  (region-height region) height)

  region))

;;;$B%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(Bposition$B$K@_Dj$9$k!#(B
(defmethod set-region-position ((region region) (new-position position))
  (let ((width (region-width region))
	(height (region-height region)))
    (setf (region-left region) (position-x new-position)
	  (region-bottom region) (position-y new-position)
	  (region-width region) width
	  (region-height region) height)
    region))

;;;$B%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(Bdelta-x delta-y$B$K$:$i$9!#(B
(defmethod shift-region-position ((region region) delta-x delta-y)
  (declare (inline +))
  (with-slots (left bottom right top) region
	(incf left delta-x)
	(incf right delta-x)
	(incf bottom delta-y)
	(incf top delta-y))
  region)

;;; $BFs$D$N%j!<%8%g%s$K$*$1$k!"3F!9$N:9$r5a$a$k!#(B
;;; ( (- left1 left2) (- top1 top2) (- right1 right2) (- bottom1 bottom2))
;;; $B$NCM$,5a$^$k!#(B***1 $B$O!":G=i$N%j!<%8%g%s(B ***2 $B$O!"<!$N%j!<%8%g%s(B
(defmethod region-difference ((region1 region) (region2 region))
  (declare (inline -))
  (with-region-destuctured ((left1 top1 right1 bottom1) region1)
     (with-region-destuctured ((left2 top2 right2 bottom2) region2)
       (values (- left1 left2) (- top1 top2) 
	       (- right1 right2) (- bottom1 bottom2)))))


;;; $BFs$D$N%j!<%8%g%s$rHf$Y$k!#F1$8$J$i$P(B T $B$=$&$G$J$1$l$P(BNIL
(defmethod region-equal ((region1 region) (region2 region))
  (declare (inline =))
    (with-region-destuctured ((left1 top1 right1 bottom1) region1)
     (with-region-destuctured ((left2 top2 right2 bottom2) region2)
        (if (and (= left1 left2)
		 (= top1 top2)
		 (= right1 right2)
		 (= bottom1 bottom2))
	    T
	  NIL))))

;;; $BFs$D$N%j!<%8%g%s$N$*$*$-$5$rHf$Y$k!#F1$8$J$i$P(B T $B$=$&$G$J$1$l$P(BNIL
(defmethod region-same-area ((region1 region) (region2 region))
  (declare (inline =))
  (if (and (= (region-width region1) (region-width region2))
	   (= (region-height region1) (region-height region2)))
      T
    NIL))

;;; $BFs$D$N%j!<%8%g%sLL@Q$NHf3S!#%j!<%8%g%s(B1$B$O!"%j!<%8%g%s(B2$B$h$j>.$5$1$l$P(B
;;; T$B!#$=$l0J30$J$i$P(BNIL
(defmethod region-smaller-p ((region1 region) (region2 region))
  (declare (inline abs * <))
   (let ((menseki1 (abs (* (region-width region1) (region-height region1))))
	 (menseki2 (abs (* (region-width region2) (region-height region2)))))
     (if (< menseki1 menseki2)
	 T
       NIL)))

;;; $BFs$D$N%j!<%8%g%sLL@Q$NHf3S!#%j!<%8%g%s(B1$B$O!"%j!<%8%g%s(B2$B$h$jBg$-$1$l$P(B
;;; T$B!#$=$l0J30$J$i$P(BNIL
(defmethod region-larger-p ((region1 region) (region2 region))
  (declare (inline abs * >))
   (let ((menseki1 (abs (* (region-width region1) (region-height region1))))
	 (menseki2 (abs (* (region-width region2) (region-height region2)))))
     (if (> menseki1 menseki2)
	 T
       NIL)))

;;; $BFs$D$N%j!<%8%g%s$r4^$`%j!<%8%g%s$r5a$a$k!#(B
(defmethod region-union ((region1 region) (region2 region))
  (declare (inline min max))
  (make-region :left (min (region-left region1) (region-left region2))
	       :top (max (region-top region1) (region-top region2))
	       :right (max (region-right region1) (region-right region2))
	       :bottom (min (region-bottom region1) (region-bottom region2)))
  )

;;; $BFs$D$N%j!<%8%g%s$r4^$`%j!<%8%g%s$r5a$a$k!#(B
;;; region1 $B$,GK2u$5$l$k(B
(defmethod region-union-no-copy ((region1 region) (region2 region))
  (with-slots 
   ((l1 left) (b1 bottom) (r1 right) (t1 top)) region1
   (with-slots 
    ((l2 left) (b2 bottom) (r2 right) (t2 top)) region2
    (setf l1 (min l1 l2) b1 (min b1 b2) t1 (max t1 t2) r1 (max r1 r2))
    region1)))
  

;;; $BIA2h%j!<%8%g%s$KIA2h%(%j%"$r@_Dj%a%=%C%I(B
(defmethod  set-drawing-region ((drawing-region region) (set-region region))
  (declare (inline max min))
  (with-accessors ((left1 region-left) (right1 region-right)
                   (top1 region-top) (bottom1 region-bottom))
                  drawing-region
     (with-accessors ((left2 region-left) (right2 region-right)
                      (top2 region-top) (bottom2 region-bottom)) set-region
           (setf left1 (min left1 left2)
                 right1 (max right1 right2)
                 top1 (max top1 top2)
                 bottom1 (min bottom1 bottom2)))
     ))

(defmethod  set-drawing-region ((drawing-region NULL) (set-region region))
  (values drawing-region set-region)
  )


;;; $BM?$($i$l$?%j!<%8%g%s$N%3%T!<$r:n$k(B
(defmethod copy-region ((region region))
  (make-region :left (region-left region) :right (region-right region)
	       :top (region-top region) :bottom (region-bottom region)))


;;; $BFs$D$N%j!<%8%g%s(B(region1,region2)$B$r4^$_!"(B
;;; region1$B$+$i$O$_=P$7$F$$$kJ}$K0lDjNL$r2C$($k(B
;;; x$BJ}8~$O!"(Bexpand-width ,y$BJ}8~$K$O(Bexpand-height 
;;; $B$b$7$O$_=P$7$F$$$J$1$l$P!"Bg$-$$J}$N%j!<%8%g%s$rJV$9(B
(defmethod region-union-expand ((region1 region) (region2 region)
				(region3 region)
				(expand-width integer)
				(expand-height integer))
  (declare (inline /= decf incf))
  (let* ((left1 (region-left region1))
	 (left2 (region-left region2))
	 (top1 (region-top region1))
	 (top2 (region-top region2))
	 (right1 (region-right region1))
	 (right2 (region-right region2))
	 (bottom1 (region-bottom region1))
	 (bottom2 (region-bottom region2))
	 (left (min left1 left2))
	 (top (max top1 top2))
	 (right (max right1 right2))
	 (bottom (min bottom1 bottom2)))

    (when (/= left1  left)
	  ;;; REGION2$B$,:8$K$O$_=P$7$F$$$k(B
	  (decf left expand-width))

    (when (/= top1 top)
	  ;;; region2$B$,>e$K$O$_=P$7$F$$$k(B
	  (incf top expand-height))

    (when (/= right1 right)
	  ;;; region2$B$,1&$K$O$_=P$7$F$$$k(B
	  (incf right expand-width))

    (when (/= bottom1 bottom)
	  ;;; region2 $B$,2<$K$O$_=P$7$F$$$k(B
	  (decf bottom expand-height))

    (setf (region-left region3) left
	  (region-right region3) right
	  (region-top region3) top
	  (region-bottom region3) bottom)
    region3))


;;; $BM?$($i$l$?%]%8%7%g%s$K:G$b6a$$%j!<%8%g%s$N3Q$N%]%8%7%g%s$rJV$9(B
(defmethod near-corner ((region region) (pos position))
  (declare (inline <= abs -))
  (let ((p-x
	 (if (<= (abs (- (region-left region)
			 (position-x pos)))
		 (abs (- (region-right region)
			 (position-x pos))))
	     (region-left region)
	   (region-right region)))
	(p-y 
	 (if (<= (abs (- (region-bottom region)
			 (position-y pos)))
		 (abs (- (region-top region)
			 (position-y pos))))
	     (region-bottom region)
	   (region-top region))))
    (make-position :x p-x :y p-y)))

;;; $BM?$($i$l$?%]%8%7%g%s$K:G$b6a$$%j!<%8%g%s$N3Q$N%]%8%7%g%s$rJV$9(B
(defmethod near-corner-xy ((region region) x y)
  (declare (inline <= abs -))
  (let ((p-x
	 (if (<= (abs (- (region-left region)
			 x))
		 (abs (- (region-right region)
			 x)))
	     (region-left region)
	   (region-right region)))
	(p-y 
	 (if (<= (abs (- (region-bottom region)
			 Y))
		 (abs (- (region-top region)
			 y)))
	     (region-bottom region)
	   (region-top region))))
    (values p-x p-y)))

;;;; End of primitive.lisp 







