;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%W%l%<%s%F!<%7%g%s4XO"(B
;;; presentation.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%W%l%<%s%F!<%7%g%s%/%i%9(B
;;; 3/13 1990 $B8E:d(B
;;; Version 1.0   Corded by t.kosaka 1990-3-13
;;; Version 1.3   Corded by T.kosaka 1990-12-19

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%W%l%<%s%F!<%7%g%s%/%i%9(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass yy-presentation (event-method-mixin)
 ((presentation-class :initarg :presentation-class
                     :accessor presentation-class)
  (presentation-keyword :initarg :presntation-keyword
                       :accessor presentation-keyword)
  (instance :initarg :instance :accessor instance)
  (presentation-stream :initarg :presentation-stream
                       :accessor presentation-stream)
  (drawing-sequence :initarg :drawing-sequence :initform '(nil)
                    :accessor drawing-sequence)
  (after-drawing-list :accessor after-drawing-list
                      :initform '(nil))
  ;;; $BI=<($7$?%$%s%9%?%s%9$,0\F0$G$-$k$+!)(B
  (presentation-move-mode :initarg :presentation-move-mode
			  :initform :move-mode
			  :accessor presentation-move-mode)
  (yy-presentation-territory-no :accessor yy-presentation-territory-no)
  (presentation-region :initarg :presenation-region
                       :accessor presentation-region)
  ))

;;; $B%W%l%<%s%F!<%7%g%s$rGK2u$9$k(B
;;; flush-presentation presentation &optional (territory T)
;;; ARG.
;;;          presentation = $B%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9(B
;;;          territory    = $B$b$7(BT$B$J$i$P%F%j%H%j!<$NGK2u(B
(defmethod flush-presentation ((presentation yy-presentation)
                               &optional (territory T))
  ;;; $B4XO"IU$1$r2r=|(B
  (delete-lisp-object (yy-presentation-territory-no presentation))

  ;;; $B?F$+$i<h$j=|$/(B
  (setf (present-list (presentation-stream presentation))
    (delete presentation (present-list (presentation-stream presentation))))

  (if territory
      (yy-protocol-5 (yy-presentation-territory-no presentation)))

  (setf (yy-presentation-territory-no presentation) nil))



;;; $B%W%l%<%s%F!<%7%g%s$N?F$rJV$9(B
(defmethod parent-stream ((presentation yy-presentation))
  (presentation-stream presentation))

;;; $B%*%V%8%'%/%H$N$"$k0LCV$r%k!<%H%&%#%s%I%&%9%H%j!<%`$+$i$N0LCV$KJQ99$7$?(B
;;; $B0LCV$r5a$a$k(BXY$BMQ%W%l%<%s%F!<%7%g%sMQ(B
(defmethod translate-root-xy ((object yy-presentation) x y)
  (translate-root-xy (presentation-stream object)
		     (+ x (region-left (presentation-region object)))
		     (+ y (region-bottom (presentation-region object))))
  )

;;; $B%$%Y%s%H%a%=%C%I%_%-%7%s$N%"%/%;%C%5(B SETF
(defmethod (setf event-mask) :after ((new-mask integer)
                              (event-method yy-presentation))
  (setf (slot-value event-method 'event-mask)
        (logior new-mask (slot-value event-method 'event-mask)))
  (yy-protocol-72 (yy-presentation-territory-no event-method)
		  (slot-value event-method 'event-mask)))

;;; $B%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B setf
(defmethod (setf button1-method) :after (new-value
                                       (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B:8%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B SETF
(defmethod (setf left-button-down-1-method) :after (new-value
                                       (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $BCf%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B SETF
(defmethod (setf middle-button-down-1-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B1&%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf right-button-down-1-method) :after (new-value
                            (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf button-up-method) :after (new-value
                                     (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B:8%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf left-button-up-method) :after (new-value
                            (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $BCf%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf middle-button-up-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B1&%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf right-button-up-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf button2-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B:8%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf left-button-down-2-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $BCf%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf middle-button-down-2-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B1&%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf right-button-down-2-method) :after (new-value
                           (event-method yy-presentation))
  (if new-value
    (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%^%&%9%+!<%=%k$,F0$/$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf move-mouse-cursor-method) :after (new-value
                           (event-method yy-presentation ))
  (if new-value
    (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))
	    

;;; $B%^%&%9%+!<%=%k$,F~$C$?;~$K5/F0$9$k%a%=%C%I(B
(defmethod (setf mouse-cursor-in-method) :after (new-value
                           (event-method yy-presentation))
  (when new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B%^%&%9%+!<%=%k$,=P$?;~$K5/F0$9$k%a%=%C%I(B
(defmethod (setf mouse-cursor-out-method) :after (new-value
                           (event-method  yy-presentation))
  (if new-value
    (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B%^%&%9%+!<%=%k$,$"$kNN0h$G(BN$B%_%jICDd;_$7$?;~$K5/F0$9$k%a%=%C%I(B
(defmethod (setf mouse-cursor-wait-method) :after (new-value
                           (event-method yy-presentation))
  (if new-value
      (yy-protocol-72 (yy-presentation-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B%$%Y%s%H$N0l;~Dd;_(B $B%W%l%<%s%F!<%7%g%sMQ(B
(defmethod disnable-event ((presentation yy-presentation) mask)
  (declare (function yy-presentaion-territory-no (t) integer))
  (let* ((old-mask (event-mask presentation))
         (new-mask (logand (lognot mask) old-mask)))
    (yy-protocol-72 (yy-presentaion-territory-no presentation) new-mask)))



;;;$B%$%Y%s%H$N2sI|(B $B%W%l%<%s%F!<%7%g%sMQ(B
(defmethod enable-event ((presentation yy-presentation))
  (declare (function yy-presentaion-territory-no (t) integer))
  (yy-protocol-72 (yy-presentaion-territory-no presentation)
                  (event-mask presentation)))








