;;; -*- Mode: LISP; Syntax: Common-lisp; Package: user; Base: 10 -*-
;;; presentation-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;             All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.2 90/12/15 by t.kosaka


(in-package :yy)



;;; presentation-classp
;;; $B;XDj$7$?%$%s%9%?%s%9$,!";XDj$7$?%/%i%9$G$"$k$+D4$Y$k!#(B
;;; presentation-classp ob type-list
;;; ob        -> $B%$%s%9%?%s%9(B
;;; type-list -> $B%/%i%9%j%9%H(B
;;; ret       <- T or NIL
(defun presentation-classp (ob type-list)
  (let* ((temp (gentemp))
	 (new-arg (get-list type-list))
	 (form nil))
    (if (not (listp type-list))
	(setf new-arg (list type-list))
      (if (and (not (listp (car type-list))) 
	       (not (member (car type-list) '(and or not))))
	  (setf new-arg (list type-list))
	))
      
;(print new-arg)
    ;;; $B<B9T%U%)!<%`$r:n$k(B
    (setf form (replace-type-list new-arg temp))

    (if (not (member (car form) '(and not or)))
	(setf form (car form)))
;(print form)
    (setf (symbol-value temp)
      (if  (listp ob)
	  `(quote ,ob)
	ob))
    (eval form)))

;;; presentation-subclassp
;;; $B;XDj$7$?%W%l%<%s%F!<%7%g%s%/%i%9$,!";XDj$5$l$?%?%$%W$N%5%V%/%i%9$+D4$Y$k(B
;;; presentation-subclassp type1 type2
;;; type1     -> $BD4$Y$?$$%?%$%W(B
;;; type2     -> $B%?%$%W(B
;;; ret       <- T or NIL
(defun presentation-subclassp (type1 type2)
  (let* ((new-arg2 (get-list type2))
	 (temp (gentemp))
	 (form nil))
    (if (not (listp type2))
	(setf new-arg2 (list type2))
      (if (and (not (listp (car type2))) 
	       (not (member (car type2) '(and or not))))
	  (setf new-arg2 (list type2))
	))
      
    ;;; $B<B9T%U%)!<%`$r:n$k(B
    (setf form (replace-type-list-for-subtype new-arg2 temp))

    (if (not (member (car form) '(and not or)))
	(setf form (car form)))

    (setf (symbol-value temp) (m-list type1))
    
    (eval form)))


;;; $B%j%9%H$N@hF,%j%9%H$r5a$a$k(B
(defun get-list (ob)
       (if (typep ob 'list)
           (if (typep (car ob) 'list)
               (get-list (car ob))
             ob)
         ob))


;;; $B%?%$%W%j%9%H$NCV49(B
;;; presentation-classp$BMQ(B
(defun replace-type-list (list ob)
  (mapcar #'(lambda (x)
      (case x
	(and `and)
	(or  'or)
	(not 'not)
	(t 
	 (if (and (listp x) (member (get-top x) '(and or not)))
	     (replace-type-list (get-list x) ob)
	   (cond 
	    ((eq (get-top x) 'member)
	       (list 'member-engine ob `(quote ,(cdr (get-list x)))))
	    ((eq (get-top x) 'satisfies)
	     (list `(quote ,(cdr (get-list x))) ob))
	    (t
	     (if (listp x)
		 (list 'type-engine ob `(quote ,(get-top x))
		   `(quote ,(cdr (get-list x))))
	       (list 'type-engine ob `(quote ,x))))
	    )))
	)
      )
      list))

;;; $B%?%$%W%j%9%H$NCV49(B
;;; presentation-subclassp$BMQ(B
(defun replace-type-list-for-subtype (list ob-list)
  (mapcar #'(lambda (x)
      (case x
	(and `and)
	(or  'or)
	(not 'not)
	(t 
	 (if (and (listp x) (member (get-top x) '(and or not)))
	     (replace-type-list-for-suntype (get-list x) ob-list)
	   (cond 
	    ((eq (get-top x) 'member)
	       (list 'member-engine (car ob-list) `(quote ,(cdr (get-list x)))))
	    ((eq (get-top x) 'satisfies)
	     (list `(quote ,(cdr (get-list x))) (car ob-list)))
	    (t
	     (if (listp x)
		 (list 'type-type-engine ob-list `(quote ,(get-top x))
		   `(quote ,(cdr (get-list x))))
	       (list 'type-type-engine ob-list `(quote ,x))))
	    )))
	)
      )
      list))


;;; type-engine
;;; $B7?$H%*%V%8%'%/%H$K$h$kH=Dj%(%s%8%s(B
(defun type-engine (ob type &optional args)
  (let* ((p-type-list (get type 'yy-presentation))
	 (new-arg (make-normal-list args))
	 (no-types (append (list type) new-arg))
	 (ret nil))

    (if p-type-list
	;;; $B7?;XDj2h$"$k(B
	(dolist (item p-type-list)
	  ;;                   (format t "~a ~a~%" (data-arg item) new-arg)
	  (dolist (str (check-methods item))
	    (when (check-argument (check-method-args str) new-arg)
	      (if (check-method-function str)
		  (setf ret (apply (check-method-function str)
				   (nconc (list item ob) new-arg))))
	      (return)))
	  )
      ;;;$B7?;XDj$,$J$$(B
      (setf ret (typep-yy ob no-types)))
    ret))

;;; member-engine
;;; $B%a%s%P!<$K$h$kH=Dj%(%s%8%s(B
(defun member-engine (ob list)
  (let ((ret nil))
    (dolist (item s-list)
      (when (equal ob item)
	(setf ret T)
	(return))
      )
    ret))

;;; type-type-engine 
;;; $B7?$H@8@.$7$?%*%V%8%'%/%H$NH=Dj%(%s%8%s(B
(defun type-type-engine (type-list type &optional args)
  (let* ((p-type-list (get type 'yy-presentation))
         (new-arg (make-normal-list args))
         (no-types (append (list type) new-arg))
	 (new-type (marge-type (car type-list) (cdr type-list) args))
	 (ob nil)
         (ret nil))

    (setf ob (car (make-any-object new-type)))

    (when ob
      (if p-type-list
              ;;; $B7?;XDj2h$"$k(B
	  (dolist (item p-type-list)
	    (dolist (str (check-methods item))
	      (when (check-argument (check-method-args str) new-arg)
		(if (check-method-function str)
		    (setf ret (apply (check-method-function str)
				     (nconc (list item ob) new-arg))))
		(return)))
	    )
             ;;;$B7?;XDj$,$J$$(B
	(setf ret (typep-yy ob no-types)))
      )
    ret))
  

;;; marge-type 
;;; $B%?%$%W$H!"%?%$%W$r%^!<%8$7$?%?%$%W$r$D$/$k(B
(defun marge-type (type-name type1 type2)
  (let ((ret nil)
	(max (max (length type1) (length type2))))

    (dotimes (i max)
      (if (or (eq '* (nth i type1)) (null (nth i type1)))
	  (push (nth i type2) ret)
	(push (nth i type1) ret)))

    (if ret
	(nconc (list type-name) (reverse ret))
      (list type-name))
    ))


;;; typep-yy
;;; $B%?%$%W0z?t$K%-!<%o!<%I!"$r;H$($k$h$&$K$7$?(B
;;; typep-yy object type-list
(defun typep-yy (object type-list)
  (let ((ret nil))
    (if (get-key-word type-list)
        ;;; $B%-!<%o!<%I0z?t$,$"$k(B
	(if (eq 'STANDARD-CLASS
		(intern (string 
			 (class-name 
			  (class-of (find-class (car type-list) nil))))))
	    (setf ret (typep-yy-class object type-list))
	  (setf ret (typep-yy-structure object type-list)))

      (setf ret (typep object (if (cdr type-list)
				       type-list
				       (car type-list)))))
    ret))

;;; $B%/%i%9$N%?%$%WH=Dj(B
(defun typep-yy-class (object type-list)
  (let ((ret nil))
    
    (if (typep object (car type-list))
	;;; $B%f!<%6Dj5A%/%i%9(B
	(let ((len (length (cdr type-list)))
	      (i 1))
	  (loop
	   (if (zerop len)
	       (return))

	   (if (slot-exists-p object (intern 
				      (string (nth i type-list))))
	       (if (not (equal (slot-value object 
					   (intern (string (nth i type-list))))
			       (nth (incf i) type-list)))
		   (progn (setf ret NIL)
			  (return))
		 (setf ret T))
		     
	     (progn 
	       (setf ret nil)
	       (return)))

	   (decf len 2)
	   (incf i))
	  ))
    ret))

;;; $B9=B$$NH=Dj(B
(defun typep-yy-structure (object type-list)
  (let ((ret nil))
     ;;; $B9=B$(B
    (if (eq (car type-list) (type-of object))
	(let ((len (length (cdr type-list)))
	      (f-name nil)
	      (i 1))
	  (loop
	   (if (zerop len)
	       (return))

	   (if (setf f-name 
		     (structure-slot-exists-p object 
				   (intern (string (nth i type-list)))))
	       (if (equal (apply (intern (string f-name))
				 (list object))
			  (nth (incf i) type-list))
		   (setf ret T)
		 (progn
		   (setf ret NIL)
		   (return)))
	     (progn 
	       (setf ret nil)
	       (return)))
		 
	   (incf i)
	   (decf len 2)
	   )
	  )
      )
    ret))

;;; m-list
;;; $B%j%9%H$G$"$l$P%j%9%H$r!"%"%H%`$G$"$l$P%"%H%`$N%j%9%H$rJV$9(B
;;; m-list any
;;; ret list
(defun m-list (object)
  (if (listp object)
      object
    (list object)))

;;; number-type 
;;; $B7?$K9g$o$;$??t;z$r$D$/$k(B
;;; number-type type
(defun number-type (type)
  (let* ((new-arg (m-list type))
	 (second (second new-arg)))

    (if (or (and second (or (numberp second )
			(eq '* second)))
	    (null second))
	(case (car new-arg)
	  ((integer fixnum)
	   (if (and second (not (eq '* second )))
	       second
	     most-negative-fixnum))

	  (rational
	   (if (and sencod (not (eq '* second)))
	       second
	     most-negtive-long-float))

	  (float
	   (if (and second (not (eq '* second)))
	       second
	     most-negtive-long-float))

	  (short-float
	   (if (and second (not (eq '* second)))
	       second
	     most-negative-short-float))

	  (single-float
	   (if (and second (not (eq '* second)))
	       second
	     most-negative-single-float))

	  (double-float
	   (if (and second (not (eq '* second)))
	       second
	     least-negative-double-float))

	  (long-float
	   (if (and second (not (eq '* second)))
	       second
	     most-negative-long-float))
	  )
      nil))

  )

;;; make-any-object 
;;; $B%W%l%<%s%F!<%7%g%s%?%$%W$h$j!"%*%V%8%'%/%H$r@8@.(B
;;; make-any-object presentationtype
;;; presentatation-type    -> presentation-keyword $B$r=|$$$?%?%$%W(B
;;; ret                    <- $B%*%V%8%'%/%H%j%9%H(B
;;; $B%*%V%8%'%/%H%j%9%H$O(B(object)$B$b$7$/$O(B(object arg1 arg2)$B$G!"7?;XDj;R(B
;;; $B$N=gHV$HF1$8$G$"$k!#(Barg1,arg2$B$O!v$,;XDj$5$l$?;~$K!v$H$J$k(B
(defun make-any-object (type-list)
  (let* ((type-name (get-top (m-list type-list)))
	 (args (cdr (get-list (m-list type-list))))
	 (first (first args))
	 (second (second args)))
    
    (case type-name

      ((array simple-array simple-vector vector)  ;;; array$B$N>l9g(B

       (if (second args)
	   (if (member '* (m-list second))
	       (if (or (not first) (eq '* first))
		   (list (make-array 1) '* secnd)
		 (if (eq 'symbol (type-of first))
		     (list (make-array 1 :elemet-type first) 
			   first secnd)
		   nil))

	     (if (or (not first) (eq '* first))
		 (list (make-array second) secnd first)
	       (if (eq 'symbol (type-of first))
		   (list (make-array second :element-type first)
			 second first)
		 nil)))
	 (if (or (not first) (eq '* first))
	     (list (make-array 1) first '*)
	   (if (eq 'symbol first)
	       (list (make-array 1 :element-type first) first '*)
	     nil))))

      (atom ;;; $B%"%H%`$N>l9g(B
       (list 'yy))
      
      (bignaum  ;;; Bignum $B$N>l9g(B
       (list 999999999999999999))
			   
      (bit ;;; Bit $B$N>l9g(B
       (list (bit #*1 0)))

      ((bit-vector simple-bit-vector) ;;; Bit $B%Y%/%?!<$N>l9g(B
       (if (not (eq '* first))
	   (if (numberp first)
	       (list (make-array first :element-type 'bit) first )
	     nil)
	 (list #*10 '*)))

      ((character standard-char string-char) ;;; $BJ8;z$N>l9g(B
       (list #\a))

      (common ;;; Common Lisp object $B$N>l9g(B
       (list T))

      (compiled-function ;;; $B%3%s%Q%$%k$5$l$?4X?t$N>l9g(B
       (list (symbol-function 'write)))
      
      (complex ;;; Complex $B$N>l9g(B
       (if (not (member '* (m-list (first args))))
	   (if (number-type first)
	       (list (complex (number-type first)
			      (number-type first)) first)
	     nil)
	 (list (comlex 10 10) '*)))

      ((cons list) ;;; $B%3%s%9$N>l9g(B
       (list '(1)))

      ((double-float fixnum float integer  ;;; $B?t$K4X78$"$k>l9g(B
	long-float short-float single-float)
       (let ((ret (number-type (get-list type-list))))
	 (if ret 
	     (list ret  first)
	   nil)))


      (function  ;;; $B4X?t$N>l9g(B
       (if first
	   (error "The function type specifier cannot be used for discrimination")
	 (list (symbol-function 'check-argument))))

      (hash-table ;;; $B%O%C%7%eI=$N>l9g(B
       (list (make-hash-table)))

      (keyword ;;; $B%-!<%o!<%I$N>l9g(B
       (list :yy))

      (mod ;;; mod$B$N>l9g(B
       (if (and first (not (eq '* first)))
	   (if (numberp fisrt)
	       (list (- first 1) first)
	     nil)
	 (list 1 first)))
	   
      ('nil  ;;; NIL$B$N>l9g(B
       (list nil))
      
      (null ;;; NULL $B$N>l9g(B
       (list 'null))

      (number  ;;; $B?t$N>l9g(B
       (list 1))

      (package  ;;; $B%Q%C%1!<%8$N>l9g(B
       (list *package*))

      (pathname ;;; $B%Q%9L>$N>l9g(B
       (list (pathname "")))

      (random-state ;;; $BMp?t$N>uBV$N>l9g(B
       (list *random-state*))

      (ratio ;;; $BJ,?t$N>l9g(B
       (list (/ 1 3)))

      (rational ;;; rational$B$N>l9g(B
       (list (rational 2.2)))

      (read-table ;;; read-table$B$N>l9g(B
       (list *readtable*))

      (sequence  ;;; $B%7!<%1%s%9$N>l9g(B
       (list 'sequence*))
       
      ((simple-string string) ;;; $BJ8;zNs$N>l9g(B
       (if (and first (not (eq '* first)))
	   (if (numberp first)
	       (list (make-string first) first)
	     nil)
	 (list "yy" '*)))
       
      (stream ;;; $B%9%H%j!<%`$N>l9g(B
       (list *terminal-io*))

      (symbol
       (list (gentemp)))
       
      (t
       (if (eq 't type-naem)
	   (list T)
	 (user-defind-class type-name args)))
    )))

;;; user-defind-class
;;; $B%f!<%6Dj5A%/%i%9(B
;;; user-defined-class class-name args 
;;; args    class-name    -->  $B%/%i%9L>(B
;;;         args          -->  $B0z?t(B
(defun user-defined-class (name args)
  ;;; $B%f!<%6Dj5A$N(Bpresentation-class 
  (if (get name 'yy-presentation)
      (let ((praent-name
	     (presentation-paernt (get name 'yy-presntaion))))
	;;; $B?F$,$J$/$J$k$^$G7+$jJV$9(B
      (loop 
       (if (null praent-name)
	   (return)
	 (setf praent-name 
	       (presentation-paernt (get praent-name 'yy-presntaion))))
       )
      (make-any-object (push parent-name args)))
    ;;;; $B%f!<%6Dj5A$N%/%i%9$+!)(B
    (if (eq 'STANDARD-CLASS
	    (intern (string (class-name (class-of (find-class name nil))))))
	;;;; $B%f!<%6Dj5A%/%i%9(B
	(let ((instance (make-instance name))
	      (len (length args))
	      (i 0)
	      (ok T))
	  (loop 
	   (if (zerop len)
	       (return))
	   (if (slot-exists-p instance (intern (string (nth i args))))
	       (setf (slot-value instance (intern (string (nth i args))))
		     (nth (incf i) args))
	     (progn (setf ok nil) (return)))
	    (decf len 2)
	    (incf i))
	  (if ok
	      (list instance)
	  nil))
      ;;; $B%9%H%i%/%A%c!<(B
      (let ((instance (apply (intern (format nil "MAKE-~a" name))))
	    (len (length args))
	    (f-name nil)
	    (new-arg nil)
	    (ok T)
	    (i 0))
	(loop
	 (if (zerop len)
	     (return))
	 (if (setf f-anme (structure-slot-exists-p instance
				 (intern (string (nth i args)))))
	     (progn 
	      (pop (nth (+ i 1) args) new-arg)
	      (pop (nth i args) new-arg))
	   (progn (setf ok nil) (return)))
	 (incf i 2)
	 (decf len 2))
	
	(if ok 
	    (list (apply (intern (format nil "MAKE-~a" name)) (new-arg)))
	  nil))
      )
    ))

;;; structure-slot-exists-p 
;;; $B%9%H%i%/%A%c!<$N%9%m%C%H$,$"$l$P!"%"%/%;%94X?t$r$+$($9(B
(defun structure-slot-exists-p (object slot-name)
  (let ((function (intern (format nil "~a-~a" (type-of object) slot-name))))
    (if (fboundp function)
	function
      nil)))

;;; check-argument
;;; $B0z?t$N;XDj$rD4$Y$k!#(Bparameter-specializer-name$B$O!"%A%'%C%/$7$J$$!#(B
;;; check-argument arg1 arg2
;;; arg1         ->  $B0z?t#1(B $B%a%=%C%I$N(Blambda-list
;;; arg2         ->  $B0z?t#2(B $B8F$S$@$7$N0z?t(B
;;; ret          <-  $B0lCW$9$l$P(BT$B!"$=$&$G$J$1$l$P(BNIL
(defun check-argument (arg1 arg2)
  (let ((count 0)
	(any-key nil)
	(auxflg nil)
	(optional (list-of-optional '&optional arg1))
	(keyword (set-keyword (list-of-optional '&key arg1)))
	(rest (list-of-optional '&rest arg1))
	(new-arg1 (copy-alist arg1))
	(item nil)
	(new-arg2 nil)
	(ret nil))

    ;;; &allow-other-keys $B$N%5!<%A(B
    (if (find '&allow-other-keys new-arg1)
	(setf any-key t))

    ;;; &aux$B$$$3$&$r$H$j=|$/(B
    (setf new-arg1 (mapcan #'(lambda (x) (if (eq '&aux x)
				    (setf auxflg T)
				  (if (not auxflg)
				      (list x))))
		  new-arg1))

    ;;; $B%-!<%o!<%I0z?t$^$G$N0z?t(B
    (dolist (item new-arg1)
      (if (member item '(&optional &key &rest))
	  (return)
	(incf count)))

    (if (< (length arg2) count)
	(setf ret nil)
	(if rest
	    (setf ret t)
           ;;; $B0z?t$NHf3S(B
	  (progn 
	    (setf new-arg2 (nthcdr count arg2))

	    ;;; $B%-!<%o!<%I0z?t$+$i(B
	    (when keyword
	      (loop
		(setf item (nth count new-arg2))
		(if (null item)
		    (return))
		(when (keywordp item)
		  (if any-key
		      (progn (setf ret t)
			     (return))
		    (if (not (member item keyword))
			(return)
		      (incf count)))
		  (incf count))))
	    ;;; optonal
	    (if (> (length (nthcdr count arg2)) (length optional))
		(setf ret nil)
	      (setf ret t)))
	  )
	)
    ret))
		    

;;;list-ob-optional
;;; $B;XDj$7$?%-!<%o!<%I0z?t0J9_$N%j%9%H$rJV$9(B
(defun list-of-optional (optinal list)
  (let ((flg nil))
    (mapcan #'(lambda (x)
       (if (eq optinal x)
	   (setf flg t)
	 (if flg
	     (if (member x '(&rest &key &optional))
		 (setf flg nil)
	       (if (listp x)
		   (list (car x))
		 (list x)))
	   )))
	    (list* list))))
	 
;;; set-keyword
;;; $B%-!<%o!<%I0z?t$K$9$k(B
(defun set-keyword (list)
  (mapcan #'(lambda (x)
	       (list (read-from-string (format nil ":~a" (string x)))))
	  list))
 

;;; take-out-keyword
;;; $B%-!<%o!<%I0z?t$r=|$$$?%j%9%H$r$+$($9(B
(defun take-out-keyword (list)
  (let ((flg nil))
    (mapcan #'(lambda (x)
		(if (keyowrdp x)
		    (setf flg t)
		  (if (not flg)
		      (list x)
		    (setf flg nil))))
	    list)))

;;; make-normal-list
;;; $BLZ9=B$%j%9%H$r%j%9%H$K$9$k(B
;;; make-normal-list list
;;; lisp  ->  $BLZ9=B$%j%9%H(B
(defun make-normal-list (data)
  (mapcar #'(lambda (x)
	      (get-top x)) data))

;;; $B%j%9%H$N@hF,$N%j%9%H$rJV$9(B
(defmethod get-top-list ((data list))
  (if (listp (car data))
      (car data)
    data))




