;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; եΥƥȥɥ
;;; This file is EUC code.
;;; graphic-test.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/02/26 by t.kosaka
;;;

;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

(in-package :yy)

;;;  --------------  饤 -------------------------

;;; Хå饦ɤοɽ륪֥Ȥοɽ
(defclass color-value ()
  ((color :initarg :color :accessor color :initform *white-color*)
   (back-color :initarg :back-color :accessor back-color 
	       :initform *black-color*)))

;;; 饤ư饹
(defclass slider-piece (event-drawable-piece)
  ((color-value  :initarg :color-value :initform nil :accessor color-value)
   (back-color :initarg :back-color :initform *white-color* 
	       :accessor back-color)
   (old-x :initform nil :accessor old-x)
   (current-x :initform 0 :accessor current-x)))

;;; 饤͡ɽʸ򰷤饹
(defclass slider (piece-region)
    ;;; ȥʸ
  ((title-slot :initarg :title-slot :initform nil :accessor title-slot)
   (value-slot :initarg :value-slot :initform nil :accessor value-slot)
   (piece-slot :initarg :piece-slot :initform nil :accessor piece-slot)
   (color-value  :initarg :color-value :initform nil :accessor color-value)
   ))

;;; 饤ͤȤ
(defmethod get-slider-value ((ob slider))
  (let ((val (value-slot ob)))
    (with-slots (value offset) val
		(funcall offset value))))

;;; 饤κɽ
(defun redisplay-slider (ob)
  (redisplay-slider-title (title-slot ob))
  (redisplay-slider-piece (piece-slot ob) 
			 (slot-value  (value-slot ob) 'value)))

;;; 饤Υȥɽ륯饹
(defclass slider-title (piece-region)
  ((title :initarg :title :initform "" :accessor title)
   (color-value  :initarg :color-value :initform nil :accessor color-value)))

(defvar *g1* (defgeneric (setf title) (a b)))

(defvar *after1* nil)

(if *after1*
    (remove-method *g1* *after1*))

;;; ȥ뤬ѹ줿Ȥκɽ᥽å
(setf *after1* (defmethod (setf title) :after (string (ob slider-title))
#-:PCL
  (declare (ignore string))
  (redisplay-slider-title ob)))

;;; ɽ
(defun redisplay-slider-title (ob)
  (declare (special *default-font*)) 
  (draw-piece-color ob (back-color (color-value ob)))
  (draw-piece-string ob 0 (font-kanji-base-line *default-font*)
		     (title ob) :color (color (color-value ob))))

;;; 饤ͤɽ륯饹  
(defclass slider-value (piece-region)
  ((value :initarg :value :initform 0 :accessor value)
   (offset :initarg :offset :initform #'+ :accessor offset)
   (color-value  :initarg :color-value :initform nil :accessor color-value)
   (a-list :initarg :a-list :initform nil :accessor a-list)
   (form :initarg :form :accessor form :initform nil)))

(defvar *g2* (defgeneric (setf value) (a b)))

(defvar *after2* nil)

(if *after2*
    (remove-method *g2* *after2*))


;;; ͤѹɽ᥽å
(setf *after2* (defmethod (setf value) :after (val (ob slider-value))
  (declare (special *default-font*))
  (draw-piece-color ob (back-color (color-value ob)))
  (let* ((string (write-to-string (round (funcall (offset ob) val))))
         (len (font-string-length *default-font* string)))
    (draw-piece-string ob (- (region-width ob) len)
		     (font-kanji-base-line *default-font*)
		     string
		     :color (color (color-value ob)))
    (funcall (form ob) (car (a-list ob)) (round (funcall (offset ob) val)))
    )))



;;; 饤ΰưκɽ
(defun redisplay-slider-piece (ob x)
  (if (old-x ob)
      (draw-piece-line ob (old-x ob) 1 (old-x ob) (- (region-height ob) 2)
		       :width 4 :color (color (color-value ob)))
    (progn (setf (old-x ob) 0) 
	   (draw-piece-color ob (color (color-value ob)))))

  (setf (old-x ob) (current-x ob)
	(current-x ob) x)
  (draw-piece-line ob x 1 x (- (region-height ob) 2) :width 4
		   :color (back-color (color-value ob)))

  (setf (value (value-slot (object-parent ob))) x)
  )

;;; ޥˤưؿ
(defun move-slider (ob state)
  (declare (special *mouse-button-down-1*))
  (if (not (zerop (logand (mouse-state-button-state state)
			  *mouse-button-down-1*)))
      ;;; ƤȤͤѹ	
      (redisplay-slider-piece ob (mouse-state-x-position state))))

(defun button-slider (ob state)
  (declare (ignore ob state))
  (values))

;;; 饤ؿ
;;; ꤵ뿧饤Τͤ򼨤ˤʤ롣
;;; formؿ᥽åɤΰϡa-list
;;; valueȤʤ롣
;;; valueϡ饤ͤǤ롣
;;; make-slider parent title value-string-width slider-width
;;;             lambda-form a-list
;;;             &key (back-color *white-color*) (color *black-color*)
;;;                  (offset #'+) (left 0) (bottom 0) (width 100)
;;;                  (initval 0)
;;; ARG.
;;;        parent              = ꡼ʥɥȥ꡼ʤС
;;;                              ɥȤդä
;;;        title               = ȥʸ
;;;                              ȥ뤬ɽǤΤ
;;;                              饤ΤΣĹ
;;;        value-string-width  = ͤɽ뤿
;;;        lambda-form         = ͤѹ줿
;;;                              ƤФؿ᥽å
;;;        a-list              = ؿƤФ
;;;                              Υꥹ
;;;        back-color          = Хå饦ɤο
;;;        color               = 饤ʸο
;;;        offset              = եå
;;;        left                = ü
;;;        bottom              = ü
;;;        width               = 
;;;        initval             = 
(defun make-slider (parent string value-string-width lambda-form
			   a-list
			   &key (back-color *white-color*)
			   (color *black-color*) (offset #'+)
			   (left 0) (bottom 0) (width 150)
			   (initval 0))
  (declare (special *default-font* *mouse-move*))
  (let* ((color-value (make-instance 'color-value
				    :color color
				    :back-color back-color))

	 (len1 (round (/ width 5)))
	 (slider (make-instance 'slider
		   :draw-piece-visible T
		   :left left :bottom bottom
		  :object-parent parent
		  :draw-piece-visible T
		  :width width
		  :height (font-kanji-height *default-font*)
		  :color-value color-value)))

    (setf (title-slot slider) 
	  (make-instance 'slider-title
	    :draw-piece-visible T
	    :title string
	    :color-value color-value
	    :object-parent slider
	    :width len1
	    :height (font-kanji-height *default-font*))
	  (value-slot slider)
	  (make-instance 'slider-value
	    :draw-piece-visible T
	    :left (+ len1 1)
	    :width value-string-width
	    :height (font-kanji-height *default-font*)
	    :offset offset
	    :value initval
	    :color-value color-value
	    :a-list a-list
	    :form lambda-form
	    :object-parent slider)
	  (piece-slot slider)
	  (make-instance 'slider-piece
	    :draw-piece-visible T
	    :left (+ len1 value-string-width 2)
	    :width (- width len1 value-string-width 2)
	    :height (font-kanji-height *default-font*)
	    :color-value color-value
	    :object-parent slider))

    ;;; ޥΥ٥ȥ᥽åɤ
    (let ((ob (piece-slot slider)))
      (with-event-object 
       (ob)
       (setf (move-mouse-cursor-method ob)
	     'move-slider
	     (get 'move-slider 'single-process) t
	     (button1-method ob) 'button-slider
	     (get 'button-slider 'single-process) t
	     (slot-value ob 'event-mask)
	     (logior *mouse-move* *mouse-button-down-1*) )))
    (redisplay-slider slider)
    slider))


;;; ɸѴޥȥå륹饤饹
(defclass matrix-panel (piece-region)
  ((theta-slider :initarg :theta-slider :initform nil
		 :accessor theta-slider)
   (x-time-slider :initarg :x-time-slider :initform nil
		  :accessor x-time-slider)
   (y-time-slider :initarg :y-time-slider :initform nil
		  :accessor y-time-slider)))

;;; ޥȥåѥͥ
(defun make-matrix-panel (stream left bottom width)
  (let ((ins (make-instance 'matrix-panel
	       :draw-piece-visible T
	       :width width
	       :left left
	       :height 84
	       :bottom bottom
	       :object-parent stream)))
    (setf (theta-slider ins)
	  (make-slider ins "" 30 'set-matrix-theta
		       (list (stream-transform-by-matrix stream))
		       :offset #'(lambda (x) (- (* x 5) 180))
		       :left 2 :bottom 24
		       :initval 36)
	  (x-time-slider ins)
	  (make-slider ins "X" 22 'set-matrix-x-time
		       (list (stream-transform-by-matrix stream))
		       :left 2 :bottom 44 :initval 5 
		       :offset #'(lambda (x) (* x 0.2)))
	  (y-time-slider ins)
	  (make-slider ins "Y" 22 'set-matrix-y-time
		       (list (stream-transform-by-matrix stream))
		       :left 2 :bottom 64 :initval 5 
		       :offset #'(lambda(x) (* x 0.2))))

    (draw-piece-rectangle ins 0 0 (region-width ins)
			  (region-height ins) :line-width 2)

    (draw-piece-string ins 2 20 "ޥȥꥯѥͥ")
    ins))


(defun set-matrix-theta (matrix new-v)
  (setf (matrix-theta matrix) new-v))

(defun set-matrix-x-time (matrix new-v)
  (setf (matrix-x-time matrix) new-v))

(defun set-matrix-y-time (matrix new-v)
  (setf (matrix-y-time matrix) new-v))

;;; åդΥɥΥե졼
(defclass switch-frame (window-frame) ())

;;; 170ɥåȾե졼ˤ
(defmethod set-frame-region :before ((frame switch-frame) region)
  (setf (region-right region) (- (region-right region) 190)
	(region-left region) (+ (region-left region) 100)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; åդΥɥ ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass switch-window (viewport-window-stream)
  ((switch-with-title :initarg switch-with-title :initform nil
		     :accessor switch-with-title)
   (matrix-panel :initarg matrix-panel :initform nil
		 :accessor matrix-panel)
   (draw-switch-list :initform nil :accessor draw-switch-list)
   (current-draw-switch :initform nil :reader current-draw-switch)
   (how-many-points :initform nil :accessor how-many-points)
   (points-list :initform nil :accessor points-list)
   (rubber-band-method :initform nil :accessor rubber-band-method)
   (clear-rubber-band :initform nil :accessor clear-rubber-band)
   (execution-method :initform nil :accessor execution-method)
   (rubber-init :initform nil :accessor rubber-init)
   (temp-x :initform nil :accessor temp-x)
   (temp-y :initform nil :accessor temp-y)
   (old-temp-x :initform nil :accessor old-temp-x)
   (old-temp-y :initform nil :accessor old-temp-y)))

;;; current-draw-switch Υ᥽å
(defmethod (setf current-draw-switch) (ob (window switch-window))
  (setf (slot-value window 'current-draw-switch) ob
	(temp-x window) nil
	(rubber-init window) nil))

(defvar *dash-list* (list "" "I" (make-string 1 :initial-element (code-char 128))
			  (make-string 1 :initial-element (code-char 170))
			  (make-string 1 :initial-element (code-char 146))))

(defvar *mono-yy-bitmap* nil)
(defvar *color-yy-bitmap* nil)
(defvar *color-image-yy* nil)

(defvar *red* nil)
(defvar *blue* nil)
(defvar *green* nil)
(defvar *yellow* nil)
(defvar *cyan* nil)
(defvar *magenta* nil)

;;; ƥѤΥɥȥ꡼
(defun make-test-window ()
  (unless *red*
	   ;;; ǥեȤΥ顼
	  (setq *red* (make-color :red 65535 :green 0 :blue 0))
	  (setq *blue* (make-color :red 0 :green 0 :blue 65535))
	  (setq *green* (make-color :red 0 :green 65535 :blue 0))
	  (setq *yellow* (make-color :red 65535 :green 65535 :blue 0))
	  (setq *cyan* (make-color :red 0 :green 65535 :blue 65535))
	  (setq *magenta* (make-color :red 65535 :green 0 :blue 65535)))

  (unless *mono-yy-bitmap*
	  (setf *mono-yy-bitmap* (make-bitmap 16 12 :image *image-yy*)))
    
  (unless *color-yy-bitmap*
	  (unless *color-image-yy* 
		  (setq *color-image-yy* (make-image 16 12 :color 
						     *white-color*)))
	  (dotimes (y 12)
		   (dotimes (x 16)
			    (if (eq *white-color* 
				    (image-color-xy *image-yy* x y))
				(setf (image-color-xy *color-image-yy* x y)
				      *red*))))
	  (setf *color-yy-bitmap*
		(make-bitmap 16 12 :image *color-image-yy*)))
    
    (setq *demo-window2*
	  (make-window-instance 'switch-window :window-region
                          (make-region :left 150 :bottom 50 :width 700
                                       :height 450)
                          :title-bar 'switch-title-bar
			  :vertical-scroll-bar 'switch-vertical-scroll-bar
			  :horizontal-scroll-bar 'switch-horizontal-scroll-bar
                          :window-frame 'switch-frame
                          :transform-matrix (make-transform-matrix)
                          :title-bar-string "Demo Window 2"))
    (set-window-method *demo-window2* 'mouse-button-method 
		      :EVENT-MASK *mouse-button-down-1*)
    (set-window-method *demo-window2* 'move-function
		       :EVENT-MASK *mouse-move*)
    (setf (get 'move-function 'single-process) t)
    )
	  
    

;;; ɽ᥽å
(defvar *after3* nil)

(if *after3*
    (remove-method #'redisplay-window *after3*))

(setf *after3* 
 (defmethod redisplay-window :after ((window switch-window))
  (declare (special *red* *blue* *green* *yellow* *cyan* *magenta*))
  (let* ((width (region-width (window-region window)))
	 (start (- width 190)))

    (if (null (switch-with-title window))
	(with-slots 
	 ((switch switch-with-title)) window

	 (push (make-switch-with-title "ʸ" 'tate-yoko-switch 
					(+ start 2) 25 :horizontal
		      '(:horizontal :vertical) window) switch)

	  (push (make-switch-with-title "" 'line-width-switch 
					(+ 64 start) 25 1
					'(1 2 4 6 8) window) switch)

	  (push (make-switch-with-title "ü" 'line-edge-switch
					(+ 128 start) 25 *SQUEAR-LINE-EDGE*
					(list *SQUEAR-LINE-EDGE*
					      *SQUEAR-LINE-EDGE-WITHOUT-END*
					      *ROUND-LINE-EDGE*)
					window) switch)

	  (push (make-switch-with-title "³" 'line-joint-switch
					(+ 2 start) 95 *SHARP-JOINT*
					(list *SHARP-JOINT* *ROUND-JOINT*)
					window) switch)
	 
	  (push (make-switch-with-title "η" 'line-dashing-switch
					(+ 64 start) 95 "" 
					*dash-list*
					window) switch)

	  (push (make-switch-with-title "迧" 'color-change-switch
					(+ 128 start) 95 *black-color*
					(list *black-color* 
					      *red* *blue* *green*
					      *yellow* *cyan* *magenta*)
					window) switch)

	  (push (make-switch-with-title "ɤ٤" 'fill-switch
					(+ 2 start) 165 *Fillednon*
					(list *Fillednon* *FillSolid*
					      *FillTiled* *FillOpaqueStippled*)
					 window) switch)
	  (push (make-switch-with-title "߸̷" 'arc-mode-switch
					(+ 64 start) 165
					 *ARCPIESLICE*
					(list *ARCPIESLICE* *ARCCHORD*)
					window) switch)))

    (if (null (draw-switch-list window))
	(with-slots
	 ((switch draw-switch-list)) window
	 (push (make-draw-switch 16 20 window 'line-draw-switch) switch)
	 (push (make-draw-switch 58 20 window 'circle-draw-switch) switch)
	 (push (make-draw-switch 16 61 window 'ellipse-draw-switch) switch)
	 (push (make-draw-switch 58 61 window 'polyline-draw-switch) switch)
	 (push (make-draw-switch 16 102 window 'region-draw-switch) switch)
	 (push (make-draw-switch 58 102 window 'polygon-draw-switch) switch)
	 (push (make-draw-switch 16 143 window 'arc-draw-switch) switch)
	 (push (make-draw-switch 58 143 window 'arc-ellipse-draw-switch) switch)
	 (push (make-draw-switch 16 184 window 'string-draw-switch) switch)))

    (if (null (matrix-panel window))
	(setf (matrix-panel window)
	    (make-matrix-panel window (- width 190) 235 170))

      (let ((ob (matrix-panel window)))
	(with-real-object
        (ob)
        (region-left ob) (- width 190))))
    )))
		
      
;;; ȥ롼Сĥå꡼
(defclass switch-with-title (piece-region)
  ((title-string :initarg :title-string :initform ""
                 :accessor title-string)
   (switch-body :initarg :switch-body :initform nil
		:accessor switch-body)))


;;; 򥹥å
(defclass select-switch (event-drawable-piece)
  ((switch-stream :initarg :switch-stream :initform nil 
		  :accessor switch-stream)
   (switch-value :initarg :switch-value 
		 :accessor switch-value)
   (select-value-list :initarg :select-value-list
		      :accessor select-value-list)
   (current-count :initarg :currenr-count :initform 0
		  :accessor current-count)))

;;; δؿ 
(defgeneric redisplay-switch (ob))

;;; ɽ
(defmethod redisplay-switch-with-title ((ob switch-with-title))
  (declare (special *black-color* *white-color* *default-font*))
  (draw-piece-color ob *black-color*)
  (let* ((width (region-width ob))
	 (len (font-string-length *default-font* (title-string ob)))
	 (start (round (/ (- width len) 2))))

    (draw-piece-string ob start (font-kanji-base-line *default-font*)
		       (title-string ob) :color *white-color*)
    (let ((ins (switch-body ob)))
      (redisplay-switch ins))))



;;; ȥСդΥå
(defun make-switch-with-title (title class-name left bottom init-switch-vlaue
				     select-value-list stream)
  (let* ((ins (make-instance 'switch-with-title
			    :draw-piece-visible T
			    :object-parent stream
			    :left left :bottom bottom
			    :width 60 :height 60
			    :title-string title))
	 (ob (make-instance class-name
			 :left 1 :bottom 15 :width 58
			 :draw-piece-visible T
			 :height 44
			 :object-parent ins
			 :switch-stream stream
			 :switch-value init-switch-vlaue
			 :select-value-list select-value-list)))

       (with-event-object 
	(ob)
	(setf (button1-method ob) 'select-button
	      (get 'select-button 'single-process) t
	      (slot-value ob 'event-mask) *mouse-button-down-1*
	      (switch-body ins) ob))
       (redisplay-switch-with-title ins)

    ins))

;;; ܥ᥽å
(defun select-button (ob state)
  (declare (ignore state))
  (let ((max (length (select-value-list ob))))
    (with-slots (current-count) ob
		(incf current-count)
		(if (>= current-count max)
		    (setf current-count 0))))
  (redisplay-switch ob))


;;; Ľ񤭡񤭥å
(defclass tate-yoko-switch (select-switch) ())

;;; ɽ
(defmethod redisplay-switch ((ob tate-yoko-switch))
  (declare (special *white-color* *default-font* *black-color*))
  (with-slots 
   (switch-stream switch-value select-value-list current-count) ob
   (display-tate-yoko-switch ob switch-value *white-color*)
   (setf switch-value (nth current-count select-value-list))
   (display-tate-yoko-switch ob switch-value *black-color*)

   (setf (stream-output-direction switch-stream) switch-value)))
   
(defun display-tate-yoko-switch (ob value color)
  (declare (special *default-font*))
  (let ((height (round (/ (region-height ob) 2))))
    (case value
	  (:horizontal
	   (draw-piece-string ob 5 height
			      "" :color color))
	(:vertical 
	 (draw-piece-vertical-string ob 16 12
			    "Ľ" :color color)))))

;;; å
(defclass line-width-switch (select-switch) ())

;;; ɽ
(defmethod redisplay-switch ((ob line-width-switch))
  (declare (special *white-color*))
  (let ((hh (round (/ (region-height ob) 2))))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width switch-value 
		      :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width switch-value)
     (setf (line-width switch-stream) switch-value))))

;;; üΥå
(defclass line-edge-switch (select-switch) ())

;;; ɽ
(defmethod redisplay-switch ((ob line-edge-switch))
  (declare (special *white-color*))
  (let ((hh (round (/ (region-height ob) 2))))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-line ob 20 hh (region-width ob) hh :width 10
		      :edge switch-value
		      :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-line ob 20 hh (region-width ob) hh :width 10
		      :edge switch-value)
     (setf (line-edge switch-stream) switch-value))))

;;; ³ηå
(defclass line-joint-switch (select-switch) ())
			 
(defmethod redisplay-switch ((ob line-joint-switch))
  (declare (special *white-color*))
  (let ((hh (region-height ob)))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-polyline ob 2 hh 24 15 56 hh :width 10
			  :connect switch-value
			  :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-polyline ob 2 hh 24 15 56 hh :width 10
			  :connect switch-value)
     (setf (line-joint-type switch-stream) switch-value))))

;;; å
(defclass line-dashing-switch (select-switch) ())

(defmethod redisplay-switch ((ob line-dashing-switch))
  (declare (special *white-color*))
  (let ((hh (round (/ (region-height ob) 2))))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width 10
		      :dash switch-value
		      :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width 10
		      :dash switch-value)
     (setf (line-dashing switch-stream) switch-value))))

;;; Υå
(defclass color-change-switch (select-switch) ())

(defmethod redisplay-switch ((ob color-change-switch))
  (with-slots
   (switch-stream switch-value select-value-list current-count) ob
   (setf switch-value (nth current-count select-value-list))
   (draw-piece-color ob switch-value)
   (setf (graphic-color switch-stream) switch-value)))

;;; եΥå
(defclass fill-switch (select-switch) ())

(defmethod redisplay-switch ((ob fill-switch))
  (declare (special *white-color*))
  (with-slots
   (switch-stream switch-value select-value-list current-count) ob
   (setf switch-value (nth current-count select-value-list))
   (let ((ret (redisplay-fill ob switch-value)))
     (setf (filled-type switch-stream) switch-value
	   (filled-pattern switch-stream) ret))
   ))

(defun redisplay-fill (ob value)
  (declare (special *white-color* *color-image-yy* *color-yy-bitmap*
		    *image-yy* *mon-yy-bitmap*))
  (draw-piece-color ob *white-color*)

  (cond 
    ((eq *Fillednon* value)
      (draw-piece-string ob 15 20 "")
      nil)

     ((eq *FillSolid* value)
      (draw-piece-string ob 20 20 "")
      nil)
     
     ((eq *FillTiled* value)
      (draw-piece-put-image ob 20 10 *color-image-yy*)
      (bitmap-territory-no *color-yy-bitmap*))

     ((eq *FillOpaqueStippled* value)
      (draw-piece-put-image ob 20 10 *image-yy*)
      (bitmap-territory-no *mono-yy-bitmap*))
     ))


;;; ⡼ɤΥå
(defclass arc-mode-switch (select-switch) ())

(defmethod redisplay-switch ((ob arc-mode-switch))
  (declare (special *white-color* *black-color*))
  (with-slots
   (switch-stream switch-value select-value-list current-count) ob
   (rediplsy-arc-mode ob switch-value *white-color*)
   (setf switch-value (nth current-count select-value-list))
   (rediplsy-arc-mode ob switch-value *black-color*)
   ))

(defun rediplsy-arc-mode (ob value color)
  (cond
   ((eq value *ARCPIESLICE*)
    (draw-piece-string ob 15 20 "" :color color))
   (t
    (draw-piece-string ob 15 20 "ݷ" :color color))
   ))


(defun move-function (window state)
  (WITH-INHIBIT-SCHEDULING
  (if (rubber-band-method window)
      (funcall (rubber-band-method window) window (mouse-state-x-position state)
	     (mouse-state-y-position state)))))

(defun mouse-button-method (window state)
  (WITH-INHIBIT-SCHEDULING
   (let ((len (round (+ (/ (length (points-list window)) 2) 1)))
	 (x (mouse-state-x-position state))
	 (y (mouse-state-y-position state)))
     (push x (points-list window))
     (push y (points-list window))
     (cond 
      ((and (eq (how-many-points window) :right)
	    (eq *mouse-right-1* (mouse-state-button-state state)))
       (rubber-clear window x y (rubber-band-method window)
		     (clear-rubber-band window))
       
       (apply (execution-method window) window (reverse (points-list window)))
       (setf (temp-x window) nil
	     (rubber-init window) nil
	     (points-list window) nil))

      ((and (numberp (how-many-points window))
	    (>= len (how-many-points window)))
       (rubber-clear window x y (rubber-band-method window)
		     (clear-rubber-band window))
       (apply (execution-method window) window (reverse (points-list window)))
       (setf (temp-x window) nil
	     (rubber-init window) nil
	     (points-list window) nil))
      
      (t
       (with-slots 
	(temp-x temp-y) window
	(setf temp-x x temp-y y))))
    )))


(defun rubber-clear (window x y rubber-method clear-rubber-band-method)
  (when (and rubber-method clear-rubber-band-method)
	(funcall rubber-method window x y)
	(setf (rubber-init window) nil)
	(funcall clear-rubber-band-method window x y)))

;;; 襳ޥɥå
(defclass draw-switch (event-drawable-piece)
  ((switch-stream :initarg :switch-stream :initform nil 
		  :accessor switch-stream)
   ))


;;; 襳ޥɤΥå
(defun make-draw-switch (left bottom stream class-name)
  (let* ((ob (make-instance class-name
			    :left left :bottom bottom :width 40
			    :draw-piece-visible T
			    :height 40
			    :object-parent stream
			    :switch-stream stream)))

    (with-event-object 
     (ob)
     (setf (button1-method ob) 'select-draw-switch
	   (get 'select-draw-switch 'single-process) t
	   (slot-value ob 'event-mask) *mouse-button-down-1*))
    (redisplay-draw-switch ob)
    ob))


(defmethod redisplay-draw-switch ((ob draw-switch))
  (draw-piece-rectangle ob 0 0 (region-width ob) 
			 (region-height ob)))

;;; ȿž 
(defun area-hanten (ob)
  (if ob 
      (draw-piece-filled-rectangle ob 1 1 (- (region-width ob) 2)
			       (- (region-height ob) 2)
			       :op *GXOR*)))

;;; 
(defclass line-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob line-draw-switch))
  (draw-piece-line ob 4 20 36 20 :width 3))

(defun line-rubber-band (stream new-x new-y)
  (when (temp-x stream)
	(with-graphic-matrix 
	 ((theta matrix-theta)
	  (xtime matrix-x-time)
	  (ytime matrix-y-time)) stream
	  (with-graphic-state 
	   ((op graphic-operation ) (color graphic-color) (w line-width)
	    (type filled-type)) stream
	    (setf op *GXOR* color *black-color* w 1 type nil
		  theta 0 xtime 1 ytime 1)
	    (with-slots 
	     (temp-x temp-y old-temp-x old-temp-y rubber-init) stream
	     (if rubber-init
		 (draw-line-xy stream temp-x temp-y old-temp-x old-temp-y)
	       (setf rubber-init t))
	     (draw-line-xy stream temp-x temp-y new-x new-y)
	     (setf old-temp-x new-x old-temp-y new-y)
	     )
	 ))))
		
(defmethod select-draw-switch ((ob line-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 2
	  (rubber-band-method stream) #'line-rubber-band
	  (execution-method stream) #'draw-line-xy
	  (clear-rubber-band stream) #'line-rubber-band
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))
    

;;; 
(defclass circle-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob circle-draw-switch))
  (draw-piece-circle ob 20 20 15 :width 3))

(defun circle-rubber-band (stream new-x new-y)
  (when (temp-x stream)
	(with-graphic-matrix 
	 ((theta matrix-theta)
	  (xtime matrix-x-time)
	  (ytime matrix-y-time)) stream
	  (with-graphic-state
	   ((op graphic-operation ) (color graphic-color) (w line-width)
	    (type filled-type)) stream
	    (setf op *GXOR* color *black-color* w 1 type nil
		  theta 0 xtime 1 ytime 1)
	    (with-slots 
	     (temp-x temp-y old-temp-x rubber-init) stream
	     (if rubber-init
		 (draw-circle-xy stream temp-x  temp-y old-temp-x)
	       (setf rubber-init T))
	     (let ((hankei (round 
			    (sqrt (abs (+ (* (- new-x temp-x)
					     (- new-x temp-x))
					  (* (- new-y temp-y)
					     (- new-y temp-y))))))))
	       (draw-circle-xy stream temp-x  temp-y hankei)
	       (setf old-temp-x hankei)))
	 ))))

(defun draw-circle-exec (stream x y &rest rest)
  (declare (ignore rest))
  (draw-circle-xy stream x y (old-temp-x stream)))

(defmethod select-draw-switch ((ob circle-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 2
	  (rubber-band-method stream) #'circle-rubber-band
	  (execution-method stream) #'draw-circle-exec
	  (clear-rubber-band stream) #'circle-rubber-band
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))
			      

;;; ʱ
(defclass ellipse-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob ellipse-draw-switch))
  (draw-piece-ellipse ob 20 20 15 10 :width 3))

(defun ellipse-rubber-band (stream new-x new-y)
  (when (temp-x stream)
	(with-graphic-matrix 
	 ((theta matrix-theta)
	  (xtime matrix-x-time)
	  (ytime matrix-y-time)) stream
	  (with-graphic-state
	   ((op graphic-operation ) (color graphic-color) (w line-width)
	    (type filled-type)) stream
	    (setf op *GXOR* color *black-color* w 1 type nil
		  theta 0 xtime 1 ytime 1)
	    (with-slots 
	     (temp-x temp-y old-temp-x old-temp-y rubber-init) stream
	     (if rubber-init
		 (draw-ellipse-xy stream temp-x temp-y old-temp-x old-temp-y)
	       (setf rubber-init T))
	     (let ((x-radius (abs (- new-x temp-x)))
		   (y-radius (abs (- new-y temp-y))))
	       (draw-ellipse-xy stream temp-x temp-y x-radius y-radius)
	       (setf old-temp-x x-radius old-temp-y y-radius)
	   ))))))

(defun draw-ellipse-exec (stream x y &rest rest)
  (declare (ignore rest))
  (draw-ellipse-xy stream x y (old-temp-x stream) (old-temp-y stream)))
	 
(defmethod select-draw-switch ((ob ellipse-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 2
	  (rubber-band-method stream) #'ellipse-rubber-band
	  (execution-method stream) #'draw-ellipse-exec
	  (clear-rubber-band stream) #'ellipse-rubber-band
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))
			      

;;; ޤ
(defclass polyline-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob polyline-draw-switch))
  (draw-piece-polyline ob 2 38 20 4 38 38 :width 3))

(defun polyline-clear (stream &optional x y)
  (with-graphic-matrix 
   ((theta matrix-theta)
    (xtime matrix-x-time)
    (ytime matrix-y-time)) stream
    (with-graphic-state
     ((op graphic-operation ) (color graphic-color) (w line-width)
      (type filled-type)) stream
      (setf op *GXOR* color *black-color* w 1 type nil
	    theta 0 xtime 1 ytime 1)
      (apply #'draw-polyline-xy stream (reverse (points-list stream))))))

(defmethod select-draw-switch ((ob polyline-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) :right
	  (rubber-band-method stream) #'line-rubber-band
	  (execution-method stream) #'draw-polyline-xy
	  (clear-rubber-band stream) #'polyline-clear
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; 
(defclass region-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob region-draw-switch))
  (draw-piece-rectangle ob 7 10 26 22 :line-width 3))

(defun region-rubber-band (stream new-x new-y)
  (when (temp-x stream)
	(with-graphic-state
	 ((op graphic-operation ) (color graphic-color) (w line-width)
	  (type filled-type)) stream
	  (with-graphic-matrix 
	   ((theta matrix-theta)
	    (xtime matrix-x-time)
	    (ytime matrix-y-time)) stream
	 (setf op *GXOR* color *black-color* w 1 type nil
	       theta 0 xtime 1 ytime 1)
	 (with-slots 
	  (temp-x temp-y old-temp-x old-temp-y rubber-init) stream
	  (if rubber-init
	      (draw-polygon-xy stream temp-x temp-y old-temp-x temp-y
			       old-temp-x old-temp-y temp-x old-temp-y)
	    (setf rubber-init T))
	  (draw-polygon-xy stream temp-x temp-y new-x temp-y
			   new-x new-y temp-x new-y)
	  (setf old-temp-x new-x old-temp-y new-y)
	  )))))

(defun draw-region-exec (stream x y x1 y1)
  (draw-region-xy stream (min x x1) (min y y1) (abs (- x x1)) (abs (- y y1))))
		
(defmethod select-draw-switch ((ob region-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 2
	  (rubber-band-method stream) #'region-rubber-band
	  (execution-method stream) #'draw-region-exec
	  (clear-rubber-band stream) #'region-rubber-band
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ¿ѷ
(defclass polygon-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob polygon-draw-switch))
  (draw-piece-polygon ob 4 33 10 4 20 20 30 4 33 33 :width 3))

(defun polygon-clear (stream &optional x y)
  (with-graphic-matrix 
   ((theta matrix-theta)
    (xtime matrix-x-time)
    (ytime matrix-y-time)) stream
    (with-graphic-state
     ((op graphic-operation ) (color graphic-color) (w line-width)
      (type filled-type)) stream
      (setf op *GXOR* color *black-color* w 1 type nil
	    theta 0 xtime 1 ytime 1)
      (apply #'draw-polygon-xy stream (reverse (points-list stream))))))


(defmethod select-draw-switch ((ob polygon-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) :right
	  (rubber-band-method stream) #'line-rubber-band
	  (execution-method stream) #'draw-polygon-xy
	  (clear-rubber-band stream) #'polygon-clear
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ߸̤
(defclass arc-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob arc-draw-switch))
  (draw-piece-arc ob 20 20 10 -10 60 :width 3))

(defun draw-arc-exec (stream x1 y1 x2 y2 x3 y3)
  (let ((hankei (abs (- x2 x1)))
	(start-kakudo (atan (- y2 y1) (- x2 x1)))
	(end-kakudo (atan (- y3 y2) (- x3 x2))))
    (draw-circle-xy stream x1 y2 hankei :start-angle start-kakudo
		    :end-angle end-kakudo)))

(defmethod select-draw-switch ((ob arc-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 3
	  (rubber-band-method stream) #'line-rubber-band
	  (execution-method stream) #'draw-arc-exec
	  (clear-rubber-band stream) #'polyline-clear
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ʱ߸̤
(defclass arc-ellipse-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob arc-ellipse-draw-switch))
  (draw-piece-ellipse ob 20 20 10 5 :theta1 10 :theta2 60 :width 3))

(defun draw-arc-ellipse-exec (stream x1 y1 x2 y2 x3 y3)

  (let ((x-hankei (abs (- x2 x1)))
	(y-hankei (abs (- y3 y2)))
	(start-kakudo (atan (- y2 y1) (- x2 x1)))
	(end-kakudo (atan (- y3 y2) (- x3 x2))))
    (draw-ellipse-xy stream x1 y2 x-hankei y-hankei :start-angle start-kakudo
		    :end-angle end-kakudo)))

(defmethod select-draw-switch ((ob arc-ellipse-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 3
	  (rubber-band-method stream) #'line-rubber-band
	  (execution-method stream) #'draw-arc-ellipse-exec
	  (clear-rubber-band stream) #'polyline-clear
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ʸ
(defclass string-draw-switch (draw-switch) ())

(defmethod redisplay-draw-switch :after ((ob string-draw-switch))
  (draw-piece-string ob 10 18 "ABC"))

(defun draw-string-exe (stream x y)
  (setf (stream-cursor-x-position stream) x
	(stream-cursor-y-position stream) y)
  (WITH-INHIBIT-SCHEDULING
   (let ((select *selection-table*))
     (select-window stream)
     (write-string (read-line stream) stream)
     (force-output stream)
     (select-window select))))

(defmethod select-draw-switch ((ob string-draw-switch) state)
  (declare (ignore state))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (how-many-points stream) 1
	  (rubber-band-method stream) nil
	  (execution-method stream) #'draw-string-exe
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))


