;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; YY $B$GDj5A$7$F$$$kJQ?t(B
;;; define-macro.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin of and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/1/11 by T.kosaka 


(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%0%m!<%P%kJQ?t$N@_Dj(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%F%j%H%*%jHV9f$H(BLISP$B%*%V%8%'%/%H$r4IM}$9$k%0%m!<%P%kJQ?t(B
(defvar *territory-lisp-object* nil)

;;; $B%G%U%)%k%H%U%)%s%H(B
(defvar *DEFAULT-FONT* nil)

;;; $B>.$5$$%U%)%s%H(B
(defvar *SMALL-FONT* nil)

;;; YY $B$N%G%U%)%k%H%^%&%9%+!<%=%k(B
(defvar *DEFALUT-MOUSE-CURSOR* nil)

;;; $B8=:_$N%^%&%9%+!<%=%k(B
(defvar *SYSTEM-MOUSE-CURSOR* nil)

;;; get position $BMQ%^%&%9%+!<%=%k(B
(defvar *GET-POSITION-MOUSE-CURSOR* nil)


;;;YY$B$N%W%m%H%3%k$N%Q%1%C%H$G$"$k?t;z(B
(defparameter *YY-MAGIC-NO* 14876)

;;; $B%k!<%H%F%j%H%j$NHV9f(B
(defvar *ROOT-TERRITORY-NO* -1)

;;; $B%+%i!<CM(B $B9u(B
(defvar *BLACK-COLOR* nil)
;;; $B%+%i!<CM(B $BGr(B
(defvar *WHITE-COLOR* nil)
;;; $B%+%i!<CM(B $BF)L@(B
(defvar *transparent* nil)

(defvar *event-process* nil)
(defvar *lister-process* nil)

;;; $B%j%9%W%j%9%J!<(B
(defvar *LISP-LISTENER* nil)

(defvar *prompt-window* nil)
(defvar *pop-up-menu-window* nil)

;;; $B8=:_$N%^%&%9%9%F!<%H(B
(defvar *SYSTEM-MOUSE-STATE* nil)

;;; $B%$%s%?!<%i%C%W%$%Y%s%H(B $B%$%s%?!<%J%kMQ(B
(defvar *SYSTEM-INTERRUPT-EVENT* nil)

;;; $B%k!<%H%&%#%s%I%&(B
(defvar *ROOT-WINDOW* nil)


;;; $B@~$NC<$N7A(B
(defconstant *SQUEAR-LINE-EDGE* 1)
(defconstant *SQUEAR-LINE-EDGE-WITHOUT-END* 2)
(defconstant *ROUND-LINE-EDGE* 3)

;;; $B@~$N@\B3$N7A(B
(defconstant *SHARP-JOINT* 1)
(defconstant *ROUND-JOINT* 2)

;;; $B%*%Z%l!<%7%g%s(B
(defconstant *GCLEAR* #x00)
(defconstant *GAND*  #x01)
(defconstant *GANDREVERSE* #x02)
(defconstant *GCOPY* #x03)
(defconstant *GANDINTEVERTED* #x04)
(defconstant *GNOOP* #x05)
(defconstant *GXOR* #x06)
(defconstant *GOR* #x07)
(defconstant *GNOR* #x08)
(defconstant *GEQIV* #x09)
(defconstant *GINVERT* #x0a)
(defconstant *GORREVERSE* #x0b)
(defconstant *GCOPYINVERTED* #x0c)
(defconstant *GORINVERTED* #x0d)
(defconstant *GNAND* #x0e)
(defconstant *GSET* #x0f)

;;; $B%U%#%k%9%?%$%k(B
(defconstant *FillSolid* 0)      
(defconstant *FillTiled* 1)
(defconstant *FillOpaqueStippled* 4)

;;; $B%U%#%k$9$k$+H]$+(B
(defconstant *Fillednon* nil) 

;;; $B%U%#%k%k!<%k(B
(defconstant *EvenOddRule* 0)
(defconstant *WindingRule* 1)

;;; $B1_8L$N%b!<%I(B
(defconstant *ARCPIESLICE* 1)   ;;; $B@p7?(B
(defconstant *ARCCHORD* 0)     ;;; $B5]7?(B
      

;;; $B%^%&%9%9%F!<%H$N%Q%i%a!<%?(B    ;;;12345678123456781234567812345678 
(defconstant *mouse-right-1*      #b00000000000000000000000000000001)
(defconstant *mouse-middle-1*     #b00000000000000000000000000000010) 
(defconstant *mouse-left-1*       #b00000000000000000000000000000100) 
(defconstant *mouse-right-up*     #b00000000000000000000000000001000) 
(defconstant *mouse-middle-up*    #b00000000000000000000000000010000) 
(defconstant *mouse-left-up*      #b00000000000000000000000000100000) 
(defconstant *mouse-move*         #b00000000000000000000000001000000) 
(defconstant *mouse-in*           #b00000000000000000000000010000000) 
(defconstant *mouse-out*          #b00000000000000000000000100000000) 
(defconstant *mouse-wait*         #b00000000000000000000001000000000) 
(defconstant *mouse-right-2*      #b00000000000000000000010000000000) 
(defconstant *mouse-middle-2*     #b00000000000000000000100000000000) 
(defconstant *mouse-left-2*       #b00000000000000000001000000000000) 
(defconstant *interrupt*          #b00000000000000010000000000000000) 
(defconstant *meta*               #b00000001000000000000000000000000) 
(defconstant *control*            #b00000010000000000000000000000000) 
(defconstant *shift*              #b00000100000000000000000000000000)

;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,F0$/(B
(defconstant *shift-mouse-move* (logior *shift* *mouse-move*))
(defconstant *shift-control-mouse-move* (logior *shift* *mouse-move* *control*))
(defconstant *shift-meta-mouse-move* (logior *shift* *mouse-move* *meta*))
(defconstant *meta-mouse-move* (logior *meta* *mouse-move* ))
(defconstant *control-mouse-move* (logior *control* *mouse-move*))


;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,BT$D(B
(defconstant *shift-mouse-wait* (logior *shift* *mouse-wait*))
(defconstant *shift-control-mouse-wait* (logior *shift* *mouse-wait* *control*))
(defconstant *shift-meta-mouse-wait* (logior *shift* *mouse-wait* *meta*))
(defconstant *meta-mouse-wait* (logior *meta* *mouse-wait* ))
(defconstant *control-mouse-wait* (logior *control* *mouse-wait*))


;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,F~$k(B
(defconstant *shift-mouse-in* (logior *shift* *mouse-in*))
(defconstant *shift-control-mouse-in* (logior *shift* *mouse-in* *control*))
(defconstant *shift-meta-mouse-in* (logior *shift* *mouse-in* *meta*))
(defconstant *meta-mouse-in* (logior *meta* *mouse-in* ))
(defconstant *control-mouse-in* (logior *control* *mouse-in*))


;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,=P$k(B
(defconstant *shift-mouse-out* (logior *shift* *mouse-out*))
(defconstant *shift-control-mouse-out* (logior *shift* *mouse-out* *control*))
(defconstant *shift-meta-mouse-out* (logior *shift* *mouse-out* *meta*))
(defconstant *meta-mouse-out* (logior *meta* *mouse-out* ))
(defconstant *control-mouse-out* (logior *control* *mouse-out*))


;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9%/%j%C%/(B
(defconstant *shift-mouse-left-1*  (logior *shift* *mouse-left-1*))
(defconstant *shift-mouse-midle-1* (logior *shift* *mouse-middle-1*))
(defconstant *shift-mouse-right-1* (logior *shift* *mouse-right-1*))
(defconstant *meta-mouse-left-1*   (logior *meta* *mouse-left-1*))
(defconstant *meta-mouse-middle-1* (logior *meta* *mouse-middle-1*))
(defconstant *meta-mouse-right-1*  (logior *meta* *mouse-right-1*))
(defconstant *control-mouse-left-1*   (logior *control* *mouse-left-1*))
(defconstant *control-mouse-middle-1* (logior *control* *mouse-middle-1*))
(defconstant *control-mouse-right-1*  (logior *control* *mouse-right-1*))
(defconstant *shift-control-mouse-left-1*  (logior *shift* *control-mouse-left-1*))
(defconstant *shift-control-mouse-middle-1*  (logior *shift* *control-mouse-middle-1*))
(defconstant *shift-control-mouse-right-1*   (logior *shift* *control-mouse-right-1*))
(defconstant *shift-meta-mouse-left-1*   (logior *shift* *meta-mouse-left-1*))
(defconstant *shift-meta-mouse-middle-1* (logior *shift* *meta-mouse-middle-1*))
(defconstant *shift-meta-mouse-right-1*  (logior *shift* *meta-mouse-right-1*))


;;; $B%\%?%s$r2!2<$7$J$,$iF0$/(B
(defconstant *mouse-move-while-mouse-right-1* (logior *mouse-right-1* *mouse-move*))
(defconstant *mouse-move-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-move*))
(defconstant *mouse-move-while-mouse-left-1*    (logior *mouse-left-1* *mouse-move*))
(defconstant *mouse-move-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-move* ))

;;; $B%\%?%s$r2!2<$7$J$,$iBT$D(B
(defconstant *mouse-wait-while-mouse-right-1* (logior *mouse-right-1* *mouse-wait*))
(defconstant *mouse-wait-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-wait*))
(defconstant *mouse-wait-while-mouse-left-1*    (logior *mouse-left-1* *mouse-wait*))
(defconstant *mouse-wait-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-wait* ))

;;; $B%\%?%s$r2!2<$7$J$,$iF~$k(B
(defconstant *mouse-in-while-mouse-right-1* (logior *mouse-right-1* *mouse-in*))
(defconstant *mouse-in-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-in*))
(defconstant *mouse-in-while-mouse-left-1*    (logior *mouse-left-1* *mouse-in*))
(defconstant *mouse-in-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-in* ))

;;; $B%\%?%s$r2!2<$7$J$,$i=P$k(B
(defconstant *mouse-out-while-mouse-right-1* (logior *mouse-right-1* *mouse-out*))
(defconstant *mouse-out-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-out*))
(defconstant *mouse-out-while-mouse-left-1*    (logior *mouse-left-1* *mouse-out*))
(defconstant *mouse-out-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-out* ))

;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9%@%V%k%/%j%C%/(B
(defconstant *shift-mouse-left-2*    (logior *shift* *mouse-left-2*))
(defconstant *shift-mouse-middle-2*   (logior *shift* *mouse-middle-2*))
(defconstant *shift-mouse-right-2*   (logior *shift* *mouse-right-2*))
(defconstant *meta-mouse-left-2*     (logior *meta* *mouse-left-2*))
(defconstant *meta-mouse-middle-2*   (logior *meta* *mouse-middle-2*))
(defconstant *meta-mouse-right-2*    (logior *meta* *mouse-right-2*))
(defconstant *control-mouse-left-2*  (logior *control* *mouse-left-2*))
(defconstant *control-mouse-middle-2* (logior *control* *mouse-middle-2*))
(defconstant *control-mouse-right-2*  (logior *control* *mouse-right-2*))
(defconstant *shift-control-mouse-left-2*    (logior *shift* *control-mouse-left-2*))
(defconstant *shift-control-mouse-middle-2*  (logior *shift* *control-mouse-middle-2*))
(defconstant *shift-control-mouse-right-2*   (logior *shift* *control-mouse-right-2*))
(defconstant *shift-meta-mouse-left-2*    (logior *shift* *meta-mouse-left-2*))
(defconstant *shift-meta-mouse-middle-2*  (logior *shift* *meta-mouse-middle-2*))
(defconstant *shift-meta-mouse-right-2*   (logior *shift* *meta-mouse-right-2*))

;;; $B%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,N%$5$l$?(B
(defconstant *shift-mouse-left-up*     (logior *shift* *mouse-left-up*))
(defconstant *shift-mouse-middle-up*    (logior *shift* *mouse-middle-up*))
(defconstant *shift-mouse-right-up*    (logior *shift* *mouse-right-up*))
(defconstant *meta-mouse-left-up*      (logior *meta* *mouse-left-up*))
(defconstant *meta-mouse-middle-up*    (logior *meta* *mouse-middle-up*))
(defconstant *meta-mouse-right-up*     (logior *meta* *mouse-right-up*))
(defconstant *control-mouse-left-up*   (logior *control* *mouse-left-up*))
(defconstant *control-mouse-middle-up* (logior *control* *mouse-middle-up*))
(defconstant *control-mouse-right-up*  (logior *control* *mouse-right-up*))
(defconstant *shift-control-mouse-left-up*    (logior *shift* *control-mouse-left-up*))
(defconstant *shift-control-mouse-middle-up*  (logior *shift* *control-mouse-middle-up*))
(defconstant *shift-control-mouse-right-up*   (logior *shift* *control-mouse-right-up*))
(defconstant *shift-meta-mouse-left-up*     (logior *shift* *meta-mouse-left-up*))
(defconstant *shift-meta-mouse-middle-up*   (logior *shift* *meta-mouse-middle-up*))
(defconstant *shift-meta-mouse-right-up*    (logior *shift* *meta-mouse-right-up*))

;;; $B%\%?%s%9%F!<%H$N0lHL(B
(defconstant *mouse-button-down-1* (logior  *mouse-right-1* *mouse-left-1*
				           *mouse-middle-1*))
(defconstant *mouse-move-while-button-down-1* (logior *mouse-button-down-1* *mouse-move*))
(defconstant *mouse-wait-while-button-down-1* (logior *mouse-button-down-1* *mouse-wait*))
(defconstant *mouse-in-while-button-down-1* (logior *mouse-button-down-1* *mouse-in*))
(defconstant *mouse-out-while-button-down-1* (logior *mouse-button-down-1* *mouse-out*))

(defconstant *mouse-button-down-2* (logior  *mouse-right-2* *mouse-left-2*
                                           *mouse-middle-2*))

(defconstant *mouse-button-up* (logior *mouse-right-up* *mouse-middle-up*
				      *mouse-left-up*))

(defconstant *mouse-none* 0)

;;; $B%+%i!<$N$?$a$NJQ?t(B
(defvar *all-colors* nil)

;;; $BDL?.9=B$BN$N@_Dj(B
;;;; $B%5!<%P!<$H$N@\B3>pJs(B
(defstruct yy-server-connection
  yy-version yy-release-no yy-responce-no
  yy-ntime yy-width yy-height yy-label)

