;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.2 90/12/xx by Y.Ohta
;;;

;;; $B3HD%%0%i%U%#%C%/(B
;;; change log
;;;

(in-package :yy)

;;; A color graphics extension for yyonx ver1.2

;;; $B%+%i!<%F!<%V%k$r;}$C$F$$$J$$$H(BRGB$B$,F1$8$G$b(Bmake-color$B$7$?CM$,Kh2s(B
;;; $B0c$&%*%V%8%'%/%H$K$J$k!#=>$C$F(Beql$B$NCM$,(Bt$B$K$J$i$J$$!#(B
;;; $B$b$7!"(Breplace-color$B$r:n$C$?$H$9$k$H%+%i!<%*%V%8%'%/%H$N(BRGB$BCM$H<B:]$N(B
;;; $B?'$,0[$J$k>l9g$,=P$F$/$k!#(B
;;; => replace-color$B$r:n$C$F$+$iJQ99$9$k(B

;;; $BF)L@?'$O$I$&$d$C$F@8@.$7$h$&$+$J!#(B
;;; $B%5!<%P!<$KEO$7$A$c$^$:$$$+$J!#(B
;;; => $B%/%i%$%"%s%H$GH=Dj$9$k(B

   ;;
;;;;;; expantended protocol
   ;;

;;; for debug
#|
(eval-when (eval compile load)
  (pushnew :debug *features*))
|#

#+debug
(defun dump-packet (&optional (size))
  (dolist (packet *send*)
    (multiple-value-bind (command length)
	(decode-com-pac (c_access packet 0))
      (lisp:format t "~%ComNo ~d Len ~d <~a>" command length (case (c_access packet 1)
							       ((0) "Alone")
							       ((1) "Start")
							       ((2) "Continue")
							       ((3) "End")
							       (otherwise "Unkown")))
      (dotimes (i (if (numberp size)
		      (min (- (floor (length packet) 4) 2) size (- length 2))
		    (min (- (floor (length packet) 4) 2) (- length 2))))
	(lisp:format t "~%~d: ~d" (+ i 2) (c_access packet (+ i 2))))
      (when (zerop (c_access packet 1))
	(return nil)))))

;;; #054 yy-protocol-54
;;; $B%"%K%a!<%7%g%s%U%l!<%`$NDj5A(B
;;; (yy-protocol-54 tno width height)
;;; args. tno = $B%F%j%H%j$NHV9f(B
;;;	  width = $B%"%K%a!<%7%g%s%U%l!<%`$NI}(B
;;;	  height = $B%"%K%a!<%7%g%s%U%l!<%`$N9b$5(B
(defcommand yy-protocol-54 (tno width height)
  (make-command-packet 54 :integer tno :integer width :integer height
		          :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #055 yy-protocol-55
;;; $B%"%K%a!<%7%g%s$N<B9T(B
;;; (yy-protocol-55 tno x y fno speed dir times sync)
;;; => last-frame-number
;;; args. tno = $B%F%j%H%j$NHV9f(B
;;;	  x = x$B:BI8(B
;;;	  y = y$B:BI8(B
;;;	  fno = $B%"%K%a!<%7%g%s3+;O%U%l!<%`HV9f(B
;;;	  speed = $B%"%K%a!<%7%g%s%9%T!<%I(B (10msec)
;;;	  dir = $BJ}8~(B 0:=forward 1:=backward
;;;	  times = $B%"%K%a!<%7%g%s$N2s?t(B 0:=endless
;;;	  sync = $BF14|$r$H$k%"%K%a!<%7%g%s$NKg?t(B
(defcommand yy-protocol-55 (tno x y fno speed dir times sync)
  (make-command-packet 55 :integer tno :integer x :integer y :integer fno
		       :integer speed
		       :integer dir :integer times :integer sync :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #056 yy-protocol-56
;;; $B%"%K%a!<%7%g%s$NDd;_(B
;;; (yy-protocol-56 tno) -> last-frame-number
;;; args. tno = $B%F%j%H%j$NHV9f(B
(defcommand yy-protocol-56 (tno)
  (make-command-packet 56 :integer tno :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #057 yy-protocol-57
;;; $B%"%K%a!<%7%g%s%U%l!<%`$NGK2u(B
;;; (yy-protocol-57 tno)
;;; args. tno = $B%F%j%H%j$NHV9f(B
(defcommand yy-protocol-57 (tno)
  (make-command-packet 57 :integer tno :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #058 yy-protocol-58 
;;; $B%"%K%a!<%7%g%s%G!<%?$N%m!<%I(Bn$B8D(B
;;; (yy-protocol-58 tno format source &rest images)
;;; args. tno = $B%F%j%H%j$NHV9f(B
;;;	  format = format of image 1:=color
;;;				   2:=gray
;;;				   3:=mono
;;;	  source = 0:=image 1:=from territory
;;;	  images* source==0
;;;			fno = frame number
;;;			image = image (bytes)
;;;		  source==1
;;;			fno = frame number
;;;			tno = source territory number
;;;			x
;;;			y
(defcommand yy-protocol-58-only (tno format source fno &rest image)
  (cond
   ;; image object
   ((zerop source)
    (make-command-packet 58
			 :integer tno :integer 1 :integer format
			 :integer fno :integer source :vector (first image) :end))
   ;; image on territory
   ((= source 1)
    (make-command-packet 58
			 :integer tno :integer 1 :integer format
			 :integer fno :integer source
			 :integer (first image) :integer (second image)
			 :integer (third image) :end))
   (t (error "yy-protocol-58-only: unknown type ~a" source)))
  #+debug
  (dump-packet 10)
  (packet-send))

(defcommand yy-protocol-58 (tno format source &rest images)
  (let ((form nil))
    (cond
     ((zerop source)
      (apply #'make-command-packet 58
	     :integer tno :integer (round images 2) :integer format
	     (do* ((x images (cddr x))
		   (fno (first x) (first x))
		   (image (second x) (second x)))
		 ((null x) (nconc form (list :end)))
	       (setf form (nconc form
				 (list :integer fno :integer source :vector image))
		     ))))
     ((= source 1)
      (apply #'make-command-packet 58
	     :integer tno :integer (round images 4) :integer format
	     (do* ((x images (nthcdr 4 x))
		   (fno (first x) (first x))
		   (sno (second x) (second x))
		   (left (third x) (third x))
		   (top (fourth x) (fourth x)))
		 ((null x) (nconc form (list :end)))
	       (setf form (nconc form
				 (list :integer fno :integer source
				       :integer sno :integer left :integer top)))
	       )))
     (t (error "yy-protocol-58: unknown type ~a" source)))
    #+debug
    (dump-packet 10)
    (packet-send)))


;;; $B%"%K%a!<%7%g%s=hM}(B
;;; The simple animation system

;;; primitives
;;; event dispatch


;;; animation method

(eval-when (eval compile)
  (defconstant *animation-pause* 0)
  (defconstant *animation-forward* 1)
  (defconstant *animation-backward* 2)

  (defconstant *yy-format* 2)
  (defconstant *cw-format* 1)
  (defconstant *color-format* #x8000)
  (defconstant *gray-format* #x4000)
  (defconstant *mono-format* #x2000)
  )

;;; $B%"%K%a!<%7%g%s%/%i%9(B
(defclass animation-frame ()
   ((left :initform 0 :initarg :left :type integer :accessor left)
    (top :initform 0 :initarg :top :type integer :accessor top)
    (width :initarg :width :type integer :accessor width)
    (height :initarg :height :type integer :accessor height)
    (window :initarg :window :type graphic-stream :reader window)
    (max-number :initarg :max-number :type integer :accessor max-number)
    (status :initform :sleep :accessor animation-status)
    ))

(defmethod print-object ((animation-frame animation-frame) stream)
  (format stream "#<Animation-frame ~ax~a>"
	  (width animation-frame) (height animation-frame)))

(defmethod define-animation-frame ((stream graphic-stream)
				   (x integer) (y integer)
				   (width integer) (height integer)
				   (max-number integer))
  (with-translate-transform-xy ((new-x new-y) stream x y)
    (with-translate-transform-xy ((x1 y1) stream (+ x width) (+ y height))
     (with-temp-region-args ((draw-anime-region) (work-region1 stream)
			     :left (min new-x x1) :width width
			     :bottom (min new-y y1) :height height)
      (let ((drawing-region (drawing-region stream)))
        ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
	(setf (world-region stream) draw-anime-region)
        ;;; drawing-region$B$K:#$N%j!<%8%g%s$rDI2C(B
	(if (null drawing-region)
	    (setf (drawing-region stream) draw-anime-region)
	  (setf (region-left drawing-region) (min (region-left drawing-region)
						  (region-left draw-anime-region))
		(region-top drawing-region) (max (region-top drawing-region)
						 (region-top draw-anime-region))
		(region-right drawing-region) (max (region-right drawing-region)
						   (region-right draw-anime-region))
		(region-bottom drawing-region) (min (region-bottom drawing-region)
						    (region-bottom draw-anime-region))
		))
	(yy-protocol-54 (world-territory-no stream) width height)
	(make-instance 'animation-frame
	  :left x :top y :width width :height height :window stream
	  :max-number max-number)
	)))))


(defun animation-tuuchi (yy-keybord-event yy-interrupt-event yy-resize-event)
  (let ((command 0))

#+EXCL
    (loop
     (when (not (zerop (c_select2)))
         (setf command (packet-receive))
         (return))
     (sleep 0.1))
#+(or LUCID Symbolics)
     (setf command (packet-receive))

      (case command
	;; $BJ8;zNs$NF~NO(B
	(70
	 (setf (slot-value yy-keybord-event 'territory-no)
	       (get-packet-data *receive* 0) ; $B%F%j%H%jHV9f(B
	       (slot-value yy-keybord-event 'event-string)
	       (get-packet-data *receive* 2 (get-packet-data *receive* 1)))
	 (values yy-keybord-event 2))
	;; $B%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(B
	(73
	 (setf (slot-value yy-interrupt-event 'territory-no)
	       (get-packet-data *receive* 0) ; $B%F%j%H%jHV9f(B
	       (slot-value yy-interrupt-event 'event-mask)
	       (get-packet-data *receive* 1)  ;;; $B%^%9%/(B
	       (position-x (slot-value  yy-interrupt-event 'event-position))
	       (get-packet-data *receive* 2)
	       (position-y (slot-value yy-interrupt-event 'event-position))
	       (get-packet-data *receive* 3))
	 (values yy-interrupt-event 1))
	;;; $B%F%j%H%j!<$NBg$-$5JQ99%$%Y%s%H(B
	(86
	 (setf (slot-value yy-resize-event 'territory-no)
 	       (get-packet-data *receive* 0) ; $B%F%j%H%jHV9f(B
 	       (region-left (slot-value yy-resize-event 'event-region))
 	       (get-packet-data *receive* 1)
 	       (region-bottom (slot-value yy-resize-event 'event-region))
 	       (get-packet-data *receive* 2)
 	       (region-width (slot-value yy-resize-event 'event-region))
 	       (get-packet-data *receive* 3)
 	       (region-height (slot-value yy-resize-event 'event-region))
 	       (get-packet-data *receive* 4))
 	  (values yy-resize-event 3))
	(55				;$B%"%K%a!<%7%g%s(B
	 (if (not (zerop (get-packet-data *receive* 2)))
	     (throw 'run-animation (values (get-packet-data *receive* 0)
					   (get-packet-data *receive* 1)
					   (get-packet-data *receive* 2)))))
	#+debug
	(otherwise
	 (lisp:format t "~%Received unkown command ~a" command))
	)
      )
  )

(defmethod run-animation ((frame animation-frame)
			  &key (left (left frame)) (top (top frame))
			  (speed 1) (start-frame-no 0)
			  (direction :forward)
			  (presentation-times :endless)
			  (sync 20))
  ;;$BI,$:%"%K%a!<%7%g%s$rDd;_$5$;$k(B
  (labels ((dir-sym2code ()
	     (case direction
	       ((:oneshot) 0)
	       ((:forward) 1)
	       ((:backward) 2)
	       (otherwise (error "run-animation: Unknown direction ~s."
				 direction))))
	   (times-sym2code ()
	     (cond
	      ((eq presentation-times :endless) 0)
	      ((and (integerp presentation-times)
		    (> presentation-times 0))
	       presentation-times)
	      (t
	       (error "run-animation: presentation-times must be integer"))))
	   (adjust-xy ()
	     (let ((width (width frame)) (height (height frame))
		   (stream (window frame)) (yy 0) (def-y 0))
	       (with-translate-transform-xy ((new-x new-y) stream left top)
 		 (with-translate-transform-xy ((x1 y1) stream (+ left width)
					       (+ top height))
		   (with-temp-region-args ((anime-region) (work-region1 stream)
					   :left (min new-x x1) :width width
					   :bottom (min new-y y1) :height height)
	             (let ((drawing-region (drawing-region stream)))
		       (setf yy (with-translate-coordinate-stream top stream)
			     def-y (if (= yy top) 0 height))
		       (setf (world-region stream) anime-region)
		       (if (null drawing-region)
			   (setf (drawing-region stream) anime-region)
			 (setf (region-left drawing-region) (min (region-left drawing-region)
								 (region-left anime-region))
			       (region-top drawing-region) (max (region-top drawing-region)
								(region-top anime-region))
			       (region-right drawing-region) (max (region-right drawing-region)
								  (region-right anime-region))
			       (region-bottom drawing-region) (min (region-bottom drawing-region)
								   (region-bottom anime-region))))
		       (setf left (+ new-x (world-x-start stream))
			     top  (- (+ new-y (world-y-start stream)) def-y)))))))))
    (let ((process *event-process*))
      (adjust-xy)			;$B$3$NCf$G(Bleft$B$H(Btop$B$NCM$rJQ99$7$F$$$k(B
      (unwind-protect
	  (let ((tno (world-territory-no (window frame)))
		(dir (dir-sym2code))
		(times(times-sym2code)))
	    (if process
		(progn
		  (setf *event-process* nil)
		  (killed-process process)))
	    (yy-protocol-55 tno left top start-frame-no speed dir times sync)
	    (setf (animation-status frame) :active)
	    ;; $B8e$G=q$-49$($k(B
	    ;; $B%^%k%A%W%m%;%9$G$OF0:n$7$J$$(B
	    (catch 'run-animation
	      (let ((keybord-event (make-instance 'yy-keybord-event))
		    (interrupt-event (make-instance 'yy-interrupt-event))
		    (resize-event (make-instance 'yy-resize-event))
		    (mouse-state (make-mouse-state))
		    (event nil) (no 0))

		(loop
		  (multiple-value-setq (event no)
		    (animation-tuuchi keybord-event 
				      interrupt-event resize-event))
		  (if no
		      (case no
			(1 (yy-event-method1 event mouse-state))
			(2 (yy-event-method2 event))
			(3 (yy-event-method3 event)))))))))


	(setf (animation-status frame) :sleep)
	(if process
	    (setf *event-process*
		  (run-process 'event-dispatch)))
	)
      )
    )


(defmethod stop-animation ((frame animation-frame))
  ;;$B$b$7<B9TCf$@$C$?$iDd;_$9$k!"$=$l0J30$O$J$K$b$7$J$$(B
  (when (eql (animation-status frame) :active)
    (yy-protocol-56 (world-territory-no (window frame)))
    nil
    ))

(defmethod display-frame ((frame animation-frame) (frame-no integer)
			  &key (x (left frame)) (y (top frame)))
  (let ((width (width frame)) (height (height frame))
	(stream (window frame)) (yy 0) (def-y 0))
    (with-translate-transform-xy ((new-x new-y) stream x y)
      (with-translate-transform-xy ((x1 y1) stream (+ x width) (+ y height))
	(with-temp-region-args ((anime-region) (work-region1 stream)
				:left (min new-x x1) :width width
				:bottom (min new-y y1) :height height)
	  (let ((drawing-region (drawing-region stream)))
	    (setf yy (with-translate-coordinate-stream y stream)
		  def-y (if (= yy y) 0 height))
	  ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
	    (setf (world-region stream) anime-region)
	    ;;; $B0LCV$NJQ99(B
	    (setf new-x (+ new-x (world-x-start stream))
		  new-y (- (+ new-y (world-y-start stream)) def-y))
	    ;; $BIA2h%W%j%_%F%#%V(B
	    (yy-protocol-55 (world-territory-no stream) new-x new-y frame-no 0 0 0 0)
	    ;; drawing-region$B$K:#$N%j!<%8%g%s$rDI2C(B
	    (if (null drawing-region)
		(setf (drawing-region stream) anime-region)
	      (setf (region-left drawing-region) (min (region-left drawing-region)
						      (region-left anime-region))
		    (region-top drawing-region) (max (region-top drawing-region)
						     (region-top anime-region))
		    (region-right drawing-region) (max (region-right drawing-region)
						       (region-right anime-region))
		    (region-bottom drawing-region) (min (region-bottom drawing-region)
							(region-bottom anime-region))))
	    frame))))))

(defmethod put-frame ((frame animation-frame) (frame-no integer) (image image)
		      &key (image-position (make-position :x 0 :y 0)))
  ;; check max-number
  (let ((image-data (image-data image))
	(format (logior (if (eql (image-format image) :yy) *yy-format* *cw-format*)
			(case (image-type image)
			  ((:color) *color-format*)
			  ((:gray) *gray-format*)
			  (otherwise *mono-format*)))))
    (yy-protocol-58-only (world-territory-no (window frame)) format 0 frame-no image-data)
    frame))

(defmethod put-frame-xy ((frame animation-frame) (frame-no integer) (image image)
			 &key (image-x 0) (image-y 0))
  ;; check max-number
  ;; $B$3$N%P!<%8%g%s$O(Bimage-x, image-y$B$r8+$F$$$J$$(B
  (let ((image-data (image-data image))
	(format (logior (if (eql (image-format image) :yy) *yy-format* *cw-format*)
			(case (image-type image)
			  ((:color) *color-format*)
			  ((:gray) *gray-format*)
			  (otherwise *mono-format*)))))
    (yy-protocol-58-only (world-territory-no (window frame)) format 0 frame-no image-data)
    frame))

(defmethod flush-animation-frame ((frame animation-frame))
  (yy-protocol-57 (world-territory-no (window frame)))
  nil
  )