;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; YY $B$GDj5A$7$F$$$k%^%/%m(B
;;; define-macro.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin of and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka
;;;   version 1.3 90/12/19 by T.kosaka 
;;;               delete drawing-text macro
;;;   version 1.3 90/2/6/  by T.kosaka


;;; YY$B$GDj5A$7$F$$$k%^%/%m(B
;;; 5/10 1990 $B8E:d(B

;;; Version 1.0   Coded by t.kosaka 1990-5-10
;;; Change log 
;;; Updata with-translate-coordinate-stream can use all object.
;;;        Add with-temp-region 
;;; Update WITH-INHIBIT-SCHEDULING is added Symbolics code
;;;	   Contribution of E.Shiota
;;; Update add funtionalty unwind-protect at with-XXXX

(in-package :yy)

;;; with-position-destructured 
(defmacro with-position-destructured (((X Y) position) &rest body)
  `(let ((,X (position-x ,position))
	(,Y (position-y ,position)))
    ,@body))


;;; $B%"!<%.%e%a%s%H$O!"(Bleft bottom right top $B$K$9$Y$-(B
;;; width height $B$bF~$l$k$Y$-(B
;;; with-region-destuructured $B%^%/%m(B
(defmacro with-region-destuctured (((left top right bottom) region) &body body)
  `(let* ((,left (region-left ,region))
	  (,top (region-top ,region))
	  (,right (region-right ,region))
	  (,bottom (region-bottom ,region)))
     ,@body))

;;; $B%"!<%.%e%a%s%H$O!"(Bleft bottom width height  $B$K$9$Y$-(B
;;; with-region-destuructured-wh $B%^%/%m(B
(defmacro with-region-destuctured-wh (((left bottom width height) 
				       region) &body body)
  `(let* ((,left (region-left ,region))
	  (,bottom (region-bottom ,region))
	  (,width (region-width ,region))
	  (,height (region-height ,region)))

      ,@body))

;;; WITH-INHIBIT-SCHEDULING
;;; FORM$B$r<B9TCf!"B>$N%W%m%;%9$N<B9T$r6X;_$9$k(B
;;; 
(DEFMACRO WITH-INHIBIT-SCHEDULING (&REST FORM)
  #+:LUCID
  `(LUCID::WITH-SCHEDULING-INHIBITED ,@FORM)
  #+:EXCL
  (let ((ret (gentemp))
	(now-p (gentemp)))
    `(let ((,now-p (remove-if-not #'mp::process-run-reasons
			      (remove mp::*current-process* 
			   mp::*all-processes* )))
	   (,ret nil))
       (dolist (p ,now-p)
	    (mp::process-disable p))
       (setf ,ret (progn ,@FORM))
       (dolist (p ,now-p)
		(mp::process-enable p))
       ,ret))
  #+Symbolics
;  `(unwind-protect ,@FORM)
  `(scl:without-interrupts ,@form)
  #-(OR :LUCID :EXCL Symbolics)
  (ERROR "WITH-INHIBIT-SCHEDULING: Sorry. Your LISP implementation is not supported.")
   )


;;; with-temp-region 
;;; $B4{$K:n$i$l$?(Bregion$B$r2>$K;H$&(B
(defmacro with-temp-region ((region) &body body)
  (let ((left (gentemp))
	(right (gentemp))
	(top (gentemp))
	(bottom (gentemp))
	(val (gentemp)))
    `(WITH-INHIBIT-SCHEDULING
      (with-slots 
       (left right top bottom) ,region
       (let ((,left left)
	     (,right right)
	     (,top top)
	     (,bottom bottom)
	     (,val (mutiple-value-list ,@body)))
	 (setf left ,left ,right right top ,top bottom ,bottom)
	 (values-list ,val))))))
#|
      (let ((,left (region-left ,region))
	   (,right (region-right ,region))
	   (,top (region-top ,region))
	   (,bottom (region-bottom ,region))
	   (,val (mutiple-value-list ,@body)))
       (setf (region-left ,region) ,left
	     (region-right ,region) ,right
	     (region-bottom ,region) ,bottom
	     (region-top ,region) ,top)
       (values-list ,val)))))
|#

;;; with-temp-region-args
;;; $B4{$K:n$i$l$?(Bregion$B$r2>$K;H$&(B
(defmacro with-temp-region-args (((var) region
                                 &key (left 0) (right left) (bottom 0) 
				 (top bottom)
				 (width nil) (height nil))
				 &body body)
  (declare (inline +))
  (let ((o-left (gentemp))
	(o-right (gentemp))
	(o-top (gentemp))
	(o-bottom (gentemp))
	(val (gentemp)))
    `(WITH-INHIBIT-SCHEDULING
      (with-slots 
       (left bottom top right) ,region
       (let ((,var ,region)
	     (,o-left left)
	     (,o-bottom bottom)
	     (,o-top top)
	     (,o-right right)
	     (,val nil))

	 (setf left ,left bottom ,bottom right ,right top ,top)

	 (if ,width
	     (setf right (+ left ,width)))

	 (if ,height
	     (setf top (+ bottom ,height)))

	 (setf ,val (multiple-value-list (progn ,@body)))
	 
	 (setf left ,o-left bottom ,o-bottom right ,o-right top ,o-top)
	 (values-list ,val))))))

#|
      (let* ((,var ,region)
	     (,o-left (region-left ,region))
	     (,o-right (region-right ,region))
	     (,o-top (region-top ,region))
	     (,o-bottom (region-bottom ,region))
	     (,n-left ,left)
	     (,n-right ,right)
	     (,n-bottom ,bottom)
	     (,n-top ,top)
	     (,n-width ,width)
	     (,n-height ,height)
	     (,val nil))

       (if ,n-width
	   (setf ,n-right (+ ,n-left ,n-width)))

       (if ,n-height
	   (setf ,n-top (+ ,n-bottom ,n-height)))

       (setf (region-left ,var) ,n-left
	     (region-right ,var) ,n-right
	     (region-bottom ,var) ,n-bottom
	     (region-top ,var) ,n-top)

	   
	(setf ,val (multiple-value-list (progn ,@body)))
	(setf (region-left ,region) ,o-left
	      (region-right ,region) ,o-right
	      (region-bottom ,region) ,o-bottom
	      (region-top ,region) ,o-top)
       (values-list ,val)))))
|#

;;; $B:BI8JQ49MQ%^%/%m(B
(defmacro with-translate-coordinate ((&rest vars) object height &body body)
  (eval `(nconc (list 'let
	   (mapcar #'(lambda (X) 
		       (list (car X) (list '+ (second X) 
			 (translate-coordinate ,object (second X) ,height))))
		   (quote ,vars)))
	   (quote ,body))))

;;; $B;HMQK!(B 
#|
(defun test (stream x y1 y2 y3) ;;; y1 y2 y3$B$O(BY$B:BI8(B
  (with-translate-coordinate ((y1 y1) (y2 y2) (y3 y3))
			    ($B%9%H%j!<%`$N:BI8JQ49%$%s%9%?%s%9(B)
			    $B%9%H%j!<%`$N:GBg9b$5(B
			    (print y1) (print y2) (print y3))
y1 y2 y3 $B$K$O!":BI8JQ49$5$l$?CM$,%P%$%s%I$5$l$k!#(B
|#


;;;$B%0%i%U%#%C%/%H%i%s%9%U%)!<%`%^%H%j%C%/%9$N%9%m%C%HCM$rF@$k%^%/%m(B
(defmacro with-matrix-destructured (((theta x-time y-time) matrix) 
				    &rest body)
  `(let ((,theta (matrix-theta ,matrix)) (,x-time (matrix-x-time ,matrix))
	 (,y-time (matrix-y-time ,matrix)))
     ,@body))


;;;; $B:BI8JQ49$H%0%i%U%#%/%9%H%i%s%9%U%)!<%`$r9MN8$KF~$l$?%^%/%m(B
(defmacro with-translate-transform (((new-pos) stream position) &rest body)
  `(let ((,new-pos (translate-coordinate 
		    (slot-value ,stream 'translate-coordinate)
		    (transform-by-matrix ,position
				 (slot-value ,stream 'transform-by-matrix)
				 :return :position)
		    (world-height ,stream))))
     ,@body))


(defmacro with-translate-transform-xy (((new-x new-y) stream x y)
                                       &rest body)
  (let ((old-pos (gentemp)))
  `(let* ((,old-pos  (transform-by-matrix-xy ,x ,y
                        (slot-value ,stream 'transform-by-matrix)
                        :return T))
          (,new-y (translate-coordinate-y
                   (slot-value ,stream 'translate-coordinate)
                   (round (second ,old-pos)) (world-height ,stream)))
          (,new-x (round (first ,old-pos))))
     ,@body)))


;;; $B:BI8JQ49MQ%^%/%m(B
;;; 27.Aug.90 yohta height, yy -> gentemp
(defmacro with-translate-coordinate-stream (Y stream)
  (let ((height (gentemp)) (yy (gentemp)))
  `(let* ((,height (if ,stream
                      (world-height ,stream)
                    0))
          (,yy (if ,stream
                (translate-coordinate-y
                        (stream-translate-coordinate ,stream) ,Y ,height)
                ,Y)))
     ,yy)))

		     
;;; $B2sE>9TNsJQ49%^%/%m(B
(defmacro with-transform-stream (pos stream)
  `(transform-by-matrix ,pos (stream-transform-by-matrix ,stream) :position))


;;; lisp$B%*%V%8%'%/%H$rH<$C$?%F%j%H%j$N@8@.(B
(defmacro  with-object-make-territory (object &key
                                       (x 0) (y 0) (width 0) (height 0)
                                       (parent -1) (visible T)
				       (drawable T)
				       (window-mode T) (fence NIL) 
				       (transparent nil))
  (let ((territory (gentemp)))
    `(let ((,territory (make-territory
                        :x ,x :y ,y :width ,width :height ,height
                        :parent ,parent :visible ,visible
			:window-mode ,window-mode
			:fence ,fence
			:transparent ,transparent
                        :drawable ,drawable)))
       (set-territory-object ,territory ,object)

       ,territory)))


;;; lisp$B%*%V%8%'%/%H$rH<$C$?%F%j%H%j$N@8@.(B
;;; lisp$B%*%V%8%'%/%H$rH<$C$?%F%j%H%j$N@8@.(B
;;; 27.Aug.90 yohta territory -> gentemp
(defmacro  with-object-make-region-territory (object region
                               &key (parent -1) (visible T) (drawable T)
			       (fence NIL)
			       (transparent nil)
			       (window-mode T))
  (let ((territory (gentemp)))
    `(let ((,territory (make-territory
                        :x (region-left ,region)
                        :y (region-bottom ,region)
                        :width (region-width ,region)
                        :height (region-height ,region)
			:window-mode ,window-mode
			:transparent ,transparent
			:fence ,fence
                        :parent ,parent :visible ,visible :drawable ,drawable)))
       (set-territory-object ,territory ,object)

       ,territory)))



;;; defcommand command-name arguments {form}*
;;; YY Protocol $B$rE83+$9$k(B
;;;
(defmacro defcommand (pn args &rest forms)
  `(defun ,pn ,args
     (declare (special *send* *max-message-size*))
     (with-inhibit-scheduling
       ,@forms
       )
     )
  )


;;; YY$B$N;~4V7WB,MQ%^%/%m(B
(defmacro yy-time (form)
  `(let ((*trace-output* (make-string-output-stream))
         (ret nil))
     (setf ret (time ,form))
     (format t "function ~a time: ~a~%" (car (quote ,form))
             (read-from-string (subseq (get-output-stream-string *trace-output*)
                                                      20)))
     ret)
     )

#|
;;; C_STRORE$B$N%j%9%W4X?t(B
(defmacro c_store (string no1 no2)
  `(cc_store ,string ,no1 ,no2))

;;; C_ACCESS $B$N%j%9%W4X?t(B
(defmacro c_access (string no)
  `(cc_access ,string ,no))

;;; C_STORE2$B$N%j%9%W4X?t(B
(defmacro c_store2 (string no1 no2)
  `(cc_store2 ,string ,no1 ,no2))

|#

;;; c_access$B$NHFJQ?t$rDj5A$9$k(B
(defsetf c_access c_store)


;;; $B%0%i%U%#%/%9$N>uBV$rJQ99$9$k%^%/%m(B
;;; $B%^%/%m$J$$$G!"%m!<%+%k$KJQ99$5$l$k(B
(defmacro with-graphic-state (vars ins &rest body)
  (let ((val (gentemp))
	(v1 (gentemp))
        (v2 (gentemp))
        (v3 (gentemp))
        (v4 (gentemp))
        (v5 (gentemp))
        (v6 (gentemp))
        (v7 (gentemp))
        (v8 (gentemp))
        (v9 (gentemp))
        (v10 (gentemp)))
    `(with-slots 
      (operation color line-width line-edge joint-type filled-pattern
       line-dashing arc-mode filled-type default-color-pattern) ,ins
      (let ((,v1 operation)
	    (,v2 color)
	    (,v3 line-width)
	    (,v4 line-edge)
	    (,v5 joint-type)
	    (,v6 filled-pattern)
	    (,v7 line-dashing)
	    (,v8 arc-mode)
	    (,v9 filled-type)
	    (,v10 default-color-pattern)
	    (,val nil))

	(unwind-protect
	    (with-accessors ,vars ,ins (setf ,val
					(multiple-value-list (progn ,@body))))

       ;;; $B85$KLa$9(B
       (setf operation ,v1 color ,v2 line-width ,v3 line-edge ,v4
	     joint-type ,v5 filled-pattern ,v6 line-dashing ,v7
	     arc-mode ,v8 filled-type ,v9 default-color-pattern ,v10))
       (values-list ,val)))))
#|
  (let ((v1 (gentemp))
	(v2 (gentemp))
	(v3 (gentemp))
	(v4 (gentemp))
	(v5 (gentemp))
	(v6 (gentemp))
	(v7 (gentemp))
	(v8 (gentemp))
	(v9 (gentemp))
	(v10 (gentemp))
	(vvv (gentemp))
	(v11 (gentemp)))
    `(let ((,v1 (graphic-operation ,ins))
	   (,v2 (graphic-color ,ins))
	   (,v3 (line-width ,ins))
	   (,v4 (line-edge ,ins))
	   (,v5 (line-joint-type ,ins))
	   (,v6 (line-dashing ,ins))
	   (,v7 (arc-mode ,ins))
	   (,v8 (filled-type ,ins))
	   (,v9 (filled-rule ,ins))
	   (,v10 (filled-pattern ,ins))
	   (,v11 (stream-default-color-pattern ,ins))
	   (,vvv nil))

       ;;; CLOS $B%^%/%m(B
       (unwind-protect
	   (with-accessors ,vars ,ins (setf ,vvv 
					(multiple-value-list (progn ,@body))))

       ;;; $B85$KLa$9(B
       (setf (graphic-operation ,ins) ,v1
	     (graphic-color ,ins) ,v2
	     (line-width ,ins) ,v3
	     (line-edge ,ins) ,v4
	     (line-joint-type ,ins) ,v5
	     (line-dashing ,ins) ,v6
	     (arc-mode ,ins) ,v7
	     (filled-type ,ins) ,v8
	     (filled-rule ,ins) ,v9
	     (filled-pattern ,ins) ,v10
	     (stream-default-color-pattern ,ins) ,v11))
       (values-list ,vvv))))
|#

;;; $B%F%-%9%H%3%s%H%m!<%k$N>uBV$rJQ49$9$k%^%/%m(B
;;; $B%^%/%m$J$$$G!"%m!<%+%k$KJQ99$5$l$k(B
(defmacro with-text-control (vars ins &rest body)
  (let ((v1 (gentemp))
	(v2 (gentemp))
	(v3 (gentemp))
	(v4 (gentemp))
	(v5 (gentemp))
	(v6 (gentemp))
	(v7 (gentemp))
	(vvv (gentemp)))
    `(let ((,v1 (stream-left-margin ,ins))
	   (,v2 (stream-right-margin ,ins))
	   (,v3 (stream-top-margin ,ins))
	   (,v4 (stream-bottom-margin ,ins))
	   (,v5 (stream-font ,ins))
	   (,v6 (slot-value ,ins 'line-feed))
	   (,v7 (stream-output-direction ,ins))
	   (,vvv nil))
        ;;; CLOS $B%^%/%m(B
       (unwind-protect 
	   (with-accessors ,vars ,ins (setf ,vvv 
					(multiple-value-list (progn  ,@body))))

       ;;; $B85$KLa$9(B
       (setf (stream-left-margin ,ins) ,v1
	     (stream-right-margin ,ins) ,v2
	     (stream-top-margin ,ins) ,v3
	     (stream-bottom-margin ,ins) ,v4
	     (stream-font ,ins) ,v5
 	     (slot-value ,ins 'line-feed) ,v6
	     (stream-output-direction ,ins) ,v7))
       (values-list ,vvv))))

;;; $B%0%i%U%#%C%/%9%^%H%j%/%9$NJQ99%a%=%C%I(B
;;; $B%^%/%m$J$$$G!"%m!<%+%k$KJQ99$5$l$k(B
(defmacro with-graphic-matrix (vars ins &rest body)
  (let ((v1 (gentemp))
	(v2 (gentemp))
	(v3 (gentemp))
	(matrix (gentemp))
	(old-m (gentemp))
	(flg (gentemp))
	(vvv (gentemp)))
    `(let* ((,matrix (stream-transform-by-matrix ,ins))
	    (,old-m ,matrix)
	    (,v1 (matrix-theta ,matrix))
	    (,v2 (matrix-x-time ,matrix))
	    (,v3 (matrix-y-time ,matrix))
	    (,vvv nil)
	    (,flg nil))

       ;;;Matrix $B$,Hs<B9T$N>l9g(B
       (if (eq 'graphic-transform-matrix-non
	       (class-name (class-of ,matrix)))
	   (setf ,flg T
		 (stream-transform-by-matrix ,ins)
		 (make-transform-matrix)
		 ,matrix (stream-transform-by-matrix ,ins)))

        ;;; CLOS $B%^%/%m(B
       (unwind-protect
	   (with-accessors ,vars ,matrix
		       (setf ,vvv (multiple-value-list (progn  ,@body))))

       ;;; $B85$KLa$9(B
       (if ,flg
	   (setf (stream-transform-by-matrix ,ins) ,old-m)
	 (setf (matrix-theta ,matrix) ,v1
	       (matrix-x-time ,matrix) ,v2
	       (matrix-y-time ,matrix) ,v3)))
    (values-list ,vvv))))


;;; $B%^%&%9$r%0%i%V$9$k%^%/%m(B
;;; $B%^%&%9%+!<%=%k$O(BNIL$B$G$bNI$$(B
(defmacro with-mouse-grabbed (mouse-cursor &rest body)
  (declare (special *SYSTEM-MOUSE-CURSOR*))
  (let ((vvv (gentemp)))
    `(WITH-INHIBIT-SCHEDULING
      (let ((mouse *SYSTEM-MOUSE-CURSOR*)
	    (,vvv nil))
      (if ,mouse-cursor
         (change-mouse-cursor ,mouse-cursor))
	 (yy-protocol-74 2)
	 (setf ,vvv (progn ,@body))
	 (yy-protocol-74 1)
	 (setf *SYSTEM-MOUSE-CURSOR* mouse)
	 ,vvv))))


;;;
;;; Defgeneric for YY
;;; Becasue PCL is not supported :Mthod option yet.
;;;
#+PCL
(eval-when (eval load compile)

(shadow 'defgeneric (find-package 'yy))

(defmacro yy::defgeneric (function-specifier lambda-list &body options)
  (expand-defgeneric-for-yy function-specifier lambda-list options))

(defun expand-defgeneric-for-yy (function-specifier lambda-list options)
  (let ((methods nil)
	(others nil))
    (dolist (option options)
      (case (car option)
	(:method (push `(defmethod ,function-specifier ,@(cdr option)) methods))
	(otherwise (push option others))))
    `(eval-when (eval load compile)
       (pcl:defgeneric ,function-specifier ,lambda-list ,@others)
       ,@methods)))
)



